/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.fadada.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.electronsign.fadada.entity.FadadaSignAttachmenPurchase;
import com.els.modules.electronsign.fadada.entity.FadadaSignAttachmenSale;
import com.els.modules.electronsign.fadada.entity.FadadaSignTaskPurchase;
import com.els.modules.electronsign.fadada.entity.FadadaSignTaskSale;
import com.els.modules.electronsign.fadada.entity.FadadaTaskActorPurchase;
import com.els.modules.electronsign.fadada.entity.FadadaTaskActorSale;
import com.els.modules.electronsign.fadada.entity.SaleFadadaSeal;
import com.els.modules.electronsign.fadada.enums.FadadaJudgeEnum;
import com.els.modules.electronsign.fadada.enums.FadadaSealFieldTypeEnum;
import com.els.modules.electronsign.fadada.mapper.FadadaSignAttachmenPurchaseMapper;
import com.els.modules.electronsign.fadada.mapper.FadadaSignTaskPurchaseMapper;
import com.els.modules.electronsign.fadada.mapper.FadadaSignTaskSaleMapper;
import com.els.modules.electronsign.fadada.mapper.FadadaTaskActorPurchaseMapper;
import com.els.modules.electronsign.fadada.mapper.SaleFadadaSealMapper;
import com.els.modules.electronsign.fadada.service.FadadaSignAttachmenSaleService;
import com.els.modules.electronsign.fadada.service.FadadaSignTaskSaleService;
import com.els.modules.electronsign.fadada.service.FadadaTaskActorSaleService;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class FadadaSignTaskSaleServiceImpl
extends BaseServiceImpl<FadadaSignTaskSaleMapper, FadadaSignTaskSale>
implements FadadaSignTaskSaleService {
    @Resource
    private FadadaTaskActorSaleService fadadaTaskActorSaleService;
    @Resource
    private FadadaSignAttachmenSaleService fadadaSignAttachmenSaleService;
    @Autowired
    private FadadaSignTaskPurchaseMapper fadadaSignTaskPurchaseMapper;
    @Autowired
    private FadadaSignAttachmenPurchaseMapper fadadaSignAttachmenPurchaseMapper;
    @Autowired
    private SaleFadadaSealMapper saleFadadaSealMapper;
    @Resource
    private FadadaTaskActorPurchaseMapper fadadaTaskActorPurchaseMapper;
    private SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(FadadaSignTaskSale fadadaSignTaskSale, List<FadadaTaskActorSale> fadadaTaskActorSaleList, List<FadadaSignAttachmenSale> fadadaSignAttachmenSaleList) {
        ((FadadaSignTaskSaleMapper)this.baseMapper).insert((Object)fadadaSignTaskSale);
        super.setHeadDefaultValue((BaseEntity)fadadaSignTaskSale);
        this.insertData(fadadaSignTaskSale, fadadaTaskActorSaleList, fadadaSignAttachmenSaleList, null);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(FadadaSignTaskSale fadadaSignTaskSale, List<FadadaTaskActorSale> fadadaTaskActorSaleList, List<FadadaSignAttachmenSale> fadadaSignAttachmenSaleList, List<FadadaSignAttachmenSale> fadadaSignAttachmenSaleBackList) {
        int count = ((FadadaSignTaskSaleMapper)this.baseMapper).updateById((Object)fadadaSignTaskSale);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.fadadaTaskActorSaleService.deleteByMainId(fadadaSignTaskSale.getId());
        this.fadadaSignAttachmenSaleService.deleteByMainId(fadadaSignTaskSale.getId());
        this.insertData(fadadaSignTaskSale, fadadaTaskActorSaleList, fadadaSignAttachmenSaleList, fadadaSignAttachmenSaleBackList);
    }

    private void insertData(FadadaSignTaskSale fadadaSignTaskSale, List<FadadaTaskActorSale> fadadaTaskActorSaleList, List<FadadaSignAttachmenSale> fadadaSignAttachmenSaleList, List<FadadaSignAttachmenSale> fadadaSignAttachmenSaleBackList) {
        if (!CollectionUtils.isEmpty(fadadaTaskActorSaleList)) {
            for (FadadaTaskActorSale fadadaTaskActorSale : fadadaTaskActorSaleList) {
                fadadaTaskActorSale.setHeadId(fadadaSignTaskSale.getId());
                SysUtil.setSysParam((BaseEntity)fadadaTaskActorSale, (BaseEntity)fadadaSignTaskSale);
                if (StrUtil.isBlank((CharSequence)fadadaTaskActorSale.getOwning())) {
                    fadadaTaskActorSale.setOwning("sale");
                }
                if ("mobile".equals(fadadaTaskActorSale.getNotifyWay())) {
                    fadadaTaskActorSale.setNotifyAddress(fadadaTaskActorSale.getMobile());
                } else {
                    fadadaTaskActorSale.setNotifyAddress(fadadaTaskActorSale.getEmail());
                }
                if ("corp".equals(fadadaTaskActorSale.getActorType())) {
                    fadadaTaskActorSale.setActorName(fadadaTaskActorSale.getCorpName());
                    fadadaTaskActorSale.setActorOpenId(fadadaTaskActorSale.getOpenCorpId());
                    continue;
                }
                fadadaTaskActorSale.setActorName(fadadaTaskActorSale.getUseName());
                fadadaTaskActorSale.setActorOpenId(fadadaTaskActorSale.getOpenUserId());
            }
            this.fadadaTaskActorSaleService.saveBatch(fadadaTaskActorSaleList, 2000);
        }
        if (!CollectionUtils.isEmpty(fadadaSignAttachmenSaleList)) {
            for (FadadaSignAttachmenSale fadadaSignAttachmenSale : fadadaSignAttachmenSaleList) {
                fadadaSignAttachmenSale.setHeadId(fadadaSignTaskSale.getId());
                SysUtil.setSysParam((BaseEntity)fadadaSignAttachmenSale, (BaseEntity)fadadaSignTaskSale);
            }
            this.fadadaSignAttachmenSaleService.saveBatch(fadadaSignAttachmenSaleList, 2000);
        }
        if (!CollectionUtils.isEmpty(fadadaSignAttachmenSaleBackList)) {
            for (FadadaSignAttachmenSale fadadaSignAttachmenSale : fadadaSignAttachmenSaleBackList) {
                fadadaSignAttachmenSale.setHeadId(fadadaSignTaskSale.getId());
                fadadaSignAttachmenSale.setSendStatus("1");
                SysUtil.setSysParam((BaseEntity)fadadaSignAttachmenSale, (BaseEntity)fadadaSignTaskSale);
            }
            this.fadadaSignAttachmenSaleService.saveBatch(fadadaSignAttachmenSaleBackList, 2000);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.fadadaTaskActorSaleService.deleteByMainId(id);
        this.fadadaSignAttachmenSaleService.deleteByMainId(id);
        ((FadadaSignTaskSaleMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.fadadaTaskActorSaleService.deleteByMainId(serializable.toString());
            this.fadadaSignAttachmenSaleService.deleteByMainId(serializable.toString());
            ((FadadaSignTaskSaleMapper)this.baseMapper).deleteById(serializable);
        }
    }

    @Override
    public void passBack(FadadaSignTaskSale fadadaSignTaskSale, List<FadadaSignAttachmenSale> fadadaSignAttachmenSaleBackList) {
        FadadaSignTaskPurchase signTaskPurchase = (FadadaSignTaskPurchase)((Object)this.fadadaSignTaskPurchaseMapper.selectById((Serializable)((Object)(fadadaSignTaskSale = (FadadaSignTaskSale)((Object)this.getById((Serializable)((Object)fadadaSignTaskSale.getId())))).getRelationId())));
        if (signTaskPurchase != null) {
            fadadaSignTaskSale.setSendBack("0");
            fadadaSignTaskSale.setSaleFileUploaded("1");
            signTaskPurchase.setSaleFileUploaded("1");
            signTaskPurchase.setSendBack("0");
            signTaskPurchase.setSendBackReson("");
            signTaskPurchase.setRelationId(fadadaSignTaskSale.getId());
            ArrayList<FadadaSignAttachmenPurchase> signAttachmenPurchases = new ArrayList<FadadaSignAttachmenPurchase>();
            for (FadadaSignAttachmenSale entity : fadadaSignAttachmenSaleBackList) {
                FadadaSignAttachmenPurchase signAttachmenPurchase = (FadadaSignAttachmenPurchase)((Object)SysUtil.copyProperties((Object)((Object)entity), FadadaSignAttachmenPurchase.class));
                signAttachmenPurchase.setReceiveStatus("1");
                signAttachmenPurchase.setRelationId(entity.getId());
                signAttachmenPurchase.setHeadId(signTaskPurchase.getId());
                signAttachmenPurchase.setElsAccount(signTaskPurchase.getElsAccount());
                signAttachmenPurchase.setDeleted(CommonConstant.DEL_FLAG_0);
                signAttachmenPurchases.add(signAttachmenPurchase);
                entity.setSendStatus("1");
            }
            this.fadadaSignAttachmenPurchaseMapper.insertBatchSomeColumn(signAttachmenPurchases);
            this.fadadaSignAttachmenSaleService.saveOrUpdateBatch(fadadaSignAttachmenSaleBackList);
            this.fadadaSignTaskPurchaseMapper.updateById((Object)signTaskPurchase);
            this.updateById((Object)fadadaSignTaskSale);
        }
    }

    @Override
    public void maintainSigner(FadadaSignTaskSale fadadaSignTaskSale, List<FadadaTaskActorSale> fadadaTaskActorSales) {
        fadadaSignTaskSale = (FadadaSignTaskSale)((Object)this.getById((Serializable)((Object)fadadaSignTaskSale.getId())));
        fadadaSignTaskSale.setSaleSignerSubmintStatus("1");
        FadadaSignTaskPurchase signTaskPurchase = (FadadaSignTaskPurchase)((Object)this.fadadaSignTaskPurchaseMapper.selectById((Serializable)((Object)fadadaSignTaskSale.getRelationId())));
        signTaskPurchase.setSaleSignerSubmintStatus("1");
        boolean corpSeal = false;
        boolean corp_seal_cross_page = false;
        ArrayList<FadadaTaskActorPurchase> taskActorPurchaseList = new ArrayList<FadadaTaskActorPurchase>();
        for (FadadaTaskActorSale entity : fadadaTaskActorSales) {
            if (FadadaSealFieldTypeEnum.corp_seal_cross_page.getValue().equals(entity.getFieldType())) {
                corp_seal_cross_page = true;
            }
            if (FadadaSealFieldTypeEnum.corp_seal.getValue().equals(entity.getFieldType())) {
                corpSeal = true;
            }
            if (FadadaJudgeEnum.TRUE.getValue().equals(entity.getRequestVerifyFree())) {
                QueryWrapper saleFadadaSealQueryWrapper = new QueryWrapper();
                saleFadadaSealQueryWrapper.eq((Object)"els_account", (Object)fadadaSignTaskSale.getElsAccount());
                saleFadadaSealQueryWrapper.eq((Object)"visa_free", (Object)"1");
                saleFadadaSealQueryWrapper.eq((Object)"seal_id", (Object)entity.getSealId());
                if (this.saleFadadaSealMapper.selectCount((Wrapper)saleFadadaSealQueryWrapper) < 1) {
                    throw new ELSBootException("\u673a\u6784\u3010" + entity.getCorpName() + "\u3011\u7684\u5370\u7ae0\u3010" + entity.getSealName() + "\u3011\u672a\u8bbe\u7f6e\u514d\u7b7e");
                }
                List saleFadadaSeals = this.saleFadadaSealMapper.selectList((Wrapper)saleFadadaSealQueryWrapper);
                String today = this.simpleDateFormat.format(new Date());
                Date date = null;
                try {
                    date = this.simpleDateFormat.parse(today);
                }
                catch (Exception e) {
                    date = new Date();
                }
                for (SaleFadadaSeal seal : saleFadadaSeals) {
                    if (seal.getExpiresTime().compareTo(date) >= 0) continue;
                    throw new ELSBootException("\u673a\u6784\u3010" + entity.getCorpName() + "\u3011\u7684\u5370\u7ae0\u3010" + entity.getSealName() + "\u3011\u514d\u7b7e\u5df2\u5230\u671f");
                }
            }
            if ("mobile".equals(entity.getNotifyWay())) {
                entity.setNotifyAddress(entity.getMobile());
            } else {
                entity.setNotifyAddress(entity.getEmail());
            }
            entity.setOwning("sale");
            FadadaTaskActorPurchase taskActorPurchase = (FadadaTaskActorPurchase)((Object)SysUtil.copyProperties((Object)((Object)entity), FadadaTaskActorPurchase.class));
            taskActorPurchase.setHeadId(signTaskPurchase.getId());
            if (StrUtil.isBlank((CharSequence)entity.getId())) {
                entity.setId(IdWorker.getIdStr());
            }
            taskActorPurchase.setRelationId(entity.getId());
            taskActorPurchase.setId(IdWorker.getIdStr());
            entity.setRelationId(taskActorPurchase.getId());
            taskActorPurchaseList.add(taskActorPurchase);
        }
        if (corp_seal_cross_page && !corpSeal) {
            throw new ELSBootException("\u7b7e\u7f72\u5b58\u5728\u9a91\u7f1d\u7ae0\u5219\u5fc5\u987b\u540c\u65f6\u5b58\u5728\u4f01\u4e1a\u516c\u7ae0");
        }
        this.fadadaSignTaskPurchaseMapper.updateById((Object)signTaskPurchase);
        this.fadadaTaskActorPurchaseMapper.insertBatchSomeColumn(taskActorPurchaseList);
        this.updateById((Object)fadadaSignTaskSale);
        this.fadadaTaskActorSaleService.deleteByMainId(fadadaSignTaskSale.getId());
        this.insertData(fadadaSignTaskSale, fadadaTaskActorSales, null, null);
    }
}

