/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.BusinessModule;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.contract.controller.PurchaseContractTemplateHeadHisController;
import com.els.modules.contract.entity.PurchaseContractTemplateHead;
import com.els.modules.contract.entity.PurchaseContractTemplateItem;
import com.els.modules.contract.service.PurchaseContractTemplateHeadService;
import com.els.modules.contract.service.PurchaseContractTemplateItemService;
import com.els.modules.contract.vo.PurchaseContractTemplateHeadVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/contract/purchaseContractTemplateHead"})
@Tag(name="\u91c7\u8d2d\u5408\u540c\u6a21\u677f\u5934")
@BusinessModule(module="contractTemplate")
public class PurchaseContractTemplateHeadController
extends BaseController<PurchaseContractTemplateHead, PurchaseContractTemplateHeadService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseContractTemplateHeadController.class);
    @Autowired
    private PurchaseContractTemplateHeadService purchaseContractTemplateHeadService;
    @Autowired
    private PurchaseContractTemplateItemService purchaseContractTemplateItemService;
    @Autowired
    private PurchaseContractTemplateHeadHisController purchaseContractTemplateHeadHisController;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"contractTemplate#purchaseContractTemplateHead:list"})
    @PermissionDataView(businessType="contractTemplate")
    public Result<?> queryPageList(PurchaseContractTemplateHead purchaseContractTemplateHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseContractTemplateHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseContractTemplateHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @SrmValidated
    @AutoLog(value="\u5408\u540c\u6a21\u677f-\u6dfb\u52a0")
    @RequiresPermissions(value={"contractTemplate#purchaseContractTemplateHead:add"})
    @PermissionDataOpt(businessType="contractTemplate", beanClass=PurchaseContractTemplateHeadService.class)
    public Result<?> add(@RequestBody PurchaseContractTemplateHeadVO purchaseContractTemplateHeadPage) {
        PurchaseContractTemplateHead purchaseContractTemplateHead = new PurchaseContractTemplateHead();
        BeanUtils.copyProperties((Object)((Object)purchaseContractTemplateHeadPage), (Object)((Object)purchaseContractTemplateHead));
        this.purchaseContractTemplateHeadService.saveMain(purchaseContractTemplateHead, purchaseContractTemplateHeadPage.getPurchaseContractTemplateItemList());
        return Result.ok((Object)((Object)purchaseContractTemplateHead));
    }

    @Operation(summary="\u83b7\u53d6\u4e24\u4e2a\u5408\u540c\u6587\u672c\u7684\u5408\u540c\u6587\u672c", description="\u83b7\u53d6\u4e24\u4e2a\u5408\u540c\u6587\u672c\u7684\u5408\u540c\u6587\u672c")
    @GetMapping(value={"/diffContractContent"})
    @RequiresPermissions(value={"contractTemplate#purchaseContractTemplateHead:list"})
    public Result<?> diffContractContent(@RequestParam(name="id", required=true) String id, @RequestParam(name="newId", required=true) String newId, @RequestParam(name="type", required=true) String type) {
        PurchaseContractTemplateItem purchaseContractContentItem = new PurchaseContractTemplateItem();
        purchaseContractContentItem.setElsAccount(TenantContext.getTenant());
        purchaseContractContentItem.setOriginalContent(this.purchaseContractTemplateHeadHisController.getHtmlById(id).toString());
        if ("head".equals(type)) {
            purchaseContractContentItem.setItemContent(this.purchaseContractTemplateHeadHisController.getHtmlById(newId).toString());
        } else {
            purchaseContractContentItem.setItemContent(this.getHtmlById(newId).toString());
        }
        return Result.ok((Object)((Object)purchaseContractContentItem));
    }

    private StringBuilder getHtmlById(String id) {
        List<PurchaseContractTemplateItem> purchaseContractTemplateItemList = this.purchaseContractTemplateItemService.selectByMainId(id);
        StringBuilder html = new StringBuilder();
        for (PurchaseContractTemplateItem item : purchaseContractTemplateItemList) {
            html.append(item.getItemContent());
        }
        return html;
    }

    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @AutoLog(value="\u5408\u540c\u6a21\u677f-\u7f16\u8f91")
    @SrmValidated
    @RequiresPermissions(value={"contractTemplate#purchaseContractTemplateHead:edit"})
    @PermissionDataOpt(businessType="contractTemplate", beanClass=PurchaseContractTemplateHeadService.class)
    public Result<?> edit(@RequestBody PurchaseContractTemplateHeadVO purchaseContractTemplateHeadPage) {
        PurchaseContractTemplateHead purchaseContractTemplateHead = new PurchaseContractTemplateHead();
        BeanUtils.copyProperties((Object)((Object)purchaseContractTemplateHeadPage), (Object)((Object)purchaseContractTemplateHead));
        this.purchaseContractTemplateHeadService.updateMain(purchaseContractTemplateHead, purchaseContractTemplateHeadPage.getPurchaseContractTemplateItemList());
        String id = purchaseContractTemplateHead.getId();
        return this.queryById(id);
    }

    @Operation(summary="\u5408\u540c\u6a21\u677f\u5934-\u5347\u7ea7\u7248\u672c", description="\u5408\u540c\u6a21\u677f\u5934-\u5347\u7ea7\u7248\u672c")
    @PostMapping(value={"/upgradeVersion"})
    @AutoLog(value="\u5408\u540c\u6a21\u677f-\u5347\u7ea7\u7248\u672c")
    @RequiresPermissions(value={"contractTemplate#purchaseContractTemplateHead:upgradeVersion"})
    @PermissionDataOpt(businessType="contractTemplate", beanClass=PurchaseContractTemplateHeadService.class)
    public Result<?> upgradeVersion(@RequestBody PurchaseContractTemplateHeadVO contractTemplateHeadPage) {
        PurchaseContractTemplateHeadVO contractTemplateHead = new PurchaseContractTemplateHeadVO();
        BeanUtils.copyProperties((Object)((Object)contractTemplateHeadPage), (Object)((Object)contractTemplateHead));
        this.purchaseContractTemplateHeadService.upgradeVersion(contractTemplateHead);
        return this.commonSuccessResult(3);
    }

    @Operation(summary="\u5408\u540c\u6a21\u677f\u5934-\u5347\u7ea7\u7248\u672c", description="\u5408\u540c\u6a21\u677f\u5934-\u5347\u7ea7\u7248\u672c")
    @PostMapping(value={"/cancel"})
    @AutoLog(value="\u5408\u540c\u6a21\u677f-\u5347\u7ea7\u7248\u672c")
    @RequiresPermissions(value={"contractTemplate#purchaseContractTemplateHead:cancel"})
    @PermissionDataOpt(businessType="contractTemplate", beanClass=PurchaseContractTemplateHeadService.class)
    public Result<?> cancel(@RequestBody PurchaseContractTemplateHeadVO contractTemplateHeadPage) {
        PurchaseContractTemplateHeadVO contractTemplateHead = new PurchaseContractTemplateHeadVO();
        BeanUtils.copyProperties((Object)((Object)contractTemplateHeadPage), (Object)((Object)contractTemplateHead));
        this.purchaseContractTemplateHeadService.cancel(contractTemplateHead.getId());
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u5408\u540c\u6a21\u677f-\u5220\u9664")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"contractTemplate#purchaseContractTemplateHead:delete"})
    @PermissionDataOpt(businessType="contractTemplate", beanClass=PurchaseContractTemplateHeadService.class)
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.purchaseContractTemplateHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u5408\u540c\u6a21\u677f-\u6279\u91cf\u5220\u9664")
    @Operation(summary="\u6279\u91cf\u5220\u9664", description="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"contractTemplate#purchaseContractTemplateHead:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.purchaseContractTemplateHeadService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"contractTemplate#purchaseContractTemplateHead:view"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        PurchaseContractTemplateHead purchaseContractTemplateHead = (PurchaseContractTemplateHead)((Object)this.purchaseContractTemplateHeadService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        PurchaseContractTemplateHeadVO purchaseContractTemplateHeadVO = new PurchaseContractTemplateHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseContractTemplateHead), (Object)((Object)purchaseContractTemplateHeadVO));
        List<PurchaseContractTemplateItem> purchaseContractTemplateItemList = this.purchaseContractTemplateItemService.selectByMainId(id);
        purchaseContractTemplateHeadVO.setPurchaseContractTemplateItemList(purchaseContractTemplateItemList);
        return Result.ok((Object)((Object)purchaseContractTemplateHeadVO));
    }

    @Operation(summary="\u901a\u8fc7\u91c7\u8d2d\u5408\u540c\u6a21\u677f\u5934id\u67e5\u8be2\u91c7\u8d2d\u5408\u540c\u6a21\u677f\u884c", description="\u901a\u8fc7\u91c7\u8d2d\u5408\u540c\u6a21\u677f\u5934id\u67e5\u8be2\u91c7\u8d2d\u5408\u540c\u6a21\u677f\u884c")
    @GetMapping(value={"/queryPurchaseContractTemplateItemByMainId"})
    @RequiresPermissions(value={"contractTemplate#purchaseContractTemplateHead:list"})
    public Result<?> queryPurchaseContractTemplateItemListByMainId(@RequestParam(name="id", required=true) String id) {
        List<PurchaseContractTemplateItem> purchaseContractTemplateItemList = this.purchaseContractTemplateItemService.selectByMainId(id);
        return Result.ok(purchaseContractTemplateItemList);
    }

    @Operation(summary="\u590d\u5236\u5355\u636e", description="\u590d\u5236\u5355\u636e")
    @GetMapping(value={"/copy"})
    @RequiresPermissions(value={"contractTemplate#purchaseContractTemplateHead:copy"})
    public Result<?> copy(@RequestParam(value="id") String id) {
        PurchaseContractTemplateHeadVO data = this.getData(id);
        this.purchaseContractTemplateHeadService.copy(data);
        return this.commonSuccessResult(3);
    }

    private PurchaseContractTemplateHeadVO getData(String id) {
        PurchaseContractTemplateHead purchaseContractTemplateHead = (PurchaseContractTemplateHead)((Object)this.purchaseContractTemplateHeadService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        PurchaseContractTemplateHeadVO purchaseContractTemplateHeadVO = new PurchaseContractTemplateHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseContractTemplateHead), (Object)((Object)purchaseContractTemplateHeadVO));
        List<PurchaseContractTemplateItem> purchaseContractTemplateItemList = this.purchaseContractTemplateItemService.selectByMainId(id);
        purchaseContractTemplateHeadVO.setPurchaseContractTemplateItemList(purchaseContractTemplateItemList);
        return purchaseContractTemplateHeadVO;
    }

    @Operation(summary="\u901a\u8fc7word\u4e0a\u4f20\u6a21\u677f", description="\u901a\u8fc7word\u4e0a\u4f20\u6a21\u677f")
    @GetMapping(value={"/uploadTemplateByDoc"})
    @RequiresPermissions(value={"contractTemplate#purchaseContractTemplateHead:copy"})
    public Result<?> uploadTemplateByDoc(HttpServletRequest request) {
        String headId = request.getParameter("id");
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<PurchaseContractTemplateItem> purchaseContractTemplateItems = new ArrayList<PurchaseContractTemplateItem>();
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entity.getValue();
            String fileSuffix = file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(".") + 1);
            if (!"doc".equals(fileSuffix) && !"docx".equals(fileSuffix)) {
                return Result.error((String)I18nUtil.translate((String)"i18n_alert_ROuNWWWWWQI_974a414a", (String)"\u53ea\u80fd\u5bfc\u5165word\u6587\u4ef6"));
            }
            PurchaseContractTemplateItem purchaseContractTemplateItem = this.purchaseContractTemplateItemService.uploadTemplateByDoc(headId, file);
            purchaseContractTemplateItems.add(purchaseContractTemplateItem);
        }
        return Result.ok(purchaseContractTemplateItems);
    }
}

