/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.esign.controller;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.validator.SrmLength;
import com.els.config.mybatis.TenantContext;
import com.els.modules.contract.entity.SaleContractAcceptance;
import com.els.modules.contract.service.SaleContractAcceptanceService;
import com.els.modules.electronsign.esign.entity.ElsContractAcceptanceEsign;
import com.els.modules.electronsign.esign.entity.ElsContractAcceptanceSigners;
import com.els.modules.electronsign.esign.enumerate.EsignBusTypeEnum;
import com.els.modules.electronsign.esign.rpc.service.EsignInvokeFinanceRpcService;
import com.els.modules.electronsign.esign.service.ElsContractAcceptanceEsignService;
import com.els.modules.electronsign.esign.service.ElsContractAcceptanceSignersService;
import com.els.modules.electronsign.esign.service.ElsEnterpriseCertificationInfoService;
import com.els.modules.electronsign.esign.vo.ElsContractAcceptanceEsignVO;
import com.els.modules.reconciliation.api.dto.ReconciliationConfirmationDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/esign/elsContractAcceptanceEsign"})
@Tag(name="\u9a8c\u6536\u7b7e\u7f72\u6d41\u7a0b\u7ba1\u7406")
public class ElsContractAcceptanceEsignController
extends BaseController<ElsContractAcceptanceEsign, ElsContractAcceptanceEsignService> {
    private static final Logger log = LoggerFactory.getLogger(ElsContractAcceptanceEsignController.class);
    @Autowired
    private ElsContractAcceptanceEsignService elsContractAcceptanceEsignService;
    @Autowired
    private ElsContractAcceptanceSignersService elsContractAcceptanceSignersService;
    @Autowired
    private ElsEnterpriseCertificationInfoService elsEnterpriseCertificationInfoService;
    @Resource
    private EsignInvokeFinanceRpcService esignInvokeFinanceRpcService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SaleContractAcceptanceService saleContractAcceptanceService;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"esign#contractAcceptanceEsign:list"})
    @PermissionDataView(businessType="eSign")
    public Result<?> queryPageList(ElsContractAcceptanceEsign elsEsign, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsEsign), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        queryWrapper.eq((Object)"send_status", (Object)"1");
        IPage pageList = this.elsContractAcceptanceEsignService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/saleList"})
    @RequiresPermissions(value={"esign#saleContractAcceptanceEsign:list"})
    public Result<?> saleList(ElsContractAcceptanceEsign elsEsign, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsEsign), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"to_els_account", (Object)TenantContext.getTenant());
        IPage pageList = this.elsContractAcceptanceEsignService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="\u9a8c\u6536\u7b7e\u7f72\u6d41\u7a0b\u7ba1\u7406", value="\u6dfb\u52a0")
    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @SrmLength
    @RequiresPermissions(value={"esign#contractAcceptanceEsign:signer", "esign#contractAcceptanceEsign:signDoc", "esign#saleContractAcceptanceEsign:initiate"}, logical=Logical.OR)
    public Result<?> add(@RequestBody ElsContractAcceptanceEsignVO elsEsignPage) {
        ElsContractAcceptanceEsign elsEsign = new ElsContractAcceptanceEsign();
        BeanUtils.copyProperties((Object)((Object)elsEsignPage), (Object)((Object)elsEsign));
        this.elsContractAcceptanceEsignService.saveMain(elsEsign, elsEsignPage.getPurchaseSignersList(), elsEsignPage.getSaleSignersList());
        return Result.ok((Object)((Object)elsEsign));
    }

    @AutoLog(busModule="\u9a8c\u6536\u7b7e\u7f72\u6d41\u7a0b\u7ba1\u7406", value="\u7f16\u8f91")
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @SrmValidated
    @RequiresPermissions(value={"esign#contractAcceptanceEsign:signer", "esign#contractAcceptanceEsign:signDoc", "esign#saleContractAcceptanceEsign:initiate"}, logical=Logical.OR)
    public Result<?> edit(@RequestBody ElsContractAcceptanceEsignVO elsEsignPage) {
        ElsContractAcceptanceEsign elsEsign = new ElsContractAcceptanceEsign();
        BeanUtils.copyProperties((Object)((Object)elsEsignPage), (Object)((Object)elsEsign));
        this.elsContractAcceptanceEsignService.updateMain(elsEsign, elsEsignPage.getPurchaseSignersList(), elsEsignPage.getSaleSignersList(), elsEsignPage.getSaleAttachments());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u9a8c\u6536\u7b7e\u7f72\u6d41\u7a0b\u7ba1\u7406", value="\u901a\u8fc7id\u5220\u9664")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"esign#saleContractAcceptanceEsign:cancel"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.elsContractAcceptanceEsignService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"esign#contractAcceptanceEsign:detail", "esign#saleContractAcceptanceEsign:detail"}, logical=Logical.OR)
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        ElsContractAcceptanceEsign elsEsign = (ElsContractAcceptanceEsign)((Object)this.elsContractAcceptanceEsignService.getById((Serializable)((Object)id)));
        ElsContractAcceptanceEsignVO elsEsignVO = new ElsContractAcceptanceEsignVO();
        BeanUtils.copyProperties((Object)((Object)elsEsign), (Object)((Object)elsEsignVO));
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"head_id", (Object)id);
        wrapper.eq((Object)"role_type", (Object)"0");
        elsEsignVO.setPurchaseSignersList(this.elsContractAcceptanceSignersService.list((Wrapper)wrapper));
        wrapper.clear();
        wrapper.eq((Object)"head_id", (Object)id);
        wrapper.eq((Object)"role_type", (Object)"1");
        elsEsignVO.setSaleSignersList(this.elsContractAcceptanceSignersService.list((Wrapper)wrapper));
        elsEsignVO.setPurchaseAttachments(this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(elsEsign.getId()));
        elsEsignVO.setSaleAttachments(this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(elsEsign.getId()));
        return Result.ok((Object)((Object)elsEsignVO));
    }

    @Operation(summary="\u901a\u8fc7\u9a8c\u6536\u7b7e\u7f72\u6d41\u7a0b\u7ba1\u7406id\u67e5\u8be2\u7b7e\u7f72\u4eba", description="\u901a\u8fc7\u9a8c\u6536\u7b7e\u7f72\u6d41\u7a0b\u7ba1\u7406id\u67e5\u8be2\u7b7e\u7f72\u4eba")
    @GetMapping(value={"/queryElsSignersByMainId"})
    @RequiresPermissions(value={"esign#contractAcceptanceEsign:detail", "esign#saleContractAcceptanceEsign:detail"}, logical=Logical.OR)
    public Result<?> queryElsSignersListByMainId(@RequestParam(name="id", required=true) String id) {
        List<ElsContractAcceptanceSigners> elsSignersList = this.elsContractAcceptanceSignersService.selectByMainId(id);
        return Result.ok(elsSignersList);
    }

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/getSignerlist"})
    @RequiresPermissions(value={"esign#contractAcceptanceEsign:detail", "esign#saleContractAcceptanceEsign:detail"}, logical=Logical.OR)
    public Result<?> getSignerlist(@RequestParam(name="id", required=true) String id, @RequestParam(name="signer", required=true) String signer, @RequestParam(name="createdAccount", required=false) String createdAccount, @RequestParam(name="busType", required=false) String busType, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        String elsAccount = null;
        String toElsAccount = null;
        if (EsignBusTypeEnum.CONTRACT_ACCEPTANCE.getValue().equals(busType)) {
            SaleContractAcceptance contractHead = (SaleContractAcceptance)((Object)this.saleContractAcceptanceService.getById((Serializable)((Object)id)));
            if (contractHead == null) {
                return Result.error((String)"\u5408\u540c\u4e0d\u5b58\u5728");
            }
            elsAccount = contractHead.getElsAccount();
            toElsAccount = contractHead.getToElsAccount();
        } else if (EsignBusTypeEnum.RECONCILIATION_CONFIRMATION.getValue().equals(busType)) {
            ReconciliationConfirmationDTO reconciliationConfirmation = this.esignInvokeFinanceRpcService.getSaleReconciliationConfirmationById(id);
            if (reconciliationConfirmation == null) {
                return Result.error((String)I18nUtil.translate((String)"i18n_alert_RLxxMK_577f2c76", (String)"\u786e\u8ba4\u51fd\u4e0d\u5b58\u5728"));
            }
            elsAccount = reconciliationConfirmation.getElsAccount();
            toElsAccount = reconciliationConfirmation.getToElsAccount();
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        QueryWrapper wrapper = new QueryWrapper();
        if ("purchase".equals(signer)) {
            wrapper.eq((Object)"els_account", (Object)toElsAccount);
        } else {
            wrapper.eq((Object)"els_account", (Object)elsAccount);
        }
        if (StrUtil.isNotBlank((CharSequence)createdAccount)) {
            wrapper.eq((Object)"created_account", (Object)createdAccount);
        }
        wrapper.isNotNull((Object)"org_id");
        IPage pageList = this.elsEnterpriseCertificationInfoService.page((IPage)page, (Wrapper)wrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="\u9a8c\u6536\u7b7e\u7f72\u6d41\u7a0b\u7ba1\u7406", value="\u5173\u952e\u5b57\u5b9a\u4f4d")
    @Operation(summary="\u5173\u952e\u5b57\u5b9a\u4f4d", description="\u5173\u952e\u5b57\u5b9a\u4f4d")
    @GetMapping(value={"/keyWordToAera"})
    @RequiresPermissions(value={"esign#saleContractAcceptanceEsign:initiate"})
    public Result<?> keyWordToAera(@RequestParam(name="elsAccount", required=true) String elsAccount, @RequestParam(name="filesId", required=true) String filesId, @RequestParam(name="signWord", required=true) String signWord) {
        ElsContractAcceptanceSigners signers = new ElsContractAcceptanceSigners();
        signers.setElsAccount(elsAccount);
        signers.setFilesId(filesId);
        signers.setSignWord(signWord);
        return this.elsContractAcceptanceSignersService.keyWordToAera(signers);
    }

    @AutoLog(busModule="\u9a8c\u6536\u7b7e\u7f72\u6d41\u7a0b\u7ba1\u7406", value="\u9000\u56de")
    @Operation(summary="\u9000\u56de", description="\u9000\u56de")
    @GetMapping(value={"/sendBack"})
    @RequiresPermissions(value={"esign#saleContractAcceptanceEsign:back"})
    public Result<?> sendBack(@RequestParam(name="id", required=true) String id) {
        return this.elsContractAcceptanceEsignService.sendBack(id);
    }

    @AutoLog(busModule="\u9a8c\u6536\u7b7e\u7f72\u6d41\u7a0b\u7ba1\u7406", value="\u64a4\u9500")
    @Operation(summary="\u64a4\u9500", description="\u64a4\u9500")
    @GetMapping(value={"/backout"})
    @RequiresPermissions(value={"esign#saleContractAcceptanceEsign:cancel"})
    public Result<?> backout(@RequestParam(name="id", required=true) String id, @RequestParam(name="reason", required=true) String reason) {
        return this.elsContractAcceptanceEsignService.backout(id, reason);
    }

    @AutoLog(busModule="\u9a8c\u6536\u7b7e\u7f72\u6d41\u7a0b\u7ba1\u7406", value="\u7b7e\u7f72\u6587\u6863\u4e0b\u8f7d")
    @Operation(summary="\u7b7e\u7f72\u6587\u6863\u4e0b\u8f7d", description="\u7b7e\u7f72\u6587\u6863\u4e0b\u8f7d")
    @GetMapping(value={"/signFileDownload"})
    @RequiresPermissions(value={"contractAcceptance#contractAcceptance:down", "esign#contractAcceptanceEsign:down", "esign#saleContractAcceptanceEsign:down"}, logical=Logical.OR)
    public Result<?> signFileDownload(@RequestParam(name="id", required=true) String id) {
        return this.elsContractAcceptanceEsignService.signFileDownload(id);
    }

    @AutoLog(busModule="\u7535\u5b50\u7b7e\u7ae0", value="\u6587\u4ef6\u4e0a\u4f20")
    @PostMapping(value={"/fileCreate"})
    @RequiresPermissions(value={"esign#saleContractAcceptanceEsign:initiate"})
    public Result<?> uploadFile(@RequestBody ElsContractAcceptanceEsignVO esign, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.elsContractAcceptanceEsignService.uploadFile(esign, request, response);
    }

    @AutoLog(busModule="\u9a8c\u6536\u7b7e\u7f72\u6d41\u7a0b\u7ba1\u7406", value="\u5f85\u7b7e\u7f72\u6587\u6863\u9884\u89c8")
    @Operation(summary="\u5f85\u7b7e\u7f72\u6587\u6863\u9884\u89c8", description="\u5f85\u7b7e\u7f72\u6587\u6863\u9884\u89c8")
    @GetMapping(value={"/viewEsignFile"})
    @RequiresPermissions(value={"esign#saleContractAcceptanceEsign:down"})
    public Result<?> viewEsignFile(@RequestParam(name="id", required=true) String id) {
        return this.elsContractAcceptanceEsignService.viewEsignFile(id);
    }

    @AutoLog(busModule="\u9a8c\u6536\u7b7e\u7f72\u6d41\u7a0b\u7ba1\u7406", value="\u5355\u636e\u7b7e\u7f72\u6587\u6863\u4e0b\u8f7d")
    @Operation(summary="\u5355\u636e\u7b7e\u7f72\u6587\u6863\u4e0b\u8f7d", description="\u5355\u636e\u7b7e\u7f72\u6587\u6863\u4e0b\u8f7d")
    @GetMapping(value={"/busSignFileDownload"})
    @RequiresPermissions(value={"esign#saleContractAcceptanceEsign:down"})
    public Result<?> busSignFileDownload(@RequestParam(name="id", required=true) String id, @RequestParam(name="busType", required=true) String busType) {
        return this.elsContractAcceptanceEsignService.busSignFileDownload(id, busType);
    }

    @AutoLog(busModule="\u9a8c\u6536\u7b7e\u7f72\u6d41\u7a0b\u7ba1\u7406", value="\u6d41\u7a0b\u67e5\u8be2")
    @Operation(summary="\u6d41\u7a0b\u67e5\u8be2", description="\u6d41\u7a0b\u67e5\u8be2")
    @GetMapping(value={"/flowQuery"})
    @RequiresPermissions(value={"esign#saleContractAcceptanceEsign:statusQuery"})
    public Result<?> flowQuery(@RequestParam(name="id", required=true) String id) {
        return this.elsContractAcceptanceEsignService.flowQuery(id);
    }

    @AutoLog(value="(e\u7b7e\u5b9d)\u4f01\u4e1a\u8ba4\u8bc1-\u7b7e\u7f72\u4eba\u7b7e\u7f72\u5b8c\u6210\u56de\u8c03")
    @Operation(summary="\u7b7e\u7f72\u4eba\u7b7e\u7f72\u5b8c\u6210\u56de\u8c03", description="\u7b7e\u7f72\u4eba\u7b7e\u7f72\u5b8c\u6210\u56de\u8c03")
    @PostMapping(value={"/noToken/callback/esign"})
    public void noTokenCallbackEsign(@RequestBody JSONObject object) {
        log.info("\u9a8c\u6536\u6d41\u7a0bE\u7b7e\u5b9d\u6d41\u7a0b\u56de\u8c03\u5165\u53c2:[{}]", (Object)object.toJSONString());
        this.elsContractAcceptanceEsignService.esignSigner(object);
    }

    @AutoLog(busModule="\u7535\u5b50\u7b7e\u7ae0", value="\u4e00\u6b65\u7b7e\u7f72\u53d1\u8d77")
    @PostMapping(value={"/createFlowOneStep"})
    @RequiresPermissions(value={"esign#saleContractAcceptanceEsign:initiate"})
    public Result<?> createFlowOneStep(@RequestBody ElsContractAcceptanceEsignVO esign) throws Exception {
        return this.elsContractAcceptanceEsignService.createFlowOneStep(esign);
    }

    @AutoLog(busModule="\u7535\u5b50\u7b7e\u7ae0", value="\u6d41\u7a0b\u5f00\u542f")
    @GetMapping(value={"/startFlow"})
    @RequiresPermissions(value={"esign#saleContractAcceptanceEsign:open"})
    public Result<?> startFlow(@RequestParam(name="id", required=true) String id) throws Exception {
        return this.elsContractAcceptanceEsignService.startFlow(id);
    }

    @AutoLog(busModule="\u7535\u5b50\u7b7e\u7ae0", value="\u6d41\u7a0b\u5f52\u6863")
    @GetMapping(value={"/archiveFlow"})
    @RequiresPermissions(value={"esign#saleContractAcceptanceEsign:archive"})
    public Result<?> archiveFlow(@RequestParam(name="id", required=true) String id) throws Exception {
        return this.elsContractAcceptanceEsignService.archiveFlow(id);
    }
}

