/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.esign.controller;

import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.util.I18nUtil;
import com.els.modules.electronsign.esign.entity.PurchaseSignReturnAttachment;
import com.els.modules.electronsign.esign.service.PurchaseSignReturnAttachmentService;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u4f9b\u5e94\u5546\u56de\u4f20\u9644\u4ef6")
@RestController
@RequestMapping(value={"/esign/purchaseSignReturnAttachment"})
public class PurchaseSignReturnAttachmentController
extends BaseController<PurchaseSignReturnAttachment, PurchaseSignReturnAttachmentService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseSignReturnAttachmentController.class);
    @Autowired
    private PurchaseSignReturnAttachmentService purchaseSignReturnAttachmentService;
    @Value(value="${els.path.upload}")
    private String uploadpath;

    @AutoLog(value="\u56de\u4f20\u9644\u4ef6-\u4e0b\u8f7d", operateType=1)
    @GetMapping(value={"/download"})
    @RequiresPermissions(value={"esign#purchaseEsign:confirm"})
    public void download(@RequestParam(name="id") String id, HttpServletResponse response) {
        PurchaseSignReturnAttachment attachment = (PurchaseSignReturnAttachment)((Object)this.purchaseSignReturnAttachmentService.getById((Serializable)((Object)id)));
        String downloadFilePath = this.uploadpath + File.separator + attachment.getFilePath();
        File file = new File(downloadFilePath);
        Assert.isTrue((boolean)file.exists(), (String)I18nUtil.translate((String)"i18n_alert_BIxMKSIqQG_748441c8", (String)"\u9644\u4ef6\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664"));
        try (ServletOutputStream outputStream = response.getOutputStream();
             BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));){
            int len;
            response.addHeader("Content-Disposition", "attachment;fileName=" + new String(file.getName().getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)inputStream).read(buf)) > 0) {
                outputStream.write(buf, 0, len);
            }
            outputStream.flush();
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25" + e.getMessage());
        }
    }
}

