/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.contractlock.excel;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.excel.service.BaseExportService;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.base.api.service.ExportDataLoaderService;
import com.els.modules.electronsign.contractlock.entity.ElsClSignContract;
import com.els.modules.electronsign.contractlock.entity.ElsClSigners;
import com.els.modules.electronsign.contractlock.entity.PurchaseClSeals;
import com.els.modules.electronsign.contractlock.entity.SaleClSeals;
import com.els.modules.electronsign.contractlock.enumerate.CLContractStatusEnum;
import com.els.modules.electronsign.contractlock.enumerate.CLFIleTypeEnum;
import com.els.modules.electronsign.contractlock.enumerate.ClContractTenantType;
import com.els.modules.electronsign.contractlock.service.ElsClContractService;
import com.els.modules.electronsign.contractlock.service.ElsClSignersService;
import com.els.modules.electronsign.contractlock.service.PurchaseClSealsService;
import com.els.modules.electronsign.contractlock.service.SaleClSealsService;
import com.els.modules.electronsign.contractlock.vo.ContractExportVO;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="contractExportServiceImpl")
public class ContractExportServiceImpl
extends BaseExportService<ElsClSignContract, ContractExportVO, ElsClSignContract>
implements ExportDataLoaderService {
    @Autowired
    private ElsClContractService elsClContractService;
    @Autowired
    private ElsClSignersService signersService;
    @Autowired
    private PurchaseClSealsService purchaseClSealsService;
    @Autowired
    private SaleClSealsService saleClSealsService;

    public List<ContractExportVO> queryExportData(QueryWrapper<ElsClSignContract> queryWrapper, ElsClSignContract param, Map<String, String[]> paramMap) {
        ArrayList result = Lists.newArrayList();
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        queryWrapper.eq((Object)"is_launch", (Object)"1");
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        List list = this.elsClContractService.list((Wrapper)queryWrapper);
        if (CollUtil.isEmpty((Collection)list)) {
            return result;
        }
        List ids = list.stream().map(x -> x.getId()).distinct().collect(Collectors.toList());
        List signers = this.signersService.list((Wrapper)Wrappers.lambdaQuery().in(ElsClSigners::getHeadId, ids));
        Map<String, List<ElsClSigners>> stringListMap = signers.stream().collect(Collectors.groupingBy(x -> x.getHeadId()));
        String br = String.valueOf('\n');
        for (ElsClSignContract contract : list) {
            ContractExportVO vo = new ContractExportVO();
            vo.setTheme(contract.getSubject());
            vo.setFileType(CLFIleTypeEnum.getDescByValue(contract.getFileType()));
            vo.setContractStatus(CLContractStatusEnum.getDesc(contract.getContractStatus()));
            List<ElsClSigners> sign = stringListMap.get(contract.getId());
            if (CollUtil.isNotEmpty(sign)) {
                StringBuffer ssb = new StringBuffer();
                StringBuffer nameSb = new StringBuffer();
                StringBuffer contactSb = new StringBuffer();
                StringBuffer timeSb = new StringBuffer();
                StringBuffer typeSb = new StringBuffer();
                int i = 1;
                for (ElsClSigners elsClSigners : sign) {
                    String sealIds;
                    String[] tenantArr;
                    boolean flag = i == sign.size();
                    ++i;
                    nameSb.append(elsClSigners.getSignatoryName());
                    contactSb.append(elsClSigners.getSignatoryContact());
                    int index = 1;
                    for (String s : tenantArr = elsClSigners.getTenantType().split(",")) {
                        typeSb.append(ClContractTenantType.getDesc(s));
                        if (index >= tenantArr.length) continue;
                        typeSb.append(",");
                        ++index;
                    }
                    if (!flag) {
                        nameSb.append(br);
                        contactSb.append(br);
                        typeSb.append(br);
                    }
                    if (ObjectUtil.isNotEmpty((Object)elsClSigners.getSignTime())) {
                        timeSb.append(DateUtil.format((Date)elsClSigners.getSignTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                        if (!flag) {
                            timeSb.append(br);
                        }
                    } else {
                        timeSb.append(" ");
                        if (!flag) {
                            timeSb.append(br);
                        }
                    }
                    if (StrUtil.isNotBlank((CharSequence)(sealIds = elsClSigners.getSealIds()))) {
                        Object[] sids = sealIds.split(",");
                        if (elsClSigners.getRoleType().equals("0")) {
                            List purchaseClSeals = this.purchaseClSealsService.list((Wrapper)Wrappers.lambdaQuery().in(PurchaseClSeals::getSealId, sids));
                            if (!CollUtil.isNotEmpty((Collection)purchaseClSeals)) continue;
                            ssb.append(purchaseClSeals.stream().map(x -> x.getSealName()).collect(Collectors.joining(",")));
                            if (flag) continue;
                            ssb.append(br);
                            continue;
                        }
                        List saleClSeals = this.saleClSealsService.list((Wrapper)Wrappers.lambdaQuery().in(SaleClSeals::getSealId, sids));
                        if (!CollUtil.isNotEmpty((Collection)saleClSeals)) continue;
                        ssb.append(saleClSeals.stream().map(x -> x.getSealName()).collect(Collectors.joining(",")));
                        if (flag) continue;
                        ssb.append(br);
                        continue;
                    }
                    ssb.append(" ");
                    if (flag) continue;
                    ssb.append(br);
                }
                vo.setSignType(typeSb.toString());
                vo.setSealName(ssb.toString());
                vo.setContact(contactSb.toString());
                vo.setSignatory(nameSb.toString());
                vo.setSignTime(timeSb.toString());
            }
            result.add(vo);
        }
        return result;
    }

    public long queryExportDataCount(QueryWrapper<ElsClSignContract> queryWrapper, ElsClSignContract map, Map<String, String[]> paramMap) {
        ArrayList result = Lists.newArrayList();
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        queryWrapper.eq((Object)"is_launch", (Object)"1");
        return this.elsClContractService.count((Wrapper)queryWrapper);
    }

    public String getBusinessType() {
        return I18nUtil.translate((String)"i18n_field_jWWFuG_b2a8b944", (String)"\u7528\u5370\u6570\u636e\u5bfc\u51fa");
    }

    public String getBeanName() {
        return "clSignContractExcelDataBatchQueryLoader";
    }

    public String loadData(Integer pageNumber, Integer pageSize, Map<String, Object> entityMap, Map<String, String[]> requestParamMap) {
        ArrayList result = Lists.newArrayList();
        Page page = new Page();
        QueryWrapper queryWrapper = this.builderWrapper(entityMap, requestParamMap);
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        queryWrapper.eq((Object)"is_launch", (Object)"1");
        List list = ((Page)this.elsClContractService.page((IPage)page, (Wrapper)queryWrapper)).getRecords();
        if (CollUtil.isEmpty((Collection)list)) {
            return "[]";
        }
        List ids = list.stream().map(x -> x.getId()).distinct().collect(Collectors.toList());
        List signers = this.signersService.list((Wrapper)Wrappers.lambdaQuery().in(ElsClSigners::getHeadId, ids));
        Map<String, List<ElsClSigners>> stringListMap = signers.stream().collect(Collectors.groupingBy(x -> x.getHeadId()));
        String br = String.valueOf('\n');
        for (ElsClSignContract contract : list) {
            ContractExportVO vo = new ContractExportVO();
            vo.setTheme(contract.getSubject());
            vo.setFileType(CLFIleTypeEnum.getDescByValue(contract.getFileType()));
            vo.setContractStatus(CLContractStatusEnum.getDesc(contract.getContractStatus()));
            List<ElsClSigners> sign = stringListMap.get(contract.getId());
            if (CollUtil.isNotEmpty(sign)) {
                StringBuffer ssb = new StringBuffer();
                StringBuffer nameSb = new StringBuffer();
                StringBuffer contactSb = new StringBuffer();
                StringBuffer timeSb = new StringBuffer();
                StringBuffer typeSb = new StringBuffer();
                int i = 1;
                for (ElsClSigners elsClSigners : sign) {
                    String sealIds;
                    boolean flag = i == sign.size();
                    ++i;
                    nameSb.append(elsClSigners.getSignatoryName());
                    contactSb.append(elsClSigners.getSignatoryContact());
                    typeSb.append(ClContractTenantType.getDesc(elsClSigners.getTenantType()));
                    if (!flag) {
                        nameSb.append(br);
                        contactSb.append(br);
                        typeSb.append(br);
                    }
                    if (ObjectUtil.isNotEmpty((Object)elsClSigners.getSignTime())) {
                        timeSb.append(DateUtil.format((Date)elsClSigners.getSignTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                        if (!flag) {
                            timeSb.append(br);
                        }
                    } else {
                        timeSb.append(" ");
                        if (!flag) {
                            timeSb.append(br);
                        }
                    }
                    if (StrUtil.isNotBlank((CharSequence)(sealIds = elsClSigners.getSealIds()))) {
                        Object[] sids = sealIds.split(",");
                        if (elsClSigners.getRoleType().equals("0")) {
                            List purchaseClSeals = this.purchaseClSealsService.list((Wrapper)Wrappers.lambdaQuery().in(PurchaseClSeals::getSealId, sids));
                            if (!CollUtil.isNotEmpty((Collection)purchaseClSeals)) continue;
                            ssb.append(purchaseClSeals.stream().map(x -> x.getSealName()).collect(Collectors.joining(",")));
                            if (flag) continue;
                            ssb.append(br);
                            continue;
                        }
                        List saleClSeals = this.saleClSealsService.list((Wrapper)Wrappers.lambdaQuery().in(SaleClSeals::getSealId, sids));
                        if (!CollUtil.isNotEmpty((Collection)saleClSeals)) continue;
                        ssb.append(saleClSeals.stream().map(x -> x.getSealName()).collect(Collectors.joining(",")));
                        if (flag) continue;
                        ssb.append(br);
                        continue;
                    }
                    ssb.append(" ");
                    if (flag) continue;
                    ssb.append(br);
                }
                vo.setSignType(typeSb.toString());
                vo.setSealName(ssb.toString());
                vo.setContact(contactSb.toString());
                vo.setSignatory(nameSb.toString());
                vo.setSignTime(timeSb.toString());
            }
            result.add(vo);
        }
        return JSON.toJSONString((Object)result);
    }
}

