/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.contractlock.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.IpaasConfig;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.electronsign.contractlock.entity.PurchaseClPersonalInfo;
import com.els.modules.electronsign.contractlock.mapper.PurchaseClPersonalInfoMapper;
import com.els.modules.electronsign.contractlock.service.PurchaseClPersonalInfoService;
import com.els.modules.electronsign.contractlock.util.ClResultAnalysisUtil;
import com.els.modules.electronsign.contractlock.vo.ClCallback;
import com.els.modules.electronsign.contractlock.vo.ClCompanyCertificationVO;
import com.els.modules.electronsign.contractlock.vo.ClCompanyStaffVO;
import com.els.modules.electronsign.contractlock.vo.ClPersonalCertificationVO;
import com.els.modules.electronsign.contractlock.vo.ClQueryCertificationVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseClPersonalInfoServiceImpl
extends BaseServiceImpl<PurchaseClPersonalInfoMapper, PurchaseClPersonalInfo>
implements PurchaseClPersonalInfoService {
    Map<String, String> config = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
    private String address = this.config.get("service.address");
    private Map<String, String> configMap = ((IpaasConfig)SpringContextUtils.getBean(IpaasConfig.class)).getConfig();
    private String service = this.configMap.get("service");
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    public void updateInfo(PurchaseClPersonalInfo req) {
        this.check(req);
        req.setUpdateTime(new Date());
        LoginUserDTO sysUser = SysUtil.getLoginUser();
        String currentUser = sysUser.getSubAccount();
        req.setUpdateBy(currentUser);
        ((PurchaseClPersonalInfoMapper)this.baseMapper).updateById((Object)req);
        this.getCertificationInfo(req.getId());
    }

    public void saveInfo(PurchaseClPersonalInfo req) {
        this.check(req);
        req.setCreateTime(new Date());
        LoginUserDTO sysUser = SysUtil.getLoginUser();
        String currentUser = sysUser.getSubAccount();
        req.setCreateBy(currentUser);
        req.setElsAccount(TenantContext.getTenant());
        ((PurchaseClPersonalInfoMapper)this.baseMapper).insert((Object)req);
        this.getCertificationInfo(req.getId());
    }

    public void handleDb(PurchaseClPersonalInfo req) {
        if (StrUtil.isBlank((CharSequence)req.getId())) {
            this.saveInfo(req);
        } else {
            this.updateInfo(req);
        }
    }

    @Override
    public void add(PurchaseClPersonalInfo purchaseClPersonalInfo) {
        this.saveInfo(purchaseClPersonalInfo);
    }

    @Override
    public void check(PurchaseClPersonalInfo purchaseClPersonalInfo) {
        Assert.isTrue((this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PurchaseClPersonalInfo::getApplyContact, (Object)purchaseClPersonalInfo.getApplyContact())).eq(PurchaseClPersonalInfo::getApplyContactType, (Object)purchaseClPersonalInfo.getApplyContactType())).eq(PurchaseClPersonalInfo::getCompanyId, (Object)purchaseClPersonalInfo.getCompanyId())).ne(StrUtil.isNotBlank((CharSequence)purchaseClPersonalInfo.getId()), BaseEntity::getId, (Object)purchaseClPersonalInfo.getId())) == 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_MKdecRWKHCKWRCjL_7d1ddba3", (String)"\u5b58\u5728\u76f8\u540c\u8054\u7cfb\u65b9\u5f0f\u3001\u8054\u7cfb\u65b9\u5f0f\u7c7b\u578b\u3001\u516c\u53f8\u7684\u4eba"));
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void edit(PurchaseClPersonalInfo purchaseClPersonalInfo) {
        PurchaseClPersonalInfo old = (PurchaseClPersonalInfo)((Object)this.getById((Serializable)((Object)purchaseClPersonalInfo.getId())));
        Assert.isTrue((!"ADMIN".equals(old.getRoleStr()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_xOcrRvjjVH_b612843a", (String)"\u4e0d\u80fd\u4fee\u6539\u7ba1\u7406\u5458\u7684\u4fe1\u606f"));
        boolean needSync = StrUtil.isNotBlank((CharSequence)purchaseClPersonalInfo.getCompanyId()) && (!purchaseClPersonalInfo.getApplyContact().equals(old.getApplyContact()) || !purchaseClPersonalInfo.getApplyContactType().equals(old.getApplyContactType()) || !purchaseClPersonalInfo.getApplyUserName().equals(old.getApplyUserName()));
        this.updateInfo(purchaseClPersonalInfo);
        if (needSync) {
            ClCompanyStaffVO delReq = new ClCompanyStaffVO();
            delReq.setCompanyId(purchaseClPersonalInfo.getCompanyId());
            ClCompanyStaffVO.Body body = new ClCompanyStaffVO.Body();
            body.setContact(old.getApplyContact());
            body.setContactType(old.getApplyContactType());
            delReq.setBody(body);
            Result<?> result = this.getIPassResponse(delReq, "remove-staff-company-personal");
            Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
            ClCompanyStaffVO addReq = new ClCompanyStaffVO();
            addReq.setCompanyId(purchaseClPersonalInfo.getCompanyId());
            ClCompanyStaffVO.Body addBody = new ClCompanyStaffVO.Body();
            addBody.setUser(new ClCompanyCertificationVO.ApplicantInfo(purchaseClPersonalInfo.getApplyUserName(), purchaseClPersonalInfo.getApplyContact(), purchaseClPersonalInfo.getApplyContactType()));
            addReq.setBody(addBody);
            Result<?> addResult = this.getIPassResponse(addReq, "add-staff-company-personal");
            Assert.isTrue((boolean)addResult.isSuccess(), (String)result.getMessage());
        }
    }

    @Override
    public void delete(String id) {
        ((PurchaseClPersonalInfoMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((PurchaseClPersonalInfoMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void submitCertification(PurchaseClPersonalInfo req) {
        req.setCertificationStartTime(new Date());
        this.handleDb(req);
        ClPersonalCertificationVO certificationInfo = (ClPersonalCertificationVO)SysUtil.copyProperties((Object)((Object)req), ClPersonalCertificationVO.class);
        certificationInfo.setUsername(req.getApplyUserName());
        certificationInfo.setUser(new ClPersonalCertificationVO.User(req.getApplyContact(), req.getApplyContactType()));
        certificationInfo.setCallbackUrl(this.address + "/els/contractLock/purchaseClPersonalInfo/noToken/callback/personal");
        ClResultAnalysisUtil.handleEmptyStr(certificationInfo);
        Result<?> response = this.getIPassResponse(certificationInfo, "get-auth-personal");
        if (response.isSuccess()) {
            JSONObject jsonObject = (JSONObject)response.getResult();
            req.setCertificationPageUrl(jsonObject.getString("authUrl"));
            req.setAuthId(jsonObject.getString("authId"));
            this.updateById((Object)req);
        } else {
            Assert.isTrue((boolean)false, (String)response.getMessage());
        }
    }

    @Override
    public void getCertificationInfo(String id) {
        PurchaseClPersonalInfo info = (PurchaseClPersonalInfo)((Object)this.getById((Serializable)((Object)id)));
        ClQueryCertificationVO clQueryCertificationVO = new ClQueryCertificationVO();
        ClQueryCertificationVO.Param base = new ClQueryCertificationVO.Param();
        base.setContact(info.getApplyContact());
        base.setContactType(info.getApplyContactType());
        clQueryCertificationVO.setBase(base);
        Result<?> response = this.getIPassResponse(clQueryCertificationVO, "query-auth-personal");
        if (response.isSuccess()) {
            JSONObject jsonObject = (JSONObject)response.getResult();
            Boolean realName = jsonObject.getBoolean("realName");
            if (realName != null && realName.booleanValue()) {
                info.setRealName("1");
            } else {
                info.setRealName("0");
            }
            this.updateById((Object)info);
        }
    }

    @Override
    public void handleCallBackAuth(String contents) {
        ClCallback.PersonalAuth personalAuth = (ClCallback.PersonalAuth)JSON.parseObject((String)contents, ClCallback.PersonalAuth.class);
        PurchaseClPersonalInfo dbInfo = ((PurchaseClPersonalInfoMapper)this.baseMapper).selectByRequestId(personalAuth.getAuthId());
        if (ObjectUtil.isNotNull((Object)((Object)dbInfo)) && "1".equals(personalAuth.getStatus())) {
            dbInfo.setRealName("1");
            dbInfo.setUpdateTime(new Date());
            this.updateById((Object)dbInfo);
        }
    }

    private Result<?> getIPassResponse(Object req, String iPassCode) {
        JSONObject object = this.invokeBaseRpcService.callIPaasInterface(JSON.parseObject((String)JSON.toJSONString((Object)req)), this.service, this.invokeBaseRpcService.getIpaasInterfaceCode(iPassCode));
        return ClResultAnalysisUtil.analysisResult(object);
    }
}

