/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.esignv3.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.electronsign.config.EsignV3Properties;
import com.els.modules.electronsign.enums.SealsTypeEnum;
import com.els.modules.electronsign.esign.enumerate.EsignRoleTypeEnum;
import com.els.modules.electronsign.esign.util.FileHelper;
import com.els.modules.electronsign.esignv3.dto.CallBackDto;
import com.els.modules.electronsign.esignv3.dto.FileRp;
import com.els.modules.electronsign.esignv3.dto.FileRq;
import com.els.modules.electronsign.esignv3.dto.SealsAuthRq;
import com.els.modules.electronsign.esignv3.dto.SealsOrgAuthRq;
import com.els.modules.electronsign.esignv3.dto.SealsRp;
import com.els.modules.electronsign.esignv3.dto.SealsRq;
import com.els.modules.electronsign.esignv3.entity.EsignV3SealsAuth;
import com.els.modules.electronsign.esignv3.entity.SaleEsignV3Org;
import com.els.modules.electronsign.esignv3.entity.SaleEsignV3Seals;
import com.els.modules.electronsign.esignv3.enums.SealAuthStatusEnum;
import com.els.modules.electronsign.esignv3.enums.SealCallBackEnum;
import com.els.modules.electronsign.esignv3.enums.SealRoleEnum;
import com.els.modules.electronsign.esignv3.enums.SealStatusEnum;
import com.els.modules.electronsign.esignv3.mapper.SaleEsignV3SealsMapper;
import com.els.modules.electronsign.esignv3.service.EsignV3SealsAuthService;
import com.els.modules.electronsign.esignv3.service.SaleEsignV3OrgService;
import com.els.modules.electronsign.esignv3.service.SaleEsignV3SealsService;
import com.els.modules.electronsign.util.IpassUtil;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SaleEsignV3SealsServiceImpl
extends BaseServiceImpl<SaleEsignV3SealsMapper, SaleEsignV3Seals>
implements SaleEsignV3SealsService {
    private static final Logger log = LoggerFactory.getLogger(SaleEsignV3SealsServiceImpl.class);
    @Autowired
    private SaleEsignV3OrgService saleEsignV3OrgService;
    @Autowired
    private EsignV3SealsAuthService esignV3SealsAuthService;
    @Autowired
    private IpassUtil ipassUtil;
    @Autowired
    private EsignV3Properties esignV3Properties;

    @Override
    public void add(SaleEsignV3Seals saleEsignV3Seals) {
        saleEsignV3Seals.setElsAccount(TenantContext.getTenant());
        ((SaleEsignV3SealsMapper)this.baseMapper).insert((Object)saleEsignV3Seals);
    }

    @Override
    public void edit(SaleEsignV3Seals saleEsignV3Seals) {
        int count = ((SaleEsignV3SealsMapper)this.baseMapper).updateById((Object)saleEsignV3Seals);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        JSONObject jSONObject;
        SealsAuthRq sealsAuthRq;
        SaleEsignV3Seals saleEsignV3Seals = (SaleEsignV3Seals)((Object)this.getById((Serializable)((Object)id)));
        if (StrUtil.equals((CharSequence)saleEsignV3Seals.getSealType(), (CharSequence)SealsTypeEnum.ORG.getCode()) && StrUtil.isNotBlank((CharSequence)saleEsignV3Seals.getSealId()) && StrUtil.isNotBlank((CharSequence)saleEsignV3Seals.getOrgId())) {
            sealsAuthRq = new SealsAuthRq();
            sealsAuthRq.setSealId(saleEsignV3Seals.getSealId());
            sealsAuthRq.setOrgId(saleEsignV3Seals.getOrgId());
            IpassUtil.setNullValue(sealsAuthRq);
            jSONObject = this.ipassUtil.sendBaseAndChangeElsAccountRequest(sealsAuthRq, "e3-seal-org-del", saleEsignV3Seals.getBusAccount(), JSONObject.class);
        }
        if (StrUtil.equals((CharSequence)saleEsignV3Seals.getSealType(), (CharSequence)SealsTypeEnum.PSN.getCode()) && StrUtil.isNotBlank((CharSequence)saleEsignV3Seals.getSealId()) && StrUtil.isNotBlank((CharSequence)saleEsignV3Seals.getPsnId())) {
            sealsAuthRq = new SealsAuthRq();
            sealsAuthRq.setSealId(saleEsignV3Seals.getSealId());
            sealsAuthRq.setPsnId(saleEsignV3Seals.getPsnId());
            IpassUtil.setNullValue(sealsAuthRq);
            jSONObject = this.ipassUtil.sendBaseAndChangeElsAccountRequest(sealsAuthRq, "e3-seal-psn-del", saleEsignV3Seals.getBusAccount(), JSONObject.class);
        }
        ((SaleEsignV3SealsMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((SaleEsignV3SealsMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void auth(SealsAuthRq sealsAuthRq) {
    }

    @Override
    public void processCallback(JSONObject jsonObject) {
        CallBackDto.Seal callBackDto = (CallBackDto.Seal)jsonObject.toJavaObject(CallBackDto.Seal.class);
        SealCallBackEnum sealCallBackEnum = SealCallBackEnum.getByCode(callBackDto.getAction());
        SaleEsignV3Seals saleEsignV3Seals = ((SaleEsignV3SealsMapper)this.baseMapper).selectByRequestId(callBackDto.getSealId());
        if (ObjectUtil.isNotEmpty((Object)((Object)saleEsignV3Seals))) {
            this.processDb(saleEsignV3Seals, jsonObject, sealCallBackEnum);
        } else {
            try {
                for (int i = 0; i <= 4; ++i) {
                    log.info("\u7b49\u5f85\u6570\u636e\u6267\u884c,{}\u6b21", (Object)i);
                    Thread.sleep(5000L);
                    saleEsignV3Seals = ((SaleEsignV3SealsMapper)this.baseMapper).selectByRequestId(callBackDto.getSealId());
                    if (!ObjectUtil.isNotEmpty((Object)((Object)saleEsignV3Seals))) continue;
                    this.processDb(saleEsignV3Seals, jsonObject, sealCallBackEnum);
                    return;
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void uploadToEsign(String id) {
        SaleEsignV3Seals seals = (SaleEsignV3Seals)((Object)this.getById((Serializable)((Object)id)));
        String filePath = seals.getFilePath();
        Assert.notNull((Object)filePath, (String)"");
        InputStream inputStream = IpassUtil.getInputStreamFromUrl(filePath);
        byte[] bytes = IpassUtil.getFileMD5Bytes128(inputStream);
        String contentMD5 = IpassUtil.getFileContentMD5(bytes);
        FileRq fileRq = new FileRq();
        fileRq.setFileSize(Long.valueOf(bytes.length));
        fileRq.setContentMd5(contentMD5);
        fileRq.setFileName(filePath.substring(filePath.lastIndexOf("/") + 1));
        fileRq.setContentType("application/octet-stream");
        FileRp fileRp = this.ipassUtil.sendRequestAndChangeElsAccountRequest(fileRq, "e3-upload-seals", seals.getBusAccount(), FileRp.class);
        try {
            inputStream = IpassUtil.getInputStreamFromUrl(filePath);
            byte[] push = IoUtil.readBytes((InputStream)inputStream);
            FileHelper.streamUploadBytes(push, fileRp.getFileUploadUrl(), contentMD5, "application/octet-stream");
        }
        catch (Exception e) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_title_uploadError", (String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a") + e.getMessage());
        }
        SealsRq sealsRq = new SealsRq();
        BeanUtil.copyProperties((Object)((Object)seals), (Object)sealsRq, (String[])new String[0]);
        sealsRq.setSealImageFileKey(fileRp.getFileKey());
        IpassUtil.setNullValue(sealsRq);
        SealsTypeEnum st = SealsTypeEnum.getByCode(seals.getSealType());
        SealsRp sealsRp = this.ipassUtil.sendRequestAndChangeElsAccountRequest(sealsRq, st.getIpassCode(), seals.getBusAccount(), SealsRp.class);
        seals.setSealId(sealsRp.getSealId());
        seals.setSealStatus(SealStatusEnum.BE_AUDIT.getCode());
        this.ipassUtil.callIpassCreateBack(seals.getBusAccount(), seals.getSealId(), this.esignV3Properties.getCallBackUrl() + "/esignv3/saleEsignV3Seals/noToken/callback", null);
        this.updateById((Object)seals);
    }

    @Override
    public IPage<SaleEsignV3Seals> getSignSeal(Page<SaleEsignV3Seals> page, String orgId, String psnId, String sealType, String keyWord) {
        SaleEsignV3Org org = this.saleEsignV3OrgService.getByOrgId(orgId);
        Assert.notNull((Object)((Object)org), (String)I18nUtil.translate((String)"i18n_field_VnKIdtRVH_3e1b20d0", (String)"\u8bf7\u6838\u5b9e\u5bf9\u5e94\u673a\u6784\u4fe1\u606f"));
        if (org.getPsnId().equals(psnId)) {
            return ((SaleEsignV3SealsMapper)this.baseMapper).selectPage((IPage)page, (Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SaleEsignV3Seals::getOrgId, (Object)orgId)).eq(SaleEsignV3Seals::getSealStatus, (Object)"1"));
        }
        return ((SaleEsignV3SealsMapper)this.baseMapper).getSignSeal(page, orgId, psnId, sealType, keyWord);
    }

    @Override
    public SaleEsignV3Seals orgAuth(SealsOrgAuthRq rq) {
        SaleEsignV3Seals saleEsignV3Seals = (SaleEsignV3Seals)((Object)this.getOne((Wrapper)Wrappers.lambdaQuery().eq(SaleEsignV3Seals::getSealId, (Object)rq.getSealId()), false));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)saleEsignV3Seals)), (String)"saleEsignV3Seals is null");
        SaleEsignV3Org org = this.saleEsignV3OrgService.getByOrgId(saleEsignV3Seals.getOrgId());
        rq.setOrgId(saleEsignV3Seals.getOrgId());
        rq.setTransactorPsnId(org.getPsnId());
        rq.setEffectiveTime(rq.getEffectiveTimeDate().getTime());
        rq.setExpireTime(rq.getExpireTimeDate().getTime());
        JSONObject jsonObject = this.ipassUtil.sendRequestAndChangeElsAccountRequest(rq, "e3-seal-org-qqt-auth", saleEsignV3Seals.getBusAccount(), JSONObject.class);
        saleEsignV3Seals.setAuthorizationSignUrl(jsonObject.getString("authorizationSignUrl"));
        saleEsignV3Seals.setEffectiveTime(rq.getEffectiveTimeDate());
        saleEsignV3Seals.setExpireTime(rq.getExpireTimeDate());
        this.updateById((Object)saleEsignV3Seals);
        return saleEsignV3Seals;
    }

    @Override
    public SaleEsignV3Seals getBySealId(String sealId) {
        SaleEsignV3Seals saleEsignV3Seals = (SaleEsignV3Seals)((Object)this.getOne((Wrapper)Wrappers.lambdaQuery().eq(SaleEsignV3Seals::getSealId, (Object)sealId), false));
        return saleEsignV3Seals;
    }

    private void processDb(SaleEsignV3Seals saleEsignV3Seals, JSONObject jsonObject, SealCallBackEnum sealCallBackEnum) {
        if (ObjectUtil.isEmpty((Object)((Object)sealCallBackEnum))) {
            return;
        }
        sealCallBackEnum.processSeals(null, saleEsignV3Seals, jsonObject);
        if (sealCallBackEnum.equals((Object)SealCallBackEnum.SEAL_AUDIT)) {
            this.updateById((Object)saleEsignV3Seals);
            if (SealStatusEnum.PASS.getCode().equals(saleEsignV3Seals.getSealStatus())) {
                EsignV3SealsAuth esignV3SealsAuth;
                TenantContext.setTenant((String)saleEsignV3Seals.getElsAccount());
                SaleEsignV3Org saleEsignV3Org = (SaleEsignV3Org)((Object)this.saleEsignV3OrgService.getOne((Wrapper)Wrappers.lambdaQuery().eq(SaleEsignV3Org::getOrgId, (Object)saleEsignV3Seals.getOrgId()), false));
                if (ObjectUtil.isNotEmpty((Object)((Object)saleEsignV3Org)) && StrUtil.isNotBlank((CharSequence)saleEsignV3Org.getPsnId()) && ObjectUtil.isEmpty((Object)((Object)(esignV3SealsAuth = (EsignV3SealsAuth)((Object)this.esignV3SealsAuthService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(EsignV3SealsAuth::getSealId, (Object)saleEsignV3Seals.getSealId())).eq(EsignV3SealsAuth::getOrgId, (Object)saleEsignV3Seals.getOrgId())).eq(EsignV3SealsAuth::getPsnId, (Object)saleEsignV3Org.getPsnId())).eq(BaseEntity::getElsAccount, (Object)saleEsignV3Seals.getElsAccount()))))))) {
                    esignV3SealsAuth = new EsignV3SealsAuth();
                    esignV3SealsAuth.setSealName(saleEsignV3Seals.getSealName());
                    esignV3SealsAuth.setSealId(saleEsignV3Seals.getSealId());
                    esignV3SealsAuth.setSealType(saleEsignV3Seals.getSealType());
                    esignV3SealsAuth.setOrgName(saleEsignV3Seals.getOrgName());
                    esignV3SealsAuth.setOrgId(saleEsignV3Seals.getOrgId());
                    esignV3SealsAuth.setPsnId(saleEsignV3Org.getPsnId());
                    esignV3SealsAuth.setPsnName(saleEsignV3Org.getPsnName());
                    esignV3SealsAuth.setSubAccount(saleEsignV3Org.getSubAccount());
                    esignV3SealsAuth.setSealRole(SealRoleEnum.ORG_ADMIN.getCode());
                    esignV3SealsAuth.setSealStatus(SealAuthStatusEnum.NOT_AUTH.getCode());
                    esignV3SealsAuth.setRoleType(EsignRoleTypeEnum.SALE.getValue());
                    this.esignV3SealsAuthService.save((Object)esignV3SealsAuth);
                }
                TenantContext.clear();
            }
        }
    }
}

