/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.esignv3.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.electronsign.esignv3.dto.OrgPsnAdminRp;
import com.els.modules.electronsign.esignv3.dto.OrgPsnAdminRq;
import com.els.modules.electronsign.esignv3.dto.OrgPsnQueryRp;
import com.els.modules.electronsign.esignv3.dto.OrgPsnQueryRq;
import com.els.modules.electronsign.esignv3.dto.OrgPsnRemoveRq;
import com.els.modules.electronsign.esignv3.entity.SaleEsignV3Org;
import com.els.modules.electronsign.esignv3.entity.SaleEsignV3OrgPsn;
import com.els.modules.electronsign.esignv3.entity.SaleEsignV3Personal;
import com.els.modules.electronsign.esignv3.mapper.SaleEsignV3OrgPsnMapper;
import com.els.modules.electronsign.esignv3.service.SaleEsignV3OrgPsnService;
import com.els.modules.electronsign.esignv3.service.SaleEsignV3OrgService;
import com.els.modules.electronsign.esignv3.service.SaleEsignV3PersonalService;
import com.els.modules.electronsign.esignv3.vo.SaleV3OrgPsnVo;
import com.els.modules.electronsign.util.IpassUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SaleEsignV3OrgPsnServiceImpl
extends BaseServiceImpl<SaleEsignV3OrgPsnMapper, SaleEsignV3OrgPsn>
implements SaleEsignV3OrgPsnService {
    @Autowired
    private SaleEsignV3PersonalService personalService;
    @Autowired
    private IpassUtil ipassUtil;
    @Autowired
    @Lazy
    private SaleEsignV3OrgService orgService;

    @Override
    public void add(SaleEsignV3OrgPsn saleEsignV3OrgPsn) {
        SaleEsignV3Personal personal = (SaleEsignV3Personal)((Object)this.personalService.getById((Serializable)((Object)saleEsignV3OrgPsn.getPsnId())));
        OrgPsnAdminRp rp = this.sendEsignAdd(saleEsignV3OrgPsn, personal.getPsnName());
        if (!rp.getAddedMembers().contains(personal.getPsnId()) && CollUtil.isNotEmpty(rp.getUnaddedMembers()) && !"\u7528\u6237\u5df2\u7ecf\u662f\u5f53\u524d\u4f01\u4e1a\u6210\u5458".equals(rp.getUnaddedMembers().get(0).getFailedReason())) {
            throw new ELSBootException(rp.getUnaddedMembers().get(0).getFailedReason());
        }
        SaleEsignV3OrgPsn orgPsn = (SaleEsignV3OrgPsn)((Object)((SaleEsignV3OrgPsnMapper)this.baseMapper).selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SaleEsignV3OrgPsn::getPsnId, (Object)saleEsignV3OrgPsn.getPsnId())).eq(SaleEsignV3OrgPsn::getOrgCode, (Object)saleEsignV3OrgPsn.getOrgCode())).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(BaseEntity::getDeleted, (Object)"0")));
        if (ObjectUtil.isNotEmpty((Object)((Object)orgPsn))) {
            orgPsn.setRole(saleEsignV3OrgPsn.getRole());
            ((SaleEsignV3OrgPsnMapper)this.baseMapper).updateById((Object)orgPsn);
        } else {
            ((SaleEsignV3OrgPsnMapper)this.baseMapper).insert((Object)saleEsignV3OrgPsn);
        }
    }

    public OrgPsnAdminRp sendEsignAdd(SaleEsignV3OrgPsn saleEsignV3OrgPsn, String psnName) {
        OrgPsnAdminRq.Members members = new OrgPsnAdminRq.Members();
        members.setPsnId(saleEsignV3OrgPsn.getPsnCode());
        members.setMemberName(psnName);
        members.setRole(saleEsignV3OrgPsn.getRole());
        OrgPsnAdminRq orgPsnAdminRq = OrgPsnAdminRq.builder().base(new OrgPsnAdminRq.Base(saleEsignV3OrgPsn.getOrgCode())).body(new OrgPsnAdminRq.Body(Arrays.asList(members))).build();
        OrgPsnAdminRp rp = this.ipassUtil.sendRequest(orgPsnAdminRq, "e3-org-psn-add", OrgPsnAdminRp.class);
        return rp;
    }

    @Override
    public void edit(SaleEsignV3OrgPsn saleEsignV3OrgPsn) {
        int count = ((SaleEsignV3OrgPsnMapper)this.baseMapper).updateById((Object)saleEsignV3OrgPsn);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((SaleEsignV3OrgPsnMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((SaleEsignV3OrgPsnMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public IPage<SaleV3OrgPsnVo> pageVo(Page<SaleV3OrgPsnVo> page, String orgId, boolean notAdmin, String sealId) {
        return ((SaleEsignV3OrgPsnMapper)this.baseMapper).pageVo(page, orgId, notAdmin, sealId);
    }

    @Override
    @SrmTransaction
    public void removeStaff(SaleEsignV3OrgPsn saleEsignV3OrgPsn) {
        SaleEsignV3OrgPsn pev = (SaleEsignV3OrgPsn)((Object)this.getById((Serializable)((Object)saleEsignV3OrgPsn.getId())));
        this.handleEsignRemove(pev.getOrgCode(), pev.getPsnCode());
        this.removeById((Serializable)((Object)pev.getId()));
    }

    @Override
    public void synchronizeEmployees(String ids) {
        for (String id : ids.split(",")) {
            SaleEsignV3Org org = (SaleEsignV3Org)((Object)this.orgService.getById((Serializable)((Object)id)));
            OrgPsnQueryRq orgPsnQueryRq = new OrgPsnQueryRq();
            orgPsnQueryRq.setOrgId(org.getOrgId());
            orgPsnQueryRq.setPageSize("100");
            orgPsnQueryRq.setPageNum("1");
            OrgPsnQueryRp rp = this.ipassUtil.sendBaseRequest(orgPsnQueryRq, "e3-org-psn-query", OrgPsnQueryRp.class);
            if (!CollUtil.isNotEmpty(rp.getMembers())) continue;
            List admins = rp.getMembers().stream().filter(x -> Arrays.stream(x.getRole().split(",")).toList().contains("99")).collect(Collectors.toList());
            if (!admins.stream().map(x -> x.getPsnId()).collect(Collectors.toList()).contains(org.getPsnId())) {
                OrgPsnQueryRp.Member adminM = (OrgPsnQueryRp.Member)admins.get(0);
                org.setPsnId(adminM.getPsnId());
                org.setPsnName(adminM.getPsnName());
                org.setPsnAccount(Optional.ofNullable(adminM.getPsnAccount().getAccountMobile()).orElse(adminM.getPsnAccount().getAccountEmail()));
                this.orgService.updateById((Object)org);
            }
            for (OrgPsnQueryRp.Member member : rp.getMembers()) {
                SaleEsignV3OrgPsn orgPsn;
                String psnAccount = Optional.ofNullable(member.getPsnAccount().getAccountMobile()).orElse(member.getPsnAccount().getAccountEmail());
                SaleEsignV3Personal psn = this.personalService.getByPsnId(member.getPsnId(), org.getElsAccount());
                if (ObjectUtil.isEmpty((Object)((Object)psn))) {
                    psn = new SaleEsignV3Personal();
                    psn.setId(IdWorker.getIdStr());
                    psn.setElsAccount(org.getElsAccount());
                    psn.setCompanyName(org.getOrgName());
                    psn.setBusAccount(org.getBusAccount());
                    psn.setPsnId(member.getPsnId());
                    psn.setPsnName(member.getPsnName());
                    psn.setPsnAccount(psnAccount);
                    psn.setSubAccount(psnAccount);
                    psn.setRealnameStatus("1");
                    this.personalService.save((Object)psn);
                }
                if (ObjectUtil.isEmpty((Object)((Object)(orgPsn = (SaleEsignV3OrgPsn)((Object)((SaleEsignV3OrgPsnMapper)this.baseMapper).selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SaleEsignV3OrgPsn::getPsnCode, (Object)member.getPsnId())).eq(SaleEsignV3OrgPsn::getOrgCode, (Object)org.getOrgId())).eq(BaseEntity::getElsAccount, (Object)org.getElsAccount())).eq(BaseEntity::getDeleted, (Object)"0"))))))) {
                    orgPsn = new SaleEsignV3OrgPsn();
                    orgPsn.setElsAccount(org.getElsAccount());
                    orgPsn.setOrgId(org.getId());
                    orgPsn.setOrgCode(org.getOrgId());
                    orgPsn.setPsnId(psn.getId());
                    orgPsn.setPsnCode(psn.getPsnId());
                }
                List<String> eRoles = Arrays.stream(member.getRole().split(",")).toList();
                ArrayList srmRoles = Lists.newArrayList();
                if (eRoles.contains("99")) {
                    srmRoles.add("1");
                }
                if (eRoles.contains("2")) {
                    srmRoles.add("2");
                }
                if (eRoles.contains("3")) {
                    srmRoles.add("3");
                }
                orgPsn.setRole(srmRoles.stream().collect(Collectors.joining(",")));
                if (StrUtil.isNotBlank((CharSequence)orgPsn.getId())) {
                    ((SaleEsignV3OrgPsnMapper)this.baseMapper).updateById((Object)orgPsn);
                    continue;
                }
                ((SaleEsignV3OrgPsnMapper)this.baseMapper).insert((Object)orgPsn);
            }
        }
    }

    public void handleEsignRemove(String orgCode, String psnCode) {
        OrgPsnRemoveRq orgPsnRemoveRq = new OrgPsnRemoveRq();
        orgPsnRemoveRq.getBase().setOrgId(orgCode);
        orgPsnRemoveRq.getBase().setMemberPsnIds(psnCode);
        OrgPsnAdminRp rp = this.ipassUtil.sendRequest(orgPsnRemoveRq, "e3-org-psn-remove", OrgPsnAdminRp.class);
    }
}

