/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.esign.service.impl;

import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SysUtil;
import com.els.modules.electronsign.esign.entity.PurchaseEsign;
import com.els.modules.electronsign.esign.entity.PurchaseSignReturnAttachment;
import com.els.modules.electronsign.esign.entity.SaleEsign;
import com.els.modules.electronsign.esign.entity.SaleEsignAttachment;
import com.els.modules.electronsign.esign.entity.SaleSignReturnAttachment;
import com.els.modules.electronsign.esign.mapper.PurchaseEsignMapper;
import com.els.modules.electronsign.esign.mapper.PurchaseSignReturnAttachmentMapper;
import com.els.modules.electronsign.esign.mapper.SaleEsignAttachmentMapper;
import com.els.modules.electronsign.esign.mapper.SaleEsignMapper;
import com.els.modules.electronsign.esign.mapper.SaleSignReturnAttachmentMapper;
import com.els.modules.electronsign.esign.service.PurchaseSignReturnAttachmentService;
import com.els.modules.electronsign.esign.service.SaleEsignAttachmentService;
import com.els.modules.electronsign.esign.service.SaleEsignService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SaleEsignServiceImpl
extends BaseServiceImpl<SaleEsignMapper, SaleEsign>
implements SaleEsignService {
    @Autowired
    private SaleEsignMapper saleEsignMapper;
    @Autowired
    private SaleEsignAttachmentMapper saleEsignAttachmentMapper;
    @Autowired
    private SaleEsignAttachmentService saleEsignAttachmentService;
    @Autowired
    private SaleSignReturnAttachmentMapper saleSignReturnAttachmentMapper;
    @Autowired
    private PurchaseEsignMapper purchaseEsignMapper;
    @Autowired
    private PurchaseSignReturnAttachmentMapper purchaseSignReturnAttachmentMapper;
    @Autowired
    private PurchaseSignReturnAttachmentService purchaseSignReturnAttachmentService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(SaleEsign saleEsign, List<SaleEsignAttachment> saleEsignAttachmentList) {
        this.saleEsignMapper.insert((Object)saleEsign);
        this.insertData(saleEsign, saleEsignAttachmentList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(SaleEsign saleEsign, List<SaleEsignAttachment> saleEsignAttachmentList) {
        this.saleEsignMapper.updateById((Object)saleEsign);
        this.saleEsignAttachmentMapper.deleteByMainId(saleEsign.getId());
        this.insertData(saleEsign, saleEsignAttachmentList);
    }

    private void insertData(SaleEsign saleEsign, List<SaleEsignAttachment> saleEsignAttachmentList) {
        for (SaleEsignAttachment entity : saleEsignAttachmentList) {
            entity.setHeadId(saleEsign.getId());
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)saleEsign);
        }
        if (!saleEsignAttachmentList.isEmpty()) {
            this.saleEsignAttachmentService.saveBatch(saleEsignAttachmentList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.saleEsignAttachmentMapper.deleteByMainId(id);
        this.saleEsignMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.saleEsignAttachmentMapper.deleteByMainId(serializable.toString());
            this.saleEsignMapper.deleteById(serializable);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void returnSignFile(String id) {
        SaleEsign esign = (SaleEsign)((Object)this.getById((Serializable)((Object)id)));
        PurchaseEsign purchaseEsign = (PurchaseEsign)((Object)this.purchaseEsignMapper.selectById((Serializable)((Object)esign.getRelationId())));
        purchaseEsign.setReturnSignedFile("1");
        purchaseEsign.setReject("0");
        esign.setReturnSignedFile("1");
        esign.setPassBack("1");
        esign.setReject("0");
        this.purchaseEsignMapper.updateById((Object)purchaseEsign);
        this.updateById((Object)esign);
        List<SaleSignReturnAttachment> attachments = this.saleSignReturnAttachmentMapper.selectByMainId(id);
        ArrayList<PurchaseSignReturnAttachment> returnAttachments = new ArrayList<PurchaseSignReturnAttachment>();
        for (SaleSignReturnAttachment saleSignReturnAttachment : attachments) {
            PurchaseSignReturnAttachment attachment = new PurchaseSignReturnAttachment();
            BeanUtils.copyProperties((Object)((Object)saleSignReturnAttachment), (Object)((Object)attachment));
            attachment.setElsAccount(purchaseEsign.getElsAccount());
            attachment.setHeadId(purchaseEsign.getId());
            attachment.setId(null);
            returnAttachments.add(attachment);
            saleSignReturnAttachment.setSendStatus("1");
            this.saleSignReturnAttachmentMapper.updateById((Object)saleSignReturnAttachment);
        }
        if (!returnAttachments.isEmpty()) {
            this.purchaseSignReturnAttachmentMapper.deleteByMainId(purchaseEsign.getId());
            this.purchaseSignReturnAttachmentService.saveBatch(returnAttachments);
        }
    }
}

