/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.SysUtil;
import com.els.modules.contract.entity.PurchaseContractTemplateHead;
import com.els.modules.contract.entity.PurchaseContractTemplateHeadHis;
import com.els.modules.contract.entity.PurchaseContractTemplateItem;
import com.els.modules.contract.entity.PurchaseContractTemplateItemHis;
import com.els.modules.contract.mapper.PurchaseContractTemplateHeadHisMapper;
import com.els.modules.contract.mapper.PurchaseContractTemplateHeadMapper;
import com.els.modules.contract.mapper.PurchaseContractTemplateItemMapper;
import com.els.modules.contract.service.PurchaseContractTemplateHeadService;
import com.els.modules.contract.service.PurchaseContractTemplateItemHisService;
import com.els.modules.contract.service.PurchaseContractTemplateItemService;
import com.els.modules.contract.vo.PurchaseContractTemplateHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseContractTemplateHeadServiceImpl
extends ServiceImpl<PurchaseContractTemplateHeadMapper, PurchaseContractTemplateHead>
implements PurchaseContractTemplateHeadService {
    @Resource
    private PurchaseContractTemplateHeadMapper purchaseContractTemplateHeadMapper;
    @Resource
    private PurchaseContractTemplateItemMapper purchaseContractTemplateItemMapper;
    @Resource
    private PurchaseContractTemplateItemService purchaseContractTemplateItemService;
    @Resource
    private PurchaseContractTemplateHeadHisMapper purchaseContractTemplateHeadHisMapper;
    @Resource
    private PurchaseContractTemplateItemHisService purchaseContractTemplateItemHisService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseContractTemplateHead purchaseContractTemplateHead, List<PurchaseContractTemplateItem> purchaseContractTemplateItemList) {
        purchaseContractTemplateHead.setContractTemplateVersion(1);
        if (StrUtil.isBlank((CharSequence)purchaseContractTemplateHead.getContractTemplateNumber())) {
            String nextCode = this.invokeBaseRpcService.getNextCode("srmContractTempNumber", (Object)purchaseContractTemplateHead);
            purchaseContractTemplateHead.setContractTemplateNumber(nextCode);
        }
        if (StrUtil.isBlank((CharSequence)purchaseContractTemplateHead.getTemplateStatus())) {
            purchaseContractTemplateHead.setTemplateStatus("1");
        }
        if (StrUtil.isBlank((CharSequence)purchaseContractTemplateHead.getAuditStatus())) {
            purchaseContractTemplateHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        }
        this.purchaseContractTemplateHeadMapper.insert((Object)purchaseContractTemplateHead);
        this.insertData(purchaseContractTemplateHead, purchaseContractTemplateItemList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseContractTemplateHead purchaseContractTemplateHead, List<PurchaseContractTemplateItem> purchaseContractTemplateItemList) {
        if (StrUtil.isBlank((CharSequence)purchaseContractTemplateHead.getTemplateStatus())) {
            purchaseContractTemplateHead.setTemplateStatus("1");
        }
        if (StrUtil.isBlank((CharSequence)purchaseContractTemplateHead.getAuditStatus())) {
            purchaseContractTemplateHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        }
        this.purchaseContractTemplateHeadMapper.updateById((Object)purchaseContractTemplateHead);
        this.purchaseContractTemplateItemMapper.deleteByMainId(purchaseContractTemplateHead.getId());
        this.insertData(purchaseContractTemplateHead, purchaseContractTemplateItemList);
    }

    private void insertData(PurchaseContractTemplateHead purchaseContractTemplateHead, List<PurchaseContractTemplateItem> purchaseContractTemplateItemList) {
        if (!CollectionUtils.isEmpty(purchaseContractTemplateItemList)) {
            for (PurchaseContractTemplateItem entity : purchaseContractTemplateItemList) {
                entity.setId(null);
                entity.setHeadId(purchaseContractTemplateHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseContractTemplateHead);
            }
            if (!purchaseContractTemplateItemList.isEmpty()) {
                this.purchaseContractTemplateItemService.saveBatch(purchaseContractTemplateItemList);
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseContractTemplateItemMapper.deleteByMainId(id);
        this.purchaseContractTemplateHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void cancel(String id) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseEntity::getId, (Object)id)).set(PurchaseContractTemplateHead::getTemplateStatus, (Object)"2")).update();
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void copy(PurchaseContractTemplateHeadVO id) {
        PurchaseContractTemplateHead purchaseBiddingHead = (PurchaseContractTemplateHead)((Object)SysUtil.copyProperties((Object)((Object)id), PurchaseContractTemplateHead.class));
        this.builderHead(purchaseBiddingHead);
        List<PurchaseContractTemplateItem> purchaseContractTemplateItemList = id.getPurchaseContractTemplateItemList();
        purchaseContractTemplateItemList.forEach(item -> item.setId(null));
        this.saveMain(purchaseBiddingHead, purchaseContractTemplateItemList);
    }

    public void builderHead(PurchaseContractTemplateHead purchaseContractTemplateHead) {
        purchaseContractTemplateHead.setId(null);
        purchaseContractTemplateHead.setContractTemplateNumber(null);
        purchaseContractTemplateHead.setTemplateStatus("1");
        purchaseContractTemplateHead.setCreateBy(null);
        purchaseContractTemplateHead.setCreateById(null);
        purchaseContractTemplateHead.setCreateTime(null);
        purchaseContractTemplateHead.setUpdateById(null);
        purchaseContractTemplateHead.setUpdateTime(null);
        purchaseContractTemplateHead.setContractTemplateVersion(0);
        purchaseContractTemplateHead.setAuditStatus("0");
        purchaseContractTemplateHead.setFlowId(null);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseContractTemplateItemMapper.deleteByMainId(serializable.toString());
            this.purchaseContractTemplateHeadMapper.deleteById(serializable);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void upgradeVersion(PurchaseContractTemplateHead head) {
        List<PurchaseContractTemplateItem> itemList = this.purchaseContractTemplateItemMapper.selectByMainId(head.getId());
        PurchaseContractTemplateHeadHis headHis = new PurchaseContractTemplateHeadHis();
        BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)headHis));
        headHis.setId(null);
        headHis.setTemplateId(head.getId());
        this.purchaseContractTemplateHeadHisMapper.insert((Object)headHis);
        ArrayList<PurchaseContractTemplateItemHis> itemHisList = new ArrayList<PurchaseContractTemplateItemHis>();
        for (PurchaseContractTemplateItem item : itemList) {
            PurchaseContractTemplateItemHis itemHis = new PurchaseContractTemplateItemHis();
            BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)itemHis));
            itemHis.setId(null);
            itemHis.setHeadId(headHis.getId());
            itemHisList.add(itemHis);
        }
        this.purchaseContractTemplateItemHisService.saveBatch(itemHisList);
        int version = head.getContractTemplateVersion();
        head.setContractTemplateVersion(++version);
        head.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        head.setTemplateStatus("1");
        head.setFlowId("");
        this.purchaseContractTemplateHeadMapper.updateById((Object)head);
    }
}

