/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.esignv3.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.electronsign.config.EsignV3Properties;
import com.els.modules.electronsign.enums.SealsTypeEnum;
import com.els.modules.electronsign.esign.enumerate.EsignRoleTypeEnum;
import com.els.modules.electronsign.esign.util.FileHelper;
import com.els.modules.electronsign.esignv3.dto.CallBackDto;
import com.els.modules.electronsign.esignv3.dto.FileRp;
import com.els.modules.electronsign.esignv3.dto.FileRq;
import com.els.modules.electronsign.esignv3.dto.OrgPsnQueryRq;
import com.els.modules.electronsign.esignv3.dto.OrgSealsAuthQueryRp;
import com.els.modules.electronsign.esignv3.dto.OrgSealsQueryRp;
import com.els.modules.electronsign.esignv3.dto.SealsAuthRq;
import com.els.modules.electronsign.esignv3.dto.SealsOrgAuthRq;
import com.els.modules.electronsign.esignv3.dto.SealsRp;
import com.els.modules.electronsign.esignv3.dto.SealsRq;
import com.els.modules.electronsign.esignv3.entity.EsignV3SealsAuth;
import com.els.modules.electronsign.esignv3.entity.PurchaseEsignV3Org;
import com.els.modules.electronsign.esignv3.entity.PurchaseEsignV3Personal;
import com.els.modules.electronsign.esignv3.entity.PurchaseEsignV3Seals;
import com.els.modules.electronsign.esignv3.enums.SealAuthStatusEnum;
import com.els.modules.electronsign.esignv3.enums.SealCallBackEnum;
import com.els.modules.electronsign.esignv3.enums.SealRoleEnum;
import com.els.modules.electronsign.esignv3.enums.SealStatusEnum;
import com.els.modules.electronsign.esignv3.mapper.PurchaseEsignV3SealsMapper;
import com.els.modules.electronsign.esignv3.service.EsignV3SealsAuthService;
import com.els.modules.electronsign.esignv3.service.PurchaseEsignV3OrgService;
import com.els.modules.electronsign.esignv3.service.PurchaseEsignV3PersonalService;
import com.els.modules.electronsign.esignv3.service.PurchaseEsignV3SealsService;
import com.els.modules.electronsign.util.ESignUtil;
import com.els.modules.electronsign.util.IpassUtil;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseEsignV3SealsServiceImpl
extends BaseServiceImpl<PurchaseEsignV3SealsMapper, PurchaseEsignV3Seals>
implements PurchaseEsignV3SealsService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseEsignV3SealsServiceImpl.class);
    @Autowired
    private IpassUtil ipassUtil;
    @Autowired
    private EsignV3Properties esignV3Properties;
    @Autowired
    private EsignV3SealsAuthService esignV3SealsAuthService;
    @Autowired
    private PurchaseEsignV3OrgService purchaseEsignV3OrgService;
    @Autowired
    private PurchaseEsignV3PersonalService purchaseEsignV3PersonalService;
    @Value(value="${els.storage.type}")
    private String storeType;

    @Override
    public void add(PurchaseEsignV3Seals purchaseEsignV3Seals) {
        ((PurchaseEsignV3SealsMapper)this.baseMapper).insert((Object)purchaseEsignV3Seals);
    }

    @Override
    public void edit(PurchaseEsignV3Seals purchaseEsignV3Seals) {
        int count = ((PurchaseEsignV3SealsMapper)this.baseMapper).updateById((Object)purchaseEsignV3Seals);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        JSONObject jSONObject;
        SealsAuthRq sealsAuthRq;
        PurchaseEsignV3Seals purchaseEsignV3Seals = (PurchaseEsignV3Seals)((Object)this.getById((Serializable)((Object)id)));
        if (StrUtil.equals((CharSequence)purchaseEsignV3Seals.getSealType(), (CharSequence)SealsTypeEnum.ORG.getCode()) && StrUtil.isNotBlank((CharSequence)purchaseEsignV3Seals.getSealId()) && StrUtil.isNotBlank((CharSequence)purchaseEsignV3Seals.getOrgId())) {
            sealsAuthRq = new SealsAuthRq();
            sealsAuthRq.setSealId(purchaseEsignV3Seals.getSealId());
            sealsAuthRq.setOrgId(purchaseEsignV3Seals.getOrgId());
            IpassUtil.setNullValue(sealsAuthRq);
            jSONObject = this.ipassUtil.sendBaseRequest(sealsAuthRq, "e3-seal-org-del", JSONObject.class);
        }
        if (StrUtil.equals((CharSequence)purchaseEsignV3Seals.getSealType(), (CharSequence)SealsTypeEnum.PSN.getCode()) && StrUtil.isNotBlank((CharSequence)purchaseEsignV3Seals.getSealId()) && StrUtil.isNotBlank((CharSequence)purchaseEsignV3Seals.getPsnId())) {
            sealsAuthRq = new SealsAuthRq();
            sealsAuthRq.setSealId(purchaseEsignV3Seals.getSealId());
            sealsAuthRq.setPsnId(purchaseEsignV3Seals.getPsnId());
            IpassUtil.setNullValue(sealsAuthRq);
            jSONObject = this.ipassUtil.sendBaseRequest(sealsAuthRq, "e3-seal-psn-del", JSONObject.class);
        }
        ((PurchaseEsignV3SealsMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((PurchaseEsignV3SealsMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void uploadToEsign(String id) {
        PurchaseEsignV3Seals seals = (PurchaseEsignV3Seals)((Object)this.getById((Serializable)((Object)id)));
        String filePath = seals.getFilePath();
        Assert.notNull((Object)filePath, (String)"");
        InputStream inputStream = IpassUtil.getInputStreamFromUrl(filePath);
        byte[] bytes = IpassUtil.getFileMD5Bytes128(inputStream);
        String contentMD5 = IpassUtil.getFileContentMD5(bytes);
        FileRq fileRq = new FileRq();
        fileRq.setFileSize(Long.valueOf(bytes.length));
        fileRq.setContentMd5(contentMD5);
        fileRq.setFileName(filePath.substring(filePath.lastIndexOf("/") + 1));
        fileRq.setContentType("application/octet-stream");
        FileRp fileRp = this.ipassUtil.sendRequest(fileRq, "e3-upload-seals", FileRp.class);
        try {
            inputStream = IpassUtil.getInputStreamFromUrl(filePath);
            byte[] push = IoUtil.readBytes((InputStream)inputStream);
            FileHelper.streamUploadBytes(push, fileRp.getFileUploadUrl(), contentMD5, "application/octet-stream");
        }
        catch (Exception e) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_title_uploadError", (String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a") + e.getMessage());
        }
        SealsRq sealsRq = new SealsRq();
        BeanUtil.copyProperties((Object)((Object)seals), (Object)sealsRq, (String[])new String[0]);
        sealsRq.setSealImageFileKey(fileRp.getFileKey());
        IpassUtil.setNullValue(sealsRq);
        SealsTypeEnum st = SealsTypeEnum.getByCode(seals.getSealType());
        SealsRp sealsRp = this.ipassUtil.sendRequest(sealsRq, st.getIpassCode(), SealsRp.class);
        seals.setSealId(sealsRp.getSealId());
        seals.setSealStatus(SealStatusEnum.BE_AUDIT.getCode());
        this.ipassUtil.callIpassCreateBack(seals.getElsAccount(), seals.getSealId(), this.esignV3Properties.getCallBackUrl() + "/esignv3/purchaseEsignV3Seals/noToken/callback", null);
        this.updateById((Object)seals);
    }

    @Override
    public void auth(SealsAuthRq sealsAuthRq) {
    }

    @Override
    public void processCallback(JSONObject jsonObject) {
        CallBackDto.Seal callBackDto = (CallBackDto.Seal)jsonObject.toJavaObject(CallBackDto.Seal.class);
        SealCallBackEnum sealCallBackEnum = SealCallBackEnum.getByCode(callBackDto.getAction());
        PurchaseEsignV3Seals purchaseEsignV3Seals = ((PurchaseEsignV3SealsMapper)this.baseMapper).selectByRequestId(callBackDto.getSealId());
        if (ObjectUtil.isNotEmpty((Object)((Object)purchaseEsignV3Seals))) {
            this.processDb(purchaseEsignV3Seals, jsonObject, sealCallBackEnum);
        } else {
            try {
                for (int i = 0; i <= 4; ++i) {
                    log.info("\u7b49\u5f85\u6570\u636e\u6267\u884c,{}\u6b21", (Object)i);
                    Thread.sleep(5000L);
                    purchaseEsignV3Seals = ((PurchaseEsignV3SealsMapper)this.baseMapper).selectByRequestId(callBackDto.getSealId());
                    if (!ObjectUtil.isNotEmpty((Object)((Object)purchaseEsignV3Seals))) continue;
                    this.processDb(purchaseEsignV3Seals, jsonObject, sealCallBackEnum);
                    return;
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public IPage<PurchaseEsignV3Seals> getSignSeal(Page<PurchaseEsignV3Seals> page, String orgId, String psnId, String sealType, String keyWord) {
        PurchaseEsignV3Org org = this.purchaseEsignV3OrgService.getByOrgId(orgId);
        Assert.notNull((Object)((Object)org), (String)I18nUtil.translate((String)"i18n_field_VnKIdtRVH_3e1b20d0", (String)"\u8bf7\u6838\u5b9e\u5bf9\u5e94\u673a\u6784\u4fe1\u606f"));
        if (org.getPsnId().equals(psnId)) {
            return ((PurchaseEsignV3SealsMapper)this.baseMapper).selectPage((IPage)page, (Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PurchaseEsignV3Seals::getOrgId, (Object)orgId)).eq(PurchaseEsignV3Seals::getSealStatus, (Object)"1"));
        }
        return ((PurchaseEsignV3SealsMapper)this.baseMapper).getSignSeal(page, orgId, psnId, sealType, keyWord);
    }

    @Override
    public PurchaseEsignV3Seals orgAuth(SealsOrgAuthRq rq) {
        PurchaseEsignV3Seals purchaseEsignV3Seals = (PurchaseEsignV3Seals)((Object)this.getOne((Wrapper)Wrappers.lambdaQuery().eq(PurchaseEsignV3Seals::getSealId, (Object)rq.getSealId()), false));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)purchaseEsignV3Seals)), (String)"purchaseEsignV3Seals is null");
        PurchaseEsignV3Org org = this.purchaseEsignV3OrgService.getByOrgId(purchaseEsignV3Seals.getOrgId());
        rq.setOrgId(purchaseEsignV3Seals.getOrgId());
        rq.setTransactorPsnId(org.getPsnId());
        rq.setEffectiveTime(rq.getEffectiveTimeDate().getTime());
        rq.setExpireTime(rq.getExpireTimeDate().getTime());
        JSONObject jsonObject = this.ipassUtil.sendRequest(rq, "e3-seal-org-qqt-auth", JSONObject.class);
        purchaseEsignV3Seals.setAuthorizationSignUrl(jsonObject.getString("authorizationSignUrl"));
        purchaseEsignV3Seals.setEffectiveTime(rq.getEffectiveTimeDate());
        purchaseEsignV3Seals.setExpireTime(rq.getExpireTimeDate());
        this.updateById((Object)purchaseEsignV3Seals);
        return purchaseEsignV3Seals;
    }

    @Override
    public void synchronizeSeals(String ids) {
        int pageSize = 20;
        block2: for (String id : ids.split(",")) {
            PurchaseEsignV3Org org = (PurchaseEsignV3Org)((Object)this.purchaseEsignV3OrgService.getById((Serializable)((Object)id)));
            OrgPsnQueryRq orgPsnQueryRq = new OrgPsnQueryRq();
            orgPsnQueryRq.setOrgId(org.getOrgId());
            int i = 1;
            while (true) {
                orgPsnQueryRq.setPageSize(20);
                orgPsnQueryRq.setPageNum(i);
                OrgSealsQueryRp rp = this.ipassUtil.sendBaseRequest(orgPsnQueryRq, "e3-seal-org-list", OrgSealsQueryRp.class);
                block4: for (OrgSealsQueryRp.Seals seal : rp.getSeals()) {
                    PurchaseEsignV3Seals purchaseEsignV3Seals = (PurchaseEsignV3Seals)((Object)this.getOne((Wrapper)Wrappers.lambdaQuery().eq(PurchaseEsignV3Seals::getSealId, (Object)seal.getSealId()), false));
                    if (ObjectUtil.isEmpty((Object)((Object)purchaseEsignV3Seals))) {
                        purchaseEsignV3Seals = new PurchaseEsignV3Seals();
                        BeanUtil.copyProperties((Object)seal, (Object)((Object)purchaseEsignV3Seals), (String[])new String[0]);
                        purchaseEsignV3Seals.setElsAccount(org.getElsAccount());
                        purchaseEsignV3Seals.setSealType(SealsTypeEnum.ORG.getCode());
                        purchaseEsignV3Seals.setOrgId(org.getOrgId());
                        purchaseEsignV3Seals.setOrgName(org.getOrgName());
                        try {
                            InputStream inputStream = IpassUtil.getInputStreamFromUrl(seal.getSealImageDownloadUrl());
                            URI uri = new URI(seal.getSealImageDownloadUrl());
                            String path = uri.getPath();
                            Path filePath = Paths.get(path, new String[0]);
                            String fileName = filePath.getFileName().toString();
                            purchaseEsignV3Seals.setFilePath(ESignUtil.saveFileGetPath(inputStream.readAllBytes(), fileName, this.storeType));
                        }
                        catch (Exception e) {
                            log.error("\u4fdd\u5b58e\u7b7e\u5b9d\u56fe\u7247\u5f02\u5e38", (Throwable)e);
                            purchaseEsignV3Seals.setFilePath(seal.getSealImageDownloadUrl());
                        }
                        this.save((Object)purchaseEsignV3Seals);
                    }
                    OrgPsnQueryRq orgPsnQueryAuthRq = new OrgPsnQueryRq();
                    int authNum = 1;
                    while (true) {
                        orgPsnQueryAuthRq.setPageSize(20);
                        orgPsnQueryAuthRq.setPageNum(authNum);
                        orgPsnQueryAuthRq.setSealId(seal.getSealId());
                        orgPsnQueryAuthRq.setOrgId(org.getOrgId());
                        OrgSealsAuthQueryRp authRp = this.ipassUtil.sendBaseRequest(orgPsnQueryAuthRq, "e3-seal-org-auth-list", OrgSealsAuthQueryRp.class);
                        this.esignV3SealsAuthService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(EsignV3SealsAuth::getSealId, (Object)seal.getSealId())).eq(BaseEntity::getElsAccount, (Object)org.getElsAccount()));
                        ArrayList adds = Lists.newArrayList();
                        for (OrgSealsAuthQueryRp.SealsAuth auth : authRp.getSealAuthorizedInfos()) {
                            if (!StrUtil.equals((CharSequence)auth.getSealId(), (CharSequence)seal.getSealId())) continue;
                            EsignV3SealsAuth esignV3SealsAuth = new EsignV3SealsAuth();
                            esignV3SealsAuth.setElsAccount(org.getElsAccount());
                            esignV3SealsAuth.setSealId(seal.getSealId());
                            esignV3SealsAuth.setSealName(seal.getSealName());
                            esignV3SealsAuth.setOrgId(org.getOrgId());
                            esignV3SealsAuth.setOrgName(org.getOrgName());
                            esignV3SealsAuth.setSealType(purchaseEsignV3Seals.getSealType());
                            String psnId = auth.getAuthorizedPsnId();
                            PurchaseEsignV3Personal psn = this.purchaseEsignV3PersonalService.getByPsnId(psnId);
                            esignV3SealsAuth.setPsnId(psnId);
                            if (ObjectUtil.isNotEmpty((Object)((Object)psn))) {
                                esignV3SealsAuth.setPsnName(psn.getPsnName());
                                esignV3SealsAuth.setSubAccount(psn.getSubAccount());
                            }
                            esignV3SealsAuth.setSealRole(auth.getSealRole());
                            esignV3SealsAuth.setEffectiveTime((Date)DateUtil.date((long)auth.getEffectiveTime()));
                            esignV3SealsAuth.setExpireTime((Date)DateUtil.date((long)auth.getExpireTime()));
                            esignV3SealsAuth.setSealStatus(SealAuthStatusEnum.getByE3Code(auth.getAuthorizeStatus()).getCode());
                            esignV3SealsAuth.setRoleType(EsignRoleTypeEnum.PURCHASE.getValue());
                            adds.add(esignV3SealsAuth);
                        }
                        if (CollUtil.isNotEmpty((Collection)adds)) {
                            this.esignV3SealsAuthService.saveBatch(adds);
                        }
                        if (ObjectUtil.isEmpty((Object)authRp.getTotal()) || authNum * 20 >= authRp.getTotal()) continue block4;
                        ++authNum;
                    }
                }
                if (ObjectUtil.isEmpty((Object)rp.getTotal()) || i * 20 >= rp.getTotal()) continue block2;
                ++i;
            }
        }
    }

    private void processDb(PurchaseEsignV3Seals purchaseEsignV3Seals, JSONObject jsonObject, SealCallBackEnum sealCallBackEnum) {
        sealCallBackEnum.processSeals(purchaseEsignV3Seals, null, jsonObject);
        if (sealCallBackEnum.equals((Object)SealCallBackEnum.SEAL_AUDIT)) {
            this.updateById((Object)purchaseEsignV3Seals);
            if (SealStatusEnum.PASS.getCode().equals(purchaseEsignV3Seals.getSealStatus())) {
                EsignV3SealsAuth esignV3SealsAuth;
                TenantContext.setTenant((String)purchaseEsignV3Seals.getElsAccount());
                PurchaseEsignV3Org purchaseEsignV3Org = (PurchaseEsignV3Org)((Object)this.purchaseEsignV3OrgService.getOne((Wrapper)Wrappers.lambdaQuery().eq(PurchaseEsignV3Org::getOrgId, (Object)purchaseEsignV3Seals.getOrgId()), false));
                if (ObjectUtil.isNotEmpty((Object)((Object)purchaseEsignV3Org)) && StrUtil.isNotBlank((CharSequence)purchaseEsignV3Org.getPsnId()) && ObjectUtil.isEmpty((Object)((Object)(esignV3SealsAuth = (EsignV3SealsAuth)((Object)this.esignV3SealsAuthService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(EsignV3SealsAuth::getSealId, (Object)purchaseEsignV3Seals.getSealId())).eq(EsignV3SealsAuth::getOrgId, (Object)purchaseEsignV3Seals.getOrgId())).eq(EsignV3SealsAuth::getPsnId, (Object)purchaseEsignV3Org.getPsnId())).eq(BaseEntity::getElsAccount, (Object)purchaseEsignV3Seals.getElsAccount()))))))) {
                    esignV3SealsAuth = new EsignV3SealsAuth();
                    esignV3SealsAuth.setSealId(purchaseEsignV3Seals.getSealId());
                    esignV3SealsAuth.setSealType(purchaseEsignV3Seals.getSealType());
                    esignV3SealsAuth.setOrgName(purchaseEsignV3Seals.getOrgName());
                    esignV3SealsAuth.setOrgId(purchaseEsignV3Seals.getOrgId());
                    esignV3SealsAuth.setPsnId(purchaseEsignV3Org.getPsnId());
                    esignV3SealsAuth.setPsnName(purchaseEsignV3Org.getPsnName());
                    esignV3SealsAuth.setSubAccount(purchaseEsignV3Org.getSubAccount());
                    esignV3SealsAuth.setSealRole(SealRoleEnum.ORG_ADMIN.getCode());
                    esignV3SealsAuth.setSealStatus(SealAuthStatusEnum.NOT_AUTH.getCode());
                    esignV3SealsAuth.setRoleType(EsignRoleTypeEnum.PURCHASE.getValue());
                    this.esignV3SealsAuthService.save((Object)esignV3SealsAuth);
                }
                TenantContext.clear();
            }
        }
    }
}

