/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.contractlock.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.api.vo.Result;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.IpaasConfig;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.electronsign.contractlock.entity.PurchaseClSeals;
import com.els.modules.electronsign.contractlock.enumerate.CLAuditEnum;
import com.els.modules.electronsign.contractlock.enumerate.CLEnableEnum;
import com.els.modules.electronsign.contractlock.mapper.PurchaseClSealsMapper;
import com.els.modules.electronsign.contractlock.service.PurchaseClPersonalInfoService;
import com.els.modules.electronsign.contractlock.service.PurchaseClSealsService;
import com.els.modules.electronsign.contractlock.util.ClResultAnalysisUtil;
import com.els.modules.electronsign.contractlock.vo.ClCallback;
import com.els.modules.electronsign.contractlock.vo.ClQuerySealListVO;
import com.els.modules.electronsign.contractlock.vo.ClSealVO;
import com.els.modules.electronsign.contractlock.vo.PurchaseClSealsVo;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseClSealsServiceImpl
extends BaseServiceImpl<PurchaseClSealsMapper, PurchaseClSeals>
implements PurchaseClSealsService {
    Map<String, String> config = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
    private String address = this.config.get("service.address");
    private Map<String, String> configMap = ((IpaasConfig)SpringContextUtils.getBean(IpaasConfig.class)).getConfig();
    private String service = this.configMap.get("service");
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchaseClPersonalInfoService purchaseClPersonalInfoService;

    private void insert(PurchaseClSeals purchaseClSeals) {
        LoginUserDTO sysUser = SysUtil.getLoginUser();
        String currentUser = sysUser.getSubAccount();
        purchaseClSeals.setBusAccount(TenantContext.getTenant());
        purchaseClSeals.setElsAccount(TenantContext.getTenant());
        purchaseClSeals.setCreateTime(new Date());
        purchaseClSeals.setCreateBy(currentUser);
        purchaseClSeals.setUploaded("0");
        purchaseClSeals.setAudited("0");
        ((PurchaseClSealsMapper)this.baseMapper).insert((Object)purchaseClSeals);
    }

    private void update(PurchaseClSeals purchaseClSeals) {
        LoginUserDTO sysUser = SysUtil.getLoginUser();
        String currentUser = sysUser.getSubAccount();
        purchaseClSeals.setUpdateTime(new Date());
        purchaseClSeals.setUpdateBy(currentUser);
        int count = ((PurchaseClSealsMapper)this.baseMapper).updateById((Object)purchaseClSeals);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void add(PurchaseClSeals purchaseClSeals) {
        this.insert(purchaseClSeals);
    }

    @Override
    public void edit(PurchaseClSeals purchaseClSeals) {
        if (StrUtil.isNotBlank((CharSequence)purchaseClSeals.getOperateStatus()) && !"0".equals(purchaseClSeals.getOperateStatus())) {
            String status = purchaseClSeals.getOperateStatus();
            Assert.isTrue((status.equals(CLEnableEnum.ENABLE.getValue()) || status.equals(CLEnableEnum.DISABLE.getValue()) ? 1 : 0) != 0, (String)"seals operateStatus error");
            Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)purchaseClSeals.getCompanyId()), (String)"companyId is null");
            Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)purchaseClSeals.getSealId()), (String)I18nUtil.translate((String)"i18n_alert_VWYdWeuAZd_2f9ecf36", (String)"\u8bf7\u5148\u63a8\u9001\u5370\u7ae0\u5230\u5951\u7ea6\u9501"));
            ClSealVO clSealVO = new ClSealVO();
            ClSealVO.Body body = new ClSealVO.Body();
            body.setSealId(purchaseClSeals.getSealId());
            body.setOperate(purchaseClSeals.getOperateStatus());
            clSealVO.setCompanyId(purchaseClSeals.getCompanyId());
            clSealVO.setBody(body);
            Result<?> response = this.getIPassResponse(clSealVO, "modify-seal-status");
            if (!response.isSuccess()) {
                Assert.isTrue((boolean)false, (String)response.getMessage());
            }
        }
        this.update(purchaseClSeals);
    }

    @Override
    public void delete(String id) {
        PurchaseClSeals seals = (PurchaseClSeals)((Object)this.getById((Serializable)((Object)id)));
        Assert.isTrue((StrUtil.isEmpty((CharSequence)seals.getSealId()) || StrUtil.equals((CharSequence)CLEnableEnum.ENABLE.getValue(), (CharSequence)seals.getOperateStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_VWHjWe_897faf28", (String)"\u8bf7\u5148\u7981\u7528\u5370\u7ae0"));
        if (StrUtil.equals((CharSequence)CLEnableEnum.DISABLE.getValue(), (CharSequence)seals.getOperateStatus())) {
            ClSealVO clSealVO = new ClSealVO();
            ClSealVO.Body base = new ClSealVO.Body();
            base.setSealId(seals.getSealId());
            clSealVO.setCompanyId(seals.getCompanyId());
            clSealVO.setBase(base);
            Result<?> response = this.getIPassResponse(clSealVO, "delete-seal");
            if (!response.isSuccess()) {
                Assert.isTrue((boolean)false, (String)response.getMessage());
            }
        }
        ((PurchaseClSealsMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((PurchaseClSealsMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void push(PurchaseClSeals purchaseClSeals) {
        ClSealVO clSealVO = new ClSealVO();
        ClSealVO.Body body = new ClSealVO.Body();
        BeanUtil.copyProperties((Object)((Object)purchaseClSeals), (Object)body, (String[])new String[0]);
        body.setFileName(purchaseClSeals.getFilePath());
        body.setLpLetterFile(purchaseClSeals.getLpLetterPath());
        body.setCallbackUrl(this.address + "/els/contractLock/purchaseClSeals/noToken/callback");
        clSealVO.setCompanyId(purchaseClSeals.getCompanyId());
        if ("".equals(body.getSealSpec())) {
            body.setSealSpec(null);
        }
        ArrayList userBeans = Lists.newArrayList();
        if (StrUtil.isNotBlank((CharSequence)purchaseClSeals.getUserIds())) {
            String[] ids = purchaseClSeals.getUserIds().split(",");
            List infos = this.purchaseClPersonalInfoService.listByIds(Arrays.asList(ids));
            userBeans.addAll(infos.stream().map(x -> {
                ClSealVO.UserBean userBean = new ClSealVO.UserBean();
                userBean.setContact(x.getApplyContact());
                userBean.setContactType(x.getApplyContactType());
                return userBean;
            }).collect(Collectors.toList()));
        }
        body.setSealUsers(userBeans);
        clSealVO.setBody(body);
        Result<?> response = this.getIPassResponse(clSealVO, "add-seal-image");
        if (response.isSuccess()) {
            JSONObject jsonObject = (JSONObject)response.getResult();
            String applyId = jsonObject.getString("applyId");
            purchaseClSeals.setApplyId(applyId);
            purchaseClSeals.setUploaded("1");
            purchaseClSeals.setAudited(CLAuditEnum.AUDIT_ING.getValue());
            purchaseClSeals.setFbk1(null);
            this.update(purchaseClSeals);
        } else {
            Assert.isTrue((boolean)false, (String)response.getMessage());
        }
    }

    @Override
    public void refresh() {
        List list = this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).isNotNull(PurchaseClSeals::getCompanyId));
        List<String> companyIds = list.stream().map(x -> x.getCompanyId()).collect(Collectors.toList());
        companyIds.forEach(id -> {
            ClQuerySealListVO vo = new ClQuerySealListVO();
            vo.setCompanyId((String)id);
            Result<?> response = this.getIPassResponse(vo, "query-seal-list");
        });
    }

    @Override
    public void handleCallBack(ClCallback.Seals seals) {
        PurchaseClSeals purchaseClSeals = ((PurchaseClSealsMapper)this.baseMapper).selectByRequestId(seals.getApplyId());
        if (ObjectUtil.isNotNull((Object)((Object)purchaseClSeals))) {
            ClCallback.Detail detail = seals.getDetail();
            if ("PASS".equals(seals.getResult())) {
                purchaseClSeals.setSealId(detail.getSealId());
                purchaseClSeals.setSealType(detail.getSealType());
                purchaseClSeals.setOperateStatus(CLEnableEnum.ENABLE.getValue());
                purchaseClSeals.setAudited(CLAuditEnum.AUDIT_SUCCESS.getValue());
            }
            if ("REJECT".equals(seals.getResult())) {
                purchaseClSeals.setAudited(CLAuditEnum.AUDIT_FAIL.getValue());
                purchaseClSeals.setFbk1(detail.getRejectReason());
            }
            this.updateById((Object)purchaseClSeals);
        }
    }

    @Override
    public PurchaseClSealsVo getByIdShow(String id) {
        PurchaseClSeals clSeals = (PurchaseClSeals)((Object)this.getById((Serializable)((Object)id)));
        if (ObjectUtil.isNotNull((Object)((Object)clSeals))) {
            String[] ids;
            List infos;
            PurchaseClSealsVo vo = new PurchaseClSealsVo();
            BeanUtil.copyProperties((Object)((Object)clSeals), (Object)((Object)vo), (String[])new String[0]);
            if (StrUtil.isNotBlank((CharSequence)clSeals.getUserIds()) && CollUtil.isNotEmpty((Collection)(infos = this.purchaseClPersonalInfoService.listByIds(Arrays.asList(ids = clSeals.getUserIds().split(",")))))) {
                vo.setUserNames(infos.stream().map(x -> x.getApplyUserName()).distinct().collect(Collectors.joining(",")));
            }
            return vo;
        }
        return null;
    }

    @Override
    public PurchaseClSeals selectByRequestIdAndCompanyId(String sealId, String companyId) {
        return ((PurchaseClSealsMapper)this.baseMapper).selectByRequestIdAndCompanyId(sealId, companyId);
    }

    private Result<?> getIPassResponse(Object req, String iPassCode) {
        JSONObject object = this.invokeBaseRpcService.callIPaasInterface(JSON.parseObject((String)JSON.toJSONString((Object)req)), this.service, this.invokeBaseRpcService.getIpaasInterfaceCode(iPassCode));
        return ClResultAnalysisUtil.analysisResult(object);
    }
}

