/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.api.dto.BaseDTO;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.contract.dto.SaleContractAcceptanceDTO;
import com.els.modules.contract.entity.PurchaseContractAcceptance;
import com.els.modules.contract.entity.SaleContractAcceptance;
import com.els.modules.contract.entity.SaleContractHead;
import com.els.modules.contract.mapper.PurchaseContractAcceptanceMapper;
import com.els.modules.contract.mapper.SaleContractAcceptanceMapper;
import com.els.modules.contract.service.SaleContractAcceptanceService;
import com.els.modules.contract.service.SaleContractHeadService;
import com.els.modules.contract.vo.SaleContractAcceptanceVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SaleContractAcceptanceServiceImpl
extends BaseServiceImpl<SaleContractAcceptanceMapper, SaleContractAcceptance>
implements SaleContractAcceptanceService {
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private PurchaseContractAcceptanceMapper purchaseContractAcceptanceMapper;
    @Autowired
    private SaleContractHeadService saleContractHeadService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(SaleContractAcceptance saleContractAcceptance, List<SaleAttachmentDTO> saleAttachmentList) {
        this.checkContractAcceptance(saleContractAcceptance);
        saleContractAcceptance.setDeleted(CommonConstant.DEL_FLAG_0);
        saleContractAcceptance.setDocumentStatus("0");
        saleContractAcceptance.setCreateAccount(TenantContext.getTenant());
        saleContractAcceptance.setBusAccount(saleContractAcceptance.getToElsAccount());
        saleContractAcceptance.setSupplierName(SysUtil.getLoginUser().getCompanyName());
        saleContractAcceptance.setAcceptanceNumbers(this.invokeBaseRpcService.getNextCode("contractAcceptanceNumbers", (Object)saleContractAcceptance, saleContractAcceptance.getBusAccount()));
        ((SaleContractAcceptanceMapper)this.baseMapper).insert((Object)saleContractAcceptance);
        this.insertData(saleContractAcceptance, saleAttachmentList);
    }

    private void checkContractAcceptance(SaleContractAcceptance saleContractAcceptance) {
        SaleContractHead saleContractHead = this.saleContractHeadService.queryByContractNumber(saleContractAcceptance.getMasterContractNumber());
        if (saleContractAcceptance.getTaxAmount() == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_CSBSxfHfxOLV_9dd48201", (String)"\u52b3\u52a1\u670d\u52a1\u542b\u7a0e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        if (StrUtil.isBlank((CharSequence)saleContractAcceptance.getMasterContractNumber())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_dnetyxOLV_257e8f91", (String)"\u4e3b\u5408\u540c\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        if (saleContractHead != null && saleContractAcceptance.getTaxAmount().compareTo(saleContractHead.getTotalTaxAmount()) > 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_CSBSxfHfxjfUdnejxfHf_c1f5cdb6", (String)"\u52b3\u52a1\u670d\u52a1\u542b\u7a0e\u91d1\u989d\u4e0d\u5f97\u5927\u4e8e\u4e3b\u5408\u540c\u7684\u542b\u7a0e\u91d1\u989d"));
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(SaleContractAcceptance saleContractAcceptance, List<SaleAttachmentDTO> saleAttachmentList) {
        this.checkContractAcceptance(saleContractAcceptance);
        ((SaleContractAcceptanceMapper)this.baseMapper).updateById((Object)saleContractAcceptance);
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(saleContractAcceptance.getId());
        this.insertData(saleContractAcceptance, saleAttachmentList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(SaleContractAcceptance saleContractAcceptance, List<SaleAttachmentDTO> saleAttachmentList) {
        saleContractAcceptance.setDocumentStatus("1");
        PurchaseContractAcceptance purchaseContractAcceptance = new PurchaseContractAcceptance();
        BeanUtils.copyProperties((Object)((Object)saleContractAcceptance), (Object)((Object)purchaseContractAcceptance));
        purchaseContractAcceptance.setElsAccount(saleContractAcceptance.getToElsAccount());
        purchaseContractAcceptance.setPurchaseName(saleContractAcceptance.getPurchaseName());
        purchaseContractAcceptance.setToElsAccount(saleContractAcceptance.getElsAccount());
        purchaseContractAcceptance.setSupplierName(saleContractAcceptance.getSupplierName());
        purchaseContractAcceptance.setCreateAccount(saleContractAcceptance.getCreateAccount());
        purchaseContractAcceptance.setRelationId(saleContractAcceptance.getId());
        purchaseContractAcceptance.setId(null);
        this.purchaseContractAcceptanceMapper.insert((Object)purchaseContractAcceptance);
        saleContractAcceptance.setRelationId(purchaseContractAcceptance.getId());
        this.updateById((Object)saleContractAcceptance);
        ArrayList<PurchaseAttachmentDTO> purchaseAttachmentList = new ArrayList<PurchaseAttachmentDTO>();
        for (SaleAttachmentDTO dto : saleAttachmentList) {
            PurchaseAttachmentDTO purchaseAttachmentDTO = new PurchaseAttachmentDTO();
            BeanUtils.copyProperties((Object)dto, (Object)purchaseAttachmentDTO);
            purchaseAttachmentDTO.setId(null);
            purchaseAttachmentDTO.setElsAccount(purchaseContractAcceptance.getElsAccount());
            purchaseAttachmentDTO.setHeadId(purchaseContractAcceptance.getId());
            purchaseAttachmentList.add(purchaseAttachmentDTO);
        }
        if (!purchaseAttachmentList.isEmpty() && purchaseAttachmentList.size() > 0) {
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
        }
    }

    @Override
    public SaleContractAcceptanceVO getDataById(String id) {
        SaleContractAcceptanceVO saleContractAcceptanceVO = new SaleContractAcceptanceVO();
        SaleContractAcceptance saleContractAcceptance = (SaleContractAcceptance)((Object)this.getById((Serializable)((Object)id)));
        BeanUtils.copyProperties((Object)((Object)saleContractAcceptance), (Object)((Object)saleContractAcceptanceVO));
        List saleAttachmentList = this.invokeBaseRpcService.selectSaleAttachmentByMainId(id);
        saleContractAcceptanceVO.setSaleAttachmentList(saleAttachmentList);
        return saleContractAcceptanceVO;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(id);
        ((SaleContractAcceptanceMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.invokeBaseRpcService.deleteSaleAttachmentByMainId(serializable.toString());
            ((SaleContractAcceptanceMapper)this.baseMapper).deleteById(serializable);
        }
    }

    @Override
    public void invalidById(String id) {
        SaleContractAcceptance saleContractAcceptance = (SaleContractAcceptance)((Object)this.getById((Serializable)((Object)id)));
        if (saleContractAcceptance == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WFxMK_c3d350df", (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff01"));
        }
        SaleContractAcceptance vo = new SaleContractAcceptance();
        vo.setId(saleContractAcceptance.getId());
        vo.setDocumentStatus("4");
        PurchaseContractAcceptance purchaseContractAcceptance = (PurchaseContractAcceptance)((Object)this.purchaseContractAcceptanceMapper.selectById((Serializable)((Object)saleContractAcceptance.getRelationId())));
        if (purchaseContractAcceptance != null) {
            purchaseContractAcceptance.setDocumentStatus("4");
            this.purchaseContractAcceptanceMapper.updateById((Object)purchaseContractAcceptance);
        }
        this.updateById((Object)vo);
    }

    @Override
    public SaleContractAcceptance getByRelationId(String relationId) {
        SaleContractAcceptance acceptance = ((SaleContractAcceptanceMapper)this.baseMapper).getSaleContractAcceptanceByRelationId(relationId);
        return acceptance;
    }

    @Override
    public List<SaleContractAcceptanceDTO> checkHasReconciliation(Set<String> reconciliationNumbers) {
        if (CollectionUtils.isEmpty(reconciliationNumbers)) {
            return new ArrayList<SaleContractAcceptanceDTO>();
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SaleContractAcceptance::getAcceptanceNumbers, reconciliationNumbers);
        List saleContractAcceptances = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)saleContractAcceptances)) {
            return new ArrayList<SaleContractAcceptanceDTO>();
        }
        ArrayList<SaleContractAcceptanceDTO> list = new ArrayList<SaleContractAcceptanceDTO>();
        for (SaleContractAcceptance saleContractAcceptance : saleContractAcceptances) {
            SaleContractAcceptanceDTO dto = new SaleContractAcceptanceDTO();
            BeanUtils.copyProperties((Object)((Object)saleContractAcceptance), (Object)dto);
            list.add(dto);
        }
        return list;
    }

    private void insertData(SaleContractAcceptance saleContractAcceptance, List<SaleAttachmentDTO> saleAttachmentList) {
        if (saleAttachmentList != null) {
            for (SaleAttachmentDTO entity : saleAttachmentList) {
                SysUtil.setSysParam((BaseDTO)entity, (BaseEntity)saleContractAcceptance);
                entity.setId(null);
                entity.setSendStatus("0");
                entity.setHeadId(saleContractAcceptance.getId());
            }
            if (!saleAttachmentList.isEmpty()) {
                this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleAttachmentList);
            }
        }
    }
}

