/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.adapter;

import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.SrmUtil;
import com.els.modules.contract.entity.PurchaseContractPromise;
import com.els.modules.contract.mapper.PurchaseContractPromiseMapper;
import com.els.modules.contract.rpc.service.ContractInvokeDeliveryWaterRpcService;
import com.els.modules.contract.service.PurchaseContractPromiseService;
import com.els.modules.workflow.modules.dto.FlowCallBackDTO;
import com.els.modules.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="purchaseContractPromiseAuditDubboAdapter")
public class PurchaseContractPromiseAuditOptCallBackServiceImpl
implements WorkflowAuditOptCallBackService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PurchaseContractPromiseAuditOptCallBackServiceImpl.class);
    @Resource
    private PurchaseContractPromiseMapper purchaseContractPromiseMapper;
    @Autowired
    private PurchaseContractPromiseService purchaseContractPromiseService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Autowired
    private ContractInvokeDeliveryWaterRpcService contractInvokeDeliveryWaterRpcService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO);
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String id) {
        PurchaseContractPromise head = (PurchaseContractPromise)((Object)this.purchaseContractPromiseService.getById((Serializable)((Object)id)));
        if (head != null) {
            return SrmUtil.toJSONObject((Object)((Object)head));
        }
        return null;
    }

    private void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        PurchaseContractPromise byId;
        PurchaseContractPromise head = new PurchaseContractPromise();
        head.setId(flowCallbackDTO.getBusinessId());
        head.setAuditStatus(auditStatus);
        head.setFlowId(flowCallbackDTO.getProcessInstanceId());
        this.purchaseContractPromiseMapper.updateById((Object)head);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(auditStatus)) {
            PurchaseContractPromise byId2 = (PurchaseContractPromise)((Object)this.purchaseContractPromiseService.getById((Serializable)((Object)flowCallbackDTO.getBusinessId())));
            if (byId2.getCreateAccount().equals(byId2.getBusAccount())) {
                byId2.setAuditStatus(auditStatus);
                this.purchaseContractPromiseService.publishEvent(byId2);
            } else {
                byId2.setAuditStatus(auditStatus);
                this.purchaseContractPromiseService.confirmedSupplier(byId2);
            }
        } else if (AuditStatusEnum.AUDIT_REJECT.getValue().equals(auditStatus) && !(byId = (PurchaseContractPromise)((Object)this.purchaseContractPromiseService.getById((Serializable)((Object)flowCallbackDTO.getBusinessId())))).getCreateAccount().equals(byId.getBusAccount())) {
            this.purchaseContractPromiseService.refundMain(flowCallbackDTO.getBusinessId(), flowCallbackDTO.getOpinion());
        }
    }
}

