/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.contractlock.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.IpaasConfig;
import com.els.config.StaticConfig;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.electronsign.contractlock.entity.SaleClPersonalInfo;
import com.els.modules.electronsign.contractlock.mapper.SaleClPersonalInfoMapper;
import com.els.modules.electronsign.contractlock.service.SaleClPersonalInfoService;
import com.els.modules.electronsign.contractlock.util.ClResultAnalysisUtil;
import com.els.modules.electronsign.contractlock.vo.ClCallback;
import com.els.modules.electronsign.contractlock.vo.ClCompanyCertificationVO;
import com.els.modules.electronsign.contractlock.vo.ClCompanyStaffVO;
import com.els.modules.electronsign.contractlock.vo.ClPersonalCertificationVO;
import com.els.modules.electronsign.contractlock.vo.ClQueryCertificationVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SaleClPersonalInfoServiceImpl
extends BaseServiceImpl<SaleClPersonalInfoMapper, SaleClPersonalInfo>
implements SaleClPersonalInfoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SaleClPersonalInfoServiceImpl.class);
    Map<String, String> config = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
    private String address = this.config.get("service.address");
    private Map<String, String> configMap = ((IpaasConfig)SpringContextUtils.getBean(IpaasConfig.class)).getConfig();
    private String service = this.configMap.get("service");
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    public void updateInfo(SaleClPersonalInfo saleClPersonalInfo) {
        this.check(saleClPersonalInfo);
        saleClPersonalInfo.setUpdateTime(new Date());
        LoginUserDTO sysUser = SysUtil.getLoginUser();
        String currentUser = sysUser.getSubAccount();
        saleClPersonalInfo.setUpdateBy(currentUser);
        ((SaleClPersonalInfoMapper)this.baseMapper).updateById((Object)saleClPersonalInfo);
        this.getCertificationInfo(saleClPersonalInfo.getId());
    }

    public void saveInfo(SaleClPersonalInfo saleClPersonalInfo) {
        this.check(saleClPersonalInfo);
        saleClPersonalInfo.setCreateTime(new Date());
        LoginUserDTO sysUser = SysUtil.getLoginUser();
        String currentUser = sysUser.getSubAccount();
        saleClPersonalInfo.setCreateBy(currentUser);
        ((SaleClPersonalInfoMapper)this.baseMapper).insert((Object)saleClPersonalInfo);
        this.getCertificationInfo(saleClPersonalInfo.getId());
    }

    public void handleDb(SaleClPersonalInfo req) {
        if (StrUtil.isBlank((CharSequence)req.getId())) {
            this.saveInfo(req);
        } else {
            this.updateInfo(req);
        }
    }

    @Override
    public void add(SaleClPersonalInfo saleClPersonalInfo) {
        this.saveInfo(saleClPersonalInfo);
    }

    private void checkNotCompanyIdPsn(SaleClPersonalInfo saleClPersonalInfo) {
        Assert.isTrue((this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SaleClPersonalInfo::getApplyContact, (Object)saleClPersonalInfo.getApplyContact())).eq(SaleClPersonalInfo::getApplyContactType, (Object)saleClPersonalInfo.getApplyContactType())).ne(StrUtil.isNotBlank((CharSequence)saleClPersonalInfo.getId()), ParentEntity::getId, (Object)saleClPersonalInfo.getId())).and(i -> ((LambdaQueryWrapper)((LambdaQueryWrapper)i.isNull(SaleClPersonalInfo::getCompanyId)).or()).eq(SaleClPersonalInfo::getCompanyId, (Object)""))) == 0L ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_IMKdeKHCKKHCKAcjL_8fb41031", (String)"\u5df2\u5b58\u5728\u76f8\u540c\u8054\u7cfb\u65b9\u5f0f\u3001\u8054\u7cfb\u65b9\u5f0f\u7c7b\u578b\u7684\u4eba"));
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void edit(SaleClPersonalInfo saleClPersonalInfo) {
        SaleClPersonalInfo old = (SaleClPersonalInfo)((Object)this.getById((Serializable)((Object)saleClPersonalInfo.getId())));
        Assert.isTrue((!"ADMIN".equals(old.getRoleStr()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_xOcrRvjjVH_b612843a", (String)"\u4e0d\u80fd\u4fee\u6539\u7ba1\u7406\u5458\u7684\u4fe1\u606f"));
        boolean needSync = StrUtil.isNotBlank((CharSequence)saleClPersonalInfo.getCompanyId()) && (!saleClPersonalInfo.getApplyContact().equals(old.getApplyContact()) || !saleClPersonalInfo.getApplyContactType().equals(old.getApplyContactType()) || !saleClPersonalInfo.getApplyUserName().equals(old.getApplyUserName()));
        this.updateInfo(saleClPersonalInfo);
        if (needSync) {
            ClCompanyStaffVO delReq = new ClCompanyStaffVO();
            delReq.setCompanyId(saleClPersonalInfo.getCompanyId());
            ClCompanyStaffVO.Body body = new ClCompanyStaffVO.Body();
            body.setContact(old.getApplyContact());
            body.setContactType(old.getApplyContactType());
            delReq.setBody(body);
            Result<?> result = this.getIPassResponse(delReq, "remove-staff-company-personal", old.getPurchaseAccount());
            Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
            ClCompanyStaffVO addReq = new ClCompanyStaffVO();
            addReq.setCompanyId(saleClPersonalInfo.getCompanyId());
            ClCompanyStaffVO.Body addBody = new ClCompanyStaffVO.Body();
            addBody.setUser(new ClCompanyCertificationVO.ApplicantInfo(saleClPersonalInfo.getApplyUserName(), saleClPersonalInfo.getApplyContact(), saleClPersonalInfo.getApplyContactType()));
            addReq.setBody(addBody);
            Result<?> addResult = this.getIPassResponse(addReq, "add-staff-company-personal", old.getPurchaseAccount());
            Assert.isTrue((boolean)addResult.isSuccess(), (String)result.getMessage());
        }
    }

    @Override
    public void delete(String id) {
        ((SaleClPersonalInfoMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((SaleClPersonalInfoMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void submitCertification(SaleClPersonalInfo req) {
        req.setCertificationStartTime(new Date());
        this.handleDb(req);
        ClPersonalCertificationVO certificationInfo = (ClPersonalCertificationVO)SysUtil.copyProperties((Object)((Object)req), ClPersonalCertificationVO.class);
        certificationInfo.setUsername(req.getApplyUserName());
        certificationInfo.setUser(new ClPersonalCertificationVO.User(req.getApplyContact(), req.getApplyContactType()));
        certificationInfo.setCallbackUrl(this.address + "/els/contractLock/saleClPersonalInfo/noToken/callback/personal");
        ClResultAnalysisUtil.handleEmptyStr(certificationInfo);
        Result<?> response = this.getIPassResponse(certificationInfo, "get-auth-personal", req.getPurchaseAccount());
        if (response.isSuccess()) {
            JSONObject jsonObject = (JSONObject)response.getResult();
            req.setCertificationPageUrl(jsonObject.getString("authUrl"));
            req.setAuthId(jsonObject.getString("authId"));
            this.updateById((Object)req);
        } else {
            Assert.isTrue((boolean)false, (String)response.getMessage());
        }
    }

    @Override
    public void getCertificationInfo(String id) {
        SaleClPersonalInfo info = (SaleClPersonalInfo)((Object)this.getById((Serializable)((Object)id)));
        ClQueryCertificationVO clQueryCertificationVO = new ClQueryCertificationVO();
        ClQueryCertificationVO.Param base = new ClQueryCertificationVO.Param();
        base.setContact(info.getApplyContact());
        base.setContactType(info.getApplyContactType());
        clQueryCertificationVO.setBase(base);
        Result<?> response = this.getIPassResponse(clQueryCertificationVO, "query-auth-personal", info.getPurchaseAccount());
        if (response.isSuccess()) {
            JSONObject jsonObject = (JSONObject)response.getResult();
            Boolean realName = jsonObject.getBoolean("realName");
            if (realName != null && realName.booleanValue()) {
                info.setRealName("1");
            } else {
                info.setRealName("0");
            }
            this.updateById((Object)info);
        }
    }

    @Override
    public void handleCallBackAuth(String contents) {
        ClCallback.PersonalAuth personalAuth = (ClCallback.PersonalAuth)JSON.parseObject((String)contents, ClCallback.PersonalAuth.class);
        SaleClPersonalInfo dbInfo = ((SaleClPersonalInfoMapper)this.baseMapper).selectByRequestId(personalAuth.getAuthId());
        if (ObjectUtil.isNotNull((Object)((Object)dbInfo)) && "1".equals(personalAuth.getStatus())) {
            dbInfo.setRealName("1");
            dbInfo.setUpdateTime(new Date());
            this.updateById((Object)dbInfo);
        }
    }

    @Override
    public void check(SaleClPersonalInfo saleClPersonalInfo) {
        if (StrUtil.isBlank((CharSequence)saleClPersonalInfo.getCompanyId())) {
            this.checkNotCompanyIdPsn(saleClPersonalInfo);
        } else {
            Assert.isTrue((this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SaleClPersonalInfo::getApplyContact, (Object)saleClPersonalInfo.getApplyContact())).eq(SaleClPersonalInfo::getApplyContactType, (Object)saleClPersonalInfo.getApplyContactType())).eq(SaleClPersonalInfo::getCompanyId, (Object)saleClPersonalInfo.getCompanyId())).eq(ParentEntity::getElsAccount, (Object)saleClPersonalInfo.getElsAccount())).ne(StrUtil.isNotBlank((CharSequence)saleClPersonalInfo.getId()), ParentEntity::getId, (Object)saleClPersonalInfo.getId())) == 0L ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_MKdecRWKHCKWRCjL_7d1ddba3", (String)"\u5b58\u5728\u8054\u7cfb\u65b9\u5f0f\u3001\u8054\u7cfb\u65b9\u5f0f\u7c7b\u578b\u3001\u516c\u53f8\u7684\u4eba"));
        }
    }

    private Result<?> getIPassResponse(Object req, String iPassCode, String purchaseElsAccount) {
        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)req));
        jsonObject.put("currentAccount", (Object)purchaseElsAccount.split(",")[0]);
        JSONObject object = this.invokeBaseRpcService.callIPaasInterface(jsonObject, this.service, this.invokeBaseRpcService.getIpaasInterfaceCode(iPassCode));
        return ClResultAnalysisUtil.analysisResult(object);
    }
}

