/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.fadada.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.contract.rpc.service.ContractInvokeMainDataRpcService;
import com.els.modules.electronsign.fadada.dto.FadadaGetOrgAuthUrlDTO;
import com.els.modules.electronsign.fadada.entity.PurchaseFadadaOrg;
import com.els.modules.electronsign.fadada.mapper.PurchaseFadadaOrgMapper;
import com.els.modules.electronsign.fadada.mapper.PurchaseFadadaOrgPsnMapper;
import com.els.modules.electronsign.fadada.mapper.PurchaseFadadaSealMapper;
import com.els.modules.electronsign.fadada.mapper.PurchaseFadadaSealPsnMapper;
import com.els.modules.electronsign.fadada.service.PurchaseFadadaOrgPsnService;
import com.els.modules.electronsign.fadada.service.PurchaseFadadaOrgService;
import com.els.modules.electronsign.fadada.service.PurchaseFadadaSealService;
import com.els.modules.electronsign.fadada.util.FadadaCallUtil;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseFadadaOrgServiceImpl
extends BaseServiceImpl<PurchaseFadadaOrgMapper, PurchaseFadadaOrg>
implements PurchaseFadadaOrgService {
    @Autowired
    private FadadaCallUtil fadadaCallUtil;
    @Autowired
    private ContractInvokeMainDataRpcService contractInvokeMainDataRpcService;
    @Autowired
    private PurchaseFadadaOrgPsnMapper purchaseFadadaOrgPsnMapper;
    @Autowired
    private PurchaseFadadaSealMapper purchaseFadadaSealMapper;
    @Autowired
    private PurchaseFadadaSealPsnMapper purchaseFadadaSealPsnMapper;
    @Autowired
    private PurchaseFadadaOrgPsnService purchaseFadadaOrgPsnService;
    @Autowired
    private PurchaseFadadaSealService purchaseFadadaSealService;

    @Override
    public void add(PurchaseFadadaOrg purchaseFadadaOrg) {
        this.handleOrgCode(purchaseFadadaOrg);
        this.saveFlag(purchaseFadadaOrg);
        ((PurchaseFadadaOrgMapper)this.baseMapper).insert((Object)purchaseFadadaOrg);
    }

    public PurchaseFadadaOrg handleOrgCode(PurchaseFadadaOrg purchaseFadadaOrg) {
        purchaseFadadaOrg.setCorpNonEditableInfo("corpName,corpIdentType,corpIdentNo");
        if ("1".equals(purchaseFadadaOrg.getLoadingOrg())) {
            PurchaseOrganizationInfoDTO organizationInfo = this.contractInvokeMainDataRpcService.selectByElsAccountAndCode(TenantContext.getTenant(), "companyCode", purchaseFadadaOrg.getOrgCode());
            Assert.isTrue((boolean)true, (String)I18nUtil.translate((String)"i18n_alert_RCIH_264a3c82", (String)"\u516c\u53f8\u5f02\u5e38"));
            if (organizationInfo != null) {
                purchaseFadadaOrg.setCorpName(organizationInfo.getOrgName());
            }
        }
        purchaseFadadaOrg.setClientCorpId(purchaseFadadaOrg.getCorpIdentNo());
        return purchaseFadadaOrg;
    }

    public void saveFlag(PurchaseFadadaOrg purchaseFadadaOrg) {
        QueryWrapper purchaseFadadaOrgQueryWrapper = new QueryWrapper();
        purchaseFadadaOrgQueryWrapper.eq((Object)"corp_name", (Object)purchaseFadadaOrg.getCorpName());
        purchaseFadadaOrgQueryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        if (this.getOne((Wrapper)purchaseFadadaOrgQueryWrapper) != null) {
            throw new ELSBootException("\u673a\u6784\u3010" + purchaseFadadaOrg.getCorpName() + "\u3011\u5df2\u88ab\u521b\u5efa\uff0c\u4e0d\u80fd\u91cd\u590d\u521b\u5efa");
        }
    }

    @Override
    public void edit(PurchaseFadadaOrg purchaseFadadaOrg) {
        this.handleOrgCode(purchaseFadadaOrg);
        this.editFlag(purchaseFadadaOrg);
        int count = ((PurchaseFadadaOrgMapper)this.baseMapper).updateById((Object)purchaseFadadaOrg);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    public void editFlag(PurchaseFadadaOrg purchaseFadadaOrg) {
        QueryWrapper purchaseFadadaOrgQueryWrapper = new QueryWrapper();
        purchaseFadadaOrgQueryWrapper.eq((Object)"corp_name", (Object)purchaseFadadaOrg.getCorpName());
        purchaseFadadaOrgQueryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        PurchaseFadadaOrg fadadaOrg = (PurchaseFadadaOrg)((Object)this.getOne((Wrapper)purchaseFadadaOrgQueryWrapper));
        if (fadadaOrg != null && !fadadaOrg.getId().equals(purchaseFadadaOrg.getId())) {
            throw new ELSBootException(purchaseFadadaOrg.getCorpName() + "\u5df2\u88ab\u521b\u5efa\uff0c\u53ef\u6362\u5176\u4ed6\u673a\u6784");
        }
    }

    @Override
    public void delete(String id) {
        ((PurchaseFadadaOrgMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((PurchaseFadadaOrgMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void auth(PurchaseFadadaOrg purchaseFadadaOrg) {
        if (StrUtil.isBlank((CharSequence)purchaseFadadaOrg.getId())) {
            this.add(purchaseFadadaOrg);
        } else {
            this.edit(purchaseFadadaOrg);
        }
        String redirectUrl = this.fadadaCallUtil.getRedirectUrl();
        FadadaGetOrgAuthUrlDTO fadadaGetOrgAuthUrlDTO = new FadadaGetOrgAuthUrlDTO(purchaseFadadaOrg, redirectUrl);
        String requestStr = JSONObject.toJSONString((Object)fadadaGetOrgAuthUrlDTO);
        JSONObject response = this.fadadaCallUtil.call(requestStr, "fadada_get_org_auth_url");
        if ("210002".equals(response.getString("code"))) {
            purchaseFadadaOrg.setAuthFailedReason("exist");
            this.getAuthInfo(purchaseFadadaOrg);
        } else {
            purchaseFadadaOrg.setAuthUrl(response.getString("authUrl"));
            ((PurchaseFadadaOrgMapper)this.baseMapper).updateById((Object)purchaseFadadaOrg);
        }
    }

    @Override
    public void updateAuthStatus(PurchaseFadadaOrg purchaseFadadaOrg) {
        JSONObject requestObject = new JSONObject();
        requestObject.put("corpIdentNo", (Object)purchaseFadadaOrg.getCorpIdentNo());
        JSONObject response = this.fadadaCallUtil.call(requestObject.toJSONString(), "fadada_get_org_auth_info");
        purchaseFadadaOrg.setAvailableStatus(response.getString("availableStatus"));
        purchaseFadadaOrg.setRealnameStatus(response.getString("identStatus"));
        purchaseFadadaOrg.setClientCorpId(response.getString("clientCorpId"));
        purchaseFadadaOrg.setOpenCorpId(response.getString("openCorpId"));
        purchaseFadadaOrg.setAuthResult(response.getString("bindingStatus"));
        this.updateById((Object)purchaseFadadaOrg);
    }

    @Override
    public void getAuthInfo(PurchaseFadadaOrg purchaseFadadaOrg) {
        JSONObject requestObject = new JSONObject();
        requestObject.put("corpIdentNo", (Object)purchaseFadadaOrg.getCorpIdentNo());
        JSONObject authInfo = this.fadadaCallUtil.call(requestObject.toJSONString(), "fadada_get_org_auth_info");
        purchaseFadadaOrg.setAvailableStatus(authInfo.getString("availableStatus"));
        purchaseFadadaOrg.setRealnameStatus(authInfo.getString("identStatus"));
        purchaseFadadaOrg.setAuthResult(authInfo.getString("bindingStatus"));
        purchaseFadadaOrg.setOpenCorpId(authInfo.getString("openCorpId"));
        requestObject = new JSONObject();
        requestObject.put("openCorpId", (Object)purchaseFadadaOrg.getOpenCorpId());
        JSONObject identInfo = this.fadadaCallUtil.call(requestObject.toJSONString(), "fadada_get_org_ident_info");
        if ("legal_rep".equals(identInfo.getString("corpIdentMethod"))) {
            purchaseFadadaOrg.setCorpIdentMethod("legalRep");
        } else {
            purchaseFadadaOrg.setCorpIdentMethod(identInfo.getString("corpIdentMethod"));
        }
        JSONObject corpIdentInfo = identInfo.getJSONObject("corpIdentInfo");
        purchaseFadadaOrg.setCorpName(corpIdentInfo.getString("corpName"));
        purchaseFadadaOrg.setCorpIdentType(corpIdentInfo.getString("corpIdentType"));
        purchaseFadadaOrg.setCorpIdentNo(corpIdentInfo.getString("corpIdentNo"));
        purchaseFadadaOrg.setLegalRepName(corpIdentInfo.getString("legalRepName"));
        JSONObject corpIdentInfoExtend = identInfo.getJSONObject("corpIdentInfoExtend");
        purchaseFadadaOrg.setBankAccountNo(corpIdentInfoExtend.getString("bankAccountNo"));
        purchaseFadadaOrg.setAuthFailedReason("");
        purchaseFadadaOrg.setAuthTime(purchaseFadadaOrg.getAuthTime() + 1);
        this.updateById((Object)purchaseFadadaOrg);
        this.purchaseFadadaOrgPsnService.refreshOrgPsnList(purchaseFadadaOrg.getId());
        this.purchaseFadadaSealService.refreshSealList(purchaseFadadaOrg.getId());
    }
}

