/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.contract.entity.PurchaseContractParam;
import com.els.modules.contract.service.PurchaseContractParamService;
import com.els.rpc.service.InvokeAccountRpcService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u5408\u540c\u53c2\u6570")
@RestController
@RequestMapping(value={"/contract/purchaseContractParam"})
public class PurchaseContractParamController
extends BaseController<PurchaseContractParam, PurchaseContractParamService> {
    @Autowired
    private PurchaseContractParamService purchaseContractParamService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"contractParam#purchaseContractParam:list"})
    public Result<?> queryPageList(PurchaseContractParam purchaseContractParam, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseContractParam), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseContractParamService.page((IPage)page, (Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)pageList.getRecords())) {
            pageList.getRecords().stream().forEach(item -> item.setParamName(I18nUtil.translate((String)item.getParamNameI18nKey(), (String)item.getParamName())));
        }
        return Result.ok((Object)pageList);
    }

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/queryPageListSys"})
    @RequiresPermissions(value={"contractParam#purchaseContractParam:list"})
    public Result<?> queryPageListSys(PurchaseContractParam purchaseContractParam, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseContractParam), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.lambda().eq(ParentEntity::getElsAccount, (Object)"100000");
        IPage pageList = this.purchaseContractParamService.page((IPage)page, (Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)pageList.getRecords())) {
            pageList.getRecords().stream().forEach(item -> item.setParamName(I18nUtil.translate((String)item.getParamNameI18nKey(), (String)item.getParamName())));
        }
        return Result.ok((Object)pageList);
    }

    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @AutoLog(busModule="\u5408\u540c\u53c2\u6570", value="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @SrmValidated
    @RequiresPermissions(value={"contractParam#purchaseContractParam:list"})
    public Result<?> add(@RequestBody PurchaseContractParam purchaseContractParam) {
        this.purchaseContractParamService.savePurchaseContractParam(purchaseContractParam);
        return Result.ok((Object)((Object)purchaseContractParam));
    }

    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @AutoLog(busModule="\u5408\u540c\u53c2\u6570", value="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @SrmValidated
    @RequiresPermissions(value={"contractParam#purchaseContractParam:list"})
    public Result<?> edit(@RequestBody PurchaseContractParam purchaseContractParam) {
        this.purchaseContractParamService.updatePurchaseContractParam(purchaseContractParam);
        String id = purchaseContractParam.getId();
        return this.queryById(id);
    }

    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @AutoLog(busModule="\u5408\u540c\u53c2\u6570", value="\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"contractParam#purchaseContractParam:delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.purchaseContractParamService.delPurchaseContractParam(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u6279\u91cf\u5220\u9664")
    @Operation(summary="\u6279\u91cf\u5220\u9664", description="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"contractParam#purchaseContractParam:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.purchaseContractParamService.delBatchPurchaseContractParam(idList);
        return this.commonSuccessResult(4);
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"contractParam#purchaseContractParam:view"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        PurchaseContractParam purchaseContractParam = (PurchaseContractParam)((Object)this.purchaseContractParamService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        return Result.ok((Object)((Object)purchaseContractParam));
    }

    @Operation(summary="\u590d\u5236\u5408\u540c\u53c2\u6570\u7ed9\u6307\u5b9aelsAccount", description="\u590d\u5236\u5408\u540c\u53c2\u6570\u7ed9\u6307\u5b9aelsAccount")
    @GetMapping(value={"/toElsAccount/{elsAccount}"})
    @RequiresPermissions(value={"contractParam#purchaseContractParam:copy"})
    public Result<?> copyToElsAccount(@PathVariable(value="elsAccount") String elsAccount) {
        ElsSubAccountDTO account = this.invokeAccountRpcService.getAccount(elsAccount, "1001");
        if (account == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_fail_elsAccountNotFound", (String)"\u5f53\u524dELSAccount[${0}]\u4e0d\u5b58\u5728", (String[])new String[]{elsAccount}));
        }
        List copyList = this.purchaseContractParamService.list();
        this.purchaseContractParamService.copyToElsAccount(copyList, elsAccount);
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_tkLR_2f0866fe", (String)"\u64cd\u4f5c\u6210\u529f"));
    }

    @AutoLog(value="Excel\u914d\u7f6e-\u5237\u65b0\u56fd\u9645\u5316\u6807\u7b7e", operateType=2)
    @Operation(summary="Excel\u914d\u7f6e-\u5237\u65b0\u56fd\u9645\u5316\u6807\u7b7e", description="Excel\u914d\u7f6e-\u5237\u65b0\u56fd\u9645\u5316\u6807\u7b7e")
    @GetMapping(value={"/refreshContractParamsI18n"})
    public Result<?> refreshExcelI18n() {
        this.purchaseContractParamService.refreshExcelI18n();
        return this.commonSuccessResult(2);
    }
}

