/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.global.api.service.impl;

import cn.hutool.core.util.StrUtil;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.util.I18nUtil;
import com.els.common.util.SrmRpcUtil;
import com.els.modules.account.api.service.AccountInfoRpcService;
import com.els.modules.contract.entity.PurchaseContractAcceptance;
import com.els.modules.contract.entity.PurchaseContractHead;
import com.els.modules.contract.entity.PurchaseContractPromise;
import com.els.modules.contract.entity.SaleContractAcceptance;
import com.els.modules.contract.entity.SaleContractHead;
import com.els.modules.contract.entity.SaleContractPromise;
import com.els.modules.contract.service.PurchaseContractAcceptanceService;
import com.els.modules.contract.service.PurchaseContractHeadService;
import com.els.modules.contract.service.PurchaseContractPromiseService;
import com.els.modules.contract.service.SaleContractAcceptanceService;
import com.els.modules.contract.service.SaleContractHeadService;
import com.els.modules.contract.service.SaleContractPromiseService;
import com.els.modules.im.api.dto.GroupChatRecordDto;
import com.els.modules.im.api.dto.RecordUserDto;
import com.els.modules.im.api.service.GroupChatRecordUserRpcService;
import com.els.modules.im.enums.ImBusinessTypeEnum;
import com.google.common.collect.Lists;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.Assert;

@RpcService(value="contractImUserRecordRpcService")
public class ContractBeanImUserRecordRpcService
implements GroupChatRecordUserRpcService {
    @Resource
    private PurchaseContractHeadService purchaseContractHeadService;
    @Resource
    private SaleContractHeadService saleContractHeadService;
    @Resource
    private PurchaseContractPromiseService purchaseContractPromiseService;
    @Resource
    private SaleContractPromiseService saleContractPromiseService;
    @Resource
    private PurchaseContractAcceptanceService purchaseContractAcceptanceService;
    @Resource
    private SaleContractAcceptanceService saleContractAcceptanceService;

    public List<RecordUserDto> loadGroupChatUserByRecord(GroupChatRecordDto imRecordDto) {
        ArrayList<RecordUserDto> resultList = new ArrayList<RecordUserDto>();
        if (ImBusinessTypeEnum.PURCHASE_CONTRACT_HEAD.getValue().equals(imRecordDto.getBusinessType())) {
            PurchaseContractHead dbHead = (PurchaseContractHead)((Object)this.purchaseContractHeadService.getById((Serializable)((Object)imRecordDto.getBusinessId())));
            Assert.isTrue((null != dbHead ? 1 : 0) != 0, (String)String.format(I18nUtil.translate((String)"i18n__rItWWWWxMK_f5ab9c91", (String)"\u8be5\u8ba2\u5355[%s]\u4e0d\u5b58\u5728"), imRecordDto.getBusinessId()));
            return this.queryAllUserWithGroupChat((AccountInfoRpcService)SrmRpcUtil.getExecuteServiceImpl(AccountInfoRpcService.class), Lists.newArrayList((Object[])new String[]{dbHead.getToElsAccount()}));
        }
        if (ImBusinessTypeEnum.SALE_CONTRACT_HEAD.getValue().equals(imRecordDto.getBusinessType())) {
            SaleContractHead dbHead = (SaleContractHead)((Object)this.saleContractHeadService.getById((Serializable)((Object)imRecordDto.getBusinessId())));
            Assert.isTrue((null != dbHead ? 1 : 0) != 0, (String)String.format(I18nUtil.translate((String)"i18n__rItWWWWxMK_f5ab9c91", (String)"\u8be5\u8ba2\u5355[%s]\u4e0d\u5b58\u5728"), imRecordDto.getBusinessId()));
            String toElsAccount = dbHead.getToElsAccount();
            String subAccount = StrUtil.isBlank((CharSequence)dbHead.getPurchasePrincipal()) ? "1001" : dbHead.getPurchasePrincipal().split("_")[0];
            RecordUserDto imUserDTO = new RecordUserDto();
            imUserDTO.setElsAccount(toElsAccount + "_" + subAccount);
            resultList.add(imUserDTO);
        } else {
            if (ImBusinessTypeEnum.PURCHASE_CONTRACT_PROMISE.getValue().equals(imRecordDto.getBusinessType())) {
                PurchaseContractPromise dbHead = (PurchaseContractPromise)((Object)this.purchaseContractPromiseService.getById((Serializable)((Object)imRecordDto.getBusinessId())));
                Assert.isTrue((null != dbHead ? 1 : 0) != 0, (String)String.format(I18nUtil.translate((String)"i18n__rItWWWWxMK_f5ab9c91", (String)"\u8be5\u8ba2\u5355[%s]\u4e0d\u5b58\u5728"), imRecordDto.getBusinessId()));
                return this.queryAllUserWithGroupChat((AccountInfoRpcService)SrmRpcUtil.getExecuteServiceImpl(AccountInfoRpcService.class), Lists.newArrayList((Object[])new String[]{dbHead.getToElsAccount()}));
            }
            if (ImBusinessTypeEnum.SALE_CONTRACT_PROMISE.getValue().equals(imRecordDto.getBusinessType())) {
                SaleContractPromise dbHead = (SaleContractPromise)((Object)this.saleContractPromiseService.getById((Serializable)((Object)imRecordDto.getBusinessId())));
                Assert.isTrue((null != dbHead ? 1 : 0) != 0, (String)String.format(I18nUtil.translate((String)"i18n__rItWWWWxMK_f5ab9c91", (String)"\u8be5\u8ba2\u5355[%s]\u4e0d\u5b58\u5728"), imRecordDto.getBusinessId()));
                String toElsAccount = dbHead.getToElsAccount();
                String subAccount = StrUtil.isNotEmpty((CharSequence)toElsAccount) && toElsAccount.split("_").length == 2 ? toElsAccount.split("_")[1] : "1001";
                RecordUserDto e = new RecordUserDto();
                e.setElsAccount(toElsAccount + "_" + subAccount);
                resultList.add(e);
            } else {
                if (ImBusinessTypeEnum.PURCHASE_CONTRACT_ACCEPTANCE.getValue().equals(imRecordDto.getBusinessType())) {
                    PurchaseContractAcceptance dbHead = (PurchaseContractAcceptance)((Object)this.purchaseContractAcceptanceService.getById((Serializable)((Object)imRecordDto.getBusinessId())));
                    Assert.isTrue((null != dbHead ? 1 : 0) != 0, (String)String.format(I18nUtil.translate((String)"i18n__rItWWWWxMK_f5ab9c91", (String)"\u8be5\u8ba2\u5355[%s]\u4e0d\u5b58\u5728"), imRecordDto.getBusinessId()));
                    return this.queryAllUserWithGroupChat((AccountInfoRpcService)SrmRpcUtil.getExecuteServiceImpl(AccountInfoRpcService.class), Lists.newArrayList((Object[])new String[]{dbHead.getToElsAccount()}));
                }
                if (ImBusinessTypeEnum.SALE_CONTRACT_ACCEPTANCE.getValue().equals(imRecordDto.getBusinessType())) {
                    SaleContractAcceptance dbHead = (SaleContractAcceptance)((Object)this.saleContractAcceptanceService.getById((Serializable)((Object)imRecordDto.getBusinessId())));
                    String toElsAccount = dbHead.getToElsAccount();
                    String subAccount = StrUtil.isNotEmpty((CharSequence)toElsAccount) && toElsAccount.split("_").length == 2 ? toElsAccount.split("_")[1] : "1001";
                    RecordUserDto e = new RecordUserDto();
                    e.setElsAccount(toElsAccount + "_" + subAccount);
                    resultList.add(e);
                }
            }
        }
        return resultList;
    }
}

