/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.BusMessageVO;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.contract.entity.PurchaseContractPromise;
import com.els.modules.contract.entity.PurchasePromiseItem;
import com.els.modules.contract.entity.SaleContractHead;
import com.els.modules.contract.entity.SaleContractPromise;
import com.els.modules.contract.entity.SalePromiseItem;
import com.els.modules.contract.enumerate.ContractPromiseStatusEnum;
import com.els.modules.contract.mapper.SaleContractHeadMapper;
import com.els.modules.contract.mapper.SaleContractPromiseMapper;
import com.els.modules.contract.mapper.SalePromiseItemMapper;
import com.els.modules.contract.service.PurchaseContractPromiseService;
import com.els.modules.contract.service.SaleContractPromiseService;
import com.els.modules.contract.service.SalePromiseItemService;
import com.els.modules.contract.vo.PurchaseContractPromiseVO;
import com.els.rpc.service.InvokeBaseRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SaleContractPromiseServiceImpl
extends BaseServiceImpl<SaleContractPromiseMapper, SaleContractPromise>
implements SaleContractPromiseService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SaleContractPromiseServiceImpl.class);
    @Resource
    private SaleContractPromiseMapper saleContractPromiseMapper;
    @Resource
    private SaleContractHeadMapper saleContractHeadMapper;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private SalePromiseItemMapper salePromiseItemMapper;
    @Resource
    private SalePromiseItemService salePromiseItemService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(SaleContractPromise saleContractPromise, List<SalePromiseItem> salePromiseItemList) {
        saleContractPromise.setElsAccount(TenantContext.getTenant());
        if (StrUtil.isBlank((CharSequence)saleContractPromise.getPromiseNumber())) {
            TenantContext.setTenant((String)(StrUtil.isNotBlank((CharSequence)saleContractPromise.getBusAccount()) ? saleContractPromise.getBusAccount() : saleContractPromise.getElsAccount()));
            String nextCode = this.invokeBaseRpcService.getNextCode("srmContractPromise", (Object)saleContractPromise, saleContractPromise.getBusAccount());
            saleContractPromise.setPromiseNumber(nextCode);
            TenantContext.setTenant((String)saleContractPromise.getElsAccount());
        }
        super.setHeadDefaultValue((ParentEntity)saleContractPromise);
        if (saleContractPromise.getAmount() != null && saleContractPromise.getContractAmount() != null && saleContractPromise.getContractAmount().compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal divide = saleContractPromise.getAmount().divide(saleContractPromise.getContractAmount(), 6, 4);
            saleContractPromise.setPerformanceRatio(divide.multiply(new BigDecimal(100)).setScale(2, 4));
        }
        this.saleContractPromiseMapper.insert((Object)saleContractPromise);
        this.insertData(saleContractPromise, salePromiseItemList);
    }

    @Override
    public void updateMain(SaleContractPromise saleContractPromise, List<SalePromiseItem> salePromiseItemList) {
        if (saleContractPromise.getAmount() != null && saleContractPromise.getContractAmount() != null && saleContractPromise.getContractAmount().compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal divide = saleContractPromise.getAmount().divide(saleContractPromise.getContractAmount(), 6, 4);
            saleContractPromise.setPerformanceRatio(divide.multiply(new BigDecimal(100)).setScale(2, 4));
        }
        this.saleContractPromiseMapper.updateById((Object)saleContractPromise);
        this.salePromiseItemMapper.deleteByMainId(saleContractPromise.getId());
        this.insertData(saleContractPromise, salePromiseItemList);
    }

    private void insertData(SaleContractPromise saleContractPromise, List<SalePromiseItem> salePromiseItemList) {
        if (!CollectionUtils.isEmpty(salePromiseItemList)) {
            for (SalePromiseItem entity : salePromiseItemList) {
                entity.setHeadId(saleContractPromise.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)saleContractPromise);
                entity.setPromiseNumber(saleContractPromise.getPromiseNumber());
            }
            if (!salePromiseItemList.isEmpty()) {
                this.salePromiseItemService.saveBatch(salePromiseItemList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.salePromiseItemMapper.deleteByMainId(id);
        this.saleContractPromiseMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.salePromiseItemMapper.deleteByMainId(serializable.toString());
            this.saleContractPromiseMapper.deleteById(serializable);
        }
    }

    @Override
    public List<SaleContractPromise> selectByMainId(String mainId) {
        return this.saleContractPromiseMapper.selectByMainId(mainId);
    }

    @Override
    public SaleContractPromise createPromise(SaleContractPromise saleContractPromise) {
        String templateAccount = saleContractPromise.getTemplateAccount();
        String templateNumber = saleContractPromise.getTemplateNumber();
        String templateName = saleContractPromise.getTemplateName();
        String templateVersion = saleContractPromise.getTemplateVersion();
        SaleContractHead saleContractHead = (SaleContractHead)((Object)this.saleContractHeadMapper.selectById((Serializable)((Object)saleContractPromise.getHeadId())));
        super.setHeadDefaultValue((ParentEntity)saleContractPromise);
        String auditStatus = AuditStatusEnum.AUDIT_NEW.getValue();
        if ("0".equals(saleContractPromise.getAudited())) {
            auditStatus = AuditStatusEnum.NO_AUDIT_REQUIRED.getValue();
        }
        if (saleContractHead != null) {
            BeanUtil.copyProperties((Object)((Object)saleContractHead), (Object)((Object)saleContractPromise), (String[])new String[0]);
            saleContractPromise.setBusAccount(saleContractHead.getBusAccount());
            saleContractPromise.setTemplateAccount(templateAccount);
            saleContractPromise.setTemplateNumber(templateNumber);
            saleContractPromise.setTemplateName(templateName);
            saleContractPromise.setTemplateVersion(templateVersion);
            saleContractPromise.setCreateAccount(TenantContext.getTenant());
            saleContractPromise.setHeadId(saleContractHead.getId());
            saleContractPromise.setId(null);
            saleContractPromise.setCreateBy(null);
            saleContractPromise.setCreateById(null);
            saleContractPromise.setCreateTime(null);
            saleContractPromise.setUpdateBy(null);
            saleContractPromise.setUpdateById(null);
            saleContractPromise.setUpdateTime(null);
        }
        saleContractPromise.setAuditStatus(auditStatus);
        this.saveSaleContractPromise(saleContractPromise);
        return saleContractPromise;
    }

    @Override
    public void saveSaleContractPromise(SaleContractPromise saleContractPromise) {
        if (StrUtil.isBlank((CharSequence)saleContractPromise.getPromiseNumber())) {
            TenantContext.setTenant((String)(StrUtil.isNotBlank((CharSequence)saleContractPromise.getBusAccount()) ? saleContractPromise.getBusAccount() : saleContractPromise.getElsAccount()));
            String nextCode = this.invokeBaseRpcService.getNextCode("srmContractPromise", (Object)saleContractPromise);
            saleContractPromise.setPromiseNumber(nextCode);
            TenantContext.setTenant((String)saleContractPromise.getElsAccount());
        }
        this.save((Object)saleContractPromise);
    }

    @Override
    public void updateSaleContractPromise(SaleContractPromise saleContractPromise) {
        if (StrUtil.isBlank((CharSequence)saleContractPromise.getPromiseNumber())) {
            TenantContext.setTenant((String)(StrUtil.isNotBlank((CharSequence)saleContractPromise.getBusAccount()) ? saleContractPromise.getBusAccount() : saleContractPromise.getElsAccount()));
            String nextCode = this.invokeBaseRpcService.getNextCode("srmContractPromise", (Object)saleContractPromise);
            saleContractPromise.setPromiseNumber(nextCode);
            TenantContext.setTenant((String)saleContractPromise.getElsAccount());
        }
        ((SaleContractPromiseMapper)this.baseMapper).updateById((Object)saleContractPromise);
    }

    @Override
    public void delSaleContractPromise(String id) {
        ((SaleContractPromiseMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchSaleContractPromise(List<String> idList) {
        ((SaleContractPromiseMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void publish(SaleContractPromise saleContractPromise) {
        SaleContractPromise saleContractPromise1 = (SaleContractPromise)((Object)this.saleContractPromiseMapper.selectById((Serializable)((Object)saleContractPromise.getId())));
        List<SalePromiseItem> salePromiseItems = this.salePromiseItemMapper.selectByMainId(saleContractPromise1.getId());
        SaleContractHead saleContractHead = (SaleContractHead)((Object)this.saleContractHeadMapper.selectById((Serializable)((Object)saleContractPromise1.getHeadId())));
        PurchaseContractPromiseService purchaseContractPromiseService = (PurchaseContractPromiseService)SpringContextUtils.getBean(PurchaseContractPromiseService.class);
        PurchaseContractPromiseVO purchaseContractPromise = new PurchaseContractPromiseVO();
        BeanUtil.copyProperties((Object)((Object)saleContractPromise), (Object)((Object)purchaseContractPromise), (String[])new String[0]);
        purchaseContractPromise.setPromiseStatus(ContractPromiseStatusEnum.CONTRACT_PROMISE_CONFIRMING.getValue());
        purchaseContractPromise.setHeadId(saleContractHead.getRelationId());
        purchaseContractPromise.setRelationId(saleContractPromise1.getId());
        purchaseContractPromise.setElsAccount(saleContractHead.getToElsAccount());
        purchaseContractPromise.setToElsAccount(saleContractHead.getElsAccount());
        if (!CollectionUtils.isEmpty(salePromiseItems)) {
            ArrayList<PurchasePromiseItem> purchasePromiseItems = new ArrayList<PurchasePromiseItem>();
            for (SalePromiseItem salePromiseItem : salePromiseItems) {
                PurchasePromiseItem purchasePromiseItem = new PurchasePromiseItem();
                BeanUtil.copyProperties((Object)((Object)salePromiseItem), (Object)((Object)purchasePromiseItem), (String[])new String[0]);
                purchasePromiseItem.setId(IdWorker.getIdStr());
                purchasePromiseItem.setRelationId(salePromiseItem.getId());
                salePromiseItem.setRelationId(purchasePromiseItem.getId());
                purchasePromiseItems.add(purchasePromiseItem);
            }
            purchaseContractPromise.setPurchasePromiseItemList(purchasePromiseItems);
        }
        if (StrUtil.isBlank((CharSequence)purchaseContractPromise.getFlowId())) {
            String auditStatus = AuditStatusEnum.AUDIT_NEW.getValue();
            if ("0".equals(purchaseContractPromise.getAudited())) {
                auditStatus = AuditStatusEnum.NO_AUDIT_REQUIRED.getValue();
            }
            purchaseContractPromise.setAuditStatus(auditStatus);
        }
        if (ContractPromiseStatusEnum.REFUND.getValue().equals(saleContractPromise1.getPromiseStatus())) {
            purchaseContractPromiseService.updateMain(purchaseContractPromise, purchaseContractPromise.getPurchasePromiseItemList());
        } else {
            purchaseContractPromiseService.saveMain(purchaseContractPromise, purchaseContractPromise.getPurchasePromiseItemList());
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(ParentEntity::getId, (Object)saleContractPromise.getId())).set(SaleContractPromise::getPromiseStatus, (Object)purchaseContractPromise.getPromiseStatus())).set(SaleContractPromise::getRelationId, (Object)purchaseContractPromise.getId())).set(SaleContractPromise::getAuditStatus, (Object)saleContractPromise.getAuditStatus())).update((Object)new SaleContractPromise());
        if (!CollectionUtils.isEmpty(salePromiseItems)) {
            salePromiseItems.forEach(item -> this.salePromiseItemMapper.updateById(item));
        }
        super.sendMessage(saleContractPromise1.getBusAccount(), "contractPromise", "publishSupplier", saleContractPromise1.getId(), "contractPromiseBusDataServiceImpl", Arrays.asList(saleContractPromise1.getToElsAccount()));
    }

    @Override
    public void confirmed(SaleContractPromise saleContractPromise) {
        SaleContractPromise saleContractPromise1 = (SaleContractPromise)((Object)this.saleContractPromiseMapper.selectById((Serializable)((Object)saleContractPromise.getId())));
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(ParentEntity::getId, (Object)saleContractPromise.getId())).set(SaleContractPromise::getPromiseStatus, (Object)ContractPromiseStatusEnum.CONFIRMED.getValue())).update((Object)new SaleContractPromise());
        PurchaseContractPromiseService purchaseContractPromiseService = (PurchaseContractPromiseService)SpringContextUtils.getBean(PurchaseContractPromiseService.class);
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)purchaseContractPromiseService.lambdaUpdate().eq(ParentEntity::getId, (Object)saleContractPromise1.getRelationId())).set(PurchaseContractPromise::getPromiseStatus, (Object)ContractPromiseStatusEnum.CONFIRMED.getValue())).update((Object)new PurchaseContractPromise());
        purchaseContractPromiseService.handleConfirmBackContract((PurchaseContractPromise)((Object)purchaseContractPromiseService.getById((Serializable)((Object)saleContractPromise1.getRelationId()))));
        String urlParam = "id=" + saleContractPromise1.getRelationId();
        ArrayList<String> receiveAccountList = new ArrayList<String>();
        receiveAccountList.add(saleContractPromise1.getToElsAccount());
        BusMessageVO messageVO = BusMessageVO.builder().businessId(saleContractPromise1.getId()).msgConfigCode("contractPromise_confirm").businessBean("contractPromiseBusDataServiceImpl").receiveAccountList(receiveAccountList).build();
        super.sendMessage(messageVO);
    }

    @Override
    public void refundMain(String id, String refundRemark) {
        SaleContractPromise saleContractPromise1 = (SaleContractPromise)((Object)this.saleContractPromiseMapper.selectById((Serializable)((Object)id)));
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(ParentEntity::getId, (Object)id)).set(SaleContractPromise::getPromiseStatus, (Object)ContractPromiseStatusEnum.REFUND.getValue())).set(SaleContractPromise::getRefundRemark, (Object)refundRemark)).update((Object)new SaleContractPromise());
        PurchaseContractPromiseService purchaseContractPromiseService = (PurchaseContractPromiseService)SpringContextUtils.getBean(PurchaseContractPromiseService.class);
        if ("1".equals(saleContractPromise1.getAudited())) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)purchaseContractPromiseService.lambdaUpdate().eq(ParentEntity::getId, (Object)saleContractPromise1.getRelationId())).set(PurchaseContractPromise::getPromiseStatus, (Object)ContractPromiseStatusEnum.REFUND.getValue())).set(PurchaseContractPromise::getRefundRemark, (Object)refundRemark)).set(PurchaseContractPromise::getAuditStatus, (Object)"0")).update((Object)new PurchaseContractPromise());
        } else {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)purchaseContractPromiseService.lambdaUpdate().eq(ParentEntity::getId, (Object)saleContractPromise1.getRelationId())).set(PurchaseContractPromise::getPromiseStatus, (Object)ContractPromiseStatusEnum.REFUND.getValue())).set(PurchaseContractPromise::getRefundRemark, (Object)refundRemark)).set(PurchaseContractPromise::getAuditStatus, (Object)"4")).update((Object)new PurchaseContractPromise());
        }
        super.sendMessage(saleContractPromise1.getBusAccount(), "contractPromise", "refund", saleContractPromise1.getId(), "contractPromiseBusDataServiceImpl", Arrays.asList(saleContractPromise1.getToElsAccount()));
    }
}

