/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.contractlock.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.IpaasConfig;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.contract.rpc.service.ContractInvokeMainDataRpcService;
import com.els.modules.electronsign.contractlock.dto.AdminDto;
import com.els.modules.electronsign.contractlock.dto.SealAuthDto;
import com.els.modules.electronsign.contractlock.dto.SealDto;
import com.els.modules.electronsign.contractlock.entity.PurchaseCLCompanyInfo;
import com.els.modules.electronsign.contractlock.entity.PurchaseClPersonalInfo;
import com.els.modules.electronsign.contractlock.entity.PurchaseClSeals;
import com.els.modules.electronsign.contractlock.enumerate.CLAuthResultEnum;
import com.els.modules.electronsign.contractlock.enumerate.CLCertificationStatusEnum;
import com.els.modules.electronsign.contractlock.enumerate.CLContactTypeEnum;
import com.els.modules.electronsign.contractlock.mapper.PurchaseCLCompanyInfoMapper;
import com.els.modules.electronsign.contractlock.service.PurchaseCLCompanyInfoService;
import com.els.modules.electronsign.contractlock.service.PurchaseClPersonalInfoService;
import com.els.modules.electronsign.contractlock.service.PurchaseClSealsService;
import com.els.modules.electronsign.contractlock.util.ClResultAnalysisUtil;
import com.els.modules.electronsign.contractlock.vo.ClCallback;
import com.els.modules.electronsign.contractlock.vo.ClCompanyCertificationVO;
import com.els.modules.electronsign.contractlock.vo.ClCompanySignVO;
import com.els.modules.electronsign.contractlock.vo.ClCompanyStaffVO;
import com.els.modules.electronsign.contractlock.vo.ClQueryCertificationVO;
import com.els.modules.electronsign.contractlock.vo.ClRoleVO;
import com.els.modules.electronsign.contractlock.vo.ClSealAuthVO;
import com.els.modules.electronsign.contractlock.vo.ClSealAutoAuthVO;
import com.els.modules.electronsign.util.ESignUtil;
import com.els.modules.electronsign.util.IpassUtil;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseCLCompanyInfoServiceImpl
extends BaseServiceImpl<PurchaseCLCompanyInfoMapper, PurchaseCLCompanyInfo>
implements PurchaseCLCompanyInfoService {
    Map<String, String> config = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
    private String address = this.config.get("service.address");
    private Map<String, String> configMap = ((IpaasConfig)SpringContextUtils.getBean(IpaasConfig.class)).getConfig();
    private String service = this.configMap.get("service");
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchaseClPersonalInfoService personalInfoService;
    @Autowired
    private ContractInvokeMainDataRpcService contractInvokeMainDataRpcService;
    @Autowired
    private IpassUtil ipassUtil;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private PurchaseClSealsService purchaseClSealsService;

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void add(PurchaseCLCompanyInfo purchaseCLCompanyInfo) {
        if ("1".equals(purchaseCLCompanyInfo.getLoadingCompany())) {
            PurchaseOrganizationInfoDTO organizationInfo = this.contractInvokeMainDataRpcService.selectByElsAccountAndCode(TenantContext.getTenant(), "companyCode", purchaseCLCompanyInfo.getCompany());
            Assert.isTrue((boolean)true, (String)I18nUtil.translate((String)"i18n_alert_RCIH_264a3c82", (String)"\u516c\u53f8\u5f02\u5e38"));
            purchaseCLCompanyInfo.setCompanyName(organizationInfo.getOrgName());
        }
        Assert.isTrue((this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ParentEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(BaseEntity::getDeleted, (Object)"0")).eq(PurchaseCLCompanyInfo::getCompanyName, (Object)purchaseCLCompanyInfo.getCompanyName())) == 0L ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_rRCIOMKWxqVBcI_9ebb70f", (String)"\u8be5\u516c\u53f8\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u53ef\u91cd\u590d\u521b\u5efa"));
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)purchaseCLCompanyInfo.getApplyContactType()), (String)"");
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)purchaseCLCompanyInfo.getApplyUserName()), (String)"");
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)purchaseCLCompanyInfo.getApplyContact()), (String)"");
        this.save((Object)purchaseCLCompanyInfo);
        this.processNewCompany(purchaseCLCompanyInfo);
    }

    public void processNewCompany(PurchaseCLCompanyInfo info) {
        ClQueryCertificationVO clQueryCertificationVO = new ClQueryCertificationVO();
        clQueryCertificationVO.setBase(new ClQueryCertificationVO.Param(info.getCompanyName()));
        Result<?> response = this.getIPassResponse(clQueryCertificationVO, "query-info-company");
        if (response.isSuccess()) {
            JSONObject jsonObject = (JSONObject)response.getResult();
            String status = jsonObject.getString("status");
            JSONArray adminInfosArray = jsonObject.getJSONArray("adminInfos");
            if (CollUtil.isNotEmpty((Collection)adminInfosArray)) {
                boolean checkFlg = false;
                List adminDtos = adminInfosArray.toJavaList(AdminDto.class);
                for (AdminDto admin : adminDtos) {
                    String newSurname;
                    String surname;
                    if ((!StrUtil.isNotBlank((CharSequence)admin.getName()) || !StrUtil.isNotBlank((CharSequence)admin.getMobile())) && !StrUtil.isNotBlank((CharSequence)admin.getEmail()) || !StrUtil.equals((CharSequence)(surname = admin.getName().substring(0, 1)), (CharSequence)(newSurname = info.getApplyUserName().substring(0, 1)))) continue;
                    if (StrUtil.isNotBlank((CharSequence)admin.getMobile()) && StrUtil.equals((CharSequence)info.getApplyContactType(), (CharSequence)CLContactTypeEnum.MOBILE.getValue()) && ESignUtil.matchingMobilePhones(admin.getMobile(), info.getApplyContact())) {
                        checkFlg = true;
                    }
                    if (!StrUtil.isNotBlank((CharSequence)admin.getEmail()) || !StrUtil.equals((CharSequence)info.getApplyContactType(), (CharSequence)CLContactTypeEnum.EMAIL.getValue()) || !ESignUtil.matchingEmail(admin.getEmail(), info.getApplyContact())) continue;
                    checkFlg = true;
                }
                if (!checkFlg) {
                    StringBuffer msg = new StringBuffer();
                    msg.append(I18nUtil.translate((String)"i18n_field_rAEIKAZdLieRSMjUVLxKRvjABs[_3889698f", (String)"\u8be5\u4f01\u4e1a\u5df2\u5728\u5951\u7ea6\u9501\u8ba4\u8bc1\u901a\u8fc7\uff0c\u586b\u5199\u7684\u7533\u8bf7\u4eba\u4e0d\u5728\u7ba1\u7406\u5458\u5217\u8868\u4e2d\uff1a["));
                    adminDtos.forEach(adminDto -> {
                        msg.append("\u59d3\u540d\uff1a" + adminDto.getName());
                        if (StrUtil.isNotBlank((CharSequence)adminDto.getMobile())) {
                            msg.append("\uff1b\u624b\u673a\uff1a" + adminDto.getMobile());
                        }
                        if (StrUtil.isNotBlank((CharSequence)adminDto.getEmail())) {
                            msg.append("\uff1b\u90ae\u7bb1\uff1a" + adminDto.getEmail());
                        }
                        msg.append("\uff1b");
                    });
                    msg.append("]");
                    throw new ELSBootException(msg.toString());
                }
            }
            if (StrUtil.isNotBlank((CharSequence)status) && "AUTH_SUCCESS".equals(status)) {
                info.setCertificationStatus(CLCertificationStatusEnum.PASSED.getValue());
                info.setCompanyId(jsonObject.getString("id"));
                this.insertAdmin(info);
                info.setCertificationStartTime(new Date());
                this.updateInfo(info);
            }
        }
    }

    @Override
    public void edit(PurchaseCLCompanyInfo purchaseCLCompanyInfo) {
        if ("1".equals(purchaseCLCompanyInfo.getLoadingCompany())) {
            PurchaseOrganizationInfoDTO organizationInfo = this.contractInvokeMainDataRpcService.selectByElsAccountAndCode(TenantContext.getTenant(), "companyCode", purchaseCLCompanyInfo.getCompany());
            Assert.isTrue((boolean)true, (String)I18nUtil.translate((String)"i18n_alert_RCIH_264a3c82", (String)"\u516c\u53f8\u5f02\u5e38"));
            purchaseCLCompanyInfo.setCompanyName(organizationInfo.getOrgName());
        }
        Assert.isTrue((this.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PurchaseCLCompanyInfo::getCompanyName, (Object)purchaseCLCompanyInfo.getCompanyName())).ne(ParentEntity::getId, (Object)purchaseCLCompanyInfo.getId())) == 0L ? 1 : 0) != 0, (String)"\u8be5\u516c\u53f8\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u53ef\u91cd\u590d\u521b\u5efa");
        int count = ((PurchaseCLCompanyInfoMapper)this.baseMapper).updateById((Object)purchaseCLCompanyInfo);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        if (!CLCertificationStatusEnum.PASSED.equals(purchaseCLCompanyInfo.getCertificationStatus())) {
            this.getCertificationInfo(purchaseCLCompanyInfo.getId());
        }
    }

    @Override
    public void delete(String id) {
        ((PurchaseCLCompanyInfoMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((PurchaseCLCompanyInfoMapper)this.baseMapper).deleteBatchIds(idList);
    }

    public void saveInfo(PurchaseCLCompanyInfo req) {
        LoginUserDTO sysUser = SysUtil.getLoginUser();
        String currentUser = sysUser.getSubAccount();
        req.setElsAccount(TenantContext.getTenant());
        req.setCreateTime(new Date());
        req.setCreateBy(currentUser);
        this.save((Object)req);
    }

    public void updateInfo(PurchaseCLCompanyInfo req) {
        req.setUpdateTime(new Date());
        LoginUserDTO sysUser = SysUtil.getLoginUser();
        String currentUser = sysUser.getSubAccount();
        req.setUpdateBy(currentUser);
        ((PurchaseCLCompanyInfoMapper)this.baseMapper).updateById((Object)req);
    }

    public void handleDb(PurchaseCLCompanyInfo req) {
        if (StrUtil.isBlank((CharSequence)req.getId())) {
            this.saveInfo(req);
        } else {
            this.updateInfo(req);
        }
    }

    @Override
    public PurchaseCLCompanyInfo submitCertification(PurchaseCLCompanyInfo req) {
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)req.getId()), (String)I18nUtil.translate((String)"i18n_field_VWsM_40db030c", (String)"\u8bf7\u5148\u4fdd\u5b58"));
        Result<?> response = null;
        if (StrUtil.isBlank((CharSequence)req.getCompanyId())) {
            ClCompanyCertificationVO certificationInfo = (ClCompanyCertificationVO)SysUtil.copyProperties((Object)((Object)req), ClCompanyCertificationVO.class);
            certificationInfo.setApplicantInfo(new ClCompanyCertificationVO.ApplicantInfo(req.getApplyUserName(), req.getApplyContact(), req.getApplyContactType()));
            certificationInfo.setCallbackUrl(this.address + "/els/contractLock/purchaseCLCompanyInfo/noToken/callback/authCompany");
            JSONObject object = this.invokeBaseRpcService.callIPaasInterface(JSON.parseObject((String)JSON.toJSONString((Object)certificationInfo)), this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("get-auth-company"));
            response = ClResultAnalysisUtil.analysisResult(object);
            if (response.isSuccess()) {
                JSONObject jsonObject = (JSONObject)response.getResult();
                req.setCertificationPageUrl(jsonObject.getString("pageUrl"));
                req.setRequestId(jsonObject.getString("requestId"));
                req.setCertificationStatus(CLCertificationStatusEnum.UNDER_CERTIFICATION.getValue());
                this.handleDb(req);
            } else {
                Assert.isTrue((boolean)false, (String)response.getMessage());
            }
        }
        return req;
    }

    private void insertAdmin(PurchaseCLCompanyInfo company) {
        TenantContext.setTenant((String)company.getElsAccount());
        List list = this.personalInfoService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PurchaseClPersonalInfo::getCompanyId, (Object)company.getCompanyId())).eq(PurchaseClPersonalInfo::getApplyContact, (Object)company.getApplyContact())).eq(PurchaseClPersonalInfo::getApplyUserName, (Object)company.getApplyUserName())).eq(BaseEntity::getDeleted, (Object)"0"));
        if (CollUtil.isNotEmpty((Collection)list)) {
            list.forEach(x -> {
                x.setRoleStr("ADMIN");
                x.setRealName("1");
                this.personalInfoService.updateById(x);
            });
        } else {
            PurchaseClPersonalInfo personalInfo = new PurchaseClPersonalInfo();
            personalInfo.setRoleStr("ADMIN");
            BeanUtil.copyProperties((Object)((Object)company), (Object)((Object)personalInfo), (String[])new String[0]);
            personalInfo.setCreateTime(new Date());
            personalInfo.setAuthPageUrl(null);
            personalInfo.setId(null);
            personalInfo.setRealName("1");
            this.personalInfoService.save((Object)personalInfo);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void getCertificationInfo(String id) {
        JSONObject jsonObject;
        Integer status;
        PurchaseCLCompanyInfo info = (PurchaseCLCompanyInfo)((Object)this.getById((Serializable)((Object)id)));
        ClQueryCertificationVO clQueryCertificationVO = new ClQueryCertificationVO();
        clQueryCertificationVO.setBody(new ClQueryCertificationVO.Param(info.getCompanyName()));
        Result<?> response = this.getIPassResponse(clQueryCertificationVO, "query-auth-company");
        if (response.isSuccess() && ObjectUtil.isNotEmpty((Object)(status = (jsonObject = (JSONObject)response.getResult()).getInteger("status")))) {
            info.setCertificationStatus(status);
            if (status.equals(CLCertificationStatusEnum.PASSED.getValue())) {
                clQueryCertificationVO = new ClQueryCertificationVO();
                clQueryCertificationVO.setBase(new ClQueryCertificationVO.Param(info.getCompanyName()));
                response = this.getIPassResponse(clQueryCertificationVO, "query-info-company");
                jsonObject = (JSONObject)response.getResult();
                info.setCompanyId(jsonObject.getString("id"));
                this.insertAdmin(info);
            }
            info.setCertificationStartTime(new Date());
            this.updateInfo(info);
        }
    }

    @Override
    public PurchaseCLCompanyInfo getAuthPage(String id) {
        PurchaseCLCompanyInfo info = (PurchaseCLCompanyInfo)((Object)this.getById((Serializable)((Object)id)));
        ClQueryCertificationVO clQueryCertificationVO = new ClQueryCertificationVO();
        clQueryCertificationVO.setBody(new ClQueryCertificationVO.Param(info.getCompanyId(), new ClCompanyCertificationVO.ApplicantInfo(info.getApplyUserName(), info.getApplyContact(), info.getApplyContactType())));
        Result<?> response = this.getIPassResponse(clQueryCertificationVO, "get-auth-page");
        if (response.isSuccess()) {
            JSONObject jsonObject = (JSONObject)response.getResult();
            info.setAuthPageUrl(jsonObject.getString("pageUrl"));
            this.updateInfo(info);
            return info;
        }
        Assert.isTrue((boolean)false, (String)response.getMessage());
        return null;
    }

    @Override
    public void addStaff(PurchaseClPersonalInfo purchaseClPersonalInfo) {
        this.personalInfoService.check(purchaseClPersonalInfo);
        ClCompanyStaffVO staffReq = new ClCompanyStaffVO();
        staffReq.setCompanyId(purchaseClPersonalInfo.getCompanyId());
        ClCompanyStaffVO.Body body = new ClCompanyStaffVO.Body();
        body.setUser(new ClCompanyCertificationVO.ApplicantInfo(purchaseClPersonalInfo.getApplyUserName(), purchaseClPersonalInfo.getApplyContact(), purchaseClPersonalInfo.getApplyContactType()));
        staffReq.setBody(body);
        Result<?> result = this.getIPassResponse(staffReq, "add-staff-company-personal");
        if (result.isSuccess()) {
            JSONObject jsonObject = (JSONObject)result.getResult();
            purchaseClPersonalInfo.setAccountId(jsonObject.getString("id"));
            purchaseClPersonalInfo.setRealName(jsonObject.getBoolean("realName") != false ? "1" : "0");
            if (StrUtil.isNotBlank((CharSequence)purchaseClPersonalInfo.getId())) {
                this.personalInfoService.edit(purchaseClPersonalInfo);
            } else {
                PurchaseCLCompanyInfo companyInfo = this.getByCompanyId(purchaseClPersonalInfo.getCompanyId());
                purchaseClPersonalInfo.setCreateTime(new Date());
                purchaseClPersonalInfo.setElsAccount(companyInfo.getElsAccount());
                purchaseClPersonalInfo.setCompanyId(companyInfo.getCompanyId());
                purchaseClPersonalInfo.setCompanyName(companyInfo.getCompanyName());
                this.personalInfoService.add(purchaseClPersonalInfo);
            }
        } else {
            Assert.isTrue((boolean)false, (String)result.getMessage());
        }
    }

    @Override
    public PurchaseCLCompanyInfo getByCompanyId(String id) {
        return (PurchaseCLCompanyInfo)((Object)this.getOne((Wrapper)Wrappers.lambdaQuery().eq(PurchaseCLCompanyInfo::getCompanyId, (Object)id)));
    }

    @Override
    public void removeStaff(PurchaseClPersonalInfo purchaseClPersonalInfo) {
        ClCompanyStaffVO staffReq = new ClCompanyStaffVO();
        staffReq.setCompanyId(purchaseClPersonalInfo.getCompanyId());
        ClCompanyStaffVO.Body body = new ClCompanyStaffVO.Body();
        body.setContact(purchaseClPersonalInfo.getApplyContact());
        body.setContactType(purchaseClPersonalInfo.getApplyContactType());
        staffReq.setBody(body);
        Result<?> result = this.getIPassResponse(staffReq, "remove-staff-company-personal");
        if (result.isSuccess()) {
            this.personalInfoService.delete(purchaseClPersonalInfo.getId());
        } else {
            Assert.isTrue((boolean)false, (String)result.getMessage());
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void handleCallBackAuth(String contents) {
        ClCallback.CompanyAuth companyAuth = (ClCallback.CompanyAuth)JSON.parseObject((String)contents, ClCallback.CompanyAuth.class);
        PurchaseCLCompanyInfo dbInfo = this.selectByRequestId(companyAuth.getRequestId());
        if (ObjectUtil.isNotNull((Object)((Object)dbInfo))) {
            dbInfo.setCertificationStatus(CLAuthResultEnum.getSrmStatusByValue(companyAuth.getStatus()));
            dbInfo.setCompanyId(companyAuth.getCompanyId());
            dbInfo.setUpdateTime(new Date());
            this.updateById((Object)dbInfo);
            if (CLAuthResultEnum.PASSED.getValue().equals(companyAuth.getStatus())) {
                this.insertAdmin(dbInfo);
            }
        }
    }

    @Override
    public String signUrl(String id) {
        PurchaseCLCompanyInfo companyInfo = (PurchaseCLCompanyInfo)((Object)this.getById((Serializable)((Object)id)));
        ClCompanySignVO companySignVO = new ClCompanySignVO();
        companySignVO.setCompanyId(companyInfo.getCompanyId());
        companySignVO.setAppName("\u4f01\u4f01\u901aSRM");
        companySignVO.setDomain(this.address);
        companySignVO.setLoginUrl("https://v6sit-micro.51qqt.com/user/login");
        companySignVO.setCasVerifyUrl(this.address + "/els/contractLock/purchaseCLCompanyInfo/noToken/casVerifyUrl");
        Result<?> result = this.getIPassResponse(companySignVO, "get-company-sign-login");
        if (result.isSuccess()) {
            String ticket = UUID.randomUUID().toString();
            ClCompanySignVO.ClCompanySignRpVO ticketVo = new ClCompanySignVO.ClCompanySignRpVO();
            ticketVo.setName(companyInfo.getApplyUserName());
            ticketVo.setContact(companyInfo.getApplyContact());
            this.redisUtil.set("contractLock:auth:ticket:" + ticket, (Object)ticketVo);
            String url = "https://cloudapi.qiyuesuo.cn/saas/ssogateway?ticket=" + ticket + "&pageType=SEAL_PAGE";
            return url;
        }
        Assert.isTrue((boolean)false, (String)result.getMessage());
        return null;
    }

    @Override
    public ClCompanySignVO.ClCompanySignRpVO handleCasVerify(String ticket) {
        ClCompanySignVO.ClCompanySignRpVO ticketVo = (ClCompanySignVO.ClCompanySignRpVO)this.redisUtil.get("contractLock:auth:ticket:" + ticket);
        this.redisUtil.del(new String[]{"contractLock:auth:ticket:" + ticket});
        return ticketVo;
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void generateDefaultSeal(SealDto sealRq) {
        PurchaseCLCompanyInfo companyInfo = (PurchaseCLCompanyInfo)((Object)this.getById((Serializable)((Object)sealRq.getId())));
        List personalInfos = this.personalInfoService.listByIds(sealRq.getUserIds());
        if (StrUtil.isNotBlank((CharSequence)companyInfo.getDefaultSealId())) {
            List oldPns = this.personalInfoService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PurchaseClPersonalInfo::getAddDefaultSeal, (Object)"1")).eq(PurchaseClPersonalInfo::getCompanyId, (Object)companyInfo.getCompanyId()));
            List oldIds = oldPns.stream().map(x -> x.getId()).distinct().collect(Collectors.toList());
            List nowIds = personalInfos.stream().map(x -> x.getId()).distinct().collect(Collectors.toList());
            List removes = oldPns.stream().filter(x -> !nowIds.contains(x.getId())).collect(Collectors.toList());
            List adds = personalInfos.stream().filter(x -> !oldIds.contains(x.getId())).collect(Collectors.toList());
            ClSealAuthVO clSealAuthVO = new ClSealAuthVO();
            clSealAuthVO.setCompanyId(companyInfo.getCompanyId());
            clSealAuthVO.getBody().setSealId(companyInfo.getDefaultSealId());
            clSealAuthVO.getBody().setSealImageInfo(null);
            clSealAuthVO.getBody().setName(null);
            if (CollUtil.isNotEmpty(removes)) {
                List<ClSealAuthVO.User> us = removes.stream().map(x -> {
                    ClSealAuthVO.User u = new ClSealAuthVO.User();
                    u.setContact(x.getApplyContact());
                    u.setContactType(x.getApplyContactType());
                    return u;
                }).collect(Collectors.toList());
                clSealAuthVO.getBody().setOperate("REMOVE");
                clSealAuthVO.getBody().setSealUsers(us);
                Result<?> result = this.getIPassResponse(clSealAuthVO, "modify-auto-seal");
                Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
                this.personalInfoService.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(PurchaseClPersonalInfo::getAddDefaultSeal, (Object)"0")).in(ParentEntity::getId, (Collection)removes.stream().map(x -> x.getId()).collect(Collectors.toList())));
            }
            if (CollUtil.isNotEmpty(adds)) {
                List<ClSealAuthVO.User> as = adds.stream().map(x -> {
                    ClSealAuthVO.User u = new ClSealAuthVO.User();
                    u.setContact(x.getApplyContact());
                    u.setContactType(x.getApplyContactType());
                    return u;
                }).collect(Collectors.toList());
                clSealAuthVO.getBody().setOperate("ADD");
                clSealAuthVO.getBody().setSealUsers(as);
                Result<?> addResult = this.getIPassResponse(clSealAuthVO, "modify-auto-seal");
                Assert.isTrue((boolean)addResult.isSuccess(), (String)addResult.getMessage());
                this.personalInfoService.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(PurchaseClPersonalInfo::getAddDefaultSeal, (Object)"1")).in(ParentEntity::getId, (Collection)adds.stream().map(x -> x.getId()).collect(Collectors.toList())));
            }
        } else {
            ClSealAuthVO clSealAuthVO = new ClSealAuthVO();
            clSealAuthVO.setCompanyId(companyInfo.getCompanyId());
            List<ClSealAuthVO.User> us = personalInfos.stream().map(x -> {
                ClSealAuthVO.User u = new ClSealAuthVO.User();
                u.setContact(x.getApplyContact());
                u.setContactType(x.getApplyContactType());
                return u;
            }).collect(Collectors.toList());
            clSealAuthVO.getBody().setUsers(us);
            Result<?> result = this.getIPassResponse(clSealAuthVO, "create-auto-seal");
            Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
            JSONObject jsonObject = (JSONObject)result.getResult();
            String sealId = jsonObject.getString("id");
            Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)sealId), (String)I18nUtil.translate((String)"i18n_field_yVIHLvMid_26f57497", (String)"\u63a5\u53e3\u5f02\u5e38\uff0c\u672a\u8fd4\u56deid"));
            companyInfo.setDefaultSealId(sealId);
            personalInfos.forEach(p -> p.setAddDefaultSeal("1"));
            this.updateById((Object)companyInfo);
            this.personalInfoService.updateBatchById(personalInfos);
        }
    }

    @Override
    public SealDto defaultSeal(String id) {
        PurchaseCLCompanyInfo companyInfo = (PurchaseCLCompanyInfo)((Object)this.getById((Serializable)((Object)id)));
        SealDto seal = new SealDto();
        List psns = this.personalInfoService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PurchaseClPersonalInfo::getAddDefaultSeal, (Object)"1")).eq(PurchaseClPersonalInfo::getCompanyId, (Object)companyInfo.getCompanyId()));
        if (CollUtil.isNotEmpty((Collection)psns)) {
            seal.setUserIds(psns.stream().map(x -> x.getId()).collect(Collectors.toList()));
        }
        seal.setPsns(this.personalInfoService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PurchaseClPersonalInfo::getCompanyId, (Object)companyInfo.getCompanyId())).eq(PurchaseClPersonalInfo::getRealName, (Object)"1")));
        seal.setId(id);
        return seal;
    }

    @Override
    public void roleAdmin(String id, String operate) {
        ClRoleVO clRoleVO = new ClRoleVO();
        PurchaseClPersonalInfo personalInfo = (PurchaseClPersonalInfo)((Object)this.personalInfoService.getById((Serializable)((Object)id)));
        clRoleVO.setCompanyId(personalInfo.getCompanyId());
        clRoleVO.getBody().setRole("SEAL_ADMIN");
        clRoleVO.getBody().setOperate(operate);
        clRoleVO.getBody().setUsers(Arrays.asList(new ClRoleVO.User(personalInfo.getApplyContact(), personalInfo.getApplyContactType())));
        Result<?> addResult = this.getIPassResponse(clRoleVO, "admin-psn-role");
        Assert.isTrue((boolean)addResult.isSuccess(), (String)addResult.getMessage());
        personalInfo.setRoleStr(operate.equals("ADD") ? "SEAL_ADMIN" : null);
        this.personalInfoService.updateById((Object)personalInfo);
    }

    @Override
    public JSONObject automaticSealAuth(SealAuthDto sealAuthDto) {
        ClSealAutoAuthVO clSealAutoAuthVO = new ClSealAutoAuthVO(sealAuthDto.getCompanyId(), sealAuthDto.getContact(), sealAuthDto.getContactType(), sealAuthDto.getAuthDeadline(), sealAuthDto.getRemark());
        clSealAutoAuthVO.setCallbackUrl(this.address + "/els/contractLock/purchaseCLCompanyInfo/noToken/callback/authSeal");
        JSONObject result = this.ipassUtil.sendRequest(clSealAutoAuthVO, "seal-auth-auto", JSONObject.class);
        return result;
    }

    @Override
    public void handleCallBackSealAuth(String contents) {
        contents = contents.replaceAll("\\\\", "");
        contents = contents.replaceAll("\"\\[", "[");
        contents = contents.replaceAll("]\"", "]");
        ClCallback.SealAuth sealAuth = (ClCallback.SealAuth)JSON.parseObject((String)contents, ClCallback.SealAuth.class);
        sealAuth.getSeals().forEach(seal -> {
            PurchaseClSeals purchaseClSeals = this.purchaseClSealsService.selectByRequestIdAndCompanyId(seal.getId(), sealAuth.getCompanyId());
            if (ObjectUtil.isNotEmpty((Object)((Object)purchaseClSeals))) {
                purchaseClSeals.setAuthStatus(sealAuth.getAuthStatus());
                purchaseClSeals.setAuthStartTime(sealAuth.getAuthStartTime());
                purchaseClSeals.setAuthDeadline(sealAuth.getAuthDeadline());
                purchaseClSeals.setCancelTime(sealAuth.getCancelTime());
                this.purchaseClSealsService.updateById((Object)purchaseClSeals);
            }
        });
    }

    private PurchaseCLCompanyInfo selectByRequestId(String requestId) {
        return ((PurchaseCLCompanyInfoMapper)this.baseMapper).selectByRequestId(requestId);
    }

    private Result<?> getIPassResponse(Object req, String iPassCode) {
        JSONObject object = this.invokeBaseRpcService.callIPaasInterface(JSON.parseObject((String)JSON.toJSONString((Object)req)), this.service, this.invokeBaseRpcService.getIpaasInterfaceCode(iPassCode));
        return ClResultAnalysisUtil.analysisResult(object);
    }

    public static void main(String[] args) {
        String content = "{\"sealName\":null,\"companyId\":\"2965104832169509402\",\"agentId\":2947343594438132664,\"sealId\":null,\"authStartTime\":\"2024-06-24\",\"seals\":\"[{\\\"name\\\":\\\"\u76d6\u7ae0\u6d4b\u8bd50612\\\",\\\"id\\\":\\\"3105767392232558880\\\"}]\",\"companyName\":\"\u5e7f\u5dde\u4f01\u4f01\u901a\",\"contact\":\"18922469800\",\"authStatus\":\"authorized\",\"authDeadline\":\"2024-06-30\",\"remark\":\"11\",\"type\":\"SUCCESS\"}";
        content = content.replaceAll("\\\\", "");
        content = content.replaceAll("\"\\[", "[");
        content = content.replaceAll("]\"", "]");
        System.out.println(content);
        ClCallback.SealAuth sealAuth = (ClCallback.SealAuth)JSON.parseObject((String)content, ClCallback.SealAuth.class);
        System.out.println(sealAuth);
    }
}

