/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.fadada.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.electronsign.fadada.dto.FadadaCreateMemberDTO;
import com.els.modules.electronsign.fadada.entity.SaleFadadaOrg;
import com.els.modules.electronsign.fadada.entity.SaleFadadaOrgPsn;
import com.els.modules.electronsign.fadada.entity.SaleFadadaPersonal;
import com.els.modules.electronsign.fadada.mapper.SaleFadadaOrgMapper;
import com.els.modules.electronsign.fadada.mapper.SaleFadadaOrgPsnMapper;
import com.els.modules.electronsign.fadada.mapper.SaleFadadaPersonalMapper;
import com.els.modules.electronsign.fadada.service.SaleFadadaOrgPsnService;
import com.els.modules.electronsign.fadada.util.FadadaCallUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SaleFadadaOrgPsnServiceImpl
extends BaseServiceImpl<SaleFadadaOrgPsnMapper, SaleFadadaOrgPsn>
implements SaleFadadaOrgPsnService {
    @Autowired
    private FadadaCallUtil fadadaCallUtil;
    @Autowired
    private SaleFadadaPersonalMapper saleFadadaPersonalMapper;
    @Autowired
    private SaleFadadaOrgMapper saleFadadaOrgMapper;

    @Override
    public void add(SaleFadadaOrgPsn saleFadadaOrgPsn) {
        String elsAccount = TenantContext.getTenant();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        queryWrapper.eq((Object)"client_user_id", (Object)saleFadadaOrgPsn.getClientUserId());
        queryWrapper.eq((Object)"client_corp_id", (Object)saleFadadaOrgPsn.getClientCorpId());
        queryWrapper.eq((Object)"bus_account", (Object)saleFadadaOrgPsn.getBusAccount());
        if (!this.list((Wrapper)queryWrapper).isEmpty()) {
            throw new ELSBootException(saleFadadaOrgPsn.getOrgName() + " \u673a\u6784\u5df2\u7ecf\u5b58\u5728 " + saleFadadaOrgPsn.getMemberName());
        }
        QueryWrapper saleFadadaPersonalQueryWrapper = new QueryWrapper();
        saleFadadaPersonalQueryWrapper.eq((Object)"els_account", (Object)elsAccount);
        saleFadadaPersonalQueryWrapper.eq((Object)"bus_account", (Object)saleFadadaOrgPsn.getBusAccount());
        saleFadadaPersonalQueryWrapper.eq((Object)"client_user_id", (Object)saleFadadaOrgPsn.getClientUserId());
        SaleFadadaPersonal personal = (SaleFadadaPersonal)((Object)this.saleFadadaPersonalMapper.selectOne((Wrapper)saleFadadaPersonalQueryWrapper));
        if (personal == null) {
            throw new ELSBootException("\u8bf7\u9009\u62e9\u5458\u5de5");
        }
        saleFadadaOrgPsn.setMemberStatus("enable");
        saleFadadaOrgPsn.setActive("0");
        saleFadadaOrgPsn.setOpenUserId(personal.getOpenUserId());
        QueryWrapper saleFadadaOrgQueryWrapper = new QueryWrapper();
        saleFadadaOrgQueryWrapper.eq((Object)"els_account", (Object)elsAccount);
        saleFadadaOrgQueryWrapper.eq((Object)"bus_account", (Object)saleFadadaOrgPsn.getBusAccount());
        saleFadadaOrgQueryWrapper.eq((Object)"client_corp_id", (Object)saleFadadaOrgPsn.getClientCorpId());
        SaleFadadaOrg purchaseFadadaOrg = (SaleFadadaOrg)((Object)this.saleFadadaOrgMapper.selectOne((Wrapper)saleFadadaOrgQueryWrapper));
        if (purchaseFadadaOrg == null) {
            throw new ELSBootException("\u8bf7\u9009\u62e9\u673a\u6784");
        }
        saleFadadaOrgPsn.setOpenCorpId(purchaseFadadaOrg.getOpenCorpId());
        FadadaCreateMemberDTO fadadaCreateMemberDTO = new FadadaCreateMemberDTO(saleFadadaOrgPsn, personal.getAccountType());
        String requestStr = JSONObject.toJSONString((Object)fadadaCreateMemberDTO);
        JSONObject requestObject = JSONObject.parseObject((String)requestStr);
        requestObject.put("currentAccount", (Object)saleFadadaOrgPsn.getBusAccount());
        JSONObject response = this.fadadaCallUtil.call(requestObject.toJSONString(), "fadada_create_member");
        JSONArray array = response.getJSONArray("data");
        JSONObject memberObject = JSONArray.parseObject((String)array.get(0).toString());
        saleFadadaOrgPsn.setMemberId(memberObject.getString("memberId"));
        saleFadadaOrgPsn.setMemberActiveUrl(memberObject.getString("memberActiveUrl"));
        saleFadadaOrgPsn.setMemberActiveEmbedUrl(memberObject.getString("memberActiveEmbedUrl"));
        if ("activated".equals(memberObject.getString("memberStatus"))) {
            saleFadadaOrgPsn.setActive("1");
        }
        this.save((Object)saleFadadaOrgPsn);
    }

    @Override
    public void edit(SaleFadadaOrgPsn saleFadadaOrgPsn) {
        if (StrUtil.isNotBlank((CharSequence)saleFadadaOrgPsn.getId())) {
            int count = ((SaleFadadaOrgPsnMapper)this.baseMapper).updateById((Object)saleFadadaOrgPsn);
            Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        } else {
            this.add(saleFadadaOrgPsn);
        }
    }

    @Override
    public void delete(String id) {
        SaleFadadaOrgPsn saleFadadaOrgPsn = (SaleFadadaOrgPsn)((Object)this.getById((Serializable)((Object)id)));
        if (StrUtil.isNotBlank((CharSequence)saleFadadaOrgPsn.getMemberId())) {
            JSONObject request = new JSONObject();
            request.put("openCorpId", (Object)saleFadadaOrgPsn.getOpenCorpId());
            String[] memberIds = new String[]{saleFadadaOrgPsn.getMemberId()};
            request.put("memberIds", (Object)memberIds);
            request.put("currentAccount", (Object)saleFadadaOrgPsn.getBusAccount());
            JSONObject response = this.fadadaCallUtil.call(request.toJSONString(), "fadada_delete_member");
            ((SaleFadadaOrgPsnMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        } else {
            ((SaleFadadaOrgPsnMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        }
    }

    @Override
    public void deleteBatch(List<String> idList) {
        for (String id : idList) {
            this.delete(id);
        }
    }

    @Override
    public void disabled(String id, String status) {
        SaleFadadaOrgPsn saleFadadaOrgPsn = (SaleFadadaOrgPsn)((Object)this.getById((Serializable)((Object)id)));
        if (StrUtil.isNotBlank((CharSequence)saleFadadaOrgPsn.getMemberId())) {
            JSONObject request = new JSONObject();
            request.put("openCorpId", (Object)saleFadadaOrgPsn.getOpenCorpId());
            String[] memberIds = new String[]{saleFadadaOrgPsn.getMemberId()};
            request.put("memberIds", (Object)memberIds);
            request.put("memberStatus", (Object)status);
            request.put("currentAccount", (Object)saleFadadaOrgPsn.getBusAccount());
            this.fadadaCallUtil.call(request.toJSONString(), "fadada_set_member_status");
            saleFadadaOrgPsn.setMemberStatus(status);
            if (!"enable".equals(status)) {
                saleFadadaOrgPsn.setMemberStatus("disabled");
            }
            this.updateById((Object)saleFadadaOrgPsn);
        }
    }

    @Override
    public void refreshOrgPsnList(String id) {
        SaleFadadaOrg saleFadadaOrg = (SaleFadadaOrg)((Object)this.saleFadadaOrgMapper.selectById((Serializable)((Object)id)));
        if (saleFadadaOrg != null) {
            JSONObject requestObject = new JSONObject();
            requestObject.put("openCorpId", (Object)saleFadadaOrg.getOpenCorpId());
            requestObject.put("currentAccount", (Object)saleFadadaOrg.getBusAccount());
            JSONObject response = this.fadadaCallUtil.call(requestObject.toJSONString(), "fadada_list_member");
            if (StrUtil.isNotBlank((CharSequence)response.getString("employeeInfos"))) {
                JSONArray employeeInfos = response.getJSONArray("employeeInfos");
                ArrayList<SaleFadadaOrgPsn> fadadaOrgPsns = new ArrayList<SaleFadadaOrgPsn>();
                ArrayList<String> existOrgPsnIds = new ArrayList<String>();
                for (Object object : employeeInfos) {
                    JSONObject memberObject = JSONObject.parseObject((String)object.toString());
                    SaleFadadaOrgPsn fadadaOrgPsn = (SaleFadadaOrgPsn)((Object)SysUtil.copyProperties((Object)memberObject, SaleFadadaOrgPsn.class));
                    QueryWrapper orgPsnQueryWrapper = new QueryWrapper();
                    orgPsnQueryWrapper.eq((Object)"member_id", (Object)memberObject.getString("memberId"));
                    orgPsnQueryWrapper.eq((Object)"open_corp_id", (Object)saleFadadaOrg.getOpenCorpId());
                    orgPsnQueryWrapper.eq((Object)"els_account", (Object)saleFadadaOrg.getElsAccount());
                    List saleFadadaOrgPsnList = this.list((Wrapper)orgPsnQueryWrapper);
                    if (!saleFadadaOrgPsnList.isEmpty()) {
                        fadadaOrgPsn.setClientUserId(((SaleFadadaOrgPsn)((Object)saleFadadaOrgPsnList.get(0))).getClientUserId());
                        fadadaOrgPsn.setOpenUserId(((SaleFadadaOrgPsn)((Object)saleFadadaOrgPsnList.get(0))).getOpenUserId());
                        fadadaOrgPsn.setId(((SaleFadadaOrgPsn)((Object)saleFadadaOrgPsnList.get(0))).getId());
                        existOrgPsnIds.add(((SaleFadadaOrgPsn)((Object)saleFadadaOrgPsnList.get(0))).getId());
                    }
                    fadadaOrgPsn.setElsAccount(saleFadadaOrg.getElsAccount());
                    fadadaOrgPsn.setBusAccount(saleFadadaOrg.getBusAccount());
                    fadadaOrgPsn.setCompanyName(saleFadadaOrg.getCompanyName());
                    fadadaOrgPsn.setClientCorpId(saleFadadaOrg.getClientCorpId());
                    fadadaOrgPsn.setOpenCorpId(saleFadadaOrg.getOpenCorpId());
                    fadadaOrgPsn.setOrgName(saleFadadaOrg.getCorpName());
                    if ("activated".equals(fadadaOrgPsn.getMemberStatus())) {
                        fadadaOrgPsn.setActive("1");
                    }
                    fadadaOrgPsn.setMemberDeptids(this.fadadaCallUtil.arrayToString(memberObject.getJSONArray("memberDeptIds")));
                    fadadaOrgPsn.setRoleType(this.fadadaCallUtil.arrayToString(memberObject.getJSONArray("roleType")));
                    fadadaOrgPsns.add(fadadaOrgPsn);
                }
                if (fadadaOrgPsns.size() > 0) {
                    QueryWrapper orgPsnQueryWrapper = new QueryWrapper();
                    orgPsnQueryWrapper.eq((Object)"open_corp_id", (Object)saleFadadaOrg.getOpenCorpId());
                    orgPsnQueryWrapper.eq((Object)"els_account", (Object)saleFadadaOrg.getElsAccount());
                    if (existOrgPsnIds.size() > 0) {
                        orgPsnQueryWrapper.notIn((Object)"id", existOrgPsnIds);
                    }
                    this.remove((Wrapper)orgPsnQueryWrapper);
                    this.saveOrUpdateBatch(fadadaOrgPsns);
                }
            }
        }
    }
}

