/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.validator.SrmLength;
import com.els.config.mybatis.TenantContext;
import com.els.modules.contract.entity.SaleContractPromise;
import com.els.modules.contract.entity.SalePromiseItem;
import com.els.modules.contract.service.SaleContractPromiseService;
import com.els.modules.contract.service.SalePromiseItemService;
import com.els.modules.contract.vo.SaleContractPromiseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4f9b\u5e94\u5546\u5c65\u7ea6"})
@RestController
@RequestMapping(value={"/contract/saleContractPromise"})
public class SaleContractPromiseController
extends BaseController<SaleContractPromise, SaleContractPromiseService> {
    private static final Logger log = LoggerFactory.getLogger(SaleContractPromiseController.class);
    @Autowired
    private SaleContractPromiseService saleContractPromiseService;
    @Autowired
    private SalePromiseItemService salePromiseItemService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"contractPromise#saleContractPromise:list"})
    public Result<?> queryPageList(SaleContractPromise saleContractPromise, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleContractPromise), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.saleContractPromiseService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="\u4f9b\u5e94\u5546\u5c65\u7ea6", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/createPromise"})
    @SrmValidated
    @RequiresPermissions(value={"contractPromise#saleContractPromise:createPromise"})
    public Result<?> createPromise(@RequestBody SaleContractPromise saleContractPromise) {
        this.saleContractPromiseService.createPromise(saleContractPromise);
        return Result.ok((Object)((Object)saleContractPromise));
    }

    @AutoLog(busModule="\u4f9b\u5e94\u5546\u5c65\u7ea6", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @SrmValidated
    @RequiresPermissions(value={"contractPromise#saleContractPromise:add"})
    public Result<?> add(@RequestBody SaleContractPromise saleContractPromise) {
        this.saleContractPromiseService.saveSaleContractPromise(saleContractPromise);
        return Result.ok((Object)((Object)saleContractPromise));
    }

    @AutoLog(busModule="\u4f9b\u5e94\u5546\u5c65\u7ea6", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @SrmValidated
    @RequiresPermissions(value={"contractPromise#saleContractPromise:edit"})
    public Result<?> edit(@RequestBody SaleContractPromiseVO saleContractPromise) {
        SaleContractPromise promise = new SaleContractPromise();
        BeanUtils.copyProperties((Object)((Object)saleContractPromise), (Object)((Object)promise));
        this.saleContractPromiseService.updateMain(promise, saleContractPromise.getPurchasePromiseItemList());
        String id = promise.getId();
        return this.queryById(id);
    }

    @AutoLog(busModule="\u4f9b\u5e94\u5546\u5c65\u7ea6", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"contractPromise#saleContractPromise:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.saleContractPromiseService.delSaleContractPromise(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u4f9b\u5e94\u5546\u5c65\u7ea6", value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"contractPromise#saleContractPromise:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.saleContractPromiseService.delBatchSaleContractPromise(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"contractPromise#saleContractPromise:view"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        SaleContractPromise saleContractPromise = (SaleContractPromise)((Object)this.saleContractPromiseService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        SaleContractPromiseVO saleContractPromiseVO = new SaleContractPromiseVO();
        BeanUtils.copyProperties((Object)((Object)saleContractPromise), (Object)((Object)saleContractPromiseVO));
        List<SalePromiseItem> purchasePromiseItemList = this.salePromiseItemService.selectByMainId(id);
        saleContractPromiseVO.setPurchasePromiseItemList(purchasePromiseItemList);
        return Result.ok((Object)((Object)saleContractPromiseVO));
    }

    @AutoLog(busModule="\u4f9b\u5e94\u5546\u5c65\u7ea6", value="\u53d1\u5e03")
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    @SrmValidated
    @RequiresPermissions(value={"contractPromise#saleContractPromise:publish"})
    public Result<?> publish(@RequestBody SaleContractPromiseVO saleContractPromise) {
        SaleContractPromise promise = new SaleContractPromise();
        BeanUtils.copyProperties((Object)((Object)saleContractPromise), (Object)((Object)promise));
        this.saleContractPromiseService.updateMain(promise, saleContractPromise.getPurchasePromiseItemList());
        this.saleContractPromiseService.publish(saleContractPromise);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u4f9b\u5e94\u5546\u5c65\u7ea6", value="\u786e\u8ba4")
    @ApiOperation(value="\u786e\u8ba4", notes="\u786e\u8ba4")
    @GetMapping(value={"/confirmed"})
    @RequiresPermissions(value={"contractPromise#saleContractPromise:confirmed"})
    public Result<?> confirmed(@RequestParam(name="id") String id) {
        SaleContractPromise byId = (SaleContractPromise)((Object)this.saleContractPromiseService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        this.saleContractPromiseService.confirmed(byId);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u5408\u540c\u7ba1\u7406", value="\u9000\u56de")
    @ApiOperation(value="\u901a\u8fc7id\u9000\u56de", notes="\u901a\u8fc7id\u9000\u56de")
    @GetMapping(value={"/refund"})
    @RequiresPermissions(value={"contractPromise#saleContractPromise:refund"})
    public Result<?> refund(@RequestParam(name="id", required=true) String id, @RequestParam(name="refundRemark") @SrmLength(max=1000, scopeTitle="\u9000\u56de\u5907\u6ce8", scopeI18key="") String refundRemark) {
        this.saleContractPromiseService.refundMain(id, refundRemark);
        return this.commonSuccessResult(3);
    }
}

