/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.utils;

import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ui.freemarker.FreeMarkerConfigurationFactory;

public class Htm2WordUtil {
    private static final Logger log = LoggerFactory.getLogger(Htm2WordUtil.class);

    public static String html2Word(String html, String fileRootPath, String wordFileName) {
        String wordFilePath = fileRootPath + "/" + wordFileName;
        StringBuffer sbf = new StringBuffer();
        sbf.append("<html xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:o=\"urn:schemas-microsoft-com:office:office\" xmlns:w=\"urn:schemas-microsoft-com:office:word\" xmlns:m=\"http://schemas.microsoft.com/office/2004/12/omml\" xmlns=\"http://www.w3.org/TR/REC-html40\">");
        sbf.append("<head><!--[if gte mso 9]><xml><w:WordDocument><w:View>Print</w:View><w:TrackMoves>false</w:TrackMoves><w:TrackFormatting/><w:ValidateAgainstSchemas/><w:SaveIfXMLInvalid>false</w:SaveIfXMLInvalid><w:IgnoreMixedContent>false</w:IgnoreMixedContent><w:AlwaysShowPlaceholderText>false</w:AlwaysShowPlaceholderText><w:DoNotPromoteQF/><w:LidThemeOther>EN-US</w:LidThemeOther><w:LidThemeAsian>ZH-CN</w:LidThemeAsian><w:LidThemeComplexScript>X-NONE</w:LidThemeComplexScript><w:Compatibility><w:BreakWrappedTables/><w:SnapToGridInCell/><w:WrapTextWithPunct/><w:UseAsianBreakRules/><w:DontGrowAutofit/><w:SplitPgBreakAndParaMark/><w:DontVertAlignCellWithSp/><w:DontBreakConstrainedForcedTables/><w:DontVertAlignInTxbx/><w:Word11KerningPairs/><w:CachedColBalance/><w:UseFELayout/></w:Compatibility><w:BrowserLevel>MicrosoftInternetExplorer4</w:BrowserLevel><m:mathPr><m:mathFont m:val=\"Cambria Math\"/><m:brkBin m:val=\"before\"/><m:brkBinSub m:val=\"--\"/><m:smallFrac m:val=\"off\"/><m:dispDef/><m:lMargin m:val=\"0\"/> <m:rMargin m:val=\"0\"/><m:defJc m:val=\"centerGroup\"/><m:wrapIndent m:val=\"1440\"/><m:intLim m:val=\"subSup\"/><m:naryLim m:val=\"undOvr\"/></m:mathPr></w:WordDocument></xml><![endif]--></head>");
        sbf.append("<body>");
        sbf.append(html);
        sbf.append("</body></html>");
        byte[] htmlBytes = sbf.toString().getBytes();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(htmlBytes);
        POIFSFileSystem poifs = new POIFSFileSystem();
        DirectoryNode directory = poifs.getRoot();
        DocumentEntry documentEntry = directory.createDocument("WordDocument", (InputStream)inputStream);
        FileOutputStream outputStream = new FileOutputStream(wordFilePath);
        poifs.writeFilesystem((OutputStream)outputStream);
        inputStream.close();
        outputStream.close();
        return wordFilePath;
    }

    public static String htmlWord(String html, String fileRootPath, String wordFileName) {
        String charset2;
        Template template = null;
        StringBuffer sbf = new StringBuffer();
        sbf.append("<html xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:o=\"urn:schemas-microsoft-com:office:office\" xmlns:w=\"urn:schemas-microsoft-com:office:word\" xmlns:m=\"http://schemas.microsoft.com/office/2004/12/omml\" xmlns=\"http://www.w3.org/TR/REC-html40\">");
        sbf.append("<head><!--[if gte mso 9]><xml><w:WordDocument><w:View>Print</w:View><w:TrackMoves>false</w:TrackMoves><w:TrackFormatting/><w:ValidateAgainstSchemas/><w:SaveIfXMLInvalid>false</w:SaveIfXMLInvalid><w:IgnoreMixedContent>false</w:IgnoreMixedContent><w:AlwaysShowPlaceholderText>false</w:AlwaysShowPlaceholderText><w:DoNotPromoteQF/><w:LidThemeOther>EN-US</w:LidThemeOther><w:LidThemeAsian>ZH-CN</w:LidThemeAsian><w:LidThemeComplexScript>X-NONE</w:LidThemeComplexScript><w:Compatibility><w:BreakWrappedTables/><w:SnapToGridInCell/><w:WrapTextWithPunct/><w:UseAsianBreakRules/><w:DontGrowAutofit/><w:SplitPgBreakAndParaMark/><w:DontVertAlignCellWithSp/><w:DontBreakConstrainedForcedTables/><w:DontVertAlignInTxbx/><w:Word11KerningPairs/><w:CachedColBalance/><w:UseFELayout/></w:Compatibility><w:BrowserLevel>MicrosoftInternetExplorer4</w:BrowserLevel><m:mathPr><m:mathFont m:val=\"Cambria Math\"/><m:brkBin m:val=\"before\"/><m:brkBinSub m:val=\"--\"/><m:smallFrac m:val=\"off\"/><m:dispDef/><m:lMargin m:val=\"0\"/> <m:rMargin m:val=\"0\"/><m:defJc m:val=\"centerGroup\"/><m:wrapIndent m:val=\"1440\"/><m:intLim m:val=\"subSup\"/><m:naryLim m:val=\"undOvr\"/></m:mathPr></w:WordDocument></xml><![endif]--></head>");
        sbf.append("<body>");
        sbf.append(html);
        sbf.append("</body></html>");
        html = sbf.toString();
        String wordFilePath = fileRootPath + "/" + wordFileName;
        String charset = Htm2WordUtil.getCharset(html);
        if (!"utf-8".equals(charset) && StringUtils.isNotBlank((String)charset)) {
            html = html.replaceAll(charset, "utf-8");
        }
        if (!"utf-8".equals(charset2 = Htm2WordUtil.getCharset2(html)) && StringUtils.isNotBlank((String)charset2)) {
            html = html.replaceAll(charset2, "utf-8");
        }
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(wordFilePath), "UTF-8");
        FreeMarkerConfigurationFactory configurationFactory = new FreeMarkerConfigurationFactory();
        Configuration cfg = configurationFactory.createConfiguration();
        StringTemplateLoader templateLoader = new StringTemplateLoader();
        templateLoader.putTemplate("contract", html);
        cfg.setTemplateLoader((TemplateLoader)templateLoader);
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.IGNORE_HANDLER);
        template = cfg.getTemplate("contract", "UTF-8");
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("html", html);
        template.process(data, (Writer)writer);
        writer.flush();
        writer.close();
        return wordFilePath;
    }

    private static String getCharset(String content) {
        String charset = "";
        String regex = "charset='(.*?)'";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(content);
        if (m.find()) {
            charset = m.group(1);
        }
        return charset;
    }

    private static String getCharset2(String content) {
        String charset = "";
        String regex = "charset=3D(.[\\s\\S]*?)'";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(content);
        if (m.find()) {
            charset = m.group(1);
        }
        return charset;
    }
}

