/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.controller;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.QueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.BusinessModule;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.TemplateParseUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.board.dto.CountDTO;
import com.els.modules.contract.controller.PurchaseContractHeadHisController;
import com.els.modules.contract.entity.ContractItemCustom1;
import com.els.modules.contract.entity.ContractItemCustom2;
import com.els.modules.contract.entity.ContractItemCustom3;
import com.els.modules.contract.entity.ContractItemCustom4;
import com.els.modules.contract.entity.ContractItemCustom5;
import com.els.modules.contract.entity.PurchaseContractContentItem;
import com.els.modules.contract.entity.PurchaseContractHead;
import com.els.modules.contract.entity.PurchaseContractItem;
import com.els.modules.contract.entity.PurchaseContractPromise;
import com.els.modules.contract.entity.SaleContractHead;
import com.els.modules.contract.enumerate.ContractPromiseTypeEnum;
import com.els.modules.contract.enumerate.ContractStatusEnum;
import com.els.modules.contract.enumerate.ContractTargetTypeEnum;
import com.els.modules.contract.enumerate.ContractTypeEnum;
import com.els.modules.contract.excel.PurchaseContractHeadExportServiceImpl;
import com.els.modules.contract.rpc.service.ContractInvokeOrderRpcService;
import com.els.modules.contract.service.ContractBoardService;
import com.els.modules.contract.service.ContractItemCustom1Service;
import com.els.modules.contract.service.ContractItemCustom2Service;
import com.els.modules.contract.service.ContractItemCustom3Service;
import com.els.modules.contract.service.ContractItemCustom4Service;
import com.els.modules.contract.service.ContractItemCustom5Service;
import com.els.modules.contract.service.PurchaseContractContentItemService;
import com.els.modules.contract.service.PurchaseContractHeadService;
import com.els.modules.contract.service.PurchaseContractItemService;
import com.els.modules.contract.service.PurchaseContractPromiseService;
import com.els.modules.contract.service.SaleContractHeadService;
import com.els.modules.contract.utils.Htm2WordUtil;
import com.els.modules.contract.utils.NumberUtil;
import com.els.modules.contract.utils.PdfUtil;
import com.els.modules.contract.vo.PurchaseContractHeadVO;
import com.els.modules.contract.vo.PurchaseContractPromiseVO;
import com.els.modules.order.api.dto.PurchaseOrderHeadDTO;
import com.els.modules.order.api.dto.PurchaseOrderItemDTO;
import com.els.modules.price.api.dto.PurchaseInformationRecordsDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/contract/purchaseContractHead"})
@Api(tags={"\u91c7\u8d2d\u5408\u540c\u5934"})
public class PurchaseContractHeadController
extends BaseController<PurchaseContractHead, PurchaseContractHeadService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseContractHeadController.class);
    @Autowired
    private PurchaseContractHeadService purchaseContractHeadService;
    @Autowired
    private SaleContractHeadService saleContractHeadService;
    @Autowired
    private PurchaseContractItemService purchaseContractItemService;
    @Autowired
    private PurchaseContractContentItemService purchaseContractContentItemService;
    @Autowired
    private PurchaseContractHeadHisController purchaseContractHeadHisController;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private ContractInvokeOrderRpcService contractInvokeOrderRpcService;
    @Autowired
    private PurchaseContractPromiseService purchaseContractPromiseService;
    @Autowired
    private ContractItemCustom1Service contractItemCustom1Service;
    @Autowired
    private ContractItemCustom2Service contractItemCustom2Service;
    @Autowired
    private ContractItemCustom3Service contractItemCustom3Service;
    @Autowired
    private ContractItemCustom4Service contractItemCustom4Service;
    @Autowired
    private ContractItemCustom5Service contractItemCustom5Service;
    @Value(value="${els.path.upload}")
    private String uploadpath;
    @Autowired
    private ContractBoardService contractBoardService;

    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="contract")
    @RequiresPermissions(value={"contract#purchaseContractHead:list"})
    public Result<?> queryPageList(PurchaseContractHead purchaseContractHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        purchaseContractHead.setElsAccount(TenantContext.getTenant());
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseContractHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.lambda().ne(PurchaseContractHead::getContractType, (Object)"3");
        queryWrapper.lambda().orderByDesc(BaseEntity::getCreateTime);
        IPage pageList = this.purchaseContractHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @GetMapping(value={"/listSimple"})
    @PermissionDataView(businessType="contract")
    @RequiresPermissions(value={"contract#purchaseContractHead:list"})
    public Result<?> listSimple(PurchaseContractHead purchaseContractHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        purchaseContractHead.setElsAccount(TenantContext.getTenant());
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseContractHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.lambda().eq(PurchaseContractHead::getContractType, (Object)"3");
        queryWrapper.lambda().orderByDesc(BaseEntity::getCreateTime);
        IPage pageList = this.purchaseContractHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @GetMapping(value={"/listAll"})
    @RequiresPermissions(value={"contract#purchaseContractHead:list"})
    public Result<?> listAll(PurchaseContractHead purchaseContractHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseContractHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.lambda().orderByDesc(BaseEntity::getCreateTime);
        IPage<PurchaseContractHead> purchaseContractHeadIPage = this.purchaseContractHeadService.getListAllPurchaseContractHeadIPage((Page<PurchaseContractHead>)page, (QueryWrapper<PurchaseContractHead>)queryWrapper);
        return Result.ok(purchaseContractHeadIPage);
    }

    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @AutoLog(value="\u5408\u540c\u7ba1\u7406-\u6dfb\u52a0")
    @RequiresPermissions(value={"contract#purchaseContractHead:add"})
    @SrmValidated
    @PermissionDataOpt(businessType="contract", beanClass=PurchaseContractHeadService.class)
    public Result<?> add(@RequestBody PurchaseContractHeadVO purchaseContractHeadPage) {
        PurchaseContractHead purchaseContractHead = new PurchaseContractHead();
        BeanUtils.copyProperties((Object)((Object)purchaseContractHeadPage), (Object)((Object)purchaseContractHead));
        this.purchaseContractHeadService.saveMain(purchaseContractHead, purchaseContractHeadPage.getPurchaseContractItemList(), purchaseContractHeadPage.getPurchaseContractContentItemList(), purchaseContractHeadPage.getPurchaseAttachmentList(), purchaseContractHeadPage.getPurchaseContractPromiseList(), purchaseContractHeadPage.getContractItemCustom1List(), purchaseContractHeadPage.getContractItemCustom2List(), purchaseContractHeadPage.getContractItemCustom3List(), purchaseContractHeadPage.getContractItemCustom4List(), purchaseContractHeadPage.getContractItemCustom5List());
        return Result.ok((Object)((Object)purchaseContractHead));
    }

    @ApiOperation(value="\u6dfb\u52a0", notes="\u8f6c\u529e")
    @PostMapping(value={"/editHead"})
    @AutoLog(value="\u5408\u540c\u7ba1\u7406-\u8f6c\u529e")
    @RequiresPermissions(value={"contract#purchaseContractHead:editHead"})
    @SrmValidated
    @PermissionDataOpt(businessType="contract", beanClass=PurchaseContractHeadService.class)
    public Result<?> editHead(@RequestBody PurchaseContractHeadVO purchaseContractHeadPage) {
        PurchaseContractHead purchaseContractHead = new PurchaseContractHead();
        BeanUtils.copyProperties((Object)((Object)purchaseContractHeadPage), (Object)((Object)purchaseContractHead));
        this.purchaseContractHeadService.updateById((Object)purchaseContractHead);
        return Result.ok((Object)((Object)purchaseContractHead));
    }

    @ApiOperation(value="\u83b7\u53d6\u4e24\u4e2a\u5408\u540c\u6587\u672c\u7684\u5408\u540c\u6587\u672c", notes="\u83b7\u53d6\u4e24\u4e2a\u5408\u540c\u6587\u672c\u7684\u5408\u540c\u6587\u672c")
    @GetMapping(value={"/diffContractContent"})
    @RequiresPermissions(value={"contract#purchaseContractHead:list"})
    @PermissionDataOpt(businessType="contract", beanClass=PurchaseContractHeadService.class)
    public Result<?> diffContractContent(@RequestParam(name="id", required=true) String id, @RequestParam(name="newId", required=true) String newId, @RequestParam(name="type", required=true) String type) {
        PurchaseContractContentItem purchaseContractContentItem = new PurchaseContractContentItem();
        purchaseContractContentItem.setElsAccount(TenantContext.getTenant());
        purchaseContractContentItem.setOriginalContent(this.purchaseContractHeadHisController.getHtmlById(id).toString());
        if ("head".equals(type)) {
            purchaseContractContentItem.setItemContent(this.purchaseContractHeadHisController.getHtmlById(newId).toString());
        } else {
            purchaseContractContentItem.setItemContent(this.getHtmlById(newId).toString());
        }
        return Result.ok((Object)((Object)purchaseContractContentItem));
    }

    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @AutoLog(value="\u5408\u540c\u7ba1\u7406-\u7f16\u8f91")
    @SrmValidated
    @RequiresPermissions(value={"contract#purchaseContractHead:edit"})
    @PermissionDataOpt(businessType="contract", beanClass=PurchaseContractHeadService.class)
    public Result<?> edit(@RequestBody PurchaseContractHeadVO purchaseContractHeadPage) {
        PurchaseContractHead purchaseContractHead = new PurchaseContractHead();
        BeanUtils.copyProperties((Object)((Object)purchaseContractHeadPage), (Object)((Object)purchaseContractHead));
        this.purchaseContractHeadService.updateMain(purchaseContractHead, purchaseContractHeadPage.getPurchaseContractItemList(), purchaseContractHeadPage.getPurchaseContractContentItemList(), purchaseContractHeadPage.getPurchaseAttachmentList(), purchaseContractHeadPage.getPurchaseContractPromiseList(), purchaseContractHeadPage.getContractItemCustom1List(), purchaseContractHeadPage.getContractItemCustom2List(), purchaseContractHeadPage.getContractItemCustom3List(), purchaseContractHeadPage.getContractItemCustom4List(), purchaseContractHeadPage.getContractItemCustom5List());
        String id = purchaseContractHead.getId();
        return this.queryById(id);
    }

    @ApiOperation(value="\u91c7\u8d2d\u5408\u540c\u5934-\u4f5c\u5e9f", notes="\u91c7\u8d2d\u5408\u540c\u5934-\u4f5c\u5e9f")
    @PostMapping(value={"/cancel"})
    @AutoLog(value="\u5408\u540c\u7ba1\u7406-\u4f5c\u5e9f")
    @RequiresPermissions(value={"contract#purchaseContractHead:cancel"})
    @PermissionDataOpt(businessType="contract", beanClass=PurchaseContractHeadService.class)
    public Result<?> cancel(@RequestBody PurchaseContractHeadVO head) {
        head.setContractStatus(ContractStatusEnum.CANCEL.getValue());
        this.purchaseContractHeadService.updateStatus(head);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u91c7\u8d2d\u5408\u540c\u5934-\u5f52\u6863", notes="\u91c7\u8d2d\u5408\u540c\u5934-\u5f52\u6863")
    @PostMapping(value={"/archive"})
    @AutoLog(value="\u5408\u540c\u7ba1\u7406-\u5f52\u6863")
    @RequiresPermissions(value={"contract#purchaseContractHead:archive"})
    @PermissionDataOpt(businessType="contract", beanClass=PurchaseContractHeadService.class)
    public Result<?> archive(@RequestBody PurchaseContractHeadVO head) {
        head.setContractStatus(ContractStatusEnum.ARCHIVED.getValue());
        this.purchaseContractHeadService.updateStatus(head);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u91c7\u8d2d\u5408\u540c-\u521b\u5efa\u8ba2\u5355", notes="\u91c7\u8d2d\u5408\u540c\u5934-\u521b\u5efa\u8ba2\u5355")
    @PostMapping(value={"/createOrderByItems"})
    @AutoLog(value="\u5408\u540c\u7ba1\u7406-\u521b\u5efa\u8ba2\u5355")
    @SrmValidated
    @RequiresPermissions(value={"contract#purchaseContractHead:createOrderByItems"})
    public Result<?> createOrderByItems(@RequestBody PurchaseContractHeadVO headVO) {
        List<PurchaseOrderHeadDTO> orderHeadDTOList = this.purchaseContractHeadService.createOrderByItems(headVO);
        StringBuffer stringBuffer = new StringBuffer();
        for (PurchaseOrderHeadDTO purchaseOrderHeadVO : orderHeadDTOList) {
            stringBuffer = stringBuffer.append(" " + purchaseOrderHeadVO.getOrderNumber());
        }
        return Result.ok((String)(I18nUtil.translate((String)"i18n_alert_sItLRWLRsIttWW_dcec862d", (String)"\u8f6c\u8ba2\u5355\u6210\u529f,\u6210\u529f\u8f6c\u8ba2\u5355\u5355\u6570:") + orderHeadDTOList.size() + I18nUtil.translate((String)"i18n_alert_WtyzqLW_10983e53", (String)",\u5355\u53f7\u5206\u522b\u4e3a:") + stringBuffer.toString()));
    }

    @ApiOperation(value="\u91c7\u8d2d\u5408\u540c-\u521b\u5efa\u5c65\u7ea6\u5355", notes="\u91c7\u8d2d\u5408\u540c\u5934-\u521b\u5efa\u5c65\u7ea6\u5355")
    @PostMapping(value={"/createPromiseByItems"})
    @AutoLog(value="\u5408\u540c\u7ba1\u7406-\u521b\u5efa\u5c65\u7ea6\u5355")
    @SrmValidated
    @RequiresPermissions(value={"contract#purchaseContractHead:createPromiseByItems"})
    public Result<?> createPromiseByItems(@RequestBody PurchaseContractHeadVO headVO) {
        List<PurchaseContractPromiseVO> orderHeadDTOList = this.purchaseContractHeadService.createPromiseByItems(headVO);
        StringBuffer stringBuffer = new StringBuffer();
        for (PurchaseContractPromiseVO purchaseOrderHeadVO : orderHeadDTOList) {
            stringBuffer = stringBuffer.append(" " + purchaseOrderHeadVO.getPromiseNumber());
        }
        return Result.ok((String)(I18nUtil.translate((String)"i18n_alert_sIZtLRWLRsIZttWW_44803993", (String)"\u8f6c\u5c65\u7ea6\u5355\u6210\u529f,\u6210\u529f\u8f6c\u5c65\u7ea6\u5355\u5355\u6570:") + orderHeadDTOList.size() + I18nUtil.translate((String)"i18n_alert_WtyzqLW_10983e53", (String)",\u5355\u53f7\u5206\u522b\u4e3a:") + stringBuffer.toString()));
    }

    @ApiOperation(value="\u91c7\u8d2d\u5408\u540c-\u521b\u5efa\u4ef7\u683c\u4e3b\u6570\u636e", notes="\u91c7\u8d2d\u5408\u540c\u5934-\u521b\u5efa\u4ef7\u683c\u4e3b\u6570\u636e")
    @PostMapping(value={"/createPriceByItems"})
    @AutoLog(value="\u5408\u540c\u7ba1\u7406-\u521b\u5efa\u4ef7\u683c\u4e3b\u6570\u636e")
    @SrmValidated
    @RequiresPermissions(value={"contract#purchaseContractHead:createPromiseByItems"})
    public Result<?> createPriceByItems(@RequestBody PurchaseContractHeadVO headVO) {
        List<PurchaseInformationRecordsDTO> priceByItems = this.purchaseContractHeadService.createPriceByItems(headVO);
        if (!CollectionUtils.isEmpty(priceByItems) && priceByItems.size() == 1) {
            return Result.ok(priceByItems);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (PurchaseInformationRecordsDTO purchaseOrderHeadVO : priceByItems) {
            stringBuffer = stringBuffer.append(" " + purchaseOrderHeadVO.getInfoRecordNumber());
        }
        return Result.ok((String)(I18nUtil.translate((String)"", (String)"\u751f\u6210\u4ef7\u683c\u4e3b\u6570\u636e\u6210\u529f,\u6210\u529f\u751f\u6210\u4ef7\u683c\u4e3b\u6570\u636e\u6761\u6570:") + priceByItems.size() + I18nUtil.translate((String)"i18n_alert_WtyzqLW_10983e53", (String)",\u5355\u53f7\u5206\u522b\u4e3a:") + stringBuffer.toString()));
    }

    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @AutoLog(value="\u5408\u540c\u7ba1\u7406-\u5220\u9664")
    @RequiresPermissions(value={"contract#purchaseContractHead:delete"})
    @PermissionDataOpt(businessType="contract", beanClass=PurchaseContractHeadService.class)
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.purchaseContractHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u5408\u540c\u7ba1\u7406-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"contract#purchaseContractHead:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.purchaseContractHeadService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @BusinessModule(module="contract")
    @RequiresPermissions(value={"contract#purchaseContractHead:view"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        PurchaseContractHead purchaseContractHead = (PurchaseContractHead)((Object)this.purchaseContractHeadService.getById((Serializable)((Object)id)));
        PurchaseContractHeadVO purchaseContractHeadVO = this.getData(id);
        List<PurchaseContractItem> purchaseContractItemList = purchaseContractHeadVO.getPurchaseContractItemList();
        if (ContractPromiseTypeEnum.ORDER.getValue().equals(purchaseContractHead.getPromiseType()) && !CollectionUtils.isEmpty(purchaseContractItemList)) {
            List<String> collect = purchaseContractItemList.parallelStream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
            List<PurchaseOrderItemDTO> purchaseOrderItemDTOList = this.contractInvokeOrderRpcService.listItemBySourceItemId(collect);
            purchaseContractHeadVO.setOrderItemList(purchaseOrderItemDTOList);
        }
        purchaseContractHeadVO.setPurchaseContractItemList(purchaseContractItemList);
        this.calculateTraget(purchaseContractHeadVO);
        return Result.ok((Object)((Object)purchaseContractHeadVO));
    }

    private PurchaseContractHeadVO getData(String id) {
        PurchaseContractHead purchaseContractHead = (PurchaseContractHead)((Object)this.purchaseContractHeadService.getById((Serializable)((Object)id)));
        PurchaseContractHeadVO purchaseContractHeadVO = new PurchaseContractHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseContractHead), (Object)((Object)purchaseContractHeadVO));
        List<PurchaseContractItem> purchaseContractItemList = this.purchaseContractItemService.selectByMainId(id);
        List<PurchaseContractContentItem> purchaseContractContentItemList = this.purchaseContractContentItemService.selectByMainId(id);
        purchaseContractHeadVO.setPurchaseContractContentItemList(purchaseContractContentItemList);
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        purchaseContractHeadVO.setPurchaseAttachmentList(purchaseAttachmentList);
        List<PurchaseContractPromise> purchaseContractPromiseList = this.purchaseContractPromiseService.selectByMainId(id);
        purchaseContractHeadVO.setPurchaseContractPromiseList(purchaseContractPromiseList);
        List<ContractItemCustom1> contractItemCustom1List = this.contractItemCustom1Service.selectByMainId(id);
        purchaseContractHeadVO.setContractItemCustom1List(contractItemCustom1List);
        List<ContractItemCustom2> contractItemCustom2List = this.contractItemCustom2Service.selectByMainId(id);
        purchaseContractHeadVO.setContractItemCustom2List(contractItemCustom2List);
        List<ContractItemCustom3> contractItemCustom3List = this.contractItemCustom3Service.selectByMainId(id);
        purchaseContractHeadVO.setContractItemCustom3List(contractItemCustom3List);
        List<ContractItemCustom4> contractItemCustom4List = this.contractItemCustom4Service.selectByMainId(id);
        purchaseContractHeadVO.setContractItemCustom4List(contractItemCustom4List);
        List<ContractItemCustom5> contractItemCustom5List = this.contractItemCustom5Service.selectByMainId(id);
        purchaseContractHeadVO.setContractItemCustom5List(contractItemCustom5List);
        purchaseContractHeadVO.setPurchaseContractItemList(purchaseContractItemList);
        return purchaseContractHeadVO;
    }

    private void calculateTraget(PurchaseContractHeadVO purchaseContractHeadVO) {
        String contractType = purchaseContractHeadVO.getContractType();
        String promiseType = purchaseContractHeadVO.getPromiseType();
        if (StringUtils.isBlank((CharSequence)contractType) || StringUtils.isBlank((CharSequence)promiseType)) {
            return;
        }
        List<PurchaseContractPromise> promiseList = purchaseContractHeadVO.getPurchaseContractPromiseList();
        if (ContractTypeEnum.NORMAL.getValue().equals(contractType)) {
            if (ContractPromiseTypeEnum.ORDER.getValue().equals(promiseType)) {
                List<PurchaseOrderItemDTO> orderItemList = purchaseContractHeadVO.getOrderItemList();
                if (!CollectionUtils.isEmpty(orderItemList)) {
                    BigDecimal reduce = orderItemList.parallelStream().filter(item -> item.getTaxAmount() != null).map(PurchaseOrderItemDTO::getTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                    purchaseContractHeadVO.setTargetQuantityAlready(reduce.toString());
                }
            } else if (!CollectionUtils.isEmpty(promiseList)) {
                BigDecimal reduce = promiseList.parallelStream().filter(item -> item.getAmount() != null).map(PurchaseContractPromise::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                purchaseContractHeadVO.setTargetQuantityAlready(reduce.toString());
            }
        } else if (ContractTypeEnum.FRAME.getValue().equals(contractType)) {
            if (ContractPromiseTypeEnum.ORDER.getValue().equals(promiseType)) {
                List<PurchaseOrderItemDTO> orderItemList = purchaseContractHeadVO.getOrderItemList();
                if (!CollectionUtils.isEmpty(orderItemList)) {
                    Object reduce;
                    for (PurchaseContractItem purchaseContractItem : purchaseContractHeadVO.getPurchaseContractItemList()) {
                        BigDecimal total = BigDecimal.ZERO;
                        if (ContractTargetTypeEnum.MONEY.getValue().equals(purchaseContractHeadVO.getTargetType())) {
                            BigDecimal amount = orderItemList.parallelStream().filter(item -> purchaseContractItem.getId().equals(item.getSourceItemId())).filter(p -> p.getTaxAmount() != null).map(PurchaseOrderItemDTO::getTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                            purchaseContractItem.setTargetQuantityAlready(amount);
                            continue;
                        }
                        BigDecimal quantity = orderItemList.parallelStream().filter(item -> purchaseContractItem.getId().equals(item.getSourceItemId())).filter(p -> p.getQuantity() != null).map(PurchaseOrderItemDTO::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
                        purchaseContractItem.setTargetQuantityAlready(quantity);
                    }
                    if (ContractTargetTypeEnum.MONEY.getValue().equals(purchaseContractHeadVO.getTargetType())) {
                        reduce = orderItemList.parallelStream().filter(item -> item.getTaxAmount() != null).map(PurchaseOrderItemDTO::getTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                        purchaseContractHeadVO.setTargetQuantityAlready(((BigDecimal)reduce).toString());
                    } else {
                        reduce = orderItemList.parallelStream().filter(item -> item.getQuantity() != null).map(PurchaseOrderItemDTO::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
                        purchaseContractHeadVO.setTargetQuantityAlready(((BigDecimal)reduce).toString());
                    }
                }
            } else if (!CollectionUtils.isEmpty(promiseList)) {
                BigDecimal reduce = promiseList.parallelStream().filter(item -> item.getAmount() != null).map(PurchaseContractPromise::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                purchaseContractHeadVO.setTargetQuantityAlready(reduce.toString());
            }
        }
    }

    @ApiOperation(value="\u91c7\u8d2d\u5408\u540c\u5934-\u901a\u8fc7id\u83b7\u53d6\u9884\u89c8\u6570\u636e", notes="\u91c7\u8d2d\u5408\u540c\u5934-\u901a\u8fc7id\u83b7\u53d6\u9884\u89c8\u6570\u636e")
    @GetMapping(value={"/getPreviewData"})
    @RequiresPermissions(value={"contract#purchaseContractHead:getPreviewData"})
    @PermissionDataOpt(businessType="contract", beanClass=PurchaseContractHeadService.class)
    public Result<?> getPreviewData(@RequestParam(name="id", required=true) String id) {
        return Result.ok((Object)this.getHtmlById(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u91c7\u8d2d\u5408\u540c\u5934-\u901a\u8fc7id\u83b7\u53d6\u9884\u89c8\u6570\u636e", notes="\u91c7\u8d2d\u5408\u540c\u5934-\u901a\u8fc7id\u83b7\u53d6\u9884\u89c8\u6570\u636e")
    @GetMapping(value={"/getPreviewDataPdf"})
    @RequiresPermissions(value={"contract#purchaseContractHead:getPreviewData"})
    @PermissionDataOpt(businessType="contract", beanClass=PurchaseContractHeadService.class)
    public void getPreviewDataPdf(@RequestParam(name="id", required=true) String id, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String html = this.getHtmlById(id).toString();
        PurchaseContractHead contractBuyHead = (PurchaseContractHead)((Object)this.purchaseContractHeadService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        String waterMark = contractBuyHead.getWaterMark();
        boolean b = waterMark != null && !"0".equals(waterMark);
        log.info(":::contract.waterMark:" + waterMark);
        String path = PdfUtil.htmlToPdf(this.uploadpath, html.toString(), contractBuyHead.getContractNumber() + "_" + contractBuyHead.getContractVersion(), b, contractBuyHead.getWaterMarkComment(), null);
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            log.info("path=" + path);
            File file = new File(path);
            if (file.exists()) {
                int len;
                response.addHeader("Content-Disposition", "attachment;fileName=" + new String(file.getName().getBytes("UTF-8"), "iso-8859-1"));
                response.addHeader("Access-Control-Allow-Origin", "*");
                response.addHeader("Access-Control-Expose-Headers", "Content-Disposition");
                response.setContentType("application/octet-stream");
                inputStream = new BufferedInputStream(new FileInputStream(file));
                outputStream = response.getOutputStream();
                byte[] buf = new byte[1024];
                while ((len = inputStream.read(buf)) > 0) {
                    outputStream.write(buf, 0, len);
                }
                outputStream.flush();
            }
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25" + e.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error("printStackTrace:", (Throwable)e);
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    log.error("printStackTrace:", (Throwable)e);
                }
            }
        }
    }

    private StringBuilder getHtmlById(String id) {
        Result<?> result = this.queryById(id);
        log.info(":::contract:\u5f00\u59cb\u6570\u636e\u5b57\u5178\u6e32\u67d3");
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean((String)"dictAspect");
        dictAspect.parseDictText(result);
        log.info(":::contract:\u5f00\u59cb\u8f6c\u5316\u5b9e\u4f53");
        PurchaseContractHeadVO purchaseContractHeadVO = (PurchaseContractHeadVO)((Object)JSON.parseObject((String)result.getResult().toString(), PurchaseContractHeadVO.class));
        log.info(":::contract:\u5f00\u59cb\u5b9e\u4f53\u8d4b\u503c");
        JSONObject jsonObject = (JSONObject)result.getResult();
        for (Map.Entry next : jsonObject.entrySet()) {
            if (!((String)next.getKey()).contains("_dictText") || next.getValue() == null || String.valueOf(next.getValue()).split("_").length <= 1) continue;
            next.setValue(next.getValue().toString().split("_")[1]);
        }
        log.info(":::contract:\u5f00\u59cb\u6e32\u67d3\u5408\u540c");
        Map param = (Map)JSON.parse((String)jsonObject.toString());
        param.put("itemList", param.get("purchaseContractItemList"));
        param.put("pageBreak", "<div style=\"page-break-after:always; \"></div>");
        log.info(":::contract:\u5206\u9875\u7b26\u63d2\u5165");
        List<PurchaseContractContentItem> contractBuyContentItemList = purchaseContractHeadVO.getPurchaseContractContentItemList();
        if (CollectionUtils.isEmpty(contractBuyContentItemList)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_saveBeforePreview", (String)"\u8bf7\u4fdd\u5b58\u6761\u6b3e\u884c\u540e\u9884\u89c8"));
        }
        int index = 0;
        if (purchaseContractHeadVO.getTotalTaxAmount().compareTo(BigDecimal.ZERO) > 0) {
            param.put("zh_totalTaxAmount", NumberUtil.number2CNMontrayUnit(purchaseContractHeadVO.getTotalTaxAmount()));
        }
        StringBuilder html = new StringBuilder();
        for (PurchaseContractContentItem item : contractBuyContentItemList) {
            if ("3".equals(item.getItemType()) || "4".equals(item.getItemType())) {
                param.put("index", ++index);
                param.put("zh_index", NumberUtil.number2Chinese(index));
            }
            String itemContent = item.getItemContent();
            if ("4".equals(item.getItemType())) {
                itemContent = PdfUtil.changeTemplate(itemContent);
            }
            String content = "";
            if (StringUtils.isNotBlank((CharSequence)itemContent)) {
                content = TemplateParseUtil.getTemplateText((String)"", (String)itemContent, (Map)param);
            }
            html.append(content);
        }
        return html;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/download"})
    @RequiresPermissions(value={"contract#purchaseContractHead:download"})
    public void download(@RequestParam(name="id", required=true) String id, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String html = this.getHtmlById(id).toString();
        PurchaseContractHead contractBuyHead = (PurchaseContractHead)((Object)this.purchaseContractHeadService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        String waterMark = contractBuyHead.getWaterMark();
        boolean b = waterMark != null && !"0".equals(waterMark);
        log.info(":::contract.waterMark:" + waterMark);
        String path = PdfUtil.htmlToPdf(this.uploadpath, html.toString(), contractBuyHead.getContractNumber() + "_" + contractBuyHead.getContractVersion(), b, contractBuyHead.getWaterMarkComment(), null);
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            log.info("path=" + path);
            File file = new File(path);
            if (file.exists()) {
                int len;
                response.addHeader("Content-Disposition", "attachment;fileName=" + new String(file.getName().getBytes("UTF-8"), "iso-8859-1"));
                inputStream = new BufferedInputStream(new FileInputStream(file));
                outputStream = response.getOutputStream();
                byte[] buf = new byte[1024];
                while ((len = inputStream.read(buf)) > 0) {
                    outputStream.write(buf, 0, len);
                }
                outputStream.flush();
            }
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25" + e.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error("printStackTrace:", (Throwable)e);
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    log.error("printStackTrace:", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/downloadDoc"})
    @RequiresPermissions(value={"contract#purchaseContractHead:download"})
    public void downloadDoc(@RequestParam(name="id", required=true) String id, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String html = this.getHtmlById(id).toString();
        PurchaseContractHead contractBuyHead = (PurchaseContractHead)((Object)this.purchaseContractHeadService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            String path = Htm2WordUtil.htmlWord(html, this.uploadpath, contractBuyHead.getContractNumber() + "_" + contractBuyHead.getContractVersion() + ".doc");
            log.info("path=" + path);
            File file = new File(path);
            if (file.exists()) {
                int len;
                response.addHeader("Content-Disposition", "attachment;fileName=" + new String(file.getName().getBytes("UTF-8"), "iso-8859-1"));
                inputStream = new BufferedInputStream(new FileInputStream(file));
                outputStream = response.getOutputStream();
                byte[] buf = new byte[1024];
                while ((len = inputStream.read(buf)) > 0) {
                    outputStream.write(buf, 0, len);
                }
                outputStream.flush();
            }
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25" + e.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error("printStackTrace:", (Throwable)e);
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    log.error("printStackTrace:", (Throwable)e);
                }
            }
        }
    }

    @ApiOperation(value="\u590d\u5236\u5355\u636e", notes="\u590d\u5236\u5355\u636e")
    @GetMapping(value={"/copy"})
    @RequiresPermissions(value={"contract#purchaseContractHead:copy"})
    public Result<?> copy(@RequestParam(value="id") String id) {
        PurchaseContractHeadVO data = this.getData(id);
        this.purchaseContractHeadService.copy(data);
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u91c7\u8d2d\u5408\u540c\u5934-\u901a\u8fc7id\u5347\u7ea7\u7248\u672c", notes="\u91c7\u8d2d\u5408\u540c\u5934-\u901a\u8fc7id\u83b7\u53d6\u9884\u89c8\u6570\u636e")
    @GetMapping(value={"/upgradeVersion"})
    @RequiresPermissions(value={"contract#purchaseContractHead:upgradeVersion"})
    @AutoLog(value="\u5408\u540c\u7ba1\u7406-\u7248\u672c\u53d8\u66f4")
    @PermissionDataOpt(businessType="contract", beanClass=PurchaseContractHeadService.class)
    public Result<?> upgradeVersion(@RequestParam(name="id", required=true) String id) {
        this.purchaseContractHeadService.upgradeVersion(id);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u91c7\u8d2d\u5408\u540c\u5934-\u901a\u8fc7id\u53d1\u5e03\u4f9b\u5e94\u5546", notes="\u91c7\u8d2d\u5408\u540c\u5934-\u901a\u8fc7id\u53d1\u5e03\u4f9b\u5e94\u5546")
    @GetMapping(value={"/publish"})
    @AutoLog(value="\u5408\u540c\u7ba1\u7406-\u53d1\u5e03")
    @RequiresPermissions(value={"contract#purchaseContractHead:publish"})
    @PermissionDataOpt(businessType="contract", beanClass=PurchaseContractHeadService.class)
    public Result<?> publish(@RequestParam(name="id", required=true) String id) {
        this.purchaseContractHeadService.publish(id);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7\u91c7\u8d2d\u5408\u540c\u5934id\u67e5\u8be2\u91c7\u8d2d\u5408\u540c\u884c", notes="\u901a\u8fc7\u91c7\u8d2d\u5408\u540c\u5934id\u67e5\u8be2\u91c7\u8d2d\u5408\u540c\u884c")
    @GetMapping(value={"/queryPurchaseContractItemByMainId"})
    @RequiresPermissions(value={"contract#purchaseContractHead:list"})
    public Result<?> queryPurchaseContractItemListByMainId(@RequestParam(name="id", required=true) String id) {
        List<PurchaseContractItem> purchaseContractItemList = this.purchaseContractItemService.selectByMainId(id);
        return Result.ok(purchaseContractItemList);
    }

    @ApiOperation(value="\u901a\u8fc7\u91c7\u8d2d\u5408\u540c\u5934id\u67e5\u8be2\u91c7\u8d2d\u5408\u540c\u6761\u6b3e\u884c", notes="\u901a\u8fc7\u91c7\u8d2d\u5408\u540c\u5934id\u67e5\u8be2\u91c7\u8d2d\u5408\u540c\u6761\u6b3e\u884c")
    @GetMapping(value={"/queryPurchaseContractContentItemByMainId"})
    @RequiresPermissions(value={"contract#purchaseContractHead:list"})
    public Result<?> queryPurchaseContractContentItemListByMainId(@RequestParam(name="id", required=true) String id) {
        List<PurchaseContractContentItem> purchaseContractContentItemList = this.purchaseContractContentItemService.selectByMainId(id);
        return Result.ok(purchaseContractContentItemList);
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @PermissionDataView(businessType="contract")
    @RequiresPermissions(value={"contract#purchaseContractHead:list"})
    public Result<?> queryTabsCount(PurchaseContractHead purchaseContractHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseContractHead), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"contract_status", "count(0) as participateQuantity"}).lambda().ne(PurchaseContractHead::getContractType, (Object)"3");
        queryWrapper.groupBy((Object)"contract_status");
        List list = ((PurchaseContractHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseContractHead::getContractStatus, PurchaseContractHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "contractStatus", null, all));
        List srmContractStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmContractStatus", TenantContext.getTenant());
        for (DictDTO status : srmContractStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "contractStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/countsimple"})
    @PermissionDataView(businessType="contract")
    @RequiresPermissions(value={"contract#purchaseContractHead:list"})
    public Result<?> queryTabsCountSimple(PurchaseContractHead purchaseContractHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseContractHead), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"contract_status", "count(0) as participateSimpleQuantity"}).lambda().eq(PurchaseContractHead::getContractType, (Object)"3");
        queryWrapper.groupBy((Object)"contract_status");
        List simple_list = ((PurchaseContractHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = simple_list.stream().collect(Collectors.toMap(PurchaseContractHead::getContractStatus, PurchaseContractHead::getParticipateSimpleQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "contractStatus", null, all));
        List srmReviewStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmContractStatus", TenantContext.getTenant());
        for (DictDTO status : srmReviewStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "contractStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @PostMapping(value={"/exportXls"})
    @RequiresPermissions(value={"contract#purchaseContractHead:export"})
    @PermissionDataOpt(businessType="contract", beanClass=PurchaseContractHeadService.class)
    public ModelAndView exportXls(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        return super.exportXls(request, object, PurchaseContractHeadExportServiceImpl.class);
    }

    @GetMapping(value={"/listByAccept"})
    @RequiresPermissions(value={"contract#purchaseContractHead:list"})
    public Result<?> listByAccept(PurchaseContractHead purchaseContractHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        if (TenantContext.getTenant().equals(purchaseContractHead.getToElsAccount())) {
            SaleContractHead query = new SaleContractHead();
            BeanUtils.copyProperties((Object)((Object)purchaseContractHead), (Object)((Object)query));
            query.setElsAccount(TenantContext.getTenant());
            query.setToElsAccount(purchaseContractHead.getElsAccount());
            QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)query), (Map)req.getParameterMap());
            Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
            queryWrapper.lambda().orderByDesc(BaseEntity::getCreateTime);
            IPage<SaleContractHead> saleContractHeadIPage = this.saleContractHeadService.listByAccept((Page<SaleContractHead>)page, (QueryWrapper<SaleContractHead>)queryWrapper);
            return Result.ok(saleContractHeadIPage);
        }
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseContractHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.lambda().orderByDesc(BaseEntity::getCreateTime);
        IPage<PurchaseContractHead> purchaseContractHeadIPage = this.purchaseContractHeadService.listByAccept((Page<PurchaseContractHead>)page, (QueryWrapper<PurchaseContractHead>)queryWrapper);
        return Result.ok(purchaseContractHeadIPage);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ApiOperation(value="\u91c7\u8d2d\u5408\u540c\u5934-\u5173\u95ed", notes="\u91c7\u8d2d\u5408\u540c\u5934-\u5173\u95ed")
    @PostMapping(value={"/close"})
    @AutoLog(value="\u5408\u540c\u7ba1\u7406-\u5173\u95ed")
    @RequiresPermissions(value={"contract#purchaseContractHead:close"})
    @PermissionDataOpt(businessType="contract", beanClass=PurchaseContractHeadService.class)
    public Result<?> close(@RequestBody PurchaseContractHeadVO head) {
        if (head.isCheck()) {
            String msg = this.purchaseContractHeadService.checkClose(head);
            if (!StrUtil.isBlank((CharSequence)msg)) return Result.ok((String)msg, (Object)true);
            if (StringUtils.isNotEmpty((CharSequence)head.getSupplement()) && head.getSupplement().equals("1")) {
                head.setContractStatus(ContractStatusEnum.CLOSED.getValue());
            } else {
                head.setContractStatus(ContractStatusEnum.CONFIRMING_CLOSED.getValue());
            }
            this.purchaseContractHeadService.updateStatus(head);
            return this.commonSuccessResult(8);
        } else {
            if (StringUtils.isNotEmpty((CharSequence)head.getSupplement()) && head.getSupplement().equals("1")) {
                head.setContractStatus(ContractStatusEnum.CLOSED.getValue());
            } else {
                head.setContractStatus(ContractStatusEnum.CONFIRMING_CLOSED.getValue());
            }
            this.purchaseContractHeadService.updateStatus(head);
        }
        return this.commonSuccessResult(8);
    }

    @ApiOperation(value="\u67e5\u8be2\u4f9b\u5e94\u5546\u7684\u5408\u540c\u6570", notes="\u67e5\u8be2\u4f9b\u5e94\u5546\u7684\u5408\u540c\u6570")
    @GetMapping(value={"/countBySupplier"})
    public Result<?> countBySupplier(PurchaseContractHead contractHead, HttpServletRequest req) {
        JSONObject jsonObj = this.contractBoardService.compareCountTrend();
        return Result.ok((Object)jsonObj);
    }

    @ApiOperation(value="\u5408\u540c\u72b6\u6001-\u997c\u72b6\u56fe", notes="\u5408\u540c\u72b6\u6001-\u997c\u72b6\u56fe")
    @GetMapping(value={"/countStatusPie"})
    public Result<?> countStatusPie(PurchaseContractHead contractHead, HttpServletRequest req) {
        JSONObject jsonObj = this.contractBoardService.countStatusPie();
        return Result.ok((Object)jsonObj);
    }

    @ApiOperation(value="\u4e34\u671f", notes="\u4e34\u671f")
    @GetMapping(value={"/comingOfAge"})
    public Result<?> comingOfAge(PurchaseContractHead purchaseContractHead, HttpServletRequest req) {
        ArrayList<CountDTO> result = new ArrayList<CountDTO>();
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, 2);
        Date date = calendar.getTime();
        Calendar calendar1 = Calendar.getInstance();
        Date nowDate = calendar1.getTime();
        List list = ((QueryChainWrapper)((QueryChainWrapper)((PurchaseContractHeadService)this.service).query().lt((Object)"expiry_date", (Object)date)).gt((Object)"expiry_date", (Object)nowDate)).list();
        result.add(new CountDTO(I18nUtil.translate((String)"", (String)"\u5408\u540c\u4e34\u671f"), "itemStatus", null, Integer.valueOf(list.size()), "", ""));
        List list1 = ((QueryChainWrapper)((PurchaseContractHeadService)this.service).query().lt((Object)"expiry_date", (Object)nowDate)).list();
        result.add(new CountDTO(I18nUtil.translate((String)"", (String)"\u5408\u540c\u5230\u671f"), "itemStatus", null, Integer.valueOf(list1.size()), "", ""));
        return Result.ok(result);
    }

    @ApiOperation(value="\u4e34\u671f", notes="\u4e34\u671f")
    @GetMapping(value={"/contractTypeDistribution"})
    public Result<?> contractTypeDistribution(PurchaseContractHead purchaseContractHead, HttpServletRequest req) {
        List list = ((QueryChainWrapper)((PurchaseContractHeadService)this.service).query().select(new String[]{"contract_type", "count(*) as fbk1"}).groupBy((Object)"contract_type")).list();
        list.stream().forEach(i -> {
            String srmContractType = ((InvokeBaseRpcService)SpringContextUtils.getBean(InvokeBaseRpcService.class)).queryDictTextByKey("srmContractType", i.getContractType(), TenantContext.getTenant());
            i.setContractType(srmContractType);
        });
        JSONObject outerJson = new JSONObject();
        JSONArray seriesDataArray = new JSONArray();
        JSONObject seriesDataObject = new JSONObject();
        JSONArray dataArray = new JSONArray();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            JSONObject dataObject1 = new JSONObject();
            dataObject1.put("name", (Object)((PurchaseContractHead)((Object)list.get(i2))).getContractType());
            dataObject1.put("value", (Object)Integer.valueOf(((PurchaseContractHead)((Object)list.get(i2))).getFbk1()));
            dataArray.add((Object)dataObject1);
        }
        seriesDataObject.put("data", (Object)dataArray);
        seriesDataArray.add((Object)seriesDataObject);
        outerJson.put("seriesData", (Object)seriesDataArray);
        outerJson.put("type", (Object)"pie");
        return Result.ok((Object)outerJson);
    }

    @ApiOperation(value="\u4e34\u671f", notes="\u4e34\u671f")
    @GetMapping(value={"/contractCompletionRatio"})
    public Result<?> contractCompletionRatio(PurchaseContractHead purchaseContractHead, HttpServletRequest req) {
        List list = ((QueryChainWrapper)((PurchaseContractHeadService)this.service).query().ne((Object)"contract_status", (Object)"6")).list();
        List list1 = ((QueryChainWrapper)((PurchaseContractHeadService)this.service).query().eq((Object)"contract_status", (Object)"6")).list();
        JSONObject outerJson = new JSONObject();
        JSONArray seriesDataArray = new JSONArray();
        JSONObject seriesDataObject = new JSONObject();
        JSONArray dataArray = new JSONArray();
        JSONObject dataObject1 = new JSONObject();
        dataObject1.put("name", (Object)"\u672a\u5b8c\u6210");
        dataObject1.put("value", (Object)list.size());
        dataArray.add((Object)dataObject1);
        JSONObject dataObject2 = new JSONObject();
        dataObject2.put("name", (Object)"\u5df2\u5b8c\u6210");
        dataObject2.put("value", (Object)list1.size());
        dataArray.add((Object)dataObject2);
        seriesDataObject.put("data", (Object)dataArray);
        seriesDataArray.add((Object)seriesDataObject);
        outerJson.put("seriesData", (Object)seriesDataArray);
        outerJson.put("type", (Object)"pie");
        return Result.ok((Object)outerJson);
    }
}

