/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.contractlock.controller;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.electronsign.contractlock.entity.ElsClSignContract;
import com.els.modules.electronsign.contractlock.excel.ContractExportServiceImpl;
import com.els.modules.electronsign.contractlock.service.ElsClContractService;
import com.els.modules.electronsign.contractlock.vo.ClCallback;
import com.els.modules.electronsign.contractlock.vo.ClContractVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u5951\u7ea6\u9501\u5408\u540c"})
@RestController
@RequestMapping(value={"/contractLock/elsClContract"})
public class ElsClContractController
extends BaseController<ElsClSignContract, ElsClContractService> {
    private static final Logger log = LoggerFactory.getLogger(ElsClContractController.class);
    @Autowired
    private ElsClContractService elsClContractService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"contractLock#signFlow:list"})
    public Result<?> queryPageList(ElsClSignContract elsClSignContract, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsClSignContract), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.ne((Object)"bus_type", (Object)"single");
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        IPage pageList = this.elsClContractService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/saleList"})
    @RequiresPermissions(value={"contractLock#saleSignFlow:list"})
    @PermissionDataView(businessType="contractLock")
    public Result<?> saleList(ElsClSignContract elsClSignContract, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsClSignContract), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"to_els_account", (Object)TenantContext.getTenant());
        queryWrapper.eq((Object)"send_status", (Object)"1");
        queryWrapper.ne((Object)"bus_type", (Object)"single");
        IPage pageList = this.elsClContractService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/singleList/{code}"})
    @RequiresPermissions(value={"contractLock#purchaseSign:list"})
    @PermissionDataView(businessType="contractLock")
    public Result<?> singleList(ElsClSignContract elsClSignContract, @PathVariable String code, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsClSignContract), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"bus_type", (Object)"single");
        if ("1".equals(code)) {
            queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        } else {
            queryWrapper.eq((Object)"to_els_account", (Object)TenantContext.getTenant());
            queryWrapper.eq((Object)"send_status", (Object)"1");
        }
        IPage pageList = this.elsClContractService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/saleSingleList/{code}"})
    @RequiresPermissions(value={"contractLock#saleSign:list"})
    @PermissionDataView(businessType="contractLock")
    public Result<?> saleSingleList(ElsClSignContract elsClSignContract, @PathVariable String code, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsClSignContract), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"bus_type", (Object)"single");
        if ("1".equals(code)) {
            queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        } else {
            queryWrapper.eq((Object)"to_els_account", (Object)TenantContext.getTenant());
            queryWrapper.eq((Object)"send_status", (Object)"1");
        }
        IPage pageList = this.elsClContractService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u53d1\u9001", notes="\u53d1\u9001")
    @PostMapping(value={"/saleSend"})
    @RequiresPermissions(value={"contractLock#saleSign:send", "contractLock#purchaseSign:send"}, logical=Logical.OR)
    public Result<?> saleSend(@RequestBody ClContractVO req) {
        this.elsClContractService.saleSend(req);
        return Result.ok();
    }

    @ApiOperation(value="\u786e\u8ba4", notes="\u786e\u8ba4")
    @GetMapping(value={"/confirm"})
    @RequiresPermissions(value={"contractLock#saleSign:confirm", "contractLock#purchaseSign:confirm"}, logical=Logical.OR)
    public Result<?> confirm(@RequestParam(name="id") String id) {
        this.elsClContractService.confirm(id);
        return Result.ok();
    }

    @ApiOperation(value="\u9a73\u56de", notes="\u9a73\u56de")
    @GetMapping(value={"/reject"})
    @RequiresPermissions(value={"contractLock#purchaseSign:reject", "contractLock#saleSign:reject"}, logical=Logical.OR)
    public Result<?> reject(@RequestParam(name="id") String id, @RequestParam(name="rejectReason") String rejectReason) {
        this.elsClContractService.reject(id, rejectReason);
        return Result.ok();
    }

    @AutoLog(busModule="\u5951\u7ea6\u9501\u5408\u540c\u6d41\u7a0b", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"contractLock#purchaseSign:add", "contractLock#purchaseSign:edit", "contractLock#saleSign:edit", "contractLock#saleSign:add"}, logical=Logical.OR)
    @SrmValidated
    public Result<?> add(@RequestBody ClContractVO req) {
        this.elsClContractService.saveMain(req);
        return Result.ok((Object)((Object)req));
    }

    @AutoLog(busModule="\u5951\u7ea6\u9501\u5408\u540c\u6d41\u7a0b", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"contractLock#purchaseSign:add", "contractLock#purchaseSign:edit", "contractLock#saleSign:edit", "contractLock#saleSign:add"}, logical=Logical.OR)
    @SrmValidated
    public Result<?> edit(@RequestBody ClContractVO req) {
        this.elsClContractService.editMain(req);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u5951\u7ea6\u9501\u5408\u540c\u6d41\u7a0b", value="\u53d1\u9001\u4f9b\u5e94\u5546\u7ef4\u62a4\u7b7e\u7f72\u4eba")
    @ApiOperation(value="\u53d1\u9001\u4f9b\u5e94\u5546\u7ef4\u62a4\u7b7e\u7f72\u4eba", notes="\u53d1\u9001\u4f9b\u5e94\u5546\u7ef4\u62a4\u7b7e\u7f72\u4eba")
    @PostMapping(value={"/send"})
    @RequiresPermissions(value={"contractLock#saleSignFlow:signer", "contractLock#purchaseSignFlow:signer"}, logical=Logical.OR)
    public Result<?> send(@RequestBody ClContractVO req, HttpServletRequest request, HttpServletResponse response) {
        this.elsClContractService.send(req, request, response);
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts/{code}"})
    @PermissionDataView(businessType="contractLock")
    @RequiresPermissions(value={"contractLock#saleSign:list", "contractLock#purchaseSign:list"}, logical=Logical.OR)
    public Result<?> queryTabsCount(@PathVariable String code, ElsClSignContract elsClSignContract, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        String tenant = TenantContext.getTenant();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsClSignContract), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"bus_type", (Object)"single");
        queryWrapper.eq((Object)"els_account", (Object)tenant);
        Integer count1 = ((ElsClContractService)this.service).count((Wrapper)queryWrapper);
        Integer count2 = 0;
        IPage iPage = (IPage)this.singleList(elsClSignContract, "0", 1, 1, req).getResult();
        if (ObjectUtil.isNotEmpty((Object)iPage)) {
            count2 = (int)iPage.getTotal();
        }
        result.add(new CountVO("\u672c\u65b9\u521b\u5efa", "self", "1", Integer.valueOf(count1)));
        result.add(new CountVO(code.equals("1") ? "\u4f9b\u65b9\u521b\u5efa" : "\u91c7\u65b9\u521b\u5efa", "other", "2", count2));
        return Result.ok(result);
    }

    @AutoLog(busModule="\u5951\u7ea6\u9501\u5408\u540c\u6d41\u7a0b", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"contractLock#purchaseSign:delete", "contractLock#saleSign:delete"}, logical=Logical.OR)
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.elsClContractService.delete(id);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"contractLock#saleSign:detail", "contractLock#saleSignFlow:detail", "contractLock#signFlow:detail", "contractLock#purchaseSign:detail"}, logical=Logical.OR)
    public Result<?> queryById(@RequestParam(name="id") String id) {
        ClContractVO rp = this.elsClContractService.getMainById(id);
        return Result.ok((Object)((Object)rp));
    }

    @AutoLog(busModule="\u5951\u7ea6\u9501\u5408\u540c\u6d41\u7a0b", value="\u521b\u5efa\u8349\u7a3f")
    @ApiOperation(value="\u521b\u5efa\u8349\u7a3f", notes="\u521b\u5efa\u8349\u7a3f")
    @GetMapping(value={"/createDraft"})
    @RequiresPermissions(value={"contractLock#purchaseSign:createDraft", "contractLock#signFlow:createDraft", "contractLock#saleSign:createDraft"}, logical=Logical.OR)
    public Result<?> createDraft(@RequestParam(name="id") String id, @RequestParam(value="companyId", required=false) String companyId, @RequestParam(value="creatorId", required=false) String creatorId) {
        ClContractVO rp = this.elsClContractService.createDraft(id, companyId, creatorId);
        return Result.ok((Object)((Object)rp));
    }

    @AutoLog(busModule="\u5951\u7ea6\u9501\u5408\u540c\u6d41\u7a0b", value="\u5408\u540c\u56de\u8c03")
    @ApiOperation(value="\u5408\u540c\u56de\u8c03", notes="\u5408\u540c\u56de\u8c03")
    @PostMapping(value={"/noToken/callback/contract"})
    public void callbackContract(@RequestBody ClCallback.Contract contract) {
        log.info("\u5951\u7ea6\u9501\u5408\u540c\u56de\u8c03req:{}", (Object)JSON.toJSONString((Object)contract));
        this.elsClContractService.handleCallBackContract(contract);
    }

    @AutoLog(busModule="\u5951\u7ea6\u9501\u5408\u540c\u6d41\u7a0b", value="\u6587\u4ef6\u4e0a\u4f20\u5230\u5951\u7ea6\u9501")
    @ApiOperation(value="\u6587\u4ef6\u4e0a\u4f20\u5230\u5951\u7ea6\u9501", notes="\u6587\u4ef6\u4e0a\u4f20\u5230\u5951\u7ea6\u9501")
    @PostMapping(value={"/uploadFileToContractLock"})
    @RequiresPermissions(value={"contractLock#purchaseSign:uploadFile", "contractLock#signFlow:uploadFile", "contractLock#saleSign:uploadFile"}, logical=Logical.OR)
    public Result<?> uploadFileToContractLock(@RequestBody ClContractVO req, HttpServletRequest request, HttpServletResponse response) {
        ClContractVO rp = this.elsClContractService.uploadFileToContractLock(req, request, response);
        return Result.ok((Object)((Object)rp));
    }

    @AutoLog(busModule="\u5951\u7ea6\u9501\u5408\u540c\u6d41\u7a0b", value="\u64a4\u9500")
    @ApiOperation(value="\u64a4\u9500", notes="\u64a4\u9500")
    @GetMapping(value={"/backout"})
    @RequiresPermissions(value={"contractLock#signFlow:cancel"})
    public Result<?> backout(@RequestParam(name="id", required=true) String id, @RequestParam(name="reason", required=true) String reason) {
        this.elsClContractService.backout(id, reason);
        return Result.ok();
    }

    @AutoLog(busModule="\u5951\u7ea6\u9501\u5408\u540c\u6d41\u7a0b", value="\u6d41\u7a0b\u67e5\u8be2")
    @ApiOperation(value="\u5408\u540c\u8be6\u60c5", notes="\u6d41\u7a0b\u67e5\u8be2")
    @GetMapping(value={"/flowQuery"})
    @RequiresPermissions(value={"contractLock#signFlow:statusQuery", "contractLock#purchaseSign:queryFlow", "contractLock#saleSign:queryFlow"}, logical=Logical.OR)
    public Result<?> flowQuery(@RequestParam(name="id", required=true) String id) {
        return this.elsClContractService.flowQuery(id);
    }

    @AutoLog(busModule="\u5951\u7ea6\u9501\u5408\u540c\u6d41\u7a0b", value="\u6d4f\u89c8\u7b7e\u7f72\u9875\u9762")
    @ApiOperation(value="\u6d4f\u89c8\u9875\u9762", notes="\u6d4f\u89c8\u9875\u9762")
    @GetMapping(value={"/browsePage"})
    @RequiresPermissions(value={"contractLock#purchaseSign:preview", "contractLock#signFlow:preview", "contractLock#saleSign:preview", "contractLock#saleSignFlow:preview"}, logical=Logical.OR)
    public Result<?> browsePage(@RequestParam(value="id") String id) {
        String rp = this.elsClContractService.browsePage(id);
        return Result.ok((Object)rp);
    }

    @AutoLog(busModule="\u5951\u7ea6\u9501\u5408\u540c\u6d41\u7a0b", value="\u53d1\u8d77\u5408\u540c")
    @ApiOperation(value="\u53d1\u8d77\u5408\u540c", notes="\u53d1\u8d77\u5408\u540c")
    @GetMapping(value={"/initiate"})
    @RequiresPermissions(value={"contractLock#purchaseSign:initiate", "contractLock#signFlow:initiate", "contractLock#saleSign:initiate"}, logical=Logical.OR)
    public Result<?> initiate(@RequestParam(name="id") String id) {
        this.elsClContractService.initiate(id);
        return Result.ok();
    }

    @AutoLog(busModule="\u5951\u7ea6\u9501\u5408\u540c\u6d41\u7a0b", value="\u83b7\u53d6\u7b7e\u7f72\u9875\u9762")
    @ApiOperation(value="\u83b7\u53d6\u7b7e\u7f72\u9875\u9762", notes="\u83b7\u53d6\u7b7e\u7f72\u9875\u9762")
    @GetMapping(value={"/getSignPage"})
    @RequiresPermissions(value={"contractLock#signFlow:shortUrl", "contractLock#purchaseSign:getShortUrl", "contractLock#saleSign:getShortUrl"}, logical=Logical.OR)
    public Result<?> getSignPage(@RequestParam(name="id") String id) {
        String rp = this.elsClContractService.getSignPage(id);
        return Result.ok((Object)rp);
    }

    @AutoLog(busModule="\u4e0b\u8f7d\u7b7e\u7f72\u6587\u6863", value="\u83b7\u53d6\u7b7e\u7f72\u9875\u9762")
    @ApiOperation(value="\u83b7\u53d6\u7b7e\u7f72\u9875\u9762", notes="\u83b7\u53d6\u7b7e\u7f72\u9875\u9762")
    @GetMapping(value={"/downSignFile"})
    @RequiresPermissions(value={"contractLock#signFlow:down", "contractLock#saleSignFlow:down"}, logical=Logical.OR)
    public Result<?> downSignFile(@RequestParam(name="id") String id) {
        return Result.ok((Object)this.elsClContractService.downSignFile(id));
    }

    @AutoLog(busModule="\u4e0b\u8f7d\u7b7e\u7f72\u6587\u6863", value="\u83b7\u53d6\u7b7e\u7f72\u9875\u9762")
    @ApiOperation(value="\u83b7\u53d6\u7b7e\u7f72\u9875\u9762", notes="\u83b7\u53d6\u7b7e\u7f72\u9875\u9762")
    @GetMapping(value={"/downSignFileByDocumentId"})
    @RequiresPermissions(value={"contractLock#signFlow:down", "contractLock#saleSignFlow:down"}, logical=Logical.OR)
    public void downSignFileByDocumentId(@RequestParam(name="id") String id, @RequestParam(name="fileName") String fileName, @RequestParam(name="documentId") String documentId, HttpServletResponse response) {
        byte[] fileByte = this.elsClContractService.downSignFileByDocumentId(id, fileName, documentId);
        response.setContentType("application/x-msdownload;");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName);
        ByteArrayInputStream is = new ByteArrayInputStream(fileByte);
        BufferedInputStream bis = new BufferedInputStream(is);
        FilterOutputStream bos = null;
        try {
            int len;
            bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
            byte[] buffer = new byte[2048];
            while ((len = bis.read(buffer, 0, buffer.length)) != -1) {
                ((BufferedOutputStream)bos).write(buffer, 0, len);
                ((BufferedOutputStream)bos).flush();
            }
            if (bis != null) {
                bis.close();
            }
            if (bos != null) {
                bos.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @AutoLog(busModule="\u5951\u7ea6\u9501\u5408\u540c\u6d41\u7a0b", value="\u9000\u56de")
    @ApiOperation(value="\u9000\u56de", notes="\u9000\u56de")
    @GetMapping(value={"/sendBack"})
    @RequiresPermissions(value={"contractLock#signFlow:back"})
    public Result<?> sendBack(@RequestParam(name="id", required=true) String id) {
        this.elsClContractService.sendBack(id);
        return Result.ok();
    }

    @AutoLog(busModule="\u5951\u7ea6\u9501\u5408\u540c\u6d41\u7a0b", value="\u4e0b\u8f7d\u5f52\u6863\u6587\u6863")
    @ApiOperation(value="\u4e0b\u8f7d\u5f52\u6863\u6587\u6863", notes="\u4e0b\u8f7d\u5f52\u6863\u6587\u6863")
    @GetMapping(value={"/downloadArchive"})
    @RequiresPermissions(value={"contractLock#signFlow:down", "contractLock#saleSignFlow:down"}, logical=Logical.OR)
    public Result<?> downloadArchive(@RequestParam(name="id") String id) {
        return Result.ok((Object)((Object)this.elsClContractService.downloadArchive(id, null)));
    }

    @AutoLog(busModule="\u5951\u7ea6\u9501\u5408\u540c\u6d41\u7a0b", value="\u4e0b\u8f7d\u5f52\u6863\u6587\u6863")
    @ApiOperation(value="\u4e0b\u8f7d\u5f52\u6863\u6587\u6863", notes="\u4e0b\u8f7d\u5f52\u6863\u6587\u6863")
    @GetMapping(value={"/downloadArchiveByRelationId"})
    @RequiresPermissions(value={"contractLock#signFlow:down", "contractLock#saleSignFlow:down"}, logical=Logical.OR)
    public Result<?> downloadArchiveByRelationId(@RequestParam(name="id") String id) {
        return Result.ok((Object)((Object)this.elsClContractService.downloadArchive(null, id)));
    }

    @AutoLog(busModule="\u5951\u7ea6\u9501\u5408\u540c\u6d41\u7a0b", value="\u5f52\u6863")
    @ApiOperation(value="\u5f52\u6863", notes="\u5f52\u6863")
    @GetMapping(value={"/archive"})
    @RequiresPermissions(value={"contractLock#signFlow:archive"})
    public Result<?> archive(@RequestParam(name="id") String id) {
        this.elsClContractService.archive(id);
        return Result.ok();
    }

    @PostMapping(value={"/exportXls"})
    @PermissionDataView(businessType="contractLock")
    @RequiresPermissions(value={"contractLock#purchaseSign:export"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        return super.exportXls(request, object, ContractExportServiceImpl.class);
    }
}

