/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.esignv3.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.electronsign.config.EsignV3Properties;
import com.els.modules.electronsign.esignv3.dto.AuthRp;
import com.els.modules.electronsign.esignv3.dto.CallBackDto;
import com.els.modules.electronsign.esignv3.dto.PersonalRp;
import com.els.modules.electronsign.esignv3.dto.PersonalRq;
import com.els.modules.electronsign.esignv3.entity.SaleEsignV3Personal;
import com.els.modules.electronsign.esignv3.enums.AuthCallBackEnum;
import com.els.modules.electronsign.esignv3.enums.RealNameStatusEnum;
import com.els.modules.electronsign.esignv3.mapper.SaleEsignV3PersonalMapper;
import com.els.modules.electronsign.esignv3.service.SaleEsignV3PersonalService;
import com.els.modules.electronsign.util.IpassUtil;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SaleEsignV3PersonalServiceImpl
extends BaseServiceImpl<SaleEsignV3PersonalMapper, SaleEsignV3Personal>
implements SaleEsignV3PersonalService {
    @Autowired
    private IpassUtil ipassUtil;
    @Autowired
    private EsignV3Properties esignV3Properties;

    @Override
    public void add(SaleEsignV3Personal saleEsignV3Personal) {
        Assert.isTrue((this.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SaleEsignV3Personal::getPsnAccount, (Object)saleEsignV3Personal.getPsnAccount())).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())) == 0 ? 1 : 0) != 0, (String)"\u8be5\u7528\u6237\u5df2\u5b58\u5728");
        ((SaleEsignV3PersonalMapper)this.baseMapper).insert((Object)saleEsignV3Personal);
    }

    @Override
    public void edit(SaleEsignV3Personal saleEsignV3Personal) {
        Assert.isTrue((this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SaleEsignV3Personal::getPsnAccount, (Object)saleEsignV3Personal.getPsnAccount())).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).ne(BaseEntity::getId, (Object)saleEsignV3Personal.getId())) == 0 ? 1 : 0) != 0, (String)"\u8be5\u7528\u6237\u5df2\u5b58\u5728");
        int count = ((SaleEsignV3PersonalMapper)this.baseMapper).updateById((Object)saleEsignV3Personal);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    public boolean processPsn(SaleEsignV3Personal personal) {
        PersonalRq.PsnAuthConfig rq = new PersonalRq.PsnAuthConfig();
        rq.setPsnAccount(personal.getPsnAccount());
        try {
            PersonalRp rp = this.ipassUtil.sendBaseRequest(rq, "e3-query-auth-personal", PersonalRp.class);
            if (RealNameStatusEnum.REAL_NAME.getValue().equals(rp.getRealnameStatus()) && StrUtil.isNotBlank((CharSequence)rp.getPsnId())) {
                BeanUtil.copyProperties((Object)rp.getPsnInfo(), (Object)((Object)personal), (String[])new String[0]);
                personal.setRealnameStatus(RealNameStatusEnum.REAL_NAME.getCode());
                personal.setPsnId(rp.getPsnId());
                this.updateById((Object)personal);
                return true;
            }
        }
        catch (Exception e) {
            this.log.error("processPsn error", (Throwable)e);
            return false;
        }
        return false;
    }

    @Override
    public void delete(String id) {
        ((SaleEsignV3PersonalMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((SaleEsignV3PersonalMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public SaleEsignV3Personal submitCertification(SaleEsignV3Personal personal, String needSave) {
        if ("1".equals(needSave)) {
            if (StrUtil.isBlank((CharSequence)personal.getId())) {
                this.add(personal);
            } else {
                this.edit(personal);
            }
        } else {
            personal = (SaleEsignV3Personal)((Object)this.getById((Serializable)((Object)personal.getId())));
        }
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)personal)), (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        Assert.isTrue((!RealNameStatusEnum.REAL_NAME.getCode().equals(personal.getRealnameStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_rjDILi_596d38db", (String)"\u8be5\u7528\u6237\u5df2\u8ba4\u8bc1"));
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)personal.getPsnAccount()), (String)I18nUtil.translate((String)"i18n_field_rjDILi_596d38db", (String)"\u8be5\u7528\u6237\u5df2\u8ba4\u8bc1"));
        if (this.processPsn(personal)) {
            return personal;
        }
        PersonalRq.PsnAuthPageConfig psnAuthPageConfig = new PersonalRq.PsnAuthPageConfig();
        BeanUtil.copyProperties((Object)((Object)personal), (Object)psnAuthPageConfig, (String[])new String[0]);
        IpassUtil.setNullValue(psnAuthPageConfig);
        if (StrUtil.isNotBlank((CharSequence)personal.getPsnAvailableAuthModes())) {
            psnAuthPageConfig.setPsnAvailableAuthModes(Arrays.asList(personal.getPsnAvailableAuthModes().split(",")));
        }
        if (StrUtil.isNotBlank((CharSequence)personal.getPsnEditableFields())) {
            psnAuthPageConfig.setPsnEditableFields(Arrays.asList(personal.getPsnEditableFields().split(",")));
        }
        PersonalRq.PsnInfo psnInfo = new PersonalRq.PsnInfo();
        BeanUtil.copyProperties((Object)((Object)personal), (Object)psnInfo, (String[])new String[0]);
        IpassUtil.setNullValue(psnInfo);
        PersonalRq.PsnAuthConfig psnAuthConfig = new PersonalRq.PsnAuthConfig();
        psnAuthConfig.setPsnAccount(personal.getPsnAccount());
        psnAuthConfig.setPsnAuthPageConfig(psnAuthPageConfig);
        psnAuthConfig.setPsnInfo(psnInfo);
        IpassUtil.setNullValue(psnAuthConfig);
        PersonalRq.AuthorizeConfig authConfig = new PersonalRq.AuthorizeConfig();
        if (StrUtil.isNotBlank((CharSequence)personal.getAuthorizedScopes())) {
            authConfig.setAuthorizedScopes(Arrays.asList(personal.getAuthorizedScopes().split(",")));
        }
        String notifyUrl = this.esignV3Properties.getCallBackUrl() + "/esignV3/saleEsignV3Personal/noToken/callback";
        PersonalRq personalRq = PersonalRq.builder().psnAuthConfig(psnAuthConfig).authorizeConfig(authConfig).notifyUrl(notifyUrl).build();
        IpassUtil.setNullValue(personalRq);
        AuthRp rp = this.ipassUtil.sendRequest(personalRq, "e3-get-auth-personal", AuthRp.class);
        personal.setAuthFlowId(rp.getAuthFlowId());
        personal.setAuthShortYrl(rp.getAuthShortUrl());
        personal.setAuthUrl(rp.getAuthUrl());
        this.updateById((Object)personal);
        return personal;
    }

    @Override
    public void handleCallBack(CallBackDto.PersonalAuth params) {
        SaleEsignV3Personal personal;
        if (AuthCallBackEnum.AUTH_PASS.getCode().equals(params.getAction()) && ObjectUtil.isNotEmpty((Object)((Object)(personal = ((SaleEsignV3PersonalMapper)this.baseMapper).selectByRequestId(params.getAuthFlowId()))))) {
            personal.setRealnameStatus(RealNameStatusEnum.REAL_NAME.getCode());
            personal.setPsnId(params.getPsnInfo().getPsnId());
            this.updateById((Object)personal);
        }
    }

    @Override
    public void refreshRealNameStatus(String id) {
        SaleEsignV3Personal personal = (SaleEsignV3Personal)((Object)this.getById((Serializable)((Object)id)));
        if (ObjectUtil.isEmpty((Object)((Object)personal)) || RealNameStatusEnum.REAL_NAME.getCode().equals(personal.getRealnameStatus())) {
            return;
        }
        PersonalRq.QueryAuth queryAuth = new PersonalRq.QueryAuth();
        BeanUtil.copyProperties((Object)((Object)personal), (Object)queryAuth, (String[])new String[0]);
        IpassUtil.setNullValue(queryAuth);
        HashMap params = Maps.newHashMap();
        params.put("base", queryAuth);
        AuthRp.QueryRp queryRp = this.ipassUtil.sendRequest(params, "e3-query-auth-personal", AuthRp.QueryRp.class);
        if (RealNameStatusEnum.REAL_NAME.getCode().equals(queryRp.getRealnameStatus())) {
            personal.setRealnameStatus(RealNameStatusEnum.REAL_NAME.getCode());
            personal.setPsnId(queryRp.getPsnId());
            this.updateById((Object)personal);
        }
    }

    @Override
    public SaleEsignV3Personal getByPsnAccount(String psnAccount) {
        return (SaleEsignV3Personal)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SaleEsignV3Personal::getPsnAccount, (Object)psnAccount)).eq(BaseEntity::getDeleted, (Object)"0"), false));
    }

    @Override
    public SaleEsignV3Personal getByPsnId(String psnId, String elsAccount) {
        return (SaleEsignV3Personal)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SaleEsignV3Personal::getPsnId, (Object)psnId)).eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(BaseEntity::getDeleted, (Object)"0")));
    }

    @Override
    public String getAuth(SaleEsignV3Personal personalData) {
        SaleEsignV3Personal personal = (SaleEsignV3Personal)((Object)this.getById((Serializable)((Object)personalData.getId())));
        if (StrUtil.isNotBlank((CharSequence)personal.getAuthorizedScopes())) {
            List<String> old = Arrays.asList(personal.getAuthorizedScopes().split(","));
            List<String> n = Arrays.asList(personalData.getAuthorizedScopes().split(","));
            ArrayList end = Lists.newArrayList();
            end.addAll(old);
            end.addAll(n);
            personal.setAuthorizedScopes(end.stream().distinct().collect(Collectors.joining(",")));
        } else {
            personal.setAuthorizedScopes(personalData.getAuthorizedScopes());
        }
        PersonalRq.PsnAuthPageConfig psnAuthPageConfig = new PersonalRq.PsnAuthPageConfig();
        BeanUtil.copyProperties((Object)((Object)personal), (Object)psnAuthPageConfig, (String[])new String[0]);
        IpassUtil.setNullValue(psnAuthPageConfig);
        if (StrUtil.isNotBlank((CharSequence)personal.getPsnAvailableAuthModes())) {
            psnAuthPageConfig.setPsnAvailableAuthModes(Arrays.asList(personal.getPsnAvailableAuthModes().split(",")));
        }
        if (StrUtil.isNotBlank((CharSequence)personal.getPsnEditableFields())) {
            psnAuthPageConfig.setPsnEditableFields(Arrays.asList(personal.getPsnEditableFields().split(",")));
        }
        PersonalRq.PsnInfo psnInfo = new PersonalRq.PsnInfo();
        BeanUtil.copyProperties((Object)((Object)personal), (Object)psnInfo, (String[])new String[0]);
        IpassUtil.setNullValue(psnInfo);
        PersonalRq.PsnAuthConfig psnAuthConfig = new PersonalRq.PsnAuthConfig();
        psnAuthConfig.setPsnAccount(personal.getPsnAccount());
        psnAuthConfig.setPsnAuthPageConfig(psnAuthPageConfig);
        psnAuthConfig.setPsnInfo(psnInfo);
        IpassUtil.setNullValue(psnAuthConfig);
        PersonalRq.AuthorizeConfig authConfig = new PersonalRq.AuthorizeConfig();
        if (StrUtil.isNotBlank((CharSequence)personal.getAuthorizedScopes())) {
            authConfig.setAuthorizedScopes(Arrays.asList(personal.getAuthorizedScopes().split(",")));
        }
        String notifyUrl = this.esignV3Properties.getCallBackUrl() + "/esignV3/purchaseEsignV3Personal/noToken/callback";
        PersonalRq personalRq = PersonalRq.builder().psnAuthConfig(psnAuthConfig).authorizeConfig(authConfig).notifyUrl(notifyUrl).build();
        IpassUtil.setNullValue(personalRq);
        AuthRp rp = this.ipassUtil.sendRequest(personalRq, "e3-get-auth-personal", AuthRp.class);
        personal.setAuthFlowId(rp.getAuthFlowId());
        personal.setAuthShortYrl(rp.getAuthShortUrl());
        personal.setAuthUrl(rp.getAuthUrl());
        this.updateById((Object)personal);
        return personal.getAuthUrl();
    }
}

