/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.fadada.dto;

import com.els.modules.electronsign.fadada.dto.FadadaDocDTO;
import com.els.modules.electronsign.fadada.dto.FadadaSignTaskActorDTO;
import com.els.modules.electronsign.fadada.entity.FadadaSignAttachmenPurchase;
import com.els.modules.electronsign.fadada.entity.FadadaSignTaskPurchase;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class FadadaFileSignTaskCreateDTO {
    private OpenId initiator;
    private String signTaskSubject;
    private String signDocType;
    private String expiresTime;
    private boolean autoStart = true;
    private boolean autoFinish = true;
    private String businessTypeId;
    private String catalogId;
    private boolean autoFillFinalize = true;
    private boolean signInOrder = false;
    private String certCAOrg;
    private BusinessScene businessScene;
    private List<FadadaDocDTO> docs;
    private List<Attach> attachs;
    private List<FadadaSignTaskActorDTO> actors;

    public FadadaFileSignTaskCreateDTO(String idType, String openId, String businessId, FadadaSignTaskPurchase fadadaSignTaskPurchase, List<FadadaSignAttachmenPurchase> attachsAttachment) {
        this.initiator = new OpenId(idType, openId);
        if (StringUtils.isNotBlank((CharSequence)businessId)) {
            this.businessScene = new BusinessScene(businessId);
        }
        this.signTaskSubject = fadadaSignTaskPurchase.getSignTaskSubject();
        this.signDocType = fadadaSignTaskPurchase.getSignDocType();
        this.signInOrder = Boolean.valueOf(fadadaSignTaskPurchase.getSignInOrder());
        this.expiresTime = fadadaSignTaskPurchase.getExpiresTime().getTime() + "";
        if (!CollectionUtils.isEmpty(attachsAttachment)) {
            ArrayList<Attach> attachs = new ArrayList<Attach>();
            for (FadadaSignAttachmenPurchase entity : attachsAttachment) {
                Attach attach = new Attach(entity);
                attachs.add(attach);
            }
            this.attachs = attachs;
        }
    }

    public OpenId getInitiator() {
        return this.initiator;
    }

    public String getSignTaskSubject() {
        return this.signTaskSubject;
    }

    public String getSignDocType() {
        return this.signDocType;
    }

    public String getExpiresTime() {
        return this.expiresTime;
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public boolean isAutoFinish() {
        return this.autoFinish;
    }

    public String getBusinessTypeId() {
        return this.businessTypeId;
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public boolean isAutoFillFinalize() {
        return this.autoFillFinalize;
    }

    public boolean isSignInOrder() {
        return this.signInOrder;
    }

    public String getCertCAOrg() {
        return this.certCAOrg;
    }

    public BusinessScene getBusinessScene() {
        return this.businessScene;
    }

    public List<FadadaDocDTO> getDocs() {
        return this.docs;
    }

    public List<Attach> getAttachs() {
        return this.attachs;
    }

    public List<FadadaSignTaskActorDTO> getActors() {
        return this.actors;
    }

    public void setInitiator(OpenId initiator) {
        this.initiator = initiator;
    }

    public void setSignTaskSubject(String signTaskSubject) {
        this.signTaskSubject = signTaskSubject;
    }

    public void setSignDocType(String signDocType) {
        this.signDocType = signDocType;
    }

    public void setExpiresTime(String expiresTime) {
        this.expiresTime = expiresTime;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public void setAutoFinish(boolean autoFinish) {
        this.autoFinish = autoFinish;
    }

    public void setBusinessTypeId(String businessTypeId) {
        this.businessTypeId = businessTypeId;
    }

    public void setCatalogId(String catalogId) {
        this.catalogId = catalogId;
    }

    public void setAutoFillFinalize(boolean autoFillFinalize) {
        this.autoFillFinalize = autoFillFinalize;
    }

    public void setSignInOrder(boolean signInOrder) {
        this.signInOrder = signInOrder;
    }

    public void setCertCAOrg(String certCAOrg) {
        this.certCAOrg = certCAOrg;
    }

    public void setBusinessScene(BusinessScene businessScene) {
        this.businessScene = businessScene;
    }

    public void setDocs(List<FadadaDocDTO> docs) {
        this.docs = docs;
    }

    public void setAttachs(List<Attach> attachs) {
        this.attachs = attachs;
    }

    public void setActors(List<FadadaSignTaskActorDTO> actors) {
        this.actors = actors;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FadadaFileSignTaskCreateDTO)) {
            return false;
        }
        FadadaFileSignTaskCreateDTO other = (FadadaFileSignTaskCreateDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAutoStart() != other.isAutoStart()) {
            return false;
        }
        if (this.isAutoFinish() != other.isAutoFinish()) {
            return false;
        }
        if (this.isAutoFillFinalize() != other.isAutoFillFinalize()) {
            return false;
        }
        if (this.isSignInOrder() != other.isSignInOrder()) {
            return false;
        }
        OpenId this$initiator = this.getInitiator();
        OpenId other$initiator = other.getInitiator();
        if (this$initiator == null ? other$initiator != null : !((Object)this$initiator).equals(other$initiator)) {
            return false;
        }
        String this$signTaskSubject = this.getSignTaskSubject();
        String other$signTaskSubject = other.getSignTaskSubject();
        if (this$signTaskSubject == null ? other$signTaskSubject != null : !this$signTaskSubject.equals(other$signTaskSubject)) {
            return false;
        }
        String this$signDocType = this.getSignDocType();
        String other$signDocType = other.getSignDocType();
        if (this$signDocType == null ? other$signDocType != null : !this$signDocType.equals(other$signDocType)) {
            return false;
        }
        String this$expiresTime = this.getExpiresTime();
        String other$expiresTime = other.getExpiresTime();
        if (this$expiresTime == null ? other$expiresTime != null : !this$expiresTime.equals(other$expiresTime)) {
            return false;
        }
        String this$businessTypeId = this.getBusinessTypeId();
        String other$businessTypeId = other.getBusinessTypeId();
        if (this$businessTypeId == null ? other$businessTypeId != null : !this$businessTypeId.equals(other$businessTypeId)) {
            return false;
        }
        String this$catalogId = this.getCatalogId();
        String other$catalogId = other.getCatalogId();
        if (this$catalogId == null ? other$catalogId != null : !this$catalogId.equals(other$catalogId)) {
            return false;
        }
        String this$certCAOrg = this.getCertCAOrg();
        String other$certCAOrg = other.getCertCAOrg();
        if (this$certCAOrg == null ? other$certCAOrg != null : !this$certCAOrg.equals(other$certCAOrg)) {
            return false;
        }
        BusinessScene this$businessScene = this.getBusinessScene();
        BusinessScene other$businessScene = other.getBusinessScene();
        if (this$businessScene == null ? other$businessScene != null : !((Object)this$businessScene).equals(other$businessScene)) {
            return false;
        }
        List<FadadaDocDTO> this$docs = this.getDocs();
        List<FadadaDocDTO> other$docs = other.getDocs();
        if (this$docs == null ? other$docs != null : !((Object)this$docs).equals(other$docs)) {
            return false;
        }
        List<Attach> this$attachs = this.getAttachs();
        List<Attach> other$attachs = other.getAttachs();
        if (this$attachs == null ? other$attachs != null : !((Object)this$attachs).equals(other$attachs)) {
            return false;
        }
        List<FadadaSignTaskActorDTO> this$actors = this.getActors();
        List<FadadaSignTaskActorDTO> other$actors = other.getActors();
        return !(this$actors == null ? other$actors != null : !((Object)this$actors).equals(other$actors));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FadadaFileSignTaskCreateDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAutoStart() ? 79 : 97);
        result = result * 59 + (this.isAutoFinish() ? 79 : 97);
        result = result * 59 + (this.isAutoFillFinalize() ? 79 : 97);
        result = result * 59 + (this.isSignInOrder() ? 79 : 97);
        OpenId $initiator = this.getInitiator();
        result = result * 59 + ($initiator == null ? 43 : ((Object)$initiator).hashCode());
        String $signTaskSubject = this.getSignTaskSubject();
        result = result * 59 + ($signTaskSubject == null ? 43 : $signTaskSubject.hashCode());
        String $signDocType = this.getSignDocType();
        result = result * 59 + ($signDocType == null ? 43 : $signDocType.hashCode());
        String $expiresTime = this.getExpiresTime();
        result = result * 59 + ($expiresTime == null ? 43 : $expiresTime.hashCode());
        String $businessTypeId = this.getBusinessTypeId();
        result = result * 59 + ($businessTypeId == null ? 43 : $businessTypeId.hashCode());
        String $catalogId = this.getCatalogId();
        result = result * 59 + ($catalogId == null ? 43 : $catalogId.hashCode());
        String $certCAOrg = this.getCertCAOrg();
        result = result * 59 + ($certCAOrg == null ? 43 : $certCAOrg.hashCode());
        BusinessScene $businessScene = this.getBusinessScene();
        result = result * 59 + ($businessScene == null ? 43 : ((Object)$businessScene).hashCode());
        List<FadadaDocDTO> $docs = this.getDocs();
        result = result * 59 + ($docs == null ? 43 : ((Object)$docs).hashCode());
        List<Attach> $attachs = this.getAttachs();
        result = result * 59 + ($attachs == null ? 43 : ((Object)$attachs).hashCode());
        List<FadadaSignTaskActorDTO> $actors = this.getActors();
        result = result * 59 + ($actors == null ? 43 : ((Object)$actors).hashCode());
        return result;
    }

    public String toString() {
        return "FadadaFileSignTaskCreateDTO(initiator=" + this.getInitiator() + ", signTaskSubject=" + this.getSignTaskSubject() + ", signDocType=" + this.getSignDocType() + ", expiresTime=" + this.getExpiresTime() + ", autoStart=" + this.isAutoStart() + ", autoFinish=" + this.isAutoFinish() + ", businessTypeId=" + this.getBusinessTypeId() + ", catalogId=" + this.getCatalogId() + ", autoFillFinalize=" + this.isAutoFillFinalize() + ", signInOrder=" + this.isSignInOrder() + ", certCAOrg=" + this.getCertCAOrg() + ", businessScene=" + this.getBusinessScene() + ", docs=" + this.getDocs() + ", attachs=" + this.getAttachs() + ", actors=" + this.getActors() + ")";
    }

    class Attach {
        private String attachId;
        private String attachName;
        private String attachFileId;

        public Attach(FadadaSignAttachmenPurchase attachmenPurchase) {
            this.attachId = attachmenPurchase.getId();
            this.attachName = attachmenPurchase.getFileName();
            this.attachFileId = attachmenPurchase.getFileId();
        }

        public String getAttachId() {
            return this.attachId;
        }

        public String getAttachName() {
            return this.attachName;
        }

        public String getAttachFileId() {
            return this.attachFileId;
        }

        public void setAttachId(String attachId) {
            this.attachId = attachId;
        }

        public void setAttachName(String attachName) {
            this.attachName = attachName;
        }

        public void setAttachFileId(String attachFileId) {
            this.attachFileId = attachFileId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Attach)) {
                return false;
            }
            Attach other = (Attach)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$attachId = this.getAttachId();
            String other$attachId = other.getAttachId();
            if (this$attachId == null ? other$attachId != null : !this$attachId.equals(other$attachId)) {
                return false;
            }
            String this$attachName = this.getAttachName();
            String other$attachName = other.getAttachName();
            if (this$attachName == null ? other$attachName != null : !this$attachName.equals(other$attachName)) {
                return false;
            }
            String this$attachFileId = this.getAttachFileId();
            String other$attachFileId = other.getAttachFileId();
            return !(this$attachFileId == null ? other$attachFileId != null : !this$attachFileId.equals(other$attachFileId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Attach;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $attachId = this.getAttachId();
            result = result * 59 + ($attachId == null ? 43 : $attachId.hashCode());
            String $attachName = this.getAttachName();
            result = result * 59 + ($attachName == null ? 43 : $attachName.hashCode());
            String $attachFileId = this.getAttachFileId();
            result = result * 59 + ($attachFileId == null ? 43 : $attachFileId.hashCode());
            return result;
        }

        public String toString() {
            return "FadadaFileSignTaskCreateDTO.Attach(attachId=" + this.getAttachId() + ", attachName=" + this.getAttachName() + ", attachFileId=" + this.getAttachFileId() + ")";
        }
    }

    class BusinessScene {
        private String businessId;
        private String transReferenceId;

        public BusinessScene(String businessId) {
            this.businessId = businessId;
        }

        public String getBusinessId() {
            return this.businessId;
        }

        public String getTransReferenceId() {
            return this.transReferenceId;
        }

        public void setBusinessId(String businessId) {
            this.businessId = businessId;
        }

        public void setTransReferenceId(String transReferenceId) {
            this.transReferenceId = transReferenceId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BusinessScene)) {
                return false;
            }
            BusinessScene other = (BusinessScene)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$businessId = this.getBusinessId();
            String other$businessId = other.getBusinessId();
            if (this$businessId == null ? other$businessId != null : !this$businessId.equals(other$businessId)) {
                return false;
            }
            String this$transReferenceId = this.getTransReferenceId();
            String other$transReferenceId = other.getTransReferenceId();
            return !(this$transReferenceId == null ? other$transReferenceId != null : !this$transReferenceId.equals(other$transReferenceId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BusinessScene;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $businessId = this.getBusinessId();
            result = result * 59 + ($businessId == null ? 43 : $businessId.hashCode());
            String $transReferenceId = this.getTransReferenceId();
            result = result * 59 + ($transReferenceId == null ? 43 : $transReferenceId.hashCode());
            return result;
        }

        public String toString() {
            return "FadadaFileSignTaskCreateDTO.BusinessScene(businessId=" + this.getBusinessId() + ", transReferenceId=" + this.getTransReferenceId() + ")";
        }
    }

    class OpenId {
        private String idType = "corp";
        private String openId;

        public OpenId(String idType, String openId) {
            this.idType = idType;
            this.openId = openId;
        }

        public String getIdType() {
            return this.idType;
        }

        public String getOpenId() {
            return this.openId;
        }

        public void setIdType(String idType) {
            this.idType = idType;
        }

        public void setOpenId(String openId) {
            this.openId = openId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OpenId)) {
                return false;
            }
            OpenId other = (OpenId)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$idType = this.getIdType();
            String other$idType = other.getIdType();
            if (this$idType == null ? other$idType != null : !this$idType.equals(other$idType)) {
                return false;
            }
            String this$openId = this.getOpenId();
            String other$openId = other.getOpenId();
            return !(this$openId == null ? other$openId != null : !this$openId.equals(other$openId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OpenId;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $idType = this.getIdType();
            result = result * 59 + ($idType == null ? 43 : $idType.hashCode());
            String $openId = this.getOpenId();
            result = result * 59 + ($openId == null ? 43 : $openId.hashCode());
            return result;
        }

        public String toString() {
            return "FadadaFileSignTaskCreateDTO.OpenId(idType=" + this.getIdType() + ", openId=" + this.getOpenId() + ")";
        }
    }
}

