/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.base.api;

import com.alibaba.fastjson.JSONObject;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.SysUtil;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class WRSendMessageUtil {
    private static final Logger log = LoggerFactory.getLogger(WRSendMessageUtil.class);
    @Resource
    private InterfaceUtil interfaceUtil;
    @Value(value="${message.app-authorization}")
    private String appAuthorization;
    @Value(value="${message.X-HMAC-SIGNATURE}")
    private String xHmacSignature;
    @Value(value="${message.X-HMAC-ACCESS-KEY}")
    private String xHmacAccessKey;
    @Value(value="${message.verification_code}")
    private String verificationCode;
    @Value(value="${message.register_code}")
    private String registerCode;

    public void sendSmsMessage(String msgType, String phone, Object titleContent, Object textContent) {
        try {
            JSONObject resultObj;
            JSONObject headObj = this.buildHeadObj();
            JSONObject bodyParamObj = new JSONObject();
            bodyParamObj.put("type", (Object)"3");
            bodyParamObj.put("templateCode", (Object)("0".equals(msgType) ? this.verificationCode : this.registerCode));
            bodyParamObj.put("receive", (Object)phone);
            bodyParamObj.put("receiveName", (Object)"");
            JSONObject paramObj = new JSONObject();
            if ("0".equals(msgType)) {
                paramObj.put("code", textContent);
            } else if ("1".equals(msgType)) {
                paramObj = (JSONObject)textContent;
                this.replaceKey(paramObj, "contactsName", "code1");
                this.replaceKey(paramObj, "purchaseName", "code2");
                this.replaceKey(paramObj, "supplierName", "code3");
                this.replaceKey(paramObj, "elsAccount", "code4");
                this.replaceKey(paramObj, "subAccount", "code5");
                this.replaceKey(paramObj, "password", "code6");
            }
            bodyParamObj.put("param", (Object)paramObj);
            JSONObject jsonObject = this.interfaceUtil.callInterface(SysUtil.getPurchaseAccount(), "", "smsMessage", headObj, null, bodyParamObj, null);
            if (jsonObject.containsKey((Object)"code") && "200".equals(jsonObject.getString("code")) && !"0000".equals((resultObj = JSONObject.parseObject((String)jsonObject.getString("result"))).getString("code"))) {
                log.error("\u53d1\u9001\u65f6\u95f4\uff1a" + System.currentTimeMillis() + "\uff0c\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff1a" + resultObj.getString("msg"));
            }
        }
        catch (Exception e) {
            log.error("\u77ed\u4fe1\u63a5\u53e3\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    private JSONObject buildHeadObj() {
        JSONObject headParamObj = new JSONObject();
        headParamObj.put("app-authorization", (Object)this.appAuthorization);
        headParamObj.put("X-DATE", (Object)new Date());
        headParamObj.put("X-HMAC-SIGNATURE", (Object)this.xHmacSignature);
        headParamObj.put("X-HMAC-ACCESS-KEY", (Object)this.xHmacAccessKey);
        return headParamObj;
    }

    private void replaceKey(JSONObject jsonObj, String oldKey, String newKey) {
        Object value = jsonObj.remove((Object)oldKey);
        jsonObj.put(newKey, value);
    }
}

