/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;

public class Base64Util {
    private static final Base64.Decoder DECODER_64 = Base64.getDecoder();
    private static final Base64.Encoder ENCODER_64 = Base64.getEncoder();
    private static final Integer DPI = 200;
    private static final String CODE_FORMATE = "UTF-8";

    public static String textToBase64Str(String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return text;
        }
        String encodedToStr = null;
        try {
            encodedToStr = ENCODER_64.encodeToString(text.getBytes(CODE_FORMATE));
        }
        catch (UnsupportedEncodingException e) {
            e.getMessage();
        }
        return encodedToStr;
    }

    public static String base64StrToText(String base64Str) {
        if (StringUtils.isBlank((CharSequence)base64Str)) {
            return base64Str;
        }
        String byteToText = null;
        try {
            byteToText = new String(DECODER_64.decode(base64Str), CODE_FORMATE);
        }
        catch (UnsupportedEncodingException e) {
            e.getMessage();
        }
        return byteToText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String fileToBase64Str(File file) throws IOException {
        String base64Str = null;
        FileInputStream fin = null;
        BufferedInputStream bin = null;
        ByteArrayOutputStream baos = null;
        FilterOutputStream bout = null;
        try {
            fin = new FileInputStream(file);
            bin = new BufferedInputStream(fin);
            baos = new ByteArrayOutputStream();
            bout = new BufferedOutputStream(baos);
            byte[] buffer = new byte[1024];
            int len = bin.read(buffer);
            while (len != -1) {
                ((BufferedOutputStream)bout).write(buffer, 0, len);
                len = bin.read(buffer);
            }
            ((BufferedOutputStream)bout).flush();
            byte[] bytes = baos.toByteArray();
            base64Str = ENCODER_64.encodeToString(bytes).trim();
        }
        catch (IOException e) {
            e.getMessage();
        }
        finally {
            try {
                fin.close();
                bin.close();
                bout.close();
            }
            catch (IOException e) {
                e.getMessage();
            }
        }
        return base64Str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void base64ContentToFile(String base64Content, String filePath) throws IOException {
        BufferedInputStream bis = null;
        FileOutputStream fos = null;
        FilterOutputStream bos = null;
        try {
            byte[] bytes = DECODER_64.decode(base64Content);
            ByteArrayInputStream byteInputStream = new ByteArrayInputStream(bytes);
            bis = new BufferedInputStream(byteInputStream);
            File file = new File(filePath);
            File path = file.getParentFile();
            if (!path.exists()) {
                path.mkdirs();
            }
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            byte[] buffer = new byte[1024];
            int length = bis.read(buffer);
            while (length != -1) {
                ((BufferedOutputStream)bos).write(buffer, 0, length);
                length = bis.read(buffer);
            }
            ((BufferedOutputStream)bos).flush();
        }
        catch (IOException e) {
            e.getMessage();
        }
        finally {
            try {
                bis.close();
                fos.close();
                bos.close();
            }
            catch (IOException e) {
                e.getMessage();
            }
        }
    }
}

