/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.extend.api.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.els.common.aspect.annotation.Dict;
import com.els.common.excel.DictEntity;
import com.els.common.excel.Excel;
import com.els.common.excel.ExcelCollection;
import com.els.common.excel.ExcelCollectionEntity;
import com.els.common.excel.ExcelEntity;
import com.els.common.excel.ExcelExportClassColumnDTO;
import com.els.common.excel.ExcelExportDTO;
import com.els.common.excel.service.BaseExportService;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.ConvertUtils;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.enumerate.PurchaseReportParamEnum;
import com.els.modules.extend.api.service.MDTKExcelExportRpcService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopContext;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.env.Environment;

public abstract class MDTKBaseExportServiceImpl<T, V, P>
implements MDTKExcelExportRpcService {
    private static final Logger log = LoggerFactory.getLogger(MDTKBaseExportServiceImpl.class);
    String limit = ((Environment)SpringContextUtils.getBean(Environment.class)).getProperty("els.config.export.limit");

    protected int syncCountLimit() {
        if (CharSequenceUtil.isEmpty((CharSequence)this.limit)) {
            return 2000;
        }
        return Integer.parseInt(this.limit);
    }

    private BaseExportService<T, V, P> getTargetService(Object beanInstance) {
        if (!AopUtils.isAopProxy((Object)beanInstance)) {
            return (BaseExportService)beanInstance;
        }
        return (BaseExportService)AopContext.currentProxy();
    }

    private Object getTarget(Object beanInstance) {
        if (!AopUtils.isAopProxy((Object)beanInstance)) {
            return beanInstance;
        }
        if (AopUtils.isCglibProxy((Object)beanInstance)) {
            try {
                Field h = beanInstance.getClass().getDeclaredField("CGLIB$CALLBACK_0");
                h.setAccessible(true);
                Object dynamicAdvisedInterceptor = h.get(beanInstance);
                Field advised = dynamicAdvisedInterceptor.getClass().getDeclaredField("advised");
                advised.setAccessible(true);
                Object tar = ((AdvisedSupport)advised.get(dynamicAdvisedInterceptor)).getTargetSource().getTarget();
                return this.getTarget(tar);
            }
            catch (Exception e) {
                log.error(":::\u83b7\u53d6\u4ee3\u7406\u6e90\u5bf9\u8c61\u5f02\u5e38 ==> {}", (Object)e.getMessage());
                return beanInstance;
            }
        }
        return beanInstance;
    }

    private Class getTClass(int index) {
        ParameterizedType type = (ParameterizedType)this.getTarget(this).getClass().getGenericSuperclass();
        return (Class)type.getActualTypeArguments()[index];
    }

    protected void exportSelectionsFilter(Map<String, String[]> parameterMap, QueryWrapper<T> queryWrapper, T entity) {
        String[] selectionArray = parameterMap.get("selections");
        List<String> selectionList = null;
        if (null == selectionArray || selectionArray.length == 0) {
            try {
                JSONObject object = (JSONObject)JSON.parseObject((String)JSON.toJSONString(entity), JSONObject.class);
                selectionList = (List<String>)object.getObject("selections", List.class);
            }
            catch (Exception object) {}
        } else {
            String selections = selectionArray[0];
            if (ConvertUtils.isNotEmpty((Object)selections)) {
                selectionList = Arrays.asList(selections.split(","));
            }
        }
        if (CollUtil.isEmpty(selectionList)) {
            return;
        }
        queryWrapper.clear();
        queryWrapper.in((Object)"id", (Collection)selectionList);
        QueryGenerator.doMultiFieldsOrder(queryWrapper, parameterMap, entity);
    }

    protected boolean idFilter(Map<String, String[]> parameterMap) {
        List<String> selectionList;
        String[] selectionArray = parameterMap.get("selections");
        if (null == selectionArray || selectionArray.length == 0) {
            return false;
        }
        String selections = selectionArray[0];
        return ConvertUtils.isNotEmpty((Object)selections) && CollUtil.isNotEmpty(selectionList = Arrays.asList(selections.split(",")));
    }

    protected QueryWrapper<T> builderWrapper(Map<String, Object> map, Map<String, String[]> requestMap) {
        Object o = map.get(PurchaseReportParamEnum.ENTITY.getValue());
        String jsonObj = JSON.toJSONString((Object)o);
        if (this.doQueryWrapperFiler()) {
            Object entity = JSON.parseObject((String)jsonObj, (Class)this.getTClass(0));
            return this.buildWrapper(entity, requestMap);
        }
        return null;
    }

    protected String builderWrapper(Map<String, Object> map, Map<String, String[]> requestMap, Integer pageNumber, Integer pageSize, BaseMapper<T> mapper) {
        Object o = map.get(PurchaseReportParamEnum.ENTITY.getValue());
        String jsonObj = JSON.toJSONString((Object)o);
        if (this.doQueryWrapperFiler()) {
            Object entity = JSON.parseObject((String)jsonObj, (Class)this.getTClass(0));
            QueryWrapper<Object> queryWrapper = this.buildWrapper(entity, requestMap);
            queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
            Page page = new Page((long)pageNumber.intValue(), (long)pageSize.intValue());
            List records = ((Page)mapper.selectPage((IPage)page, queryWrapper)).getRecords();
            return JSON.toJSONString((Object)records);
        }
        return null;
    }

    protected String builderWrapper(Map<String, Object> map, Map<String, String[]> requestMap, Integer pageNumber, Integer pageSize, IService<T> mapper) {
        Object o = map.get(PurchaseReportParamEnum.ENTITY.getValue());
        String jsonObj = JSON.toJSONString((Object)o);
        if (this.doQueryWrapperFiler()) {
            Object entity = JSON.parseObject((String)jsonObj, (Class)this.getTClass(0));
            QueryWrapper<Object> queryWrapper = this.buildWrapper(entity, requestMap);
            queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
            Page page = new Page((long)pageNumber.intValue(), (long)pageSize.intValue());
            List records = ((Page)mapper.page((IPage)page, queryWrapper)).getRecords();
            return JSON.toJSONString((Object)records);
        }
        return null;
    }

    public QueryWrapper<T> buildWrapper(T entity, Map<String, String[]> requestMap) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper(entity, requestMap);
        this.exportSelectionsFilter(requestMap, queryWrapper, entity);
        return queryWrapper;
    }

    protected boolean doQueryWrapperFiler() {
        return true;
    }

    public abstract List<V> queryExportData(QueryWrapper<T> var1, P var2, Map<String, String[]> var3);

    public abstract long queryExportDataCount(QueryWrapper<T> var1, P var2, Map<String, String[]> var3);

    public abstract String getBusinessType();

    public abstract String getBeanName();

    public ExcelExportDTO builderExcelEntityList(List<V> dataList, Class<V> clazz) {
        List<ExcelExportClassColumnDTO> column = this.buildExcelExportData(clazz, null, null);
        return new ExcelExportDTO(column, JSON.toJSONString(dataList));
    }

    public static List<Field> getClassFields(Class<?> clazz) {
        ArrayList<Field> list = new ArrayList<Field>();
        do {
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                list.add(fields[i]);
            }
        } while ((clazz = clazz.getSuperclass()) != Object.class && clazz != null);
        return list;
    }

    public List<ExcelExportClassColumnDTO> buildExcelExportData(Class<?> clazz, List<ExcelExportClassColumnDTO> result, Set<String> typeList) {
        List<Field> fields = MDTKBaseExportServiceImpl.getClassFields(clazz);
        if (result == null) {
            result = new ArrayList<ExcelExportClassColumnDTO>(fields.size());
        }
        if (typeList == null) {
            typeList = Sets.newHashSet();
        }
        typeList.add(clazz.getSimpleName().toLowerCase());
        for (Field field : fields) {
            if (field.getName().equals("serialVersionUID")) continue;
            ExcelExportClassColumnDTO dto = new ExcelExportClassColumnDTO();
            if (Collection.class.isAssignableFrom(field.getType())) {
                dto.setExcelCollection(this.buildCollection(field.getAnnotation(ExcelCollection.class)));
                dto.setCollection(Boolean.valueOf(true));
                ArrayList childrenList = Lists.newArrayList();
                ParameterizedType stringListType = (ParameterizedType)field.getGenericType();
                Type[] actualTypeArguments = stringListType.getActualTypeArguments();
                if (null == actualTypeArguments || actualTypeArguments.length == 0) continue;
                Class childrenClass = (Class)actualTypeArguments[0];
                if (!typeList.contains(childrenClass.getSimpleName().toLowerCase())) {
                    this.buildExcelExportData(childrenClass, childrenList, typeList);
                }
                dto.setFileType(field.getType().getSimpleName().toLowerCase());
                dto.setChildren((List)childrenList);
            } else {
                dto.setFileType(field.getType().getSimpleName().toLowerCase());
                dto.setExcel(this.buildExcel(field.getAnnotation(Excel.class)));
                dto.setDict(this.buildDict(field.getAnnotation(Dict.class)));
            }
            dto.setFileName(field.getName());
            typeList.add(dto.getFileType());
            result.add(dto);
        }
        return result;
    }

    protected ExcelEntity buildExcel(Excel annotation) {
        if (null == annotation) {
            return null;
        }
        ExcelEntity excelEntity = new ExcelEntity();
        excelEntity.buildExcelEntity(annotation);
        return excelEntity;
    }

    protected DictEntity buildDict(Dict annotation) {
        if (null == annotation) {
            return null;
        }
        DictEntity dictEntity = new DictEntity();
        dictEntity.buildDictEntity(annotation);
        return dictEntity;
    }

    protected ExcelCollectionEntity buildCollection(ExcelCollection annotation) {
        if (null == annotation) {
            return null;
        }
        ExcelCollectionEntity collectionEntity = new ExcelCollectionEntity();
        collectionEntity.buildCollectionEntity(annotation);
        return collectionEntity;
    }
}

