/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.template.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.ListColumnQueryBuilder;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.attachment.storage.service.FileStoreSignService;
import com.els.modules.template.entity.TemplateConfigHead;
import com.els.modules.template.entity.TemplateConfigItem;
import com.els.modules.template.entity.TemplateGroup;
import com.els.modules.template.entity.TemplateHead;
import com.els.modules.template.enumerate.TemplateStatusEnum;
import com.els.modules.template.service.TemplateConfigHeadService;
import com.els.modules.template.service.TemplateConfigItemService;
import com.els.modules.template.service.TemplateGroupService;
import com.els.modules.template.service.TemplateHeadService;
import com.els.modules.template.util.ConfigPageGeneJsUtil;
import com.els.modules.template.vo.TemplateHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/template/templateHead02"})
@Api(tags={"\u4e1a\u52a1\u6a21\u677f\u914d\u7f6e"})
public class TemplateHeadController02
extends BaseController<TemplateHead, TemplateHeadService> {
    private static final Logger log = LoggerFactory.getLogger(TemplateHeadController02.class);
    @Autowired
    private TemplateHeadService templateHeadService;
    @Autowired
    private TemplateGroupService templateGroupService;
    @Autowired
    private TemplateConfigHeadService templateConfigHeadService;
    @Autowired
    private TemplateConfigItemService templateConfigItemService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private RedisUtil redisUtil;
    @Resource(name="fileStoreSignServiceImpl")
    private FileStoreSignService fileStoreSignServiceImpl;
    @Value(value="${els.path.upload}")
    private String uploadpath;
    private String fileServerType = "local";
    private Pattern pattern = Pattern.compile("\\$\\{([^}]+)}");

    @AutoLog(value="\u4e1a\u52a1\u6a21\u677f-\u6279\u91cf\u751f\u6210\u914d\u7f6e")
    @ApiOperation(value="\u6279\u91cf\u751f\u6210\u914d\u7f6e", notes="\u6279\u91cf\u751f\u6210\u914d\u7f6e")
    @GetMapping(value={"/noToken/batchGenerateConfigTest"})
    public Result<?> batchGenerateConfigTest() {
        QueryWrapper templateHeadQueryWrapper = new QueryWrapper();
        templateHeadQueryWrapper.eq((Object)"els_account", (Object)"100000");
        templateHeadQueryWrapper.eq((Object)"is_deleted", (Object)"0");
        List list = this.templateHeadService.list((Wrapper)templateHeadQueryWrapper);
        List templateIds = list.stream().map(p -> p.getId()).collect(Collectors.toList());
        List templateHeadList = this.templateHeadService.listByIds(templateIds);
        List cancelList = templateHeadList.stream().filter(x -> TemplateStatusEnum.CANCEL.getValue().equals(x.getTemplateStatus())).collect(Collectors.toList());
        templateHeadList.removeAll(cancelList);
        List newTemplateIds = templateHeadList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        String cancelNumber = cancelList.stream().map(TemplateHead::getTemplateNumber).collect(Collectors.joining(","));
        if (CollUtil.isEmpty(newTemplateIds)) {
            throw new ELSBootException(cancelNumber + I18nUtil.translate((String)"i18n_alert_IrIOkur_28cc9928", (String)"\u6a21\u677f\u5df2\u7ecf\u4f5c\u5e9f\u4e86"));
        }
        Map templateGroupMap = ListColumnQueryBuilder.batchQueryByColumnListToMap(newTemplateIds, Function.identity(), TemplateGroup::getHeadId, wrapper -> this.templateGroupService.list((Wrapper)wrapper), null, (List)Lists.newArrayList((Object[])new ListColumnQueryBuilder.SortColumn[]{ListColumnQueryBuilder.SortColumn.builder(TemplateGroup::getSortOrder, (boolean)false)}));
        Map templateConfigHeadMap = ListColumnQueryBuilder.batchQueryByColumnListToMap(newTemplateIds, Function.identity(), TemplateConfigHead::getHeadId, wrapper -> this.templateConfigHeadService.list((Wrapper)wrapper), null, (List)Lists.newArrayList((Object[])new ListColumnQueryBuilder.SortColumn[]{ListColumnQueryBuilder.SortColumn.builder(TemplateConfigHead::getSortOrder, (boolean)false)}));
        Map templateConfigItemMap = ListColumnQueryBuilder.batchQueryByColumnListToMap(newTemplateIds, Function.identity(), TemplateConfigItem::getHeadId, wrapper -> this.templateConfigItemService.list((Wrapper)wrapper), null, (List)Lists.newArrayList((Object[])new ListColumnQueryBuilder.SortColumn[]{ListColumnQueryBuilder.SortColumn.builder(TemplateConfigItem::getSortOrder, (boolean)false)}));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"business_type", (Object)"enterprise");
        queryWrapper.eq((Object)"els_account", (Object)"100000");
        queryWrapper.eq((Object)"is_default_type", (Object)"1");
        List headList = this.templateHeadService.list((Wrapper)queryWrapper);
        ArrayList successIds = Lists.newArrayList();
        ArrayList cacheKeys = Lists.newArrayList();
        for (TemplateHead templateHead : templateHeadList) {
            TemplateHeadVO headVO = new TemplateHeadVO();
            BeanUtils.copyProperties((Object)((Object)templateHead), (Object)headVO);
            headVO.setTemplateConfigHeadList((List)ObjectUtil.defaultIfNull(templateConfigHeadMap.get(templateHead.getId()), (Object)Lists.newArrayList()));
            headVO.setTemplateConfigItemList((List)ObjectUtil.defaultIfNull(templateConfigItemMap.get(templateHead.getId()), (Object)Lists.newArrayList()));
            headVO.setTemplateGroupList((List)ObjectUtil.defaultIfNull(templateGroupMap.get(templateHead.getId()), (Object)Lists.newArrayList()));
            if ("supplierMasterData".equals(headVO.getBusinessType())) {
                List supplierMasterDataTemplateGroupList = headVO.getTemplateGroupList();
                if (!supplierMasterDataTemplateGroupList.isEmpty() && supplierMasterDataTemplateGroupList.size() > 0) {
                    Object trag = false;
                    for (TemplateGroup group : supplierMasterDataTemplateGroupList) {
                        if (!"enterpriseForm".equals(group.getGroupCode())) continue;
                        trag = true;
                        break;
                    }
                    if (!((Boolean)trag).booleanValue()) {
                        this.supplierMasterDataTemplateDealOnBatch(headList, headVO);
                    }
                } else {
                    this.supplierMasterDataTemplateDealOnBatch(headList, headVO);
                }
                for (TemplateConfigHead templateConfigHead : headVO.getTemplateConfigHeadList()) {
                    if (!"enterpriseForm".equals(templateConfigHead.getGroupCode())) continue;
                    if ("elsAccount".equals(templateConfigHead.getFieldName())) {
                        templateConfigHead.setFieldName("toElsAccount");
                    }
                    templateConfigHead.setPurchaseEdit("0");
                    templateConfigHead.setSaleEdit("0");
                }
            }
            this.setCompute(headVO.getTemplateConfigItemList());
            String savePathDir = this.uploadpath + File.separator + "js" + File.separator + TenantContext.getTenant();
            try {
                ConfigPageGeneJsUtil.generatorJs((String)savePathDir, (TemplateHeadVO)headVO);
                successIds.add(headVO.getId());
                StringBuilder redisKey = new StringBuilder("srm:template:").append(this.getTenantId()).append(":").append(headVO.getTemplateNumber()).append(":").append(headVO.getTemplateVersion());
                cacheKeys.add(redisKey.toString());
            }
            catch (Exception e) {
                log.error(":::\u4e1a\u52a1\u6a21\u677f\u751f\u6210\u5f02\u5e38,id:{}===>{}", (Object)headVO.getId(), (Object)e.getMessage());
            }
        }
        if (CollUtil.isEmpty((Collection)successIds)) {
            throw new ELSBootException(cancelNumber + I18nUtil.translate((String)"i18n_alert_IrbLKm_32d4d23", (String)"\u6a21\u677f\u751f\u6210\u5931\u8d25!"));
        }
        LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)updateWrapper.set(TemplateHead::getTemplateStatus, (Object)TemplateStatusEnum.GENERATED.getValue())).in(BaseEntity::getId, (Collection)successIds);
        this.templateHeadService.update((Wrapper)updateWrapper);
        this.redisUtil.del(cacheKeys.toArray(new String[0]));
        String msg = "\u6279\u91cf\u751f\u6210\u914d\u7f6e\u6210\u529f";
        if (StrUtil.isNotEmpty((CharSequence)cancelNumber)) {
            msg = msg + "\uff0c\u5176\u4e2d" + cancelNumber + "\u5df2\u7ecf\u4f5c\u5e9f";
        }
        return Result.ok((String)msg);
    }

    public void supplierMasterDataTemplateDeal(@RequestBody TemplateHeadVO headVO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"business_type", (Object)"enterprise");
        queryWrapper.eq((Object)"els_account", (Object)"100000");
        queryWrapper.eq((Object)"is_default_type", (Object)"1");
        List headList = this.templateHeadService.list((Wrapper)queryWrapper);
        if (!headList.isEmpty()) {
            String id = ((TemplateHead)((Object)headList.get(0))).getId();
            List templateGroupList = this.templateGroupService.selectByMainId(id);
            templateGroupList.addAll(headVO.getTemplateGroupList());
            headVO.setTemplateGroupList(templateGroupList);
            List templateConfigHeadList = this.templateConfigHeadService.selectByMainId(id);
            for (TemplateConfigHead templateConfigHead : templateConfigHeadList) {
                if (templateConfigHead.getFieldName().equals("elsAccount")) {
                    templateConfigHead.setFieldName("toElsAccount");
                }
                templateConfigHead.setPurchaseEdit("0");
                templateConfigHead.setSaleEdit("0");
            }
            templateConfigHeadList.addAll(headVO.getTemplateConfigHeadList());
            headVO.setTemplateConfigHeadList(templateConfigHeadList);
        }
    }

    public void supplierMasterDataTemplateDealOnBatch(List<TemplateHead> headList, TemplateHeadVO headVO) {
        if (!headList.isEmpty()) {
            String id = headList.get(0).getId();
            ArrayList templateGroupList = Lists.newArrayList((Iterable)this.templateGroupService.selectByMainId(id));
            templateGroupList.addAll(headVO.getTemplateGroupList());
            headVO.setTemplateGroupList((List)templateGroupList);
            ArrayList templateConfigHeadList = Lists.newArrayList((Iterable)this.templateConfigHeadService.selectByMainId(id));
            for (TemplateConfigHead templateConfigHead : templateConfigHeadList) {
                if (templateConfigHead.getFieldName().equals("elsAccount")) {
                    templateConfigHead.setFieldName("toElsAccount");
                }
                templateConfigHead.setPurchaseEdit("0");
                templateConfigHead.setSaleEdit("0");
            }
            templateConfigHeadList.addAll(headVO.getTemplateConfigHeadList());
            headVO.setTemplateConfigHeadList((List)templateConfigHeadList);
        }
    }

    private void setCompute(List<TemplateConfigItem> itemList) {
        if (CollectionUtil.isNotEmpty(itemList)) {
            List formulaList = itemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getFormula())).collect(Collectors.toList());
            HashMap<String, Boolean> computeMap = new HashMap<String, Boolean>();
            for (TemplateConfigItem item2 : formulaList) {
                Matcher matcher = this.pattern.matcher(item2.getFormula());
                while (matcher.find()) {
                    computeMap.put(matcher.group(1), true);
                }
            }
            for (TemplateConfigItem item2 : itemList) {
                if (computeMap.get(item2.getFieldName()) == null || !((Boolean)computeMap.get(item2.getFieldName())).booleanValue()) continue;
                item2.setCompute("1");
            }
        }
    }

    @AutoLog(value="\u4e1a\u52a1\u6a21\u677f-\u5347\u7ea7\u7248\u672c")
    @ApiOperation(value="\u5347\u7ea7\u7248\u672c", notes="\u5347\u7ea7\u7248\u672c")
    @GetMapping(value={"/upgradeVersion"})
    @RequiresPermissions(value={"template#templateHead:upgradeVersion"})
    public Result<?> upgradeVersion(@RequestParam(name="id") String id) {
        this.templateHeadService.upgradeVersion(id);
        return this.commonSuccessResult(3);
    }

    @SrmValidated
    @AutoLog(value="\u4e1a\u52a1\u6a21\u677f-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"template#templateHead:edit"})
    public Result<?> edit(@RequestBody TemplateHeadVO templateHeadPage) {
        TemplateHead templateHead = new TemplateHead();
        BeanUtils.copyProperties((Object)templateHeadPage, (Object)((Object)templateHead));
        this.templateHeadService.updateMain(templateHead, templateHeadPage.getTemplateGroupList(), templateHeadPage.getTemplateConfigHeadList(), templateHeadPage.getTemplateConfigItemList());
        return Result.ok((Object)((Object)templateHead));
    }

    @AutoLog(value="\u4e1a\u52a1\u6a21\u677f-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"template#templateHead:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.templateHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"template#templateHead:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        TemplateHead templateHead = (TemplateHead)((Object)this.templateHeadService.getById((Serializable)((Object)id)));
        TemplateHeadVO templateHeadVO = new TemplateHeadVO();
        BeanUtils.copyProperties((Object)((Object)templateHead), (Object)templateHeadVO);
        List templateGroupList = this.templateGroupService.selectByMainId(id);
        templateHeadVO.setTemplateGroupList(templateGroupList);
        List templateConfigHeadList = this.templateConfigHeadService.selectByMainId(id);
        templateHeadVO.setTemplateConfigHeadList(templateConfigHeadList);
        List templateConfigItemList = this.templateConfigItemService.selectByMainId(id);
        templateHeadVO.setTemplateConfigItemList(templateConfigItemList);
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        templateHeadVO.setPurchaseAttachmentList(purchaseAttachmentList);
        return Result.ok((Object)templateHeadVO);
    }

    @AutoLog(value="\u4e1a\u52a1\u6a21\u677f-\u5bfc\u51fa")
    @GetMapping(value={"/exportJson"})
    @RequiresPermissions(value={"template#templateHead:exportJson"})
    public Result<?> exportJson(TemplateHead templateHead, HttpServletRequest req, HttpServletResponse res) throws Exception {
        this.templateHeadService.exportJson(templateHead, req, res);
        return Result.ok((String)"\u5bfc\u51fa\u6210\u529f");
    }

    @AutoLog(value="\u4e1a\u52a1\u6a21\u677f-\u5bfc\u5165")
    @PostMapping(value={"/importJson"})
    @RequiresPermissions(value={"template#templateHead:importJson"})
    public Result<?> importJson(HttpServletRequest req) {
        try {
            int ch;
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)req;
            Map fileMap = multipartRequest.getFileMap();
            MultipartFile file = (MultipartFile)fileMap.get("file");
            InputStream inputStream = file.getInputStream();
            InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
            StringBuffer stringBuffer = new StringBuffer();
            while ((ch = ((Reader)reader).read()) != -1) {
                stringBuffer.append((char)ch);
            }
            ((Reader)reader).close();
            int length = stringBuffer.length();
            if (length == 0) {
                return Result.error((String)I18nUtil.translate((String)"i18n_alert_uNWFxOLV_bb53e337", (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!"));
            }
            String jsonString = stringBuffer.toString();
            List headVOList = JSON.parseArray((String)jsonString, TemplateHeadVO.class);
            if (headVOList.isEmpty()) {
                return Result.error((String)I18nUtil.translate((String)"i18n_alert_uNWFxOLV_bb53e337", (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!"));
            }
            this.templateHeadService.importJson(headVOList);
        }
        catch (Exception e) {
            log.error("\u5bfc\u5165Json\u6570\u636e\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_importJson_errorText", (String)"\u6587\u4ef6\u683c\u5f0f\u6709\u8bef\u6216\u8005\u6587\u4ef6\u7684json\u6570\u636e\u538b\u7f29\u6709\u8bef\uff0cjson\u8f6c\u4e49\u5931\u8d25!"));
        }
        return Result.ok();
    }

    @ApiOperation(value="\u901a\u8fc7\u4e1a\u52a1\u7f16\u7801\u67e5\u8be2100000\u53f7\u914d\u7f6e\u7cfb\u7edf\u7ea7\u4fe1\u606f", notes="\u901a\u8fc7\u4e1a\u52a1\u7f16\u7801\u67e5\u8be2100000\u53f7\u914d\u7f6e\u7cfb\u7edf\u7ea7\u4fe1\u606f")
    @GetMapping(value={"/querySysByBusinessType"})
    @RequiresPermissions(value={"template#templateHead:add"})
    public Result<?> querySysByBusinessType(@RequestParam(name="businessType") String businessType) {
        List templateConfigItemList;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"business_type", (Object)businessType);
        queryWrapper.eq((Object)"els_account", (Object)"100000");
        queryWrapper.eq((Object)"is_default_type", (Object)"1");
        List headList = this.templateHeadService.list((Wrapper)queryWrapper);
        if (headList.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_LYuWWWWWWERAcWWWWWWWjWF_504c6e16", (String)"\u672a\u627e\u5230100000\u914d\u7f6e\u7c7b\u578b\uff1a[${0}]\u7684\u6570\u636e", (String[])new String[]{businessType}));
        }
        String id = ((TemplateHead)((Object)headList.get(0))).getId();
        TemplateHead templateHead = (TemplateHead)((Object)this.templateHeadService.getById((Serializable)((Object)id)));
        TemplateHeadVO templateHeadVO = new TemplateHeadVO();
        BeanUtils.copyProperties((Object)((Object)templateHead), (Object)templateHeadVO);
        List templateGroupList = this.templateGroupService.selectByMainId(id);
        templateHeadVO.setTemplateGroupList(templateGroupList);
        List templateConfigHeadList = this.templateConfigHeadService.selectByMainId(id);
        if (!templateConfigHeadList.isEmpty()) {
            List configHeadList = templateConfigHeadList.parallelStream().filter(vo -> "1".equals(vo.getSys())).collect(Collectors.toList());
            templateHeadVO.setTemplateConfigHeadList(configHeadList);
        }
        if (!(templateConfigItemList = this.templateConfigItemService.selectByMainId(id)).isEmpty()) {
            List configItemList = templateConfigItemList.parallelStream().filter(vo -> "1".equals(vo.getSys())).collect(Collectors.toList());
            templateHeadVO.setTemplateConfigItemList(configItemList);
        }
        return Result.ok((Object)templateHeadVO);
    }

    @ApiOperation(value="\u901a\u8fc7\u4e1a\u52a1\u7f16\u7801\u67e5\u8be2100000\u53f7\u914d\u7f6e\u8868\u5934\u5b57\u6bb5\uff08\u9664\u7cfb\u7edf\u7ea7\u5b57\u6bb5\u5916\uff09", notes="\u901a\u8fc7\u4e1a\u52a1\u7f16\u7801\u67e5\u8be2100000\u53f7\u914d\u7f6e\u8868\u5934\u5b57\u6bb5\uff08\u9664\u7cfb\u7edf\u7ea7\u5b57\u6bb5\u5916\uff09")
    @GetMapping(value={"/queryHeadFieldsByBusinessType"})
    @RequiresPermissions(value={"template#templateHead:base"})
    public Result<?> queryHeadFieldsByBusinessType(@RequestParam(name="businessType") String businessType) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"business_type", (Object)businessType);
        queryWrapper.eq((Object)"is_default_type", (Object)"1");
        queryWrapper.eq((Object)"els_account", (Object)"100000");
        List headList = this.templateHeadService.list((Wrapper)queryWrapper);
        if (headList.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_LYuWWWWWWERAcWWWWWWWjWF_504c6e16", (String)"\u672a\u627e\u5230100000\u914d\u7f6e\u7c7b\u578b\uff1a[${0}],\u6a21\u677f\u540d\u4e3a\uff1a\u6807\u51c6\u7c7b\u578b\u7684\u914d\u7f6e", (String[])new String[]{businessType}));
        }
        String id = ((TemplateHead)((Object)headList.get(0))).getId();
        TemplateHead templateHead = (TemplateHead)((Object)this.templateHeadService.getById((Serializable)((Object)id)));
        TemplateHeadVO templateHeadVO = new TemplateHeadVO();
        BeanUtils.copyProperties((Object)((Object)templateHead), (Object)templateHeadVO);
        List templateConfigHeadList = this.templateConfigHeadService.selectByMainId(id);
        if (!templateConfigHeadList.isEmpty()) {
            List configHeadList = templateConfigHeadList.parallelStream().filter(vo -> !"1".equals(vo.getSys())).collect(Collectors.toList());
            templateHeadVO.setTemplateConfigHeadList(configHeadList);
        }
        return Result.ok((Object)templateHeadVO);
    }

    @ApiOperation(value="\u901a\u8fc7\u4e1a\u52a1\u7f16\u7801\u67e5\u8be2100000\u53f7\u914d\u7f6e\u8868\u884c\u5b57\u6bb5\uff08\u9664\u7cfb\u7edf\u7ea7\u5b57\u6bb5\u5916\uff09", notes="\u901a\u8fc7\u4e1a\u52a1\u7f16\u7801\u67e5\u8be2100000\u53f7\u914d\u7f6e\u8868\u884c\u5b57\u6bb5\uff08\u9664\u7cfb\u7edf\u7ea7\u5b57\u6bb5\u5916\uff09")
    @GetMapping(value={"/queryItemFieldsByBusinessType"})
    @RequiresPermissions(value={"template#templateHead:base"})
    public Result<?> queryItemFieldsByBusinessType(@RequestParam(name="businessType") String businessType) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"business_type", (Object)businessType);
        queryWrapper.eq((Object)"is_default_type", (Object)"1");
        queryWrapper.eq((Object)"els_account", (Object)"100000");
        List headList = this.templateHeadService.list((Wrapper)queryWrapper);
        if (headList.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u672a\u627e\u5230100000\u914d\u7f6e\u7c7b\u578b\uff1a[${0}],\u6a21\u677f\u540d\u4e3a\uff1a\u6807\u51c6\u7c7b\u578b\u7684\u914d\u7f6e", (String[])new String[]{businessType}));
        }
        String id = ((TemplateHead)((Object)headList.get(0))).getId();
        TemplateHead templateHead = (TemplateHead)((Object)this.templateHeadService.getById((Serializable)((Object)id)));
        TemplateHeadVO templateHeadVO = new TemplateHeadVO();
        BeanUtils.copyProperties((Object)((Object)templateHead), (Object)templateHeadVO);
        List templateConfigItemList = this.templateConfigItemService.selectByMainId(id);
        templateHeadVO.setTemplateConfigItemList(templateConfigItemList);
        return Result.ok((Object)templateHeadVO);
    }

    @ApiOperation(value="\u901a\u8fc7\u4e1a\u52a1\u6a21\u677f\u914d\u7f6eid\u67e5\u8be2\u4e1a\u52a1\u6a21\u677f\u5206\u7ec4", notes="\u901a\u8fc7\u4e1a\u52a1\u6a21\u677f\u914d\u7f6eid\u67e5\u8be2\u4e1a\u52a1\u6a21\u677f\u5206\u7ec4")
    @GetMapping(value={"/queryTemplateGroupByMainId"})
    @RequiresPermissions(value={"template#templateHead:base"})
    public Result<?> queryTemplateGroupListByMainId(@RequestParam(name="id") String id) {
        List templateGroupList = this.templateGroupService.selectByMainId(id);
        return Result.ok((Object)templateGroupList);
    }

    @ApiOperation(value="\u901a\u8fc7\u4e1a\u52a1\u6a21\u677f\u914d\u7f6eid\u67e5\u8be2\u4e1a\u52a1\u6a21\u677f\u914d\u7f6e\u4fe1\u606f\u8868", notes="\u901a\u8fc7\u4e1a\u52a1\u6a21\u677f\u914d\u7f6eid\u67e5\u8be2\u4e1a\u52a1\u6a21\u677f\u914d\u7f6e\u4fe1\u606f\u8868")
    @GetMapping(value={"/queryTemplateConfigHeadByMainId"})
    @RequiresPermissions(value={"template#templateHead:base"})
    public Result<?> queryTemplateConfigHeadListByMainId(@RequestParam(name="id") String id) {
        List templateConfigHeadList = this.templateConfigHeadService.selectByMainId(id);
        return Result.ok((Object)templateConfigHeadList);
    }

    @ApiOperation(value="\u901a\u8fc7\u4e1a\u52a1\u6a21\u677f\u914d\u7f6eid\u67e5\u8be2\u4e1a\u52a1\u6a21\u677f\u914d\u7f6e\u884c\u4fe1\u606f\u8868", notes="\u901a\u8fc7\u4e1a\u52a1\u6a21\u677f\u914d\u7f6eid\u67e5\u8be2\u4e1a\u52a1\u6a21\u677f\u914d\u7f6e\u884c\u4fe1\u606f\u8868")
    @GetMapping(value={"/queryTemplateConfigItemByMainId"})
    @RequiresPermissions(value={"template#templateHead:base"})
    public Result<?> queryTemplateConfigItemListByMainId(@RequestParam(name="id") String id) {
        List templateConfigItemList = this.templateConfigItemService.selectByMainId(id);
        return Result.ok((Object)templateConfigItemList);
    }

    @GetMapping(value={"/addTempleI18nKey"})
    @RequiresPermissions(value={"template#templateHead:addTempleI18nKey"})
    public Result<?> addTempleI18nKey() {
        this.templateHeadService.addTempleI18nKey();
        return this.commonSuccessResult(3);
    }
}

