/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.extend.api.controller;

import com.els.common.api.vo.Result;
import com.els.common.system.base.controller.BaseController;
import com.els.common.util.Assert;
import com.els.common.util.I18nUtil;
import com.els.modules.extend.api.service.IntegratedDocumentApiService;
import com.els.modules.integrated.api.dto.IntegratedDocumentDTO;
import com.els.modules.integrated.controller.IntegratedDocumentController;
import com.els.modules.integrated.entity.IntegratedDocument;
import com.els.modules.integrated.service.IntegratedDocumentService;
import io.swagger.annotations.Api;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/integratedDocumentApi"})
@Api(tags={"\u5355\u636e\u8054\u67e5\u5b58\u50a8Controller"})
public class IntegratedDocumentApiController
extends BaseController<IntegratedDocument, IntegratedDocumentService> {
    private static final Logger log = LoggerFactory.getLogger(IntegratedDocumentController.class);
    @Resource
    @Lazy
    private IntegratedDocumentApiService integratedDocumentRpcService;

    @PostMapping(value={"/getDetail"})
    @RequiresPermissions(value={"integrated#integratedDocument:getDetail"})
    public Result<?> getDetail(@RequestBody IntegratedDocumentDTO document) {
        Assert.isNotBlank((String)document.getId(), (String)I18nUtil.translate((String)"i18n_alert_WWxOLV_de170bab", (String)"id\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.isNotBlank((String)document.getRootId(), (String)I18nUtil.translate((String)"i18n_alert_WWWWWWxOLV_bcd1c72d", (String)"rootId\u4e0d\u80fd\u4e3a\u7a7a"));
        Map<String, Object> result = this.integratedDocumentRpcService.getDetail(document);
        return Result.ok(result);
    }
}

