/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.extend.api.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.Assert;
import com.els.common.util.I18nUtil;
import com.els.modules.bidding.api.dto.PurchaseBiddingHeadDTO;
import com.els.modules.contract.dto.PurchaseContractHeadDTO;
import com.els.modules.delivery.api.dto.PurchaseDeliveryHeadDTO;
import com.els.modules.delivery.api.dto.PurchaseDeliveryNoticeDTO;
import com.els.modules.delivery.api.dto.PurchaseRefundsDeliveryHeadDTO;
import com.els.modules.delivery.api.dto.PurchaseVoucherHeadDTO;
import com.els.modules.demand.api.dto.PurchaseRequestHeadDTO;
import com.els.modules.ebidding.api.dto.PurchaseEbiddingHeadDTO;
import com.els.modules.extend.api.enumerate.IntegratedDocumentApiEnum;
import com.els.modules.extend.api.service.IntegratedDocumentApiService;
import com.els.modules.finance.api.dto.PurchaseAddCostDTO;
import com.els.modules.finance.api.dto.PurchaseDeductCostDTO;
import com.els.modules.finance.api.dto.PurchasePaymentApplyHeadDTO;
import com.els.modules.inquiry.api.dto.PurchaseEnquiryHeadDTO;
import com.els.modules.integrated.api.dto.IntegratedDocumentDTO;
import com.els.modules.integrated.entity.IntegratedDocument;
import com.els.modules.integrated.entity.IntegratedDocumentOutDTO;
import com.els.modules.integrated.mapper.IntegratedBusinessDataMapper;
import com.els.modules.integrated.mapper.IntegratedDocumentMapper;
import com.els.modules.integrated.rpc.service.IntegratedInvokeContractRpcService;
import com.els.modules.integrated.rpc.service.IntegratedInvokeFinanceRpcService;
import com.els.modules.integrated.rpc.service.IntegratedInvokeInquiryRpcService;
import com.els.modules.integrated.rpc.service.IntegratedInvokeOrderRpcService;
import com.els.modules.order.api.dto.PurchaseOrderHeadDTO;
import com.els.modules.reconciliation.api.dto.PurchaseInvoiceDTO;
import com.els.modules.reconciliation.api.dto.PurchaseReconciliationDTO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class IntegratedDocumentApiServiceImpl
extends BaseServiceImpl<IntegratedDocumentMapper, IntegratedDocument>
implements IntegratedDocumentApiService {
    @Resource
    private IntegratedDocumentMapper integratedDocumentMapper;
    @Resource
    @Lazy
    private IntegratedInvokeInquiryRpcService integratedInvokeInquiryRpcService;
    @Resource
    @Lazy
    private IntegratedInvokeContractRpcService integratedInvokeContractRpcService;
    @Resource
    @Lazy
    private IntegratedInvokeOrderRpcService integratedInvokeOrderRpcService;
    @Resource
    @Lazy
    private IntegratedInvokeFinanceRpcService integratedInvokeFinanceRpcService;
    @Resource
    private IntegratedBusinessDataMapper integratedBusinessDataMapper;
    private static Object rootId = null;

    @Override
    public Map<String, Object> getDetail(IntegratedDocumentDTO integratedDocumentDTO) {
        IntegratedDocument integratedDocument = new IntegratedDocument();
        BeanUtils.copyProperties((Object)integratedDocumentDTO, (Object)integratedDocument);
        IntegratedDocument document = this.integratedDocumentMapper.selectById(integratedDocument.getId());
        Assert.isNotNull((Object)document, (String)I18nUtil.translate((String)"i18n_alert_PSqmAjtFKmVH_adbc0cc5", (String)"\u6682\u65e0\u53ef\u67e5\u770b\u7684\u5355\u636e\u8054\u67e5\u4fe1\u606f"));
        Assert.isNotNull((Object)document.getLinks(), (String)I18nUtil.translate((String)"i18n_alert_PSqmAjtFKmVH_adbc0cc5", (String)"\u6682\u65e0\u53ef\u67e5\u770b\u7684\u5355\u636e\u8054\u67e5\u4fe1\u606f"));
        ArrayList<Map<String, Object>> nodeList = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> tempList = new ArrayList<Map<String, Object>>();
        JSONArray jsonLinks = new JSONArray();
        this.log.error("\u8fdb\u5165\u8282\u70b9\u4fe1\u606f\u67e5\u8be2\u7ec4\u88c5");
        if (StringUtils.isNotBlank((CharSequence)document.getBetweenId())) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(IntegratedDocument::getBetweenId, (Object)document.getBetweenId());
            List integratedDocumentList = this.integratedDocumentMapper.selectList((Wrapper)queryWrapper);
            integratedDocumentList.forEach(tempDocument -> {
                IntegratedDocumentOutDTO outDTO = new IntegratedDocumentOutDTO();
                BeanUtils.copyProperties((Object)tempDocument, (Object)outDTO);
                Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)outDTO), Map.class);
                this.getNodes(map, integratedDocument, nodeList, tempList);
                jsonLinks.addAll((Collection)JSONObject.parseArray((String)tempDocument.getLinks().toString()));
                rootId = map.get(IntegratedDocumentApiEnum.PAYMENT_APPLY_HEAD_ID.getValue());
            });
        } else {
            IntegratedDocumentOutDTO outDTO = new IntegratedDocumentOutDTO();
            BeanUtils.copyProperties((Object)document, (Object)outDTO);
            Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)outDTO), Map.class);
            this.log.error("\u8fdb\u5165\u8282\u70b9\u4fe1\u606f\u67e5\u8be2\u7ec4\u88c5-------->map:" + map.toString());
            this.getNodes(map, integratedDocument, nodeList, tempList);
            this.log.error("\u8fdb\u5165\u8282\u70b9\u4fe1\u606f\u67e5\u8be2\u7ec4\u88c5-------->links:" + document.getLinks().toString());
            jsonLinks.addAll((Collection)JSONObject.parseArray((String)document.getLinks().toString()));
            rootId = map.containsKey(IntegratedDocumentApiEnum.REQUEST_HEAD_ID.getValue()) ? map.get(IntegratedDocumentApiEnum.REQUEST_HEAD_ID.getValue()) : map.get(IntegratedDocumentApiEnum.ORDER_HEAD_ID.getValue());
        }
        nodeList.addAll(tempList);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("rootId", rootId);
        data.put("nodes", nodeList);
        data.put("links", jsonLinks);
        return data;
    }

    private String getSourceNumber(String key, String value) {
        String sourceNumber = null;
        int var5 = -1;
        switch (key.hashCode()) {
            case -1935399829: {
                if (!key.equals("deductCostId")) break;
                var5 = 12;
                break;
            }
            case -1739442904: {
                if (!key.equals("invoiceId")) break;
                var5 = 13;
                break;
            }
            case -1100697762: {
                if (!key.equals("reconciliationId")) break;
                var5 = 10;
                break;
            }
            case -1018697794: {
                if (!key.equals("inqueryHeadId")) break;
                var5 = 1;
                break;
            }
            case -990012528: {
                if (!key.equals("purchaseDeliveryHeadId")) break;
                var5 = 7;
                break;
            }
            case -461790775: {
                if (!key.equals("addCostId")) break;
                var5 = 11;
                break;
            }
            case 303832937: {
                if (!key.equals("voucherHeadId")) break;
                var5 = 9;
                break;
            }
            case 623789773: {
                if (!key.equals("contractHeadId")) break;
                var5 = 4;
                break;
            }
            case 821356810: {
                if (!key.equals("refundsDeliveryHeadId")) break;
                var5 = 8;
                break;
            }
            case 928749095: {
                if (!key.equals("deliveryNoticeId")) break;
                var5 = 6;
                break;
            }
            case 1074157194: {
                if (!key.equals("requestHeadId")) break;
                var5 = 0;
                break;
            }
            case 1209648758: {
                if (!key.equals("biddingHeadId")) break;
                var5 = 3;
                break;
            }
            case 1301291017: {
                if (!key.equals("orderHeadId")) break;
                var5 = 5;
                break;
            }
            case 1687835185: {
                if (!key.equals("ebiddingHeadId")) break;
                var5 = 2;
                break;
            }
            case 1718131267: {
                if (!key.equals("paymentApplyHeadId")) break;
                var5 = 14;
            }
        }
        switch (var5) {
            case 0: {
                PurchaseRequestHeadDTO purchaseRequestHead = this.integratedInvokeInquiryRpcService.getRequestHeadById(value);
                sourceNumber = purchaseRequestHead.getRequestNumber();
                break;
            }
            case 1: {
                PurchaseEnquiryHeadDTO purchaseEnquiryHead = this.integratedInvokeInquiryRpcService.getEnquiryHeadById(value);
                sourceNumber = purchaseEnquiryHead.getEnquiryNumber();
                break;
            }
            case 2: {
                PurchaseEbiddingHeadDTO purchaseEbiddingHead = this.integratedInvokeInquiryRpcService.getEbinddingHeadById(value);
                sourceNumber = purchaseEbiddingHead.getEbiddingNumber();
                break;
            }
            case 3: {
                PurchaseBiddingHeadDTO purchaseBiddingHead = this.integratedInvokeInquiryRpcService.getBiddingHeadById(value);
                sourceNumber = purchaseBiddingHead.getBiddingNumber();
                break;
            }
            case 4: {
                PurchaseContractHeadDTO purchaseContractHeadDTO = this.integratedInvokeContractRpcService.getContractHeadHeadById(value);
                sourceNumber = purchaseContractHeadDTO.getContractNumber();
                break;
            }
            case 5: {
                PurchaseOrderHeadDTO purchaseOrderHeadDTO = this.integratedInvokeOrderRpcService.getOrderHeadById(value);
                sourceNumber = purchaseOrderHeadDTO.getOrderNumber();
                break;
            }
            case 6: {
                PurchaseDeliveryNoticeDTO purchaseDeliveryNotice = this.integratedInvokeOrderRpcService.getDeliveryNoticeById(value);
                sourceNumber = purchaseDeliveryNotice.getNoticeNumber();
                break;
            }
            case 7: {
                PurchaseDeliveryHeadDTO purchaseDeliveryHead = this.integratedInvokeOrderRpcService.getDeliveryHeadById(value);
                sourceNumber = purchaseDeliveryHead.getDeliveryNumber();
                break;
            }
            case 8: {
                PurchaseRefundsDeliveryHeadDTO purchaseRefundsDeliveryHead = this.integratedInvokeOrderRpcService.getRefundsDeliveryHeadById(value);
                sourceNumber = purchaseRefundsDeliveryHead.getRefundsDeliveryNumber();
                break;
            }
            case 9: {
                PurchaseVoucherHeadDTO purchaseVoucherHead = this.integratedInvokeOrderRpcService.getVoucherHeadById(value);
                sourceNumber = purchaseVoucherHead.getVoucherNumber();
                break;
            }
            case 10: {
                PurchaseReconciliationDTO purchaseReconciliation = this.integratedInvokeFinanceRpcService.getReconciliationHeadById(value);
                sourceNumber = purchaseReconciliation.getReconciliationNumber();
                break;
            }
            case 11: {
                PurchaseAddCostDTO purchaseAddCostDTO = this.integratedInvokeFinanceRpcService.getAddCostHeadById(value);
                sourceNumber = purchaseAddCostDTO.getCostNumber();
                break;
            }
            case 12: {
                PurchaseDeductCostDTO purchaseDeductCostDTO = this.integratedInvokeFinanceRpcService.getDeductCostHeadById(value);
                sourceNumber = purchaseDeductCostDTO.getDeductNumber();
                break;
            }
            case 13: {
                PurchaseInvoiceDTO purchaseInvoiceDTO = this.integratedInvokeFinanceRpcService.getInvoiceById(value);
                sourceNumber = purchaseInvoiceDTO.getInvoiceNumber();
                break;
            }
            case 14: {
                PurchasePaymentApplyHeadDTO purchasePaymentApplyHeadDTO = this.integratedInvokeFinanceRpcService.getPaymentApplyHeadById(value);
                sourceNumber = purchasePaymentApplyHeadDTO.getPaymentApplyNumber();
            }
        }
        return sourceNumber;
    }

    private void delNode(String type, String childId, IntegratedDocument document) {
        List<String> nodes = null;
        int var7 = -1;
        switch (type.hashCode()) {
            case -1935399829: {
                if (!type.equals("deductCostId")) break;
                var7 = 11;
                break;
            }
            case -1739442904: {
                if (!type.equals("invoiceId")) break;
                var7 = 12;
                break;
            }
            case -1100697762: {
                if (!type.equals("reconciliationId")) break;
                var7 = 9;
                break;
            }
            case -1018697794: {
                if (!type.equals("inqueryHeadId")) break;
                var7 = 0;
                break;
            }
            case -990012528: {
                if (!type.equals("purchaseDeliveryHeadId")) break;
                var7 = 6;
                break;
            }
            case -461790775: {
                if (!type.equals("addCostId")) break;
                var7 = 10;
                break;
            }
            case 303832937: {
                if (!type.equals("voucherHeadId")) break;
                var7 = 8;
                break;
            }
            case 623789773: {
                if (!type.equals("contractHeadId")) break;
                var7 = 3;
                break;
            }
            case 821356810: {
                if (!type.equals("refundsDeliveryHeadId")) break;
                var7 = 7;
                break;
            }
            case 928749095: {
                if (!type.equals("deliveryNoticeId")) break;
                var7 = 5;
                break;
            }
            case 1209648758: {
                if (!type.equals("biddingHeadId")) break;
                var7 = 2;
                break;
            }
            case 1301291017: {
                if (!type.equals("orderHeadId")) break;
                var7 = 4;
                break;
            }
            case 1687835185: {
                if (!type.equals("ebiddingHeadId")) break;
                var7 = 1;
                break;
            }
            case 1718131267: {
                if (!type.equals("paymentApplyHeadId")) break;
                var7 = 13;
            }
        }
        switch (var7) {
            case 0: {
                if (!StringUtils.isNotBlank((CharSequence)document.getInqueryHeadId())) break;
                nodes = Arrays.stream(document.getInqueryHeadId().split(",")).collect(Collectors.toList());
                document.setInqueryHeadId(this.removeBusinessId(nodes, childId));
                break;
            }
            case 1: {
                if (!StringUtils.isNotBlank((CharSequence)document.getEbiddingHeadId())) break;
                nodes = Arrays.stream(document.getEbiddingHeadId().split(",")).collect(Collectors.toList());
                document.setEbiddingHeadId(this.removeBusinessId(nodes, childId));
                break;
            }
            case 2: {
                if (!StringUtils.isNotBlank((CharSequence)document.getBiddingHeadId())) break;
                nodes = Arrays.stream(document.getBiddingHeadId().split(",")).collect(Collectors.toList());
                document.setBiddingHeadId(this.removeBusinessId(nodes, childId));
                break;
            }
            case 3: {
                if (!StringUtils.isNotBlank((CharSequence)document.getContractHeadId())) break;
                nodes = Arrays.stream(document.getContractHeadId().split(",")).collect(Collectors.toList());
                document.setContractHeadId(this.removeBusinessId(nodes, childId));
                break;
            }
            case 4: {
                if (!StringUtils.isNotBlank((CharSequence)document.getOrderHeadId())) break;
                nodes = Arrays.stream(document.getOrderHeadId().split(",")).collect(Collectors.toList());
                document.setOrderHeadId(this.removeBusinessId(nodes, childId));
                break;
            }
            case 5: {
                if (!StringUtils.isNotBlank((CharSequence)document.getDeliveryNoticeId())) break;
                nodes = Arrays.stream(document.getDeliveryNoticeId().split(",")).collect(Collectors.toList());
                document.setDeliveryNoticeId(this.removeBusinessId(nodes, childId));
                break;
            }
            case 6: {
                if (!StringUtils.isNotBlank((CharSequence)document.getPurchaseDeliveryHeadId())) break;
                nodes = Arrays.stream(document.getPurchaseDeliveryHeadId().split(",")).collect(Collectors.toList());
                document.setPurchaseDeliveryHeadId(this.removeBusinessId(nodes, childId));
                break;
            }
            case 7: {
                if (!StringUtils.isNotBlank((CharSequence)document.getRefundsDeliveryHeadId())) break;
                nodes = Arrays.stream(document.getRefundsDeliveryHeadId().split(",")).collect(Collectors.toList());
                document.setRefundsDeliveryHeadId(this.removeBusinessId(nodes, childId));
                break;
            }
            case 8: {
                if (!StringUtils.isNotBlank((CharSequence)document.getVoucherHeadId())) break;
                nodes = Arrays.stream(document.getVoucherHeadId().split(",")).collect(Collectors.toList());
                document.setVoucherHeadId(this.removeBusinessId(nodes, childId));
                break;
            }
            case 9: {
                if (!StringUtils.isNotBlank((CharSequence)document.getReconciliationId())) break;
                nodes = Arrays.stream(document.getReconciliationId().split(",")).collect(Collectors.toList());
                document.setReconciliationId(this.removeBusinessId(nodes, childId));
                break;
            }
            case 10: {
                if (!StringUtils.isNotBlank((CharSequence)document.getAddCostId())) break;
                nodes = Arrays.stream(document.getAddCostId().split(",")).collect(Collectors.toList());
                document.setAddCostId(this.removeBusinessId(nodes, childId));
                break;
            }
            case 11: {
                if (!StringUtils.isNotBlank((CharSequence)document.getDeductCostId())) break;
                nodes = Arrays.stream(document.getDeductCostId().split(",")).collect(Collectors.toList());
                document.setDeductCostId(this.removeBusinessId(nodes, childId));
                break;
            }
            case 12: {
                if (!StringUtils.isNotBlank((CharSequence)document.getInvoiceId())) break;
                nodes = Arrays.stream(document.getInvoiceId().split(",")).collect(Collectors.toList());
                document.setInvoiceId(this.removeBusinessId(nodes, childId));
                break;
            }
            case 13: {
                if (!StringUtils.isNotBlank((CharSequence)document.getPaymentApplyHeadId())) break;
                nodes = Arrays.stream(document.getPaymentApplyHeadId().split(",")).collect(Collectors.toList());
                document.setPaymentApplyHeadId(this.removeBusinessId(nodes, childId));
            }
        }
    }

    private String removeBusinessId(List<String> stringList, String childId) {
        Iterator<String> iterator = stringList.iterator();
        while (iterator.hasNext()) {
            if (!childId.equals(iterator.next())) continue;
            iterator.remove();
        }
        return StringUtils.join(stringList, (String)",");
    }

    private void setSourceId(String type, String childId, IntegratedDocument document) {
        int var5 = -1;
        switch (type.hashCode()) {
            case -1935399829: {
                if (!type.equals("deductCostId")) break;
                var5 = 11;
                break;
            }
            case -1739442904: {
                if (!type.equals("invoiceId")) break;
                var5 = 12;
                break;
            }
            case -1100697762: {
                if (!type.equals("reconciliationId")) break;
                var5 = 9;
                break;
            }
            case -1018697794: {
                if (!type.equals("inqueryHeadId")) break;
                var5 = 0;
                break;
            }
            case -990012528: {
                if (!type.equals("purchaseDeliveryHeadId")) break;
                var5 = 6;
                break;
            }
            case -461790775: {
                if (!type.equals("addCostId")) break;
                var5 = 10;
                break;
            }
            case 303832937: {
                if (!type.equals("voucherHeadId")) break;
                var5 = 8;
                break;
            }
            case 623789773: {
                if (!type.equals("contractHeadId")) break;
                var5 = 3;
                break;
            }
            case 821356810: {
                if (!type.equals("refundsDeliveryHeadId")) break;
                var5 = 7;
                break;
            }
            case 928749095: {
                if (!type.equals("deliveryNoticeId")) break;
                var5 = 5;
                break;
            }
            case 1209648758: {
                if (!type.equals("biddingHeadId")) break;
                var5 = 2;
                break;
            }
            case 1301291017: {
                if (!type.equals("orderHeadId")) break;
                var5 = 4;
                break;
            }
            case 1687835185: {
                if (!type.equals("ebiddingHeadId")) break;
                var5 = 1;
                break;
            }
            case 1718131267: {
                if (!type.equals("paymentApplyHeadId")) break;
                var5 = 13;
            }
        }
        switch (var5) {
            case 0: {
                document.setInqueryHeadId(childId);
                break;
            }
            case 1: {
                document.setEbiddingHeadId(childId);
                break;
            }
            case 2: {
                document.setBiddingHeadId(childId);
                break;
            }
            case 3: {
                document.setContractHeadId(childId);
                break;
            }
            case 4: {
                document.setOrderHeadId(childId);
                break;
            }
            case 5: {
                document.setDeliveryNoticeId(childId);
                break;
            }
            case 6: {
                document.setPurchaseDeliveryHeadId(childId);
                break;
            }
            case 7: {
                document.setRefundsDeliveryHeadId(childId);
                break;
            }
            case 8: {
                document.setVoucherHeadId(childId);
                break;
            }
            case 9: {
                document.setReconciliationId(childId);
                break;
            }
            case 10: {
                document.setAddCostId(childId);
                break;
            }
            case 11: {
                document.setDeductCostId(childId);
                break;
            }
            case 12: {
                document.setInvoiceId(childId);
                break;
            }
            case 13: {
                document.setPaymentApplyHeadId(childId);
            }
        }
    }

    private void getNodes(Map<String, Object> map, IntegratedDocument integratedDocument, List<Map<String, Object>> nodeList, List<Map<String, Object>> tempList) {
        Iterator<String> var5 = map.keySet().iterator();
        while (var5.hasNext()) {
            HashMap<String, Object> node;
            String k = var5.next();
            Object v = map.get(k);
            if (v.equals("") || v.equals("null")) continue;
            this.log.error("\u8fdb\u5165\u8282\u70b9\u4fe1\u606fgetNodes:" + k + ":" + v);
            if (k.equals(IntegratedDocumentApiEnum.REQUEST_HEAD_ID.getValue()) && !v.toString().contains(",")) {
                node = new HashMap<String, Object>();
                node.put("id", v);
                node.put("text", IntegratedDocumentApiEnum.getDesc(k) + "\n" + this.getSourceNumber(k, v.toString()));
                node.put("url", IntegratedDocumentApiEnum.getUrl(k));
                node.put("apiPath", IntegratedDocumentApiEnum.getApiPath(k));
                nodeList.add(node);
                continue;
            }
            if (k.equals(IntegratedDocumentApiEnum.ORDER_HEAD_ID.getValue()) && !v.toString().contains(",")) {
                node = new HashMap();
                node.put("id", v);
                node.put("text", IntegratedDocumentApiEnum.getDesc(k) + "\n" + this.getSourceNumber(k, v.toString()));
                node.put("url", IntegratedDocumentApiEnum.getUrl(k));
                node.put("apiPath", IntegratedDocumentApiEnum.getApiPath(k));
                nodeList.add(node);
                continue;
            }
            List<Object> values = new ArrayList<String>();
            if (v.toString().contains(",")) {
                values = Arrays.asList(v.toString().split(","));
            } else {
                values.add(v.toString());
            }
            String finalK = k;
            values.forEach(value -> {
                HashMap<String, Object> tempNode = new HashMap<String, Object>();
                if (value.equals(integratedDocument.getRootId())) {
                    tempNode.put("styleClass", "my-node-style");
                }
                tempNode.put("id", value);
                tempNode.put("text", IntegratedDocumentApiEnum.getDesc(finalK) + "\n" + this.getSourceNumber(finalK, (String)value));
                tempNode.put("url", IntegratedDocumentApiEnum.getUrl(finalK));
                tempNode.put("apiPath", IntegratedDocumentApiEnum.getApiPath(finalK));
                tempList.add(tempNode);
            });
        }
        return;
    }
}

