/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.extend.api.utils;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.dto.ThirdAuthDTO;
import com.els.modules.base.api.dto.CompanyInterfaceConfigDTO;
import com.els.modules.extend.api.ResultDTO;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InterfaceUtilNew
extends InterfaceUtil {
    private static final Logger log = LoggerFactory.getLogger(InterfaceUtilNew.class);
    @Autowired
    private RedisUtil redisUtil;
    private static final String PREFIX = "erpToken";
    private long time = 300L;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;

    public String getTokenByErp() {
        return this.getTokenByErp(false);
    }

    public String getTokenByErp(boolean refresh) {
        String erpToken = (String)this.redisUtil.get(PREFIX);
        if (!refresh && StringUtils.isNotBlank((CharSequence)erpToken)) {
            return erpToken;
        }
        String elsAccount = SysUtil.getPurchaseAccount();
        JSONObject param = this.buildTokenParam(elsAccount);
        try {
            JSONObject result = this.callInterface(elsAccount, null, param, null);
            ResultDTO resultData = (ResultDTO)JSON.parseObject((String)JSON.toJSONString((Object)result.get((Object)"result")), ResultDTO.class);
            String data = resultData.getData();
            if (StringUtils.isBlank((CharSequence)data)) {
                throw new ELSBootException("\u83b7\u53d6ERP token\u4fe1\u606f\u5f02\u5e38\u8bf7\u8054\u7cfbSRM\u7ba1\u7406\u5458!");
            }
            this.redisUtil.set(PREFIX, (Object)data, this.time);
            erpToken = data;
        }
        catch (Exception e) {
            log.error("get token error : {} ", (Object)e.getMessage());
        }
        return erpToken + "";
    }

    public JSONObject callInterface(String elsAccount, String companyCode, JSONObject param, Object custom) {
        JSONObject resultObj = this.callInterface(elsAccount, param);
        Object code = resultObj.get((Object)"code");
        if ("500".equals(code + "")) {
            throw new ELSBootException(resultObj.get((Object)"message") + "");
        }
        ResultDTO result = (ResultDTO)JSON.parseObject((String)JSON.toJSONString((Object)resultObj.get((Object)"result")), ResultDTO.class);
        if (-1 == result.getCode() && "token\u89e3\u6790\u5931\u8d25".equals(result.getMsg())) {
            String token = this.getTokenByErp(true);
            JSONObject object = (JSONObject)JSON.parseObject((String)JSON.toJSONString((Object)param.get((Object)"body")), JSONObject.class);
            object.put("accessToken", (Object)token);
            param.put("body", (Object)object);
            resultObj = this.callInterface(elsAccount, param);
        }
        return resultObj;
    }

    public JSONObject callInterface(String elsAccount, String srmInterfaceCode, JSONObject param) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("bus_account", (Object)elsAccount);
        jsonObject.put("srm_interface_code", (Object)srmInterfaceCode);
        jsonObject.put("body", (Object)param);
        String token = this.getTokenByErp();
        param.put("accessToken", (Object)token);
        return this.callInterface(elsAccount, null, jsonObject, null);
    }

    private JSONObject buildTokenParam(String elsAccount) {
        JSONObject object = new JSONObject();
        object.put("appid", (Object)"srm");
        object.put("password", (Object)"srm");
        String srmInterfaceCode = "getAccessToken";
        JSONObject param = new JSONObject();
        param.put("bus_account", (Object)elsAccount);
        param.put("srm_interface_code", (Object)srmInterfaceCode);
        param.put("body", (Object)object);
        return param;
    }

    public JSONObject callInterface(String elsAccount, JSONObject param) {
        int timeout = 60000;
        this.transitionInterfaceCode(elsAccount, null, param);
        JSONObject authObj = this.getAuthObj(elsAccount);
        StringBuilder url = new StringBuilder(authObj.getString("appUrl"));
        url.append("/els/openApi/invoke");
        log.info("request data , {}", (Object)JSON.toJSONString((Object)param));
        String result = ((HttpRequest)HttpRequest.post((String)url.toString()).header("token", authObj.getString("token"))).setReadTimeout(timeout).body(param.toJSONString()).execute().body();
        log.info("response data , {}", (Object)result);
        return JSONObject.parseObject((String)result);
    }

    private JSONObject getAuthObj(String elsAccount) {
        JSONObject authObj = (JSONObject)this.redisUtil.get("sys:thirdAuth:interfaceToken:" + elsAccount);
        if (authObj != null) {
            return authObj;
        }
        try {
            ThirdAuthDTO authDTO = this.invokeAccountRpcService.getThirdAuthByType(elsAccount, "0");
            if (authDTO == null) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_LERyVUEUiVHWDjKm_7a11f01d", (String)"\u672a\u914d\u7f6e\u63a5\u53e3\u5e73\u53f0\u51ed\u8bc1\u4fe1\u606f\uff0c\u8c03\u7528\u5931\u8d25\uff01"));
            }
            StringBuilder url = new StringBuilder(authDTO.getAppUrl());
            url.append("/els/openApi/getToken").append("?key=").append(authDTO.getAppKey()).append("&secret=").append(authDTO.getAppSecret());
            String result = HttpUtil.get((String)url.toString());
            JSONObject resultObj = JSONObject.parseObject((String)result);
            int code = resultObj.getIntValue("code");
            if (code == 200) {
                authObj = new JSONObject();
                String token = resultObj.getJSONObject("result").getString("token");
                long expiresIn = resultObj.getJSONObject("result").getLongValue("expiresIn");
                authObj.put("token", (Object)token);
                authObj.put("appUrl", (Object)authDTO.getAppUrl());
                this.redisUtil.set("sys:thirdAuth:interfaceToken:" + elsAccount, (Object)authObj, expiresIn - 200L);
                return authObj;
            }
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_SMyVUEWWWWWKm_4471fbd3", (String)"\u83b7\u53d6\u63a5\u53e3\u5e73\u53f0token\u5931\u8d25\uff01"));
        }
        catch (Exception var11) {
            log.error("InterfaceUtil_getToken_failed:", (Throwable)var11);
            throw var11;
        }
    }

    private String transitionInterfaceCode(String elsAccount, String companyCode, JSONObject param) {
        String srmInterfaceCode = param.getString("srm_interface_code");
        if (StrUtil.isBlank((CharSequence)srmInterfaceCode)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WWWCxyVAoxOLVW_92454e57", (String)"SRM\u5185\u90e8\u63a5\u53e3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        CompanyInterfaceConfigDTO configDTO = null;
        if (StrUtil.isBlank((CharSequence)companyCode)) {
            configDTO = ((InvokeBaseRpcService)SpringContextUtils.getBean(InvokeBaseRpcService.class)).getCompanyInterfaceConfigByCode(elsAccount, srmInterfaceCode);
        } else {
            configDTO = ((InvokeBaseRpcService)SpringContextUtils.getBean(InvokeBaseRpcService.class)).getCompanyInterfaceConfigByCode(elsAccount, srmInterfaceCode, companyCode);
            if (configDTO == null) {
                configDTO = ((InvokeBaseRpcService)SpringContextUtils.getBean(InvokeBaseRpcService.class)).getCompanyInterfaceConfigByCode(elsAccount, srmInterfaceCode);
            }
        }
        if (configDTO == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WWWCxyVAoWWWWWWWLYuIdjERVHWDjKm_db33664", (String)"SRM\u5185\u90e8\u63a5\u53e3\u7f16\u7801:[${0}]\u672a\u627e\u5230\u5bf9\u5e94\u7684\u914d\u7f6e\u4fe1\u606f\uff0c\u8c03\u7528\u5931\u8d25\uff01", (String[])new String[]{srmInterfaceCode}));
        }
        param.put("interface_code", (Object)configDTO.getInterfaceCode());
        return configDTO.getCustomBean();
    }
}

