/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.extend.api.common.utils;

import com.els.modules.extend.api.common.enumerate.RafflesInterfaceEnum;
import com.els.modules.extend.api.dto.ifs.request.IFSRequestBaseDTO;
import com.els.modules.extend.api.dto.ifs.request.IFSRequestBaseHeadDTO;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class IFSInterfaceUtils {
    public static IFSRequestBaseHeadDTO getIFSRequestBaseHead(String interfaceCode, String reqTime, String transId) {
        IFSRequestBaseHeadDTO headDTO = new IFSRequestBaseHeadDTO();
        headDTO.setApiVersion("V1.0.0");
        headDTO.setAuthCode("123456789");
        headDTO.setReqAppId("10001");
        headDTO.setReqName(interfaceCode);
        headDTO.setReqTime(reqTime);
        headDTO.setTransID(transId);
        return headDTO;
    }

    public static IFSRequestBaseHeadDTO getIFSRequestBaseHead(String interfaceCode, String reqTime, String transId, int rowCount) {
        IFSRequestBaseHeadDTO headDTO = new IFSRequestBaseHeadDTO();
        headDTO.setApiVersion("V1.0.0");
        headDTO.setAuthCode("123456789");
        headDTO.setReqAppId("10001");
        headDTO.setReqName(interfaceCode);
        headDTO.setReqTime(reqTime);
        headDTO.setTransID(transId);
        headDTO.setRowCount(String.valueOf(rowCount));
        return headDTO;
    }

    public static IFSRequestBaseHeadDTO getIFSCompanyAndDomainRequestBaseHead(String interfaceCode, String reqTime, String transId) {
        IFSRequestBaseHeadDTO headDTO = new IFSRequestBaseHeadDTO();
        headDTO.setApiVersion("V1.0.0");
        headDTO.setRowCount("1");
        headDTO.setReqAppId("10001");
        headDTO.setReqName(interfaceCode);
        headDTO.setReqTime(reqTime);
        headDTO.setTransID(transId);
        return headDTO;
    }

    public static IFSRequestBaseHeadDTO getIFSSupplierMainDataRequestBaseHead(String interfaceCode, String reqTime, String transId) {
        IFSRequestBaseHeadDTO headDTO = new IFSRequestBaseHeadDTO();
        headDTO.setApiVersion("V1.0.0");
        headDTO.setRowCount("1");
        headDTO.setReqAppId("10002");
        headDTO.setAuthCode("123456789");
        headDTO.setReqName(interfaceCode);
        headDTO.setReqTime(reqTime);
        headDTO.setTransID(transId);
        return headDTO;
    }

    public static IFSRequestBaseHeadDTO getIFSPoStatusChgBaseHead(String interfaceCode, String reqTime, String transId) {
        IFSRequestBaseHeadDTO headDTO = new IFSRequestBaseHeadDTO();
        headDTO.setApiVersion("V1.0.0");
        headDTO.setRowCount("1");
        headDTO.setReqAppId("10002");
        headDTO.setReqName(interfaceCode);
        headDTO.setReqTime(reqTime);
        headDTO.setTransID(transId);
        return headDTO;
    }

    public static IFSRequestBaseDTO getCommonIFSRequestBaseDTO(RafflesInterfaceEnum rafflesInterfaceEnum) {
        IFSRequestBaseDTO requestBaseDTO = new IFSRequestBaseDTO();
        IFSRequestBaseHeadDTO requestBaseHead = IFSInterfaceUtils.getIFSRequestBaseHead(rafflesInterfaceEnum.getThirdInterfaceCode(), LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")), String.valueOf(System.currentTimeMillis()));
        requestBaseDTO.setHead(requestBaseHead);
        return requestBaseDTO;
    }
}

