/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.extend.api.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.modules.extend.api.dto.oa.result.KmBaseRespDTO;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KMFormatUtils {
    private static final String reqFormat = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:web=\"${xmlUrl}\"><soapenv:Header/><soapenv:Body><web:${thirdInterfaceCode}><!--Optional:-->${body}</web:${thirdInterfaceCode}></soapenv:Body></soapenv:Envelope>";
    private static final String respSplitNode1 = "<ns2:${thirdInterfaceRespCode} xmlns:ns2=\"${xmlUrl}\">";
    private static final String respSplitNode2 = "</ns2:${thirdInterfaceRespCode}>";
    private static Logger logger = LoggerFactory.getLogger(KMFormatUtils.class);

    public static String getReqBody(String thirdInterfaceCode, String xmlUrl, Object kmReqDTO, Class kmReqDTOClass) {
        String reqBody = reqFormat.replace("${thirdInterfaceCode}", thirdInterfaceCode);
        reqBody = reqBody.replace("${xmlUrl}", xmlUrl);
        String xmlOutput = null;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{kmReqDTOClass});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            StringWriter writer = new StringWriter();
            marshaller.marshal(kmReqDTO, (Writer)writer);
            xmlOutput = writer.toString();
            xmlOutput = xmlOutput.replace("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>", "");
        }
        catch (JAXBException e) {
            logger.error("\u8bf7\u6c42xml\u8f6c\u6362\u5931\u8d25,\u8bf7\u6c42\u5185\u5bb9\uff1a" + JSON.toJSONString((Object)kmReqDTO));
        }
        if (xmlOutput != null && !"".equals(xmlOutput)) {
            reqBody = reqBody.replace("${body}", xmlOutput);
            return reqBody;
        }
        return null;
    }

    public static KmBaseRespDTO getRespBody(String thirdInterfaceCode, String xmlUrl, String respBody) {
        String thirdInterfaceRespCode = thirdInterfaceCode + "Response";
        if (respBody == null || "".equals(respBody)) {
            logger.error("OA\u63a8\u9001\u8fd4\u56de\u5185\u540c\u4e3a\u7a7a");
            return null;
        }
        if (!respBody.contains(thirdInterfaceRespCode)) {
            logger.error("OA\u63a8\u9001\u8fd4\u56de\u65b9\u6cd5\u683c\u5f0f\u4e0d\u4e00\u81f4");
            return null;
        }
        try {
            String splitNode1 = respSplitNode1.replace("${thirdInterfaceRespCode}", thirdInterfaceRespCode);
            splitNode1 = respSplitNode1.replace("${xmlUrl}", xmlUrl);
            String splitNode2 = respSplitNode2.replace("${thirdInterfaceRespCode}", thirdInterfaceRespCode);
            respBody = respBody.split(splitNode1, splitNode1.length())[1];
            respBody = respBody.split(splitNode2)[0];
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{KmBaseRespDTO.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            StringReader reader = new StringReader(respBody);
            KmBaseRespDTO respDTO = (KmBaseRespDTO)unmarshaller.unmarshal((Reader)reader);
            return respDTO;
        }
        catch (Exception e) {
            logger.error("OA\u54cd\u5e94xml\u89e3\u6790\u5931\u8d25\uff0c\u8fd4\u56de\u5185\u5bb9\uff1a" + respBody);
            return null;
        }
    }

    public static KmBaseRespDTO getRespBodyByJson(JSONObject respBody) {
        JSONObject jsonObject = respBody.getJSONObject("result");
        jsonObject = jsonObject.getJSONObject("return");
        KmBaseRespDTO respDTO = new KmBaseRespDTO();
        respDTO.setCode(jsonObject.getString("code"));
        respDTO.setDesc(jsonObject.getString("desc"));
        respDTO.setMessage(jsonObject.getString("data"));
        return respDTO;
    }
}

