/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.extend.api.supplier.enumrate;

import java.util.ArrayList;
import java.util.List;

public enum SupplierRequestFileType {
    REGISTRATION_DOCUMENTS("RegistrationDocuments", "\u516c\u53f8\u6ce8\u518c\u6587\u4ef6/\u8425\u4e1a\u6267\u7167", "CompanyInfo"),
    QUALIFIED_SUPPLIER_COMMITMENT_LETTER("QualifiedSupplierCommitmentLetter", "\u5408\u683c\u4f9b\u65b9\u627f\u8bfa\u4e66", "CommitmentInfo"),
    COMPANY_INTRODUCTION("CompanyIntroduction", "\u516c\u53f8\u7b80\u4ecb(\u4e2d\u82f1\u6587\u7248\u672c\uff09", "CompanyInfo"),
    FINANCIAL_REPORTS("FinancialReports", "\u8fd1\u4e09\u5e74\u8d22\u52a1\u62a5\u544a", "CompanyInfo"),
    PRODUCT_SAMPLES("ProductSamples", "\u4ea7\u54c1\u6837\u672c", "ProductInfo"),
    PERFORMANCE_TABLE("PerformanceTable", "\u8fd1\u4e09\u5e74\u4e1a\u7ee9\u8868", "ProductInfo"),
    ASBESTOS_FREE_DECLARATION("AsbestosFreeDeclaration", "\u65e0\u77f3\u68c9\u58f0\u660e", "CommitmentInfo"),
    SUPPLIER_CONFIRMATION_LETTER("SupplierConfirmationLetter", "\u4f9b\u5e94\u5546\u6709\u6743\u7b7e\u5b57\u4eba\u786e\u8ba4\u51fd", "CommitmentInfo");

    private String value;
    private String desc;
    private String type;

    private SupplierRequestFileType(String value, String desc, String type) {
        this.value = value;
        this.desc = desc;
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getType() {
        return this.type;
    }

    public static Boolean validCompanyInfo(String data) {
        for (SupplierRequestFileType enumerate : SupplierRequestFileType.values()) {
            if (!"CompanyInfo".equals(enumerate.getType()) || !data.equals(enumerate.getValue())) continue;
            return true;
        }
        return false;
    }

    public static Boolean validCommitmentInfo(String data) {
        for (SupplierRequestFileType enumerate : SupplierRequestFileType.values()) {
            if (!"CommitmentInfo".equals(enumerate.getType()) || !data.equals(enumerate.getValue())) continue;
            return true;
        }
        return false;
    }

    public static Boolean validProductInfo(String data) {
        for (SupplierRequestFileType enumerate : SupplierRequestFileType.values()) {
            if (!"ProductInfo".equals(enumerate.getType()) || !data.equals(enumerate.getValue())) continue;
            return true;
        }
        return false;
    }

    public static List<SupplierRequestFileType> getRequestProductInfo() {
        ArrayList<SupplierRequestFileType> list = new ArrayList<SupplierRequestFileType>();
        for (SupplierRequestFileType enumerate : SupplierRequestFileType.values()) {
            if (!"ProductInfo".equals(enumerate.getType())) continue;
            list.add(enumerate);
        }
        return list;
    }
}

