/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.extend.api.oa;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.RSA;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.util.HttpUtil;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class OaUtils {
    private static final Logger log = LoggerFactory.getLogger(OaUtils.class);
    @Value(value="${spring.profiles.active}")
    private String activeProfiles;
    @Resource
    private RedisUtil redisUtil;
    @Resource
    private InterfaceUtil interfaceUtil;
    private final String OA_REDIS_KEY_SECRET = "oa:redis:key:secret";
    private final String OA_REDIS_KEY_SPK = "oa:redis:key:spk";
    private final String OA_REDIS_KEY_USER = "oa:redis:key:user:";
    private final String OA_REDIS_KEY_TOKEN = "oa:redis:key:token";
    private final String OA_REDIS_KEY_COMPANY = "oa:redis:key:company";
    private final String APP_ID_TEST = "0C031E2A-AF40-48BF-A59B-E20BFE3A0056";
    private final String APP_ID_PROD = "0C031E2A-AF40-48BF-A59B-E20BFE3A0056";
    private final String SERVICE_ACTIVE = "ruizhihx";
    @Value(value="${oa.url}")
    private String oaUrl;

    public void registerApp() {
        String elsAccount = TenantContext.getTenant();
        JSONObject headParam = new JSONObject();
        headParam.put("appid", (Object)(StrUtil.equals((CharSequence)"ruizhihx", (CharSequence)this.activeProfiles) ? "0C031E2A-AF40-48BF-A59B-E20BFE3A0056" : "0C031E2A-AF40-48BF-A59B-E20BFE3A0056"));
        headParam.put("cpk", (Object)"123");
        JSONObject resultObj = this.interfaceUtil.callInterface(elsAccount, elsAccount, "registerApp", headParam, new JSONObject(), new JSONObject(), (Object)new JSONObject());
        log.info("\u64cd\u4f5c\u7c7b\u578b:[\u6ce8\u518c app]\u7ed3\u679c:{}", (Object)resultObj);
        JSONObject result = resultObj.getJSONObject("result");
        if (ObjectUtil.isNotNull((Object)result)) {
            Integer code = result.getInteger("code");
            if (NumberUtil.equals((long)0L, (long)code.intValue())) {
                this.redisUtil.set("oa:redis:key:secret", (Object)result.getString("secret"));
                this.redisUtil.set("oa:redis:key:spk", (Object)result.getString("spk"));
            } else {
                throw new ELSBootException(result.getString("msg"));
            }
        }
    }

    public String getToken() {
        Object token = this.redisUtil.get("oa:redis:key:token");
        if (ObjectUtil.isNull((Object)token)) {
            Object secret = this.redisUtil.get("oa:redis:key:secret");
            if (ObjectUtil.isNull((Object)secret)) {
                this.registerApp();
            }
            secret = this.redisUtil.get("oa:redis:key:secret");
            Object spk = this.redisUtil.get("oa:redis:key:spk");
            RSA rsa = new RSA(null, spk.toString());
            String encryptSecret = rsa.encryptBase64(secret.toString(), CharsetUtil.CHARSET_UTF_8, KeyType.PublicKey);
            String elsAccount = TenantContext.getTenant();
            JSONObject headParam = new JSONObject();
            headParam.put("appid", (Object)(StrUtil.equals((CharSequence)"ruizhihx", (CharSequence)this.activeProfiles) ? "0C031E2A-AF40-48BF-A59B-E20BFE3A0056" : "0C031E2A-AF40-48BF-A59B-E20BFE3A0056"));
            headParam.put("secret", (Object)encryptSecret);
            headParam.put("time", (Object)"3600");
            JSONObject resultObj = this.interfaceUtil.callInterface(elsAccount, elsAccount, "getToken", headParam, new JSONObject(), new JSONObject(), (Object)new JSONObject());
            log.info("\u64cd\u4f5c\u7c7b\u578b:[\u83b7\u53d6 oa token]\u7ed3\u679c:{}", (Object)resultObj);
            JSONObject result = resultObj.getJSONObject("result");
            if (ObjectUtil.isNotNull((Object)result)) {
                Integer code = result.getInteger("code");
                if (NumberUtil.equals((long)0L, (long)code.intValue())) {
                    token = result.getString("token");
                    this.redisUtil.set("oa:redis:key:token", (Object)result.getString("token"), 300L);
                } else {
                    throw new ELSBootException(result.getString("msg"));
                }
            }
        }
        return token.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getUserIdByAccount(String account) {
        if (account != null && account.contains("_")) {
            account = account.split("_")[0];
        }
        String userId = "";
        Object userIdObj = this.redisUtil.get("oa:redis:key:user:" + account);
        if (!ObjectUtil.isNull((Object)userIdObj)) {
            return userIdObj.toString();
        }
        String elsAccount = TenantContext.getTenant();
        JSONObject bodyParam = new JSONObject();
        JSONObject params = new JSONObject();
        params.put("workcode", (Object)account);
        bodyParam.put("params", (Object)params);
        JSONObject resultObj = this.interfaceUtil.callInterface(elsAccount, elsAccount, "getUserIdByAccount", new JSONObject(), new JSONObject(), bodyParam, (Object)new JSONObject());
        log.info("\u64cd\u4f5c\u7c7b\u578b:[\u83b7\u53d6 oa userid]\u7ed3\u679c:{}", (Object)resultObj);
        JSONObject result = resultObj.getJSONObject("result");
        if (!ObjectUtil.isNotNull((Object)result)) return userId;
        String code = result.getString("code");
        if (!StrUtil.equals((CharSequence)"1", (CharSequence)code)) throw new ELSBootException("\u8d26\u53f7[" + account + "]\u8c03\u7528 OA \u63a5\u53e3\u5931\u8d25" + result.getString("msg"));
        JSONArray jsonArray = result.getJSONObject("data").getJSONArray("dataList");
        if (!CollUtil.isNotEmpty((Collection)jsonArray)) throw new ELSBootException(String.format("\u8bf7\u8054\u7cfbOA\u7ba1\u7406\u5458\u8fdb\u884c\u67e5\u770b\u8d26\u53f7[account:%s]\u662f\u5426\u5f02\u5e38", account));
        JSONObject jsonObject = jsonArray.getJSONObject(0);
        userId = jsonObject.getString("id");
        this.redisUtil.set("oa:redis:key:user:" + account, (Object)userId, 1440000L);
        return userId;
    }

    public JSONObject callInterface(Object param, String userId) {
        String token = this.getToken();
        JSONObject jsonObject = JSON.parseObject((String)JSONUtil.toJsonStr((Object)param));
        String elsAccount = TenantContext.getTenant();
        JSONObject headParam = new JSONObject();
        headParam.put("appid", (Object)(StrUtil.equals((CharSequence)"ruizhihx", (CharSequence)this.activeProfiles) ? "0C031E2A-AF40-48BF-A59B-E20BFE3A0056" : "0C031E2A-AF40-48BF-A59B-E20BFE3A0056"));
        headParam.put("token", (Object)token);
        Object spk = this.redisUtil.get("oa:redis:key:spk");
        if (ObjectUtil.isNull((Object)spk)) {
            this.registerApp();
            spk = this.redisUtil.get("oa:redis:key:spk");
        }
        RSA rsa = new RSA(null, spk.toString());
        String encryptBase64 = rsa.encryptBase64(userId, CharsetUtil.CHARSET_UTF_8, KeyType.PublicKey);
        log.info("\u64cd\u4f5c\u7c7b\u578b:[\u8c03\u7528\u63a5\u53e3] userId:{}, \u52a0\u5bc6userid:{}", (Object)userId, (Object)encryptBase64);
        headParam.put("userid", (Object)encryptBase64);
        JSONObject resultObj = this.interfaceUtil.callInterface(elsAccount, elsAccount, "callOaInterface", headParam, new JSONObject(), jsonObject, (Object)new JSONObject());
        log.info("\u64cd\u4f5c\u7c7b\u578b:[\u8c03\u7528\u63a5\u53e3]\u7ed3\u679c:{}", (Object)resultObj);
        JSONObject result = resultObj.getJSONObject("result");
        if (ObjectUtil.isNotNull((Object)result)) {
            String code = result.getString("code");
            if (StrUtil.equals((CharSequence)"SUCCESS", (CharSequence)code)) {
                return result.getJSONObject("data");
            }
            String errMsg = JSONUtil.toJsonStr((Object)result.get((Object)"errMsg"));
            if ("{}".equals(errMsg)) {
                errMsg = JSONUtil.toJsonStr((Object)result.getJSONObject("reqFailMsg").get((Object)"msgInfo"));
            }
            throw new ELSBootException("\u8c03\u7528OA\u5ba1\u6279\u63a5\u53e3\u5931\u8d25\uff01\u62a5\u9519\u4fe1\u606f\uff1a" + errMsg);
        }
        throw new ELSBootException("\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
    }

    public JSONObject callInterfaceResult(Object param, String userId) {
        String token = this.getToken();
        JSONObject jsonObject = JSON.parseObject((String)JSONUtil.toJsonStr((Object)param));
        String elsAccount = TenantContext.getTenant();
        JSONObject headParam = new JSONObject();
        headParam.put("appid", (Object)(StrUtil.equals((CharSequence)"ruizhihx", (CharSequence)this.activeProfiles) ? "0C031E2A-AF40-48BF-A59B-E20BFE3A0056" : "0C031E2A-AF40-48BF-A59B-E20BFE3A0056"));
        headParam.put("token", (Object)token);
        Object spk = this.redisUtil.get("oa:redis:key:spk");
        if (ObjectUtil.isNull((Object)spk)) {
            this.registerApp();
            spk = this.redisUtil.get("oa:redis:key:spk");
        }
        RSA rsa = new RSA(null, spk.toString());
        String encryptBase64 = rsa.encryptBase64(userId, CharsetUtil.CHARSET_UTF_8, KeyType.PublicKey);
        log.info("\u64cd\u4f5c\u7c7b\u578b:[\u8c03\u7528\u63a5\u53e3] userId:{}, \u52a0\u5bc6userid:{}", (Object)userId, (Object)encryptBase64);
        headParam.put("userid", (Object)encryptBase64);
        JSONObject resultObj = this.interfaceUtil.callInterface(elsAccount, elsAccount, "callOaInterface", headParam, new JSONObject(), jsonObject, (Object)new JSONObject());
        log.info("\u64cd\u4f5c\u7c7b\u578b:[\u8c03\u7528\u63a5\u53e3]\u7ed3\u679c:{}", (Object)resultObj);
        JSONObject result = resultObj.getJSONObject("result");
        return result;
    }

    public JSONObject revocationFlow(Object param, String userId) {
        String token = this.getToken();
        String elsAccount = TenantContext.getTenant();
        JSONObject headParam = new JSONObject();
        headParam.put("appid", (Object)(StrUtil.equals((CharSequence)"ruizhihx", (CharSequence)this.activeProfiles) ? "0C031E2A-AF40-48BF-A59B-E20BFE3A0056" : "0C031E2A-AF40-48BF-A59B-E20BFE3A0056"));
        headParam.put("token", (Object)token);
        Object spk = this.redisUtil.get("oa:redis:key:spk");
        if (ObjectUtil.isNull((Object)spk)) {
            this.registerApp();
            spk = this.redisUtil.get("oa:redis:key:spk");
        }
        RSA rsa = new RSA(null, spk.toString());
        String encryptBase64 = rsa.encryptBase64(userId, CharsetUtil.CHARSET_UTF_8, KeyType.PublicKey);
        log.info("\u64cd\u4f5c\u7c7b\u578b:\u6d41\u7a0b\u64a4\u56de[\u8c03\u7528\u63a5\u53e3] userId:{}, \u52a0\u5bc6userid:{}", (Object)userId, (Object)encryptBase64);
        headParam.put("userid", (Object)encryptBase64);
        JSONObject jsonObject = JSON.parseObject((String)JSONUtil.toJsonStr((Object)param));
        JSONObject resultObj = this.interfaceUtil.callInterface(elsAccount, elsAccount, "revocationFlow", headParam, new JSONObject(), jsonObject, (Object)new JSONObject());
        log.info("\u64cd\u4f5c\u7c7b\u578b:\u6d41\u7a0b\u64a4\u56de[\u8c03\u7528\u63a5\u53e3]\u7ed3\u679c:{}", (Object)resultObj);
        JSONObject result = resultObj.getJSONObject("result");
        if (ObjectUtil.isNotNull((Object)result)) {
            String code = result.getString("code");
            if (StrUtil.equals((CharSequence)"SUCCESS", (CharSequence)code)) {
                return result.getJSONObject("datas");
            }
            String errMsg = JSONUtil.toJsonStr((Object)result.get((Object)"errMsg"));
            if ("{}".equals(errMsg)) {
                errMsg = JSONUtil.toJsonStr((Object)result.getJSONObject("reqFailMsg").get((Object)"msgInfo"));
            }
            throw new ELSBootException("\u6d41\u7a0b\u64a4\u56de\u63a5\u53e3\u5931\u8d25\uff01\u62a5\u9519\u4fe1\u606f\uff1a" + errMsg);
        }
        return result;
    }

    public String revocation(String flowId, String number, String itemNumber) {
        String param = "?requestid=%s&num=%s&linenum=%s";
        String message = HttpUtil.postJson((String)(this.oaUrl + "/api/custom/lobsystem/srm/retractrequest" + String.format("?requestid=%s&num=%s&linenum=%s", flowId, number, itemNumber)), null, null);
        Map map = (Map)JSONObject.parseObject((String)message, Map.class);
        return map.getOrDefault("msg", "\u64cd\u4f5c\u6210\u529f");
    }

    public JSONObject getOaMemberResult(String userId) {
        String token = this.getToken();
        String elsAccount = TenantContext.getTenant();
        JSONObject headParam = new JSONObject();
        headParam.put("appid", (Object)(StrUtil.equals((CharSequence)"ruizhihx", (CharSequence)this.activeProfiles) ? "0C031E2A-AF40-48BF-A59B-E20BFE3A0056" : "0C031E2A-AF40-48BF-A59B-E20BFE3A0056"));
        headParam.put("token", (Object)token);
        Object spk = this.redisUtil.get("oa:redis:key:spk");
        if (ObjectUtil.isNull((Object)spk)) {
            this.registerApp();
            spk = this.redisUtil.get("oa:redis:key:spk");
        }
        RSA rsa = new RSA(null, spk.toString());
        String encryptBase64 = rsa.encryptBase64(userId, CharsetUtil.CHARSET_UTF_8, KeyType.PublicKey);
        log.info("\u64cd\u4f5c\u7c7b\u578b:[\u8c03\u7528\u63a5\u53e3] userId:{}, \u52a0\u5bc6userid:{}", (Object)userId, (Object)encryptBase64);
        headParam.put("userid", (Object)encryptBase64);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("userid", (Object)userId);
        JSONObject urlParam = new JSONObject();
        urlParam.put("workcode", (Object)userId);
        JSONObject resultObj = this.interfaceUtil.callInterface(elsAccount, elsAccount, "gethrminfo", headParam, urlParam, jsonObject, (Object)new JSONObject());
        log.info("\u64cd\u4f5c\u7c7b\u578b:[\u8c03\u7528\u63a5\u53e3]\u7ed3\u679c:{}", (Object)resultObj);
        JSONObject result = resultObj.getJSONObject("result");
        if (ObjectUtil.isNotNull((Object)result)) {
            String res = result.getString("api_status");
            if (StrUtil.equals((CharSequence)"true", (CharSequence)res)) {
                return result.getJSONObject("data");
            }
            String errMsg = JSONUtil.toJsonStr((Object)result.get((Object)"msg"));
            if ("{}".equals(errMsg)) {
                errMsg = JSONUtil.toJsonStr((Object)result.getJSONObject("reqFailMsg").get((Object)"msgInfo"));
            }
            throw new ELSBootException("\u8c03\u7528OA\u4eba\u5458\u7ec4\u7ec7\u63a5\u53e3\u5931\u8d25\uff01\u62a5\u9519\u4fe1\u606f\uff1a" + errMsg);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getCompanyIdByAccount(String account) {
        if (account != null && account.contains("_")) {
            account = account.split("_")[0];
        }
        String companyId = "";
        Object userIdObj = this.redisUtil.get("oa:redis:key:company" + account);
        if (!ObjectUtil.isNull((Object)userIdObj)) {
            return userIdObj.toString();
        }
        String elsAccount = TenantContext.getTenant();
        JSONObject bodyParam = new JSONObject();
        JSONObject params = new JSONObject();
        params.put("workcode", (Object)account);
        bodyParam.put("params", (Object)params);
        JSONObject resultObj = this.interfaceUtil.callInterface(elsAccount, elsAccount, "getUserIdByAccount", new JSONObject(), new JSONObject(), bodyParam, (Object)new JSONObject());
        log.info("\u64cd\u4f5c\u7c7b\u578b:[\u83b7\u53d6 oa userid]\u7ed3\u679c:{}", (Object)resultObj);
        JSONObject result = resultObj.getJSONObject("result");
        if (!ObjectUtil.isNotNull((Object)result)) return companyId;
        String code = result.getString("code");
        if (!StrUtil.equals((CharSequence)"1", (CharSequence)code)) throw new ELSBootException("\u8d26\u53f7[" + account + "]\u8c03\u7528 OA \u63a5\u53e3\u5931\u8d25" + result.getString("msg"));
        JSONArray jsonArray = result.getJSONObject("data").getJSONArray("dataList");
        if (!CollUtil.isNotEmpty((Collection)jsonArray)) throw new ELSBootException(String.format("\u8bf7\u8054\u7cfbOA\u7ba1\u7406\u5458\u8fdb\u884c\u67e5\u770b\u8d26\u53f7[account:%s]\u662f\u5426\u5f02\u5e38", account));
        JSONObject jsonObject = jsonArray.getJSONObject(0);
        companyId = jsonObject.getString("subcompanyid1");
        this.redisUtil.set("oa:redis:key:company" + account, (Object)companyId, 1440000L);
        return companyId;
    }
}

