/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.extend.api.utils;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.logging.log4j.util.Strings;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.core.ResolvableType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class ExtendBeanUtils
extends BeanUtils {
    public static void copyPropertiesIgnorePrefix(Object source, Object target, String ignorePrefix) throws BeansException {
        ExtendBeanUtils.copyPropertiesIgnorePrefix(source, target, ignorePrefix, null, true);
    }

    public static void copyPropertiesIgnorePrefix(Object source, Object target, @Nullable String ignorePrefix, @Nullable Class<?> editable, Boolean ignoreNull) throws BeansException {
        PropertyDescriptor[] targetPds;
        Assert.notNull((Object)source, (String)"Source must not be null");
        Assert.notNull((Object)target, (String)"Target must not be null");
        Class<?> actualEditable = target.getClass();
        if (editable != null) {
            if (!editable.isInstance(target)) {
                throw new IllegalArgumentException("Target class [" + target.getClass().getName() + "] not assignable to Editable class [" + editable.getName() + "]");
            }
            actualEditable = editable;
        }
        PropertyDescriptor[] var7 = targetPds = ExtendBeanUtils.getPropertyDescriptors(actualEditable);
        int var8 = targetPds.length;
        for (int var9 = 0; var9 < var8; ++var9) {
            boolean isAssignable;
            Method readMethod;
            PropertyDescriptor sourcePd;
            PropertyDescriptor targetPd = var7[var9];
            Method writeMethod = targetPd.getWriteMethod();
            if (writeMethod == null || !Strings.isEmpty((CharSequence)ignorePrefix) && targetPd.getName().startsWith(ignorePrefix) || (sourcePd = ExtendBeanUtils.getPropertyDescriptor(source.getClass(), (String)targetPd.getName())) == null || (readMethod = sourcePd.getReadMethod()) == null) continue;
            ResolvableType sourceResolvableType = ResolvableType.forMethodReturnType((Method)readMethod);
            ResolvableType targetResolvableType = ResolvableType.forMethodParameter((Method)writeMethod, (int)0);
            boolean bl = isAssignable = !sourceResolvableType.hasUnresolvableGenerics() && !targetResolvableType.hasUnresolvableGenerics() ? targetResolvableType.isAssignableFrom(sourceResolvableType) : ClassUtils.isAssignable(writeMethod.getParameterTypes()[0], readMethod.getReturnType());
            if (!isAssignable) continue;
            try {
                if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                    readMethod.setAccessible(true);
                }
                Object value = readMethod.invoke(source, new Object[0]);
                if (ignoreNull.booleanValue() && value == null) continue;
                if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                    writeMethod.setAccessible(true);
                }
                writeMethod.invoke(target, value);
                continue;
            }
            catch (Throwable var18) {
                throw new FatalBeanException("Could not copy property '" + targetPd.getName() + "' from source to target", var18);
            }
        }
    }

    public static String removeBackslash(String str) {
        if (Strings.isEmpty((CharSequence)str)) {
            return str;
        }
        return str.replaceAll("\\\\", "");
    }
}

