/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.extend.api.utils;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.els.api.dto.BaseDTO;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.BigDecimalFormat;
import com.els.common.aspect.annotation.Dict;
import com.els.common.aspect.annotation.ReadConfig;
import com.els.common.aspect.annotation.ReadConfigType;
import com.els.common.context.BusAccountHolder;
import com.els.common.service.DictTranslateService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.AdminFlagUtil;
import com.els.common.util.ConvertUtils;
import com.els.common.util.DateUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.SensitiveFieldDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ExtendDictAspectUtils {
    private static final Logger log = LoggerFactory.getLogger(DictAspect.class);
    @Resource
    @Lazy
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private DictTranslateService dictTranslateService;
    private final Pattern pattern = Pattern.compile("\\$\\{([^}]+)}");
    private Map<String, String> localCacheMap;
    private List<SensitiveFieldDTO> sensitiveFieldList;

    private void init() {
        if (this.localCacheMap == null) {
            this.localCacheMap = new HashMap<String, String>();
        } else {
            this.localCacheMap.clear();
        }
        if (this.sensitiveFieldList != null) {
            this.sensitiveFieldList.clear();
        }
        String sensitiveFieldGroups = null;
        if (SysUtil.getLoginUser() != null) {
            sensitiveFieldGroups = SysUtil.getLoginUser().getSensitiveFieldGroups();
        }
        this.sensitiveFieldList = this.invokeBaseRpcService.findSensitiveFieldByGroup(TenantContext.getTenant(), sensitiveFieldGroups);
    }

    public void parseDictText(Object result) {
        this.init();
        if (!(result instanceof Result)) {
            return;
        }
        Object objResult = ((Result)result).getResult();
        if (objResult == null) {
            return;
        }
        if (objResult instanceof IPage) {
            long start = System.currentTimeMillis();
            ArrayList<JSONObject> items = new ArrayList<JSONObject>();
            for (Object record : ((IPage)objResult).getRecords()) {
                if (record == null) continue;
                JSONObject item = this.parseJson(record, false);
                items.add(item);
            }
            ((IPage)objResult).setRecords(items);
            long end = System.currentTimeMillis();
            log.info("result_cost:{}ms", (Object)(end - start));
        } else if (objResult instanceof List) {
            ArrayList<JSONObject> items = new ArrayList<JSONObject>();
            boolean flag = false;
            for (Object record : (List)objResult) {
                if (!(record instanceof BaseEntity)) continue;
                items.add(this.parseJson(record, false));
                flag = true;
            }
            if (flag) {
                ((List)((Result)result).getResult()).clear();
                ((List)((Result)result).getResult()).addAll(items);
            }
        } else {
            ((Result)result).setResult((Object)this.parseJson(objResult, false));
        }
    }

    public JSONObject parseJson(Object record, boolean init) {
        if (init) {
            this.init();
        }
        return this.parseJson(record, null, null, null, null);
    }

    private JSONObject parseJson(Object record, String templateAccount, String busAccount, String templateNumber, String templateVersion) {
        ReadConfig readConfig;
        ObjectMapper mapper = new ObjectMapper();
        String json = "{}";
        try {
            json = mapper.writeValueAsString(record);
        }
        catch (JsonProcessingException var15) {
            log.error("json\u89e3\u6790\u5931\u8d25" + var15.getMessage(), (Throwable)var15);
        }
        JSONObject item = JSONObject.parseObject((String)json);
        if (item == null) {
            return null;
        }
        if (StrUtil.isBlank((CharSequence)templateAccount)) {
            templateAccount = item.getString("templateAccount");
        }
        if (StrUtil.isBlank((CharSequence)busAccount) && StrUtil.isBlank((CharSequence)(busAccount = CharSequenceUtil.emptyToDefault((CharSequence)item.getString("busAccount"), (String)BusAccountHolder.get())))) {
            busAccount = TenantContext.getTenant();
            log.debug("TenantContext.getTenant():" + busAccount);
        }
        if (StrUtil.isAllBlank((CharSequence[])new CharSequence[]{templateNumber, templateVersion})) {
            templateNumber = item.getString("templateNumber");
            templateVersion = item.getString("templateVersion");
        }
        if ((readConfig = record.getClass().getAnnotation(ReadConfig.class)) != null && !StrUtil.isAllBlank((CharSequence[])new CharSequence[]{templateNumber, templateVersion})) {
            Map dictMap;
            String queryAccount;
            ReadConfigType type = readConfig.value();
            String string = queryAccount = StrUtil.isBlank((CharSequence)templateAccount) ? busAccount : templateAccount;
            if (StrUtil.isBlank((CharSequence)queryAccount)) {
                queryAccount = TenantContext.getTenant();
            }
            if (!CollectionUtils.isEmpty((Map)(dictMap = ReadConfigType.HEAD.equals((Object)type) ? this.invokeBaseRpcService.getHeadDictMap(queryAccount, templateNumber, templateVersion, readConfig.groupCode()) : this.invokeBaseRpcService.getItemDictMap(queryAccount, templateNumber, templateVersion, readConfig.groupCode())))) {
                Iterator iterator = dictMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    String value = (String)iterator.next().getValue();
                    if (!value.startsWith("/")) continue;
                    iterator.remove();
                }
            }
            this.translate(record, templateAccount, busAccount, templateNumber, templateVersion, item, dictMap, true);
        } else {
            this.translate(record, templateAccount, busAccount, templateNumber, templateVersion, item, new HashMap<String, String>(1), false);
        }
        if (!"1".equals(AdminFlagUtil.getAdminFlag())) {
            this.optSensitiveField(item);
        }
        return item;
    }

    private String encrypt(String target) {
        return StrUtil.isBlank((CharSequence)target) ? "" : target.replaceAll("(?<=\\S{3})\\S(?=\\S{4})", "*");
    }

    private String encrypt2(String target) {
        return StrUtil.isBlank((CharSequence)target) ? "" : target.replaceAll("(?<=\\S{3})\\S", "*");
    }

    private void optSensitiveField(JSONObject obj) {
        if (this.sensitiveFieldList != null) {
            try {
                for (SensitiveFieldDTO field : this.sensitiveFieldList) {
                    String fieldCode = field.getFieldCode();
                    if ("id".equals(fieldCode)) continue;
                    String repalceType = field.getReplaceType();
                    String fieldValue = obj.getString(fieldCode);
                    if ("2".equals(repalceType)) {
                        obj.put(fieldCode, (Object)this.encrypt2(fieldValue));
                        continue;
                    }
                    if ("3".equals(repalceType)) {
                        obj.put(fieldCode, (Object)this.encrypt(fieldValue));
                        continue;
                    }
                    obj.put(fieldCode, (Object)"*");
                }
            }
            catch (Exception var7) {
                log.error("optSensitiveField_failed:", (Throwable)var7);
            }
        }
    }

    private void translate(Object record, String templateAccount, String busAccount, String templateNumber, String templateVersion, JSONObject item, Map<String, String> dictMap, boolean isConfig) {
        for (Field field : ConvertUtils.getAllFields((Object)record)) {
            BigDecimalFormat annotation;
            Date date;
            String textValue;
            String code;
            String formatVal;
            String table;
            String text;
            String dictCode = dictMap.get(field.getName());
            if (isConfig && StrUtil.isNotBlank((CharSequence)dictCode)) {
                text = null;
                table = null;
                String valueText = null;
                formatVal = String.valueOf(item.get((Object)field.getName()));
                if (!dictCode.contains(",") && !dictCode.contains("#")) {
                    code = dictCode;
                } else {
                    String[] dictCodeArray = dictCode.contains("#") ? dictCode.split("#") : dictCode.split(",");
                    table = dictCodeArray[0];
                    text = dictCodeArray[1];
                    valueText = dictCodeArray[2];
                    code = "";
                    if (dictCodeArray.length > 3) {
                        code = dictCodeArray[3];
                    }
                }
                textValue = this.translateDictValue(item, code, text, table, formatVal, false, busAccount, valueText);
                if (null == textValue || !textValue.equals(formatVal) || !CharSequenceUtil.isNotEmpty((CharSequence)item.getString(field.getName() + "_dictText"))) {
                    item.put(field.getName() + "_dictText", (Object)textValue);
                }
            } else {
                Dict dict = field.getAnnotation(Dict.class);
                if (dict != null) {
                    code = dict.dicCode();
                    textValue = this.translateDictValue(item, code, text = dict.dicText(), table = dict.dictTable(), formatVal = String.valueOf(item.get((Object)field.getName())), false, busAccount, null);
                    if (null == textValue || !textValue.equals(formatVal) || !CharSequenceUtil.isNotEmpty((CharSequence)item.getString(field.getName() + "_dictText"))) {
                        item.put(field.getName() + "_dictText", (Object)textValue);
                    }
                } else if (field.getType().isAssignableFrom(List.class) && !"java.lang.Object".equals(field.getType().getName())) {
                    List list = null;
                    try {
                        PropertyDescriptor pd = new PropertyDescriptor(field.getName(), record.getClass());
                        Method getMethod = pd.getReadMethod();
                        list = (List)getMethod.invoke(record, new Object[0]);
                    }
                    catch (Exception var23) {
                        log.error("json\u89e3\u6790\u5931\u8d25" + var23.getMessage(), (Throwable)var23);
                    }
                    if (CollectionUtil.isNotEmpty(list) && (list.get(0) instanceof BaseEntity || list.get(0) instanceof BaseDTO)) {
                        ArrayList<JSONObject> items = new ArrayList<JSONObject>();
                        for (Object obj : list) {
                            JSONObject itemObj = this.parseJson(obj, templateAccount, busAccount, templateNumber, templateVersion);
                            items.add(itemObj);
                        }
                        item.put(field.getName(), items);
                    }
                } else {
                    Class<?> superclass;
                    Class<?> type = field.getType();
                    for (superclass = type.getSuperclass(); superclass != null && !superclass.equals(BaseEntity.class) && !superclass.equals(BaseDTO.class); superclass = superclass.getSuperclass()) {
                    }
                    if (superclass != null) {
                        try {
                            PropertyDescriptor pd = new PropertyDescriptor(field.getName(), record.getClass());
                            Method getMethod = pd.getReadMethod();
                            Object obj = getMethod.invoke(record, new Object[0]);
                            JSONObject itemObj = this.parseJson(obj, templateAccount, busAccount, templateNumber, templateVersion);
                            item.put(field.getName(), (Object)itemObj);
                        }
                        catch (Exception var22) {
                            log.error(field.getName() + "\u83b7\u53d6\u5b57\u6bb5\u503c\u5931\u8d25" + var22.getMessage(), (Throwable)var22);
                        }
                    }
                }
            }
            if (Date.class.equals(field.getType()) && field.getAnnotation(JsonFormat.class) == null && item.get((Object)field.getName()) != null) {
                SimpleDateFormat aDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                item.put(field.getName(), (Object)aDate.format(DateUtils.parseDate((Object)item.get((Object)field.getName()))));
            }
            if (Date.class.equals(field.getType()) && item.get((Object)field.getName()) != null && null != (date = DateUtils.parseDate((Object)item.get((Object)field.getName())))) {
                item.put(field.getName() + "_DateMaps", (Object)DateUtils.getMillis((Date)date));
            }
            if (!field.getType().isAssignableFrom(BigDecimal.class) || null == (annotation = field.getAnnotation(BigDecimalFormat.class))) continue;
            try {
                BigDecimal v;
                int scale = annotation.scale();
                field.setAccessible(true);
                Object o = field.get(record);
                if (null == o && annotation.nullToZero()) {
                    o = BigDecimal.ZERO;
                }
                if ((v = (BigDecimal)o) == null) {
                    v = BigDecimal.ZERO;
                }
                formatVal = String.format("%." + scale + "f", v.doubleValue());
                item.put(field.getName(), (Object)formatVal);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    private String translateDictValue(JSONObject item, String code, String text, String table, String key, boolean isFilterSql, String busAccount, String valueText) {
        try {
            if (ConvertUtils.isEmpty((Object)key)) {
                return null;
            }
            String language = I18nUtil.getCurrentLanguage();
            if (StrUtil.isBlank((CharSequence)language)) {
                language = "zh";
            }
            StringBuilder textValue = new StringBuilder();
            String[] keys = key.split(",");
            for (int i = 0; i < keys.length; ++i) {
                String tmpValue;
                String k = keys[i];
                if (k.trim().length() == 0) continue;
                String temCode = code;
                if (code.contains("${")) {
                    isFilterSql = true;
                    StringBuffer filterSql = new StringBuffer();
                    Matcher matcher = this.pattern.matcher(code);
                    while (matcher.find()) {
                        Object o = item.get((Object)matcher.group(1));
                        if (null == o) {
                            o = "";
                        }
                        matcher.appendReplacement(filterSql, o.toString().split(",")[i] + "");
                    }
                    matcher.appendTail(filterSql);
                    temCode = filterSql.toString();
                }
                if (StrUtil.isBlank((CharSequence)busAccount)) {
                    busAccount = "100000";
                }
                StringBuilder mapKey = new StringBuilder(busAccount);
                if (isFilterSql) {
                    mapKey.append("_").append(k.trim()).append("_").append(table).append("_").append(text).append("_").append(text).append("_").append(temCode);
                    if (this.localCacheMap.containsKey(mapKey.toString())) {
                        tmpValue = this.localCacheMap.get(mapKey.toString());
                    } else {
                        tmpValue = this.dictTranslateService.queryTableDictTextByFilterSql(busAccount, k.trim(), table, text, text, temCode);
                        this.localCacheMap.put(mapKey.toString(), tmpValue);
                    }
                } else if (StrUtil.isNotBlank((CharSequence)valueText)) {
                    mapKey.append("_").append(k.trim()).append("_").append(table).append("_").append(text).append("_").append(valueText).append("_").append(temCode);
                    if (this.localCacheMap.containsKey(mapKey.toString())) {
                        tmpValue = this.localCacheMap.get(mapKey.toString());
                    } else {
                        tmpValue = this.dictTranslateService.queryTableDictTextByFilterSql(busAccount, k.trim(), table, text, valueText, temCode);
                        this.localCacheMap.put(mapKey.toString(), tmpValue);
                    }
                } else {
                    mapKey.append("_").append(language).append("_").append(k.trim()).append("_").append(temCode);
                    if (this.localCacheMap.containsKey(mapKey.toString())) {
                        tmpValue = this.localCacheMap.get(mapKey.toString());
                    } else {
                        tmpValue = this.dictTranslateService.queryDictTextByKey(temCode, k.trim(), busAccount);
                        this.localCacheMap.put(mapKey.toString(), tmpValue);
                    }
                }
                if (tmpValue == null) continue;
                if (!"".equals(textValue.toString())) {
                    textValue.append(",");
                }
                textValue.append(tmpValue);
            }
            return textValue.length() == 0 ? key : textValue.toString();
        }
        catch (Exception var18) {
            log.error("translateDictValue_failed:", (Throwable)var18);
            throw var18;
        }
    }
}

