/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.extend.api.utils;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.system.vo.LoginUser;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.IPUtils;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.stream.function.StreamBridge;
import org.springframework.messaging.support.MessageBuilder;

public class ExtendMqUtil {
    private static final Logger log = LoggerFactory.getLogger(ExtendMqUtil.class);
    private static ExecutorService THREAD_POOL = new ThreadPoolExecutor(5, 20, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());

    public static void sendLogMsg(String msgBody) {
        try {
            if (StrUtil.isBlank((CharSequence)msgBody)) {
                return;
            }
            String key = IdWorker.getIdStr();
            StreamBridge source = (StreamBridge)SpringContextUtils.getBean(StreamBridge.class);
            if (source != null) {
                log.info("msgBody:" + msgBody);
                source.send("inputLog-out-0", (Object)MessageBuilder.withPayload((Object)msgBody).setHeader("KEYS", (Object)key).build());
            }
        }
        catch (Exception var3) {
            log.error("sendLogMsg_failed:", (Throwable)var3);
        }
    }

    public static void sendLogMsg(String elsAccount, String logContent, Integer logType, Integer operateType) {
        JSONObject object = new JSONObject();
        object.put("elsAccount", (Object)elsAccount);
        object.put("logContent", (Object)logContent);
        object.put("logType", (Object)logType);
        object.put("operateType", (Object)operateType);
        try {
            HttpServletRequest request = SpringContextUtils.getHttpServletRequest();
            object.put("ip", (Object)IPUtils.getIpAddr((HttpServletRequest)request));
            LoginUser sysUser = SysUtil.getLoginUser();
            if (sysUser != null) {
                object.put("userid", (Object)sysUser.getSubAccount());
                object.put("username", (Object)sysUser.getRealname());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ExtendMqUtil.sendLogMsg(object.toJSONString());
    }

    public static void sendIntegrateDataMsg(String integratedId, String businessType, String businessId, String businessDataType, JSONObject jsonObject) {
        JSONObject object = new JSONObject();
        object.put("integratedId", (Object)integratedId);
        object.put("businessType", (Object)businessType);
        object.put("businessId", (Object)businessId);
        object.put("businessDataType", (Object)businessDataType);
        object.put("jsonData", (Object)jsonObject.toJSONString());
        JSONObject objectdata = new JSONObject();
        objectdata.put("dataType", (Object)"integrateData");
        objectdata.put("data", (Object)object);
        ExtendMqUtil.sendIntegrateDataMsg(objectdata.toJSONString());
    }

    public static void sendIntegrateDataLinkMsg(String integratedId, String businessType, String businessParentType, String businessId, String businessParentId, String businessDataType) {
        JSONObject object = new JSONObject();
        LoginUser loginUser = SysUtil.getLoginUser();
        object.put("integratedId", (Object)integratedId);
        object.put("elsAccount", (Object)TenantContext.getTenant());
        object.put("createBy", (Object)(loginUser.getSubAccount() + "_" + loginUser.getRealname()));
        object.put("updateBy", (Object)(loginUser.getSubAccount() + "_" + loginUser.getRealname()));
        object.put("businessType", (Object)businessType);
        object.put("businessParentType", (Object)businessParentType);
        object.put("businessId", (Object)businessId);
        object.put("businessParentId", (Object)businessParentId);
        object.put("businessDataType", (Object)businessDataType);
        JSONObject objectdata = new JSONObject();
        objectdata.put("dataType", (Object)"integrateDataLink");
        JSONArray jsonArray = new JSONArray();
        objectdata.put("jsonArray", (Object)jsonArray.add((Object)object));
        ExtendMqUtil.sendIntegrateDataMsg(objectdata.toJSONString());
    }

    public static void sendIntegrateDataLinkMsg(JSONArray jsonArray, List<String> delItemStringList, List<String> delHeadStringList) {
        JSONObject objectdata = new JSONObject();
        objectdata.put("dataType", (Object)"integrateDataLink");
        if (jsonArray != null) {
            objectdata.put("jsonArray", (Object)jsonArray);
        }
        if (!CollectionUtils.isEmpty(delItemStringList)) {
            objectdata.put("delItemStringList", delItemStringList);
        }
        if (!CollectionUtils.isEmpty(delHeadStringList)) {
            objectdata.put("delHeadStringList", delHeadStringList);
        }
        ExtendMqUtil.sendIntegrateDataMsg(objectdata.toJSONString());
    }

    public static void sendIntegrateDataMsg(final String msgBody) {
        if (!StrUtil.isBlank((CharSequence)msgBody)) {
            final String key = IdWorker.getIdStr();
            final String elsAccount = TenantContext.getTenant();
            THREAD_POOL.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        InvokeBaseRpcService service = (InvokeBaseRpcService)SpringContextUtils.getBean(InvokeBaseRpcService.class);
                        service.saveRecord(elsAccount, key, msgBody, "integrateMessage");
                        StreamBridge sourceIntegratedData = (StreamBridge)SpringContextUtils.getBean(StreamBridge.class);
                        if (sourceIntegratedData != null) {
                            log.info("IntegrateData msgBody:" + msgBody);
                            sourceIntegratedData.send("inputIntegratedData-out-0", (Object)MessageBuilder.withPayload((Object)msgBody).setHeader("KEYS", (Object)key).build());
                        }
                    }
                    catch (Exception var3) {
                        log.error("sendBusMsg_failed:", (Throwable)var3);
                    }
                }
            });
        }
    }

    public static void sendBusMsg(String msgBody) {
        if (!StrUtil.isBlank((CharSequence)msgBody)) {
            String key = IdWorker.getIdStr();
            String elsAccount = TenantContext.getTenant();
            THREAD_POOL.submit(() -> {
                try {
                    InvokeBaseRpcService service = (InvokeBaseRpcService)SpringContextUtils.getBean(InvokeBaseRpcService.class);
                    service.saveRecord(elsAccount, key, msgBody, "busMessage");
                    StreamBridge source = (StreamBridge)SpringContextUtils.getBean(StreamBridge.class);
                    if (source == null) {
                        log.error(":::MqUtil source is null");
                    } else {
                        source.send("newInput-out-0", (Object)MessageBuilder.withPayload((Object)msgBody).setHeader("KEYS", (Object)key).build());
                        log.info("sendBusMsg over");
                    }
                }
                catch (Exception var3) {
                    log.error("sendBusMsg_failed:", (Throwable)var3);
                }
            });
        }
    }

    public static void sendBusMsg(String purchaseAccount, String businessType, String optType, MsgParamsVO msgParamsVO) {
        LoginUser loginUser = SysUtil.getLoginUser();
        if (loginUser == null) {
            InvokeAccountRpcService invokeAccountRpcService = (InvokeAccountRpcService)SpringContextUtils.getBean(InvokeAccountRpcService.class);
            ElsSubAccountDTO account = invokeAccountRpcService.getAccount(purchaseAccount, "1001");
            loginUser = (LoginUser)JSONObject.parseObject((String)JSON.toJSONString((Object)account), LoginUser.class);
            log.info("not find loginUser or get admin user : " + loginUser);
        }
        ExtendMqUtil.sendBusMsg(purchaseAccount, businessType, optType, msgParamsVO, loginUser);
    }

    public static void sendBusMsg(String purchaseAccount, String businessType, String optType, MsgParamsVO msgParamsVO, LoginUser loginUser) {
        JSONObject msgObj = new JSONObject();
        msgObj.put("msgKey", (Object)IdWorker.getIdStr());
        msgObj.put("busAccount", (Object)purchaseAccount);
        msgObj.put("businessType", (Object)businessType);
        msgObj.put("operateType", (Object)optType);
        msgObj.put("businessObj", (Object)SysUtil.objectToJSON((Object)msgParamsVO.getParams()));
        msgObj.put("sendObj", (Object)loginUser);
        Map accountMap = msgParamsVO.getReceiverMap();
        JSONArray array = new JSONArray();
        for (String elsAccount : accountMap.keySet()) {
            List list = (List)accountMap.get(elsAccount);
            JSONObject receiveObj = new JSONObject();
            receiveObj.put("toElsAccount", (Object)elsAccount);
            JSONObject object = msgParamsVO.getReceiveParamMap() != null ? (JSONObject)msgParamsVO.getReceiveParamMap().get(elsAccount) : null;
            String urlParam = object == null ? "" : SysUtil.getUrlParamByJson((JSONObject)object);
            receiveObj.put("urlParam", (Object)urlParam);
            receiveObj.put("toSubAccountList", (Object)JSONObject.parseArray((String)JSON.toJSONString((Object)list)));
            array.add((Object)receiveObj);
        }
        msgObj.put("receiveList", (Object)array);
        ExtendMqUtil.sendBusMsg(msgObj.toJSONString());
    }

    public static void sendOperateEventMsg(String msg) {
        if (!StrUtil.isBlank((CharSequence)msg)) {
            StreamBridge source = (StreamBridge)SpringContextUtils.getBean(StreamBridge.class);
            log.info("MqUtil: " + msg + "   source:" + JSONObject.toJSONString((Object)source));
            if (source != null) {
                source.send("inputOperateEvent-out-0", (Object)MessageBuilder.withPayload((Object)msg).setHeader("KEYS", (Object)IdWorker.getIdStr()).build());
            }
        }
    }

    public static void sendOperateEventMsg(String elsAccount, String businessType, String optType, String operateMethod, Object businessObj) {
        JSONObject msgObj = new JSONObject();
        msgObj.put("msgKey", (Object)IdWorker.getIdStr());
        msgObj.put("elsAccount", (Object)elsAccount);
        msgObj.put("businessType", (Object)businessType);
        msgObj.put("operateType", (Object)optType);
        msgObj.put("operateMethod", (Object)operateMethod);
        msgObj.put("businessObj", (Object)JSON.toJSONString((Object)businessObj));
        ExtendMqUtil.sendOperateEventMsg(msgObj.toJSONString());
    }
}

