/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.extend.api.utils;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.extend.api.enums.OptTypeEnum;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class InvokeInterfaceUtil {
    private static final Logger log = LoggerFactory.getLogger(InvokeInterfaceUtil.class);
    @Value(value="${els.config.purchaseAccount}")
    private String elsAccount;
    @Value(value="${erp.appToken.appId}")
    private String appTokenAppId;
    @Value(value="${erp.appToken.appSecuret}")
    private String appTokenAppSecuret;
    @Value(value="${erp.appToken.tenantid}")
    private String appTokenTenantid;
    @Value(value="${erp.appToken.accountId}")
    private String appTokenAccountId;
    @Value(value="${erp.appToken.language}")
    private String appTokenLanguage;
    @Value(value="${erp.accessToken.tenantid}")
    private String accessTokenTenantid;
    @Value(value="${erp.accessToken.accountId}")
    private String accessTokenAccountId;
    @Value(value="${erp.accessToken.user}")
    private String accessTokenUser;
    @Value(value="${erp.accessToken.usertype}")
    private String accessTokenUsertype;
    @Resource
    private InterfaceUtil interfaceUtil;
    @Resource
    private RedisUtil redisUtil;
    private static final String ERP_SUCCESS = "0";

    public JSONObject invokeErp(String account, OptTypeEnum optType, JSONObject urlParam, JSONObject bodyParam) {
        String elsAccount = StrUtil.isBlank((CharSequence)account) ? TenantContext.getTenant() : account;
        JSONObject headParam = new JSONObject();
        headParam.put("accessToken", (Object)this.getAccessToken(elsAccount));
        JSONObject resultObj = this.interfaceUtil.callInterface(elsAccount, elsAccount, optType.getValue(), headParam, urlParam, bodyParam, (Object)new JSONObject());
        log.info("erpCallInterface\u8c03\u7528\u63a5\u53e3{}\uff0cresultObj ===> {}", (Object)optType.getValue(), (Object)resultObj);
        String code = resultObj.getString("code");
        Assert.isTrue((boolean)StrUtil.equals((CharSequence)"200", (CharSequence)code), (String)resultObj.getString("message"), (Object[])new Object[0]);
        JSONObject result = resultObj.getJSONObject("result");
        return result;
    }

    public JSONObject invokeErpT(String account, OptTypeEnum optType, JSONObject urlParam, JSONObject bodyParam) {
        String elsAccount = StrUtil.isBlank((CharSequence)account) ? TenantContext.getTenant() : account;
        JSONObject headParam = new JSONObject();
        headParam.put("accessToken", (Object)this.getAccessToken(elsAccount));
        JSONObject resultObj = this.interfaceUtil.callInterface(elsAccount, elsAccount, optType.getValue(), headParam, urlParam, bodyParam, (Object)new JSONObject());
        log.info("erpCallInterface\u8c03\u7528\u63a5\u53e3{}\uff0cresultObj ===> {}", (Object)optType.getValue(), (Object)resultObj);
        JSONObject result = resultObj.getJSONObject("result");
        log.info("erpCallInterface\u8c03\u7528\u63a5\u53e3{}\uff0cresult ===> {}", (Object)optType.getValue(), (Object)result);
        return result;
    }

    public String getAccessToken(String elsAccount) {
        String accessToken = "";
        String key = "erp_access_token:" + this.appTokenAppId + this.appTokenTenantid;
        Object accessTokenObj = this.redisUtil.get(key);
        log.info("redisAccessTokenObj:{}", accessTokenObj);
        if (StrUtil.isBlank((CharSequence)accessToken)) {
            JSONObject headParam = new JSONObject();
            JSONObject bodyParam = new JSONObject();
            bodyParam.put("appId", (Object)this.appTokenAppId);
            bodyParam.put("appSecuret", (Object)this.appTokenAppSecuret);
            bodyParam.put("tenantid", (Object)this.appTokenTenantid);
            bodyParam.put("accountId", (Object)this.appTokenAccountId);
            bodyParam.put("language", (Object)this.appTokenLanguage);
            JSONObject appTokenResultObj = this.interfaceUtil.callInterface(elsAccount, elsAccount, OptTypeEnum.ERP_GET_APP_TOKEN.getValue(), headParam, new JSONObject(), bodyParam, (Object)new JSONObject());
            log.info("erpAppTokenCallInterface\u8c03\u7528\u63a5\u53e3{}\uff0cresultObj ===> {}", (Object)OptTypeEnum.ERP_GET_APP_TOKEN.getValue(), (Object)appTokenResultObj);
            String code = appTokenResultObj.getString("code");
            Assert.isTrue((boolean)StrUtil.equals((CharSequence)"200", (CharSequence)code), (String)appTokenResultObj.getString("message"), (Object[])new Object[0]);
            JSONObject result = appTokenResultObj.getJSONObject("result");
            if (result.getBoolean("status").booleanValue()) {
                JSONObject appTokenDataObj = result.getJSONObject("data");
                String appToken = appTokenDataObj.getString("app_token");
                JSONObject headParam2 = new JSONObject();
                JSONObject bodyParam2 = new JSONObject();
                bodyParam2.put("user", (Object)this.accessTokenUser);
                bodyParam2.put("apptoken", (Object)appToken);
                bodyParam2.put("accountId", (Object)this.accessTokenAccountId);
                bodyParam2.put("usertype", (Object)this.accessTokenUsertype);
                JSONObject accessTokenResultObj = this.interfaceUtil.callInterface(elsAccount, elsAccount, OptTypeEnum.ERP_GET_ACCESS_TOKEN.getValue(), headParam2, new JSONObject(), bodyParam2, (Object)new JSONObject());
                log.info("erpAccessTokenCallInterface\u8c03\u7528\u63a5\u53e3{}\uff0cresultObj ===> {}", (Object)OptTypeEnum.ERP_GET_ACCESS_TOKEN.getValue(), (Object)accessTokenResultObj);
                String code2 = accessTokenResultObj.getString("code");
                Assert.isTrue((boolean)StrUtil.equals((CharSequence)"200", (CharSequence)code2), (String)accessTokenResultObj.getString("message"), (Object[])new Object[0]);
                JSONObject result2 = accessTokenResultObj.getJSONObject("result");
                if (result2.getBoolean("status").booleanValue()) {
                    JSONObject accessTokenDataObj = result2.getJSONObject("data");
                    accessToken = accessTokenDataObj.getString("access_token");
                    this.redisUtil.set(key, (Object)JSONUtil.toJsonStr((Object)accessTokenDataObj), 3600L);
                }
            }
        }
        if (StrUtil.isBlank((CharSequence)accessToken)) {
            throw new ELSBootException("\u83b7\u53d6ERP token\u5931\u8d25!");
        }
        return accessToken;
    }
}

