/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.extend.api.util;

import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SegmentUtil {
    public static final int LIMIT = 1000;

    public static <T> void segment(List<T> list, long limit, Consumer<List<T>> action) {
        SegmentUtil.segment(list, limit).forEach(action);
    }

    public static <T> List<List<T>> segment(List<T> list, long limit) {
        long splitCount = ((long)list.size() + limit - 1L) / limit;
        return Stream.iterate(0, n -> n + 1).limit(splitCount).map(a -> list.stream().skip((long)a.intValue() * limit).limit(limit).collect(Collectors.toList())).collect(Collectors.toList());
    }

    public static long handlePage(long total) {
        return SegmentUtil.handlePage(total, 1000);
    }

    public static long handlePage(long total, int limit) {
        return total % (long)limit == 0L ? total / (long)limit : total / (long)limit + 1L;
    }
}

