/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.extend.api.utils;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.els.common.exception.ELSBootException;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.service.FileRpcService;
import com.els.modules.base.api.service.PurchaseAttachmentRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class DataFerryUtil {
    private static final Logger log = LoggerFactory.getLogger(DataFerryUtil.class);
    private static final String DATA_FERRY_FILE_PATH = "/dataferry/";

    public static void saveZip(String interfaceCode, JSONArray dataList, Map<String, List<String>> fileMap, List<String> numberList) throws IOException {
        InvokeBaseRpcService invokeBaseRpcService = (InvokeBaseRpcService)SpringUtil.getBean(InvokeBaseRpcService.class);
        List dataFerry = invokeBaseRpcService.queryDictItemsByCode("dataFerry", SysUtil.getPurchaseAccount());
        DictDTO dictDTO = dataFerry.stream().filter(info -> StrUtil.equals((CharSequence)interfaceCode, (CharSequence)info.getText())).findFirst().orElseThrow(() -> new ELSBootException("\u5b57\u5178\u4e2d\u672a\u914d\u7f6e\u63a5\u53e3\u7f16\u7801[" + interfaceCode + "]\u5bf9\u5e94\u7684\u6446\u6e21\u5b9e\u73b0\u7c7b\u7f16\u7801,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
        String dataFerryImplBean = dictDTO.getValue();
        String date = DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss");
        String id = SysUtil.getAssignId(null);
        String zipFileName = interfaceCode + "-" + date + "-" + id + ".zip";
        ArrayList fileNames = CollUtil.newArrayList((Object[])new String[0]);
        String fileName = interfaceCode + "-" + dataFerryImplBean + "-" + date + ".txt";
        fileNames.add(fileName);
        String zipFilePath = DATA_FERRY_FILE_PATH + zipFileName;
        String UPLOAD_PATH = ((Environment)SpringContextUtils.getBean(Environment.class)).getProperty("els.path.upload");
        File zipFile = new File(UPLOAD_PATH + zipFilePath);
        if (!zipFile.getParentFile().exists()) {
            zipFile.getParentFile().mkdirs();
        }
        for (Map.Entry<String, List<String>> entry : fileMap.entrySet()) {
            String key = entry.getKey();
            List<String> value = entry.getValue();
            for (String filePath : value) {
                fileNames.add(key + "@@" + filePath);
            }
        }
        String filenamePath = "filename.txt";
        String numberListFile = "numberList.txt";
        ByteArrayInputStream filenameIs = new ByteArrayInputStream(JSONObject.toJSONBytes((Object)fileNames, (SerializerFeature[])new SerializerFeature[0]));
        ByteArrayInputStream numberListFileIs = new ByteArrayInputStream(JSONObject.toJSONBytes((Object)CollUtil.newHashSet(numberList), (SerializerFeature[])new SerializerFeature[0]));
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(JSONObject.toJSONBytes((Object)dataList, (SerializerFeature[])new SerializerFeature[0]));
        File zip = ZipUtil.zip((File)zipFile, (String[])new String[]{fileName, filenamePath, numberListFile}, (InputStream[])new InputStream[]{byteArrayInputStream, filenameIs, numberListFileIs});
        FileRpcService fileRpcService = (FileRpcService)SpringUtil.getBean(FileRpcService.class);
        String uploadPath = fileRpcService.uploadFiles(FileUtil.readBytes((File)zip), zipFilePath, zipFileName);
        PurchaseAttachmentRpcService purchaseAttachmentRpcService = (PurchaseAttachmentRpcService)SpringUtil.getBean(PurchaseAttachmentRpcService.class);
        PurchaseAttachmentDTO purchaseAttachmentDTO = new PurchaseAttachmentDTO();
        purchaseAttachmentDTO.setId(id);
        purchaseAttachmentDTO.setFileName(zipFileName);
        purchaseAttachmentDTO.setFilePath(uploadPath);
        purchaseAttachmentDTO.setBusinessType("dataFerry");
        purchaseAttachmentDTO.setFileType("dataFerry");
        purchaseAttachmentDTO.setSaveType("local");
        purchaseAttachmentDTO.setFileSize(Convert.toStr((Object)FileUtil.size((File)zip)));
        purchaseAttachmentDTO.setUploadElsAccount(SysUtil.getPurchaseAccount());
        purchaseAttachmentDTO.setSendStatus("0");
        purchaseAttachmentDTO.setFbk1("0");
        purchaseAttachmentDTO.setFbk3(CollUtil.join((Iterable)fileNames, (CharSequence)","));
        purchaseAttachmentDTO.setFbk4(dictDTO.getDescription());
        purchaseAttachmentDTO.setFbk10(CollUtil.join(numberList, (CharSequence)","));
        purchaseAttachmentRpcService.insert(purchaseAttachmentDTO);
    }
}

