/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.extend.job.base;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.els.common.api.service.JobRpcService;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.LoginUserContext;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.extend.job.base.IJob;
import com.els.modules.extend.job.param.JobParameter;
import com.els.rpc.service.InvokeAccountRpcService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public abstract class BaseJob<T extends JobParameter>
extends TypeReference<T>
implements JobRpcService,
IJob<T> {
    private static final Logger log = LoggerFactory.getLogger(BaseJob.class);
    private InvokeAccountRpcService invokeAccountRpcService = (InvokeAccountRpcService)SpringContextUtils.getBean(InvokeAccountRpcService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String parameter) {
        if (StringUtils.isBlank((CharSequence)parameter)) {
            log.info("==================\u53c2\u6570\u4e3a\u7a7a\uff0c\u6267\u884c\u5931\u8d25=============");
            return;
        }
        JobParameter jobParameter = (JobParameter)JSONObject.parseObject((String)parameter, (TypeReference)this, (Feature[])new Feature[0]);
        try {
            TenantContext.setTenant((String)jobParameter.getTenantId());
            LoginUserDTO loginUserDTO = this.invokeAccountRpcService.getLoginUser(jobParameter.getTenantId() + "_" + "1001");
            LoginUser loginUser = new LoginUser();
            BeanUtils.copyProperties((Object)loginUserDTO, (Object)loginUser);
            LoginUserContext.setUser((LoginUser)loginUser);
            this.jobBusiness((T)jobParameter);
        }
        catch (Exception e) {
            log.error("\u5b9a\u65f6\u4efb\u52a1\u3010{}\u3011\uff0c\u6267\u884c\u51fa\u9519\uff1a{}", (Object)jobParameter.getJobImplName(), (Object)e);
        }
        finally {
            TenantContext.clear();
            LoginUserContext.clear();
        }
    }

    @Override
    public void jobBusiness(T param) {
    }
}

