/*
 * Decompiled with CFR 0.152.
 */
package com.els.common.validator;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.els.api.dto.EntityTableFieldDto;
import com.els.common.context.SrmLengthCheckTableHolder;
import com.els.common.util.ClassTypeBuilder;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.validator.BaseEnum;
import com.els.common.validator.DefaultErrorMessage;
import com.els.common.validator.DictBuilder;
import com.els.modules.base.api.dto.DictDTO;
import com.google.common.collect.Sets;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintValidatorContextImpl;
import org.hibernate.validator.internal.engine.path.NodeImpl;
import org.hibernate.validator.internal.engine.path.PathImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.core.RedisTemplate;

@Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER})
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
@Constraint(validatedBy={FieldContentLengthValidatorInner.class})
public @interface SrmLength {
    public String scopeTitle() default "";

    public String scopeI18key() default "";

    public int min() default 0;

    public int max() default 0x7FFFFFFF;

    public CheckType checkType() default CheckType.GENERAL;

    public String i18Key() default "";

    public String dictCode() default "";

    public Class<? extends BaseEnum> enumClass() default BaseEnum.class;

    public Class<?> dataClass() default String.class;

    public String message() default "";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public static class FieldContentLengthValidatorInner
    implements ConstraintValidator<SrmLength, Object> {
        private static final Logger log = LoggerFactory.getLogger(FieldContentLengthValidatorInner.class);
        final String fieldLengthCheck = ((Environment)SpringContextUtils.getBean(Environment.class)).getProperty("els.switch.fieldLengthCheck");
        private static final Set<Class<?>> COLLECT_SUPPORT_TYPE = Sets.newHashSet((Object[])new Class[]{Integer.class, Long.class, String.class, Float.class, BigDecimal.class, BigInteger.class, Short.class, Double.class, Object.class});
        private String scopeTitle;
        private String scopeI18key;
        private int min;
        private int max;
        private CheckType checkType;
        private String i18Key;
        private String dictCode;
        private String message;
        private Class<? extends BaseEnum> enumClass;
        private Class<?> dataClass;

        public void initialize(SrmLength annotation) {
            this.scopeTitle = annotation.scopeTitle();
            this.scopeI18key = annotation.scopeI18key();
            this.min = annotation.min();
            this.max = annotation.max();
            this.checkType = annotation.checkType();
            this.i18Key = annotation.i18Key();
            this.dictCode = annotation.dictCode();
            this.message = annotation.message();
            this.enumClass = annotation.enumClass();
            this.dataClass = annotation.dataClass();
        }

        public boolean isValid(Object obj, ConstraintValidatorContext context) {
            PathImpl invoke;
            System.out.println("==============SrmLength=========isValid\u5f00\u59cb==============");
            String open = CharSequenceUtil.emptyToDefault((CharSequence)((Environment)SpringContextUtils.getBean(Environment.class)).getProperty("els.config.dbLengthCheck"), (String)"open");
            System.out.println("==============SrmLength=========\u662f\u5426\u5f00\u542f\u4e86\u6570\u636e\u5e93\u6821\u9a8c:" + open);
            if (ObjectUtil.isNull((Object)obj) || CharSequenceUtil.isEmpty((CharSequence)StrUtil.toString((Object)obj))) {
                return true;
            }
            Class checkClazz = SrmLengthCheckTableHolder.get();
            boolean dbCheck = false;
            String checkTable = "";
            String dbCheckFieldName = "";
            if (null != checkClazz && "open".equals(open)) {
                System.out.println("==============SrmLength=========\u8fdb\u5165\u6570\u636e\u5e93\u6821\u9a8c");
                try {
                    boolean breakDb;
                    ConstraintValidatorContextImpl contextImpl = (ConstraintValidatorContextImpl)context;
                    Method getCopyOfBasePath = contextImpl.getClass().getDeclaredMethod("getCopyOfBasePath", new Class[0]);
                    getCopyOfBasePath.setAccessible(true);
                    invoke = (PathImpl)getCopyOfBasePath.invoke((Object)context, new Object[0]);
                    NodeImpl leafNode = invoke.getLeafNode();
                    getCopyOfBasePath.setAccessible(false);
                    NodeImpl parent = leafNode.getParent();
                    dbCheckFieldName = leafNode.getName();
                    try {
                        Class ignoreClass = parent.getContainerClass();
                        breakDb = null != ignoreClass && ignoreClass.isAssignableFrom(Collection.class);
                    }
                    catch (Exception e) {
                        breakDb = true;
                    }
                    if (null != parent && CharSequenceUtil.isNotEmpty((CharSequence)parent.getName()) && !breakDb) {
                        String itemFieldName = parent.getName();
                        Field itemField = checkClazz.getDeclaredField(itemFieldName);
                        Class itemClazz = null;
                        if (itemField.getType().isAssignableFrom(List.class) || itemField.getType().isAssignableFrom(Set.class)) {
                            Type fieldType = itemField.getGenericType();
                            if (fieldType instanceof ParameterizedType) {
                                ParameterizedType ptype = (ParameterizedType)fieldType;
                                Type[] typeArgs = ptype.getActualTypeArguments();
                                itemClazz = (Class)typeArgs[0];
                            }
                        } else {
                            itemClazz = itemField.getType();
                        }
                        checkTable = ClassTypeBuilder.getTableNameAnnotation(itemClazz);
                    } else {
                        checkTable = ClassTypeBuilder.getTableNameAnnotation((Class)checkClazz);
                    }
                    dbCheck = true;
                }
                catch (Exception contextImpl) {
                    // empty catch block
                }
            }
            List fieldDtoList = null;
            if (dbCheck) {
                System.out.println("==============SrmLength=========\u8fdb\u8fdb\u5165redis\u62c9\u53d6\u5185\u5bb9");
                RedisTemplate redisTemplate = (RedisTemplate)SpringContextUtils.getBean((String)"tableEntityRedisTemplate", RedisTemplate.class);
                fieldDtoList = (List)redisTemplate.opsForHash().get((Object)"srm:length:table", (Object)checkTable);
                if (CollectionUtil.isEmpty((Collection)fieldDtoList)) {
                    dbCheck = false;
                }
                System.out.println("==============SrmLength=========redis\u62c9\u53d6\u5230\u7684\u5185\u5bb9" + JSON.toJSONString((Object)fieldDtoList));
            }
            switch (this.checkType) {
                case GENERAL: {
                    System.out.println("==============SrmLength=========re\u8fdb\u5165\u5b57\u7b26\u4e32\u6821\u9a8c");
                    if (obj instanceof Collection) {
                        Object o;
                        if (CollectionUtil.isEmpty((Collection)((Collection)obj))) {
                            return true;
                        }
                        boolean flag = false;
                        invoke = ((Collection)obj).iterator();
                        while (invoke.hasNext() && (flag = this.checkBaseDataType(o = invoke.next(), context, dbCheck, dbCheckFieldName, fieldDtoList))) {
                        }
                        return flag;
                    }
                    return this.checkBaseDataType(obj, context, dbCheck, dbCheckFieldName, fieldDtoList);
                }
                case DICT: {
                    if (CharSequenceUtil.isEmpty((CharSequence)this.dictCode)) {
                        context.disableDefaultConstraintViolation();
                        context.buildConstraintViolationWithTemplate(I18nUtil.translate((String)DefaultErrorMessage.FIELD_LENGTH_EXCEEDS_MAXIMUM.getI18Key(), (String)DefaultErrorMessage.FIELD_LENGTH_EXCEEDS_MAXIMUM.getValue())).addConstraintViolation();
                        return false;
                    }
                    List dictList = DictBuilder.getDictList((String)this.dictCode);
                    if (CollectionUtil.isEmpty((Collection)dictList)) {
                        return true;
                    }
                    List list = dictList.stream().map(DictDTO::getValue).collect(Collectors.toList());
                    boolean contains = list.contains(obj);
                    if (!contains) {
                        this.message = DefaultErrorMessage.DICTIONARY_SCOPE_LIMITATION.getValue();
                        this.i18Key = DefaultErrorMessage.DICTIONARY_SCOPE_LIMITATION.getI18Key();
                        String msg = I18nUtil.translate((String)this.scopeI18key, (String)this.scopeTitle) + I18nUtil.translate((String)this.i18Key, (String)this.message) + " [" + String.join((CharSequence)",", DictBuilder.getDictListText((List)dictList)) + "]";
                        context.disableDefaultConstraintViolation();
                        context.buildConstraintViolationWithTemplate(msg).addConstraintViolation();
                        return contains;
                    }
                    return this.checkBaseDataType(obj, context, false, "", null);
                }
                case ENUMS: {
                    BaseEnum[] enums = this.enumClass.getEnumConstants();
                    if (null == enums || enums.length == 0) {
                        return true;
                    }
                    List list = Arrays.stream(enums).map(BaseEnum::getValue).collect(Collectors.toList());
                    boolean contains = list.contains(StrUtil.toString((Object)obj));
                    if (!contains) {
                        this.i18Key = DefaultErrorMessage.ENUM_RANGE_RESTRICTION.getI18Key();
                        this.message = DefaultErrorMessage.ENUM_RANGE_RESTRICTION.getValue();
                        String msg = I18nUtil.translate((String)this.scopeI18key, (String)this.scopeTitle) + I18nUtil.translate((String)this.i18Key, (String)this.message) + " [" + String.join((CharSequence)",", list) + "]";
                        context.disableDefaultConstraintViolation();
                        context.buildConstraintViolationWithTemplate(msg).addConstraintViolation();
                        return false;
                    }
                    return this.checkBaseDataType(obj, context, false, "", null);
                }
            }
            return true;
        }

        private void buildMessage(ConstraintValidatorContext context, boolean isDefault, String typeName, List<String> limitRangeValue, boolean dbCheck, int initMax) {
            context.disableDefaultConstraintViolation();
            if (isDefault) {
                context.buildConstraintViolationWithTemplate(String.format("[%s] " + I18nUtil.translate((String)DefaultErrorMessage.TYPE_NOT_SUPPORTED.getI18Key(), (String)DefaultErrorMessage.TYPE_NOT_SUPPORTED.getValue()), typeName)).addConstraintViolation();
                return;
            }
            if (this.checkType.equals((Object)CheckType.ENUMS) || this.checkType.equals((Object)CheckType.DICT)) {
                context.buildConstraintViolationWithTemplate(I18nUtil.translate((String)this.i18Key, (String)this.message) + " [" + String.join((CharSequence)",", limitRangeValue) + "]").addConstraintViolation();
                return;
            }
            if (CharSequenceUtil.isEmpty((CharSequence)this.message) || CharSequenceUtil.isNotEmpty((CharSequence)this.scopeTitle)) {
                this.i18Key = DefaultErrorMessage.LIMIT.getI18Key();
                this.message = DefaultErrorMessage.LIMIT.getValue();
                String msg = I18nUtil.translate((String)this.scopeI18key, (String)this.scopeTitle) + I18nUtil.translate((String)this.i18Key, (String)this.message);
                msg.replaceAll("Max}", "max}").replaceAll("Min}", "min}");
                if (dbCheck && initMax != this.max) {
                    msg = msg.replace("{max}", this.max + "");
                }
                context.buildConstraintViolationWithTemplate(msg).addConstraintViolation();
            } else {
                String msg = I18nUtil.translate((String)this.i18Key, (String)this.message).replaceAll("Max}", "max}").replaceAll("Min}", "min}");
                if (dbCheck && initMax != this.max) {
                    msg = msg.replace("{max}", this.max + "");
                }
                context.buildConstraintViolationWithTemplate(msg).addConstraintViolation();
            }
        }

        private boolean checkBaseDataType(Object obj, ConstraintValidatorContext context, boolean dbCheck, String dbCheckFieldName, List<EntityTableFieldDto> fieldDtoList) {
            boolean flag;
            EntityTableFieldDto tableFieldDto;
            Map fieldDtoMap;
            if (null == obj || CharSequenceUtil.isEmpty((CharSequence)StrUtil.toString((Object)obj))) {
                return true;
            }
            int initMax = this.max;
            if (dbCheck && (fieldDtoMap = fieldDtoList.stream().collect(Collectors.toMap(EntityTableFieldDto::getEntityFiledName, Function.identity(), (v1, v2) -> v2))).containsKey(dbCheckFieldName) && (tableFieldDto = (EntityTableFieldDto)fieldDtoMap.get(dbCheckFieldName)).getTableFieldLength() > 0) {
                this.max = tableFieldDto.getTableFieldLength();
            }
            if (!COLLECT_SUPPORT_TYPE.contains(obj.getClass())) {
                this.buildMessage(context, true, obj.getClass().getSimpleName(), null, false, initMax);
                return false;
            }
            if (this.dataClass.isAssignableFrom(Integer.class)) {
                int length = Integer.parseInt(StrUtil.toString((Object)obj));
                flag = length >= this.min && length <= this.max;
            } else if (this.dataClass.isAssignableFrom(BigDecimal.class) || this.dataClass.isAssignableFrom(Number.class) || this.dataClass.isAssignableFrom(Short.class) || this.dataClass.isAssignableFrom(Double.class) || this.dataClass.isAssignableFrom(Float.class) || this.dataClass.isAssignableFrom(Long.class)) {
                BigDecimal length = BigDecimal.valueOf(Double.parseDouble(StrUtil.toString((Object)obj)));
                flag = length.compareTo(BigDecimal.valueOf(this.min)) >= 0 && length.compareTo(BigDecimal.valueOf(this.max)) <= 0;
            } else {
                int length;
                if (obj instanceof BigDecimal) {
                    BigDecimal scale = ((BigDecimal)obj).setScale(0, RoundingMode.DOWN);
                    length = scale.toString().length();
                } else if (obj instanceof Double) {
                    int scale = ((Double)obj).intValue();
                    length = Integer.toString(scale).length();
                } else if (obj instanceof Float) {
                    int scale = ((Float)obj).intValue();
                    length = Integer.toString(scale).length();
                } else {
                    length = StrUtil.toString((Object)obj).length();
                }
                boolean bl = flag = length >= this.min && length <= this.max;
            }
            if (!flag) {
                this.buildMessage(context, false, null, null, dbCheck, initMax);
            }
            return flag;
        }
    }

    public static enum CheckType {
        GENERAL,
        DICT,
        ENUMS;

    }
}

