/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.extend.interfaces.utils;

import com.alibaba.fastjson.JSONObject;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class InterfaceConvertUtil {
    public static boolean isSap1000(String purchaseOrg) {
        return Objects.equals("7000", purchaseOrg) || Objects.equals("1000", purchaseOrg) || Objects.equals("3100", purchaseOrg) || Objects.equals("3000", purchaseOrg);
    }

    public static boolean isSap6000(String purchaseOrg) {
        return Objects.equals("6000", purchaseOrg) || Objects.equals("F001", purchaseOrg);
    }

    public static boolean isSap1000(String purchaseOrg, String state) {
        return InterfaceConvertUtil.isSap1000(purchaseOrg);
    }

    public static boolean isSap6000(String purchaseOrg, String state) {
        return InterfaceConvertUtil.isSap6000(purchaseOrg);
    }

    public static boolean checkState(String state) {
        return StringUtils.isBlank((CharSequence)state) || Objects.equals(state, "2");
    }

    public static void callInterface(String purchaseOrg, String interfaceCode, Object custom) {
        InterfaceUtil interfaceUtil = (InterfaceUtil)SpringContextUtils.getBean(InterfaceUtil.class);
        if (InterfaceConvertUtil.isSap1000(purchaseOrg)) {
            interfaceCode = String.format("%s%s", interfaceCode, "1000");
            interfaceUtil.callInterface(TenantContext.getTenant(), interfaceCode, custom);
        }
        if (InterfaceConvertUtil.isSap6000(purchaseOrg)) {
            interfaceCode = String.format("%s%s", interfaceCode, "6000");
            interfaceUtil.callInterface(TenantContext.getTenant(), interfaceCode, custom);
        }
    }

    public static JSONObject callInterface(String purchaseOrg, String companyCode, String interfaceCode, Object custom) {
        JSONObject jsonObject = new JSONObject();
        InterfaceUtil interfaceUtil = (InterfaceUtil)SpringContextUtils.getBean(InterfaceUtil.class);
        if (InterfaceConvertUtil.isSap1000(purchaseOrg)) {
            interfaceCode = String.format("%s%s", interfaceCode, "1000");
            jsonObject = interfaceUtil.callInterface(TenantContext.getTenant(), companyCode, interfaceCode, custom);
        }
        if (InterfaceConvertUtil.isSap6000(purchaseOrg)) {
            interfaceCode = String.format("%s%s", interfaceCode, "6000");
            jsonObject = interfaceUtil.callInterface(TenantContext.getTenant(), companyCode, interfaceCode, custom);
        }
        return jsonObject;
    }
}

