/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.extend.api.service;

import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.RSA;
import com.alibaba.fastjson.JSONObject;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class OaTokenUtil {
    private static final Logger log = LoggerFactory.getLogger(OaTokenUtil.class);
    @Autowired
    private RedisUtil redisUtil;
    @Value(value="${SYS.OA.auth.appId}")
    private String appId;
    @Value(value="${SYS.OA.auth.url}")
    private String url;
    @Value(value="${SYS.OA.auth.expireTime}")
    private long expireTime;
    public static final String REGIST = "/api/ec/dev/auth/regist";
    private String srmInterfaceCode = "getOARegist";
    private String srmInterfaceCode_token = "getOAToken";
    @Resource
    private InterfaceUtil interfaceUtil;

    public String getOAtoken(String elsAccount) {
        JSONObject regist;
        String tenantId = StrUtil.isNotEmpty((CharSequence)elsAccount) ? elsAccount : TenantContext.getTenant();
        Object token1 = this.redisUtil.get("oa_token");
        if (!ObjectUtil.isEmpty((Object)token1)) {
            return String.valueOf(token1);
        }
        Object secret = this.redisUtil.get("oa_secret");
        Object spk = this.redisUtil.get("oa_spk");
        if (ObjectUtil.isEmpty((Object)secret) && (regist = this.regist(elsAccount)).getBoolean("success").booleanValue()) {
            JSONObject result = regist.getJSONObject("result");
            secret = result.getString("secret");
            spk = result.getString("spk");
            this.redisUtil.set("oa_secret", secret);
            this.redisUtil.set("oa_spk", spk);
        }
        RSA rsa = new RSA(null, String.valueOf(spk));
        String encryptSecret = rsa.encryptBase64(String.valueOf(secret), CharsetUtil.CHARSET_UTF_8, KeyType.PublicKey);
        JSONObject param0 = new JSONObject();
        param0.put("bus_account", (Object)tenantId);
        param0.put("srm_interface_code", (Object)this.srmInterfaceCode_token);
        JSONObject headParam = new JSONObject();
        headParam.put("appid", (Object)this.appId);
        headParam.put("secret", (Object)encryptSecret);
        headParam.put("time", (Object)String.valueOf(this.expireTime));
        param0.put("header_param", (Object)headParam);
        param0.put("body", (Object)"{}");
        JSONObject result = this.interfaceUtil.callInterface(elsAccount, null, param0, null);
        log.info("\u8fd4\u56detoken{}", (Object)JSONObject.toJSONString((Object)result));
        if (result.getBoolean("success").booleanValue()) {
            JSONObject result1 = result.getJSONObject("result");
            String token = result1.getString("token");
            this.redisUtil.set("oa_token", (Object)token, this.expireTime - 20L);
            this.redisUtil.set("oa_PUBLIC_KEY", (Object)result1.getString("token"), this.expireTime - 20L);
            return token;
        }
        return "";
    }

    private JSONObject regist(String elsAccount) {
        RSA rsa = new RSA();
        String publicKey = rsa.getPublicKeyBase64();
        JSONObject param0 = new JSONObject();
        param0.put("bus_account", (Object)elsAccount);
        param0.put("srm_interface_code", (Object)this.srmInterfaceCode);
        JSONObject headParam = new JSONObject();
        headParam.put("appid", (Object)this.appId);
        headParam.put("cpk", (Object)publicKey);
        param0.put("header_param", (Object)headParam);
        param0.put("body", (Object)"{}");
        JSONObject data = this.interfaceUtil.callInterface(elsAccount, null, param0, null);
        log.info("\u8fd4\u56de\u516c\u94a5\uff0c\u79c1\u94a5\u4fe1\u606f{}", (Object)JSONObject.toJSONString((Object)data));
        return data;
    }
}

