/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.extend.api.utils;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanTools {
    private static final Logger log = LoggerFactory.getLogger(BeanTools.class);

    public static void copyProperties(Object source, Object target) {
        if (source == null || target == null) {
            return;
        }
        try {
            Field[] childFeilds = source.getClass().getDeclaredFields();
            Field[] parentFeilds = source.getClass().getSuperclass().getDeclaredFields();
            Field[] sourceFields = (Field[])Stream.concat(Arrays.stream(childFeilds), Arrays.stream(parentFeilds)).toArray(Field[]::new);
            Field[] childTFeilds = target.getClass().getDeclaredFields();
            Field[] parentTFeilds = target.getClass().getSuperclass().getDeclaredFields();
            Field[] targetFields = (Field[])Stream.concat(Arrays.stream(childTFeilds), Arrays.stream(parentTFeilds)).toArray(Field[]::new);
            block2: for (int i = 0; i < targetFields.length; ++i) {
                for (int j = 0; j < sourceFields.length; ++j) {
                    String value;
                    if (!sourceFields[i].getName().equals(targetFields[j].getName())) continue;
                    sourceFields[i].setAccessible(true);
                    targetFields[j].setAccessible(true);
                    Object targetField = targetFields[j].get(target);
                    if (targetField == null) {
                        targetFields[j].set(target, sourceFields[i].get(source));
                        continue block2;
                    }
                    if (targetField instanceof String && StringUtils.isBlank((CharSequence)(value = (String)targetField))) {
                        targetFields[j].set(target, sourceFields[i].get(source));
                        continue block2;
                    }
                    sourceFields[i].setAccessible(false);
                    targetFields[j].setAccessible(false);
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            log.error("copyProperties error", (Throwable)e);
        }
    }
}

