/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.audit.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.audit.api.AuditPersonConfigLygExtendRpcService;
import com.els.modules.audit.dto.AuditTaskDefDTO;
import com.els.modules.audit.dto.BpmHisTaskDTO;
import com.els.modules.audit.service.OaWorkFlowService;
import com.els.modules.extend.api.enumerate.InterfaceCodeEnum;
import com.els.modules.extend.api.utils.OaApiUtils;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.pangubpm.combination.user.entity.UcUser;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class OaWorkFlowServiceImpl
implements OaWorkFlowService {
    private static final Logger log = LoggerFactory.getLogger(OaWorkFlowServiceImpl.class);
    @Autowired
    private OaApiUtils oaApiUtils;
    @Autowired
    private AuditPersonConfigLygExtendRpcService auditPersonConfigLygExtendRpcService;
    @Autowired
    private ElsSubAccountService elsSubAccountService;
    @Value(value="${els.config.service.address}")
    private String address;

    @Override
    @Async
    @SrmTransaction
    public void sendTaskToOAByAdapter(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String action) {
        TenantContext.setTenant((String)SysUtil.getPurchaseAccount());
        log.error("------sendTaskToOAByAdapter\u65b9\u6cd5\u5165\u53c2\uff1a" + inputParamVO.getBusinessId());
        String processRootId = outputParamVO.getProcessRootId();
        String title = inputParamVO.getAuditSubject();
        String businessId = inputParamVO.getBusinessId();
        String businessType = inputParamVO.getBusinessType();
        AuditTaskDefDTO taskDefDTO = new AuditTaskDefDTO();
        taskDefDTO.setProcessId(processRootId);
        taskDefDTO.setTaskTitle(title);
        taskDefDTO.setAction(action);
        taskDefDTO.setBusinessId(businessId);
        taskDefDTO.setBusinessType(businessType);
        taskDefDTO.setSubmitUser(outputParamVO.getSubmitUser());
        taskDefDTO.setNextAuditUserList(outputParamVO.getNextAuditUserList());
        this.sendTaskToOA(taskDefDTO);
    }

    @Override
    @SrmTransaction
    public void sendTaskToOA(AuditTaskDefDTO auditTaskDef) {
        String createUser;
        String action = auditTaskDef.getAction();
        String taskId = auditTaskDef.getTaskId();
        String processId = auditTaskDef.getProcessId();
        String title = auditTaskDef.getTaskTitle();
        String businessId = auditTaskDef.getBusinessId();
        String businessType = auditTaskDef.getBusinessType();
        String submitUserId = auditTaskDef.getSubmitUser();
        String submitUser = "admin";
        if (StringUtils.isNotBlank((CharSequence)submitUserId)) {
            ElsSubAccount elsSubAccount = (ElsSubAccount)this.elsSubAccountService.getById((Serializable)((Object)submitUserId));
            submitUser = elsSubAccount != null ? elsSubAccount.getSubAccount() : "admin";
        }
        String urlPre = this.address + "/user/login?redirect=/srm/bpm/bpmnTodoList&taskId=";
        String urlEnd = "&businessType=" + businessType + "&businessId=" + businessId + "&processInstanceId=" + processId + "&token=";
        List<BpmHisTaskDTO> bpmHisTaskDTOList = this.auditPersonConfigLygExtendRpcService.selectListByProcessId(processId);
        String string = createUser = StringUtils.isNotBlank((CharSequence)submitUserId) ? submitUser : SysUtil.getLoginUser().getSubAccount();
        if ("agree".equals(action)) {
            this.completeTask(taskId);
            BpmHisTaskDTO bpmHisTaskDTO = (BpmHisTaskDTO)((Object)bpmHisTaskDTOList.stream().filter(item -> taskId.equals(item.getId())).collect(Collectors.toList()).get(0));
            bpmHisTaskDTOList.stream().filter(item -> bpmHisTaskDTO.getEndTime().equals(item.getEndTime())).forEach(itemDTO -> this.deleteTask(itemDTO.getId()));
            bpmHisTaskDTOList.stream().filter(item -> item.getEndTime() == null && !bpmHisTaskDTO.getTaskDefKey().equals(item.getTaskDefKey())).forEach(itemDTO -> {
                ElsSubAccount subAccount = (ElsSubAccount)this.elsSubAccountService.getById((Serializable)((Object)itemDTO.getAssignee()));
                if (subAccount != null) {
                    String targetUser = subAccount.getSubAccount();
                    String url = urlPre + itemDTO.getId() + urlEnd;
                    this.createTask(itemDTO.getId(), createUser, targetUser, title, this.encodeUrl(url));
                }
            });
        } else if ("unpass".equals(action) || "invalid".equals(action) || "backToNode".equals(action)) {
            this.completeTask(taskId);
            BpmHisTaskDTO bpmHisTaskDTO = (BpmHisTaskDTO)((Object)bpmHisTaskDTOList.stream().filter(item -> taskId.equals(item.getId())).collect(Collectors.toList()).get(0));
            bpmHisTaskDTOList.stream().filter(item -> bpmHisTaskDTO.getEndTime().equals(item.getEndTime())).forEach(itemDTO -> this.deleteTask(itemDTO.getId()));
            bpmHisTaskDTOList.stream().filter(item -> item.getEndTime() == null).forEach(itemDTO -> {
                ElsSubAccount subAccount = (ElsSubAccount)this.elsSubAccountService.getById((Serializable)((Object)itemDTO.getAssignee()));
                if (subAccount != null) {
                    String targetUser = subAccount.getSubAccount();
                    String url = urlPre + itemDTO.getId() + urlEnd;
                    this.createTask(itemDTO.getId(), createUser, targetUser, title, this.encodeUrl(url));
                }
            });
        } else if ("transfer".equals(action)) {
            this.completeTask(taskId);
            UcUser usersInfo = auditTaskDef.getUsersInfo();
            String targetUser = usersInfo.getAccount();
            String url = urlPre + taskId + urlEnd;
            this.createTask(taskId, createUser, targetUser, title, this.encodeUrl(url));
        } else if ("submit".equals(action)) {
            List<String> nextAuditUserList = auditTaskDef.getNextAuditUserList();
            if (CollectionUtil.isNotEmpty(nextAuditUserList)) {
                nextAuditUserList.stream().forEach(nextAuditUser -> {
                    String targetUser = nextAuditUser.split("_")[1];
                    String thisTaskId = nextAuditUser.split("_")[2];
                    String url = urlPre + thisTaskId + urlEnd;
                    this.createTask(thisTaskId, createUser, targetUser, title, this.encodeUrl(url));
                });
            } else {
                log.error("\u63d0\u4ea4\u5ba1\u6279\u65f6\uff0c\u672a\u63a8\u9001OA\u5f85\u529e =========== " + title);
            }
        } else if ("cancel".equals(action)) {
            bpmHisTaskDTOList.stream().filter(item -> item.getEndTime() == null).forEach(itemDTO -> this.deleteTask(itemDTO.getId()));
        }
    }

    private String encodeUrl(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (Exception e) {
            throw new ELSBootException("url\u8f6c\u4e49\u51fa\u9519\uff01");
        }
    }

    public void createTask(String taskId, String createUser, String targetUser, String title, String url) {
        log.error(System.currentTimeMillis() + "------------\u521b\u5efaOA\u5f85\u529e\u63a5\u53e3\uff1a" + taskId + "\uff0c\u4efb\u52a1\u5f85\u529e\u4eba\uff1a" + targetUser);
        JSONObject paramObj = this.buildParam(taskId, createUser, targetUser, title, url);
        JSONObject resultObj = this.oaApiUtils.callOA(InterfaceCodeEnum.OA_CREATE, paramObj);
        if (resultObj.containsKey((Object)"result") && !"ok".equals(resultObj.getString("result"))) {
            log.error("\u521b\u5efaOA\u5f85\u529e\u63a5\u53e3\u5f02\u5e38\uff1a" + resultObj.getString("msg"));
        }
    }

    public void completeTask(String taskId) {
        JSONObject paramObj = this.buildParam(taskId, null, null, null, null);
        JSONObject resultObj = this.oaApiUtils.callOA(InterfaceCodeEnum.OA_COMPLETE, paramObj);
        if (resultObj.containsKey((Object)"result") && !"ok".equals(resultObj.getString("result"))) {
            log.error("\u5b8c\u6210OA\u5f85\u529e\u63a5\u53e3\u5f02\u5e38\uff1a" + resultObj.getString("msg"));
        }
    }

    public void deleteTask(String taskId) {
        JSONObject paramObj = this.buildParam(taskId, null, null, null, null);
        JSONObject resultObj = this.oaApiUtils.callOA(InterfaceCodeEnum.OA_DELETE, paramObj);
        if (resultObj.containsKey((Object)"result") && !"ok".equals(resultObj.getString("result"))) {
            log.error("\u5220\u9664OA\u5f85\u529e\u63a5\u53e3\u5f02\u5e38\uff1a" + resultObj.getString("msg"));
        }
    }

    private JSONObject buildParam(String taskId, String createUser, String targetUser, String title, String url) {
        JSONObject dataObj = new JSONObject();
        dataObj.put("applicationName", (Object)"SRM");
        dataObj.put("outerId", (Object)taskId);
        if (StringUtils.isNotBlank((CharSequence)createUser)) {
            dataObj.put("createUid", (Object)createUser);
            dataObj.put("targetUid", (Object)targetUser);
            dataObj.put("title", (Object)title);
            dataObj.put("url", (Object)url);
        }
        JSONObject paramObj = new JSONObject();
        paramObj.put("boDatas", (Object)dataObj);
        return paramObj;
    }

    @Override
    public void batchTaskToOA(List<String> taskIdList, String opt) {
        block3: {
            block2: {
                if (!"complate".equals(opt)) break block2;
                for (String taskId : taskIdList) {
                    this.completeTask(taskId);
                }
                break block3;
            }
            if (!"delete".equals(opt)) break block3;
            for (String taskId : taskIdList) {
                this.deleteTask(taskId);
            }
        }
    }
}

